/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.poller.pollables;

import java.net.InetAddress;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import junit.framework.TestCase;
import org.easymock.EasyMock;
import org.opennms.netmgt.config.PollerConfig;
import org.opennms.netmgt.config.poller.Package;
import org.opennms.netmgt.dao.support.RrdTestUtils;
import org.opennms.netmgt.poller.pollables.LatencyStoringServiceMonitorAdaptor;
import org.opennms.netmgt.rrd.RrdDataSource;
import org.opennms.netmgt.rrd.RrdStrategy;
import org.opennms.netmgt.rrd.RrdUtils;
import org.opennms.test.mock.EasyMockUtils;
import org.opennms.test.mock.MockLogAppender;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LatencyStoringServiceMonitorAdaptorTest
extends TestCase {
    private EasyMockUtils m_mocks = new EasyMockUtils();
    private PollerConfig m_pollerConfig = (PollerConfig)this.m_mocks.createMock(PollerConfig.class);
    private RrdStrategy m_rrdStrategy = (RrdStrategy)this.m_mocks.createMock(RrdStrategy.class);

    protected void setUp() throws Exception {
        super.setUp();
        MockLogAppender.setupLogging();
        RrdTestUtils.initializeNullStrategy();
        RrdUtils.setStrategy((RrdStrategy)this.m_rrdStrategy);
    }

    protected void runTest() throws Throwable {
        super.runTest();
        MockLogAppender.assertNoWarningsOrGreater();
    }

    public void testUpdateRrdWithLocaleThatUsesCommasForDecimals() throws Exception {
        Locale.setDefault(Locale.FRENCH);
        NumberFormat nf = NumberFormat.getInstance();
        LatencyStoringServiceMonitorAdaptorTest.assertEquals((String)("ensure that the newly set default locale (" + Locale.getDefault() + ") uses ',' as the decimal marker"), (String)"1,5", (String)nf.format(1.5));
        LatencyStoringServiceMonitorAdaptor adaptor = new LatencyStoringServiceMonitorAdaptor(null, this.m_pollerConfig, new Package());
        LinkedHashMap<String, Double> map = new LinkedHashMap<String, Double>();
        map.put("cheese", 1.5);
        EasyMock.expect((Object)this.m_pollerConfig.getStep((Package)EasyMock.isA(Package.class))).andReturn((Object)0).anyTimes();
        EasyMock.expect((Object)this.m_pollerConfig.getRRAList((Package)EasyMock.isA(Package.class))).andReturn(new ArrayList(0));
        EasyMock.expect((Object)this.m_rrdStrategy.getDefaultFileExtension()).andReturn((Object)".rrd").anyTimes();
        EasyMock.expect((Object)this.m_rrdStrategy.createDefinition((String)EasyMock.isA(String.class), (String)EasyMock.isA(String.class), (String)EasyMock.isA(String.class), EasyMock.anyInt(), LatencyStoringServiceMonitorAdaptorTest.isAList(RrdDataSource.class), LatencyStoringServiceMonitorAdaptorTest.isAList(String.class))).andReturn(new Object());
        this.m_rrdStrategy.createFile(EasyMock.isA(Object.class));
        EasyMock.expect((Object)this.m_rrdStrategy.openFile((String)EasyMock.isA(String.class))).andReturn(new Object());
        this.m_rrdStrategy.updateFile(EasyMock.isA(Object.class), (String)EasyMock.isA(String.class), EasyMock.endsWith((String)":1.5"));
        this.m_rrdStrategy.closeFile(EasyMock.isA(Object.class));
        this.m_mocks.replayAll();
        adaptor.updateRRD("foo", InetAddress.getLocalHost(), "baz", map);
        this.m_mocks.verifyAll();
    }

    private static <T> List<T> isAList(Class<T> clazz) {
        return (List)EasyMock.isA(List.class);
    }
}

