/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.poller.monitors;

import java.util.Map;
import junit.framework.TestCase;
import org.opennms.netmgt.model.PollStatus;
import org.opennms.netmgt.poller.MonitoredService;
import org.opennms.netmgt.poller.monitors.SnmpMonitorStrategy;
import org.opennms.netmgt.snmp.SnmpValue;
import org.opennms.netmgt.snmp.mock.TestSnmpValue;
import org.opennms.test.ThrowableAnticipator;
import org.opennms.test.mock.MockLogAppender;

public class SnmpMonitorStrategyTest
extends TestCase {
    private SnmpMonitorStrategy monitor = new SnmpMonitorStrategy(){

        public PollStatus poll(MonitoredService svc, Map parameters) {
            throw new UnsupportedOperationException("method not implemented; go away, punk!");
        }
    };

    public void setUp() {
        MockLogAppender.setupLogging();
    }

    public void testMeetsCriteriaWithNullResult() {
        SnmpValue result = null;
        SnmpMonitorStrategyTest.assertFalse((boolean)this.monitor.meetsCriteria(result, null, null));
    }

    public void FIXMEtestMeetsCriteriaWithSnmpNull() {
        SnmpValue result = TestSnmpValue.NULL_VALUE;
        this.testSyntaxEquals(result, "", "1");
    }

    public void testMeetsCriteriaWithString() {
        TestSnmpValue.StringSnmpValue result = new TestSnmpValue.StringSnmpValue("A Test String");
        this.testSyntaxEquals((SnmpValue)result, "A Test String", "a test string");
        this.testSyntaxMatches((SnmpValue)result, "[tT][eE][sS][tT]", "test");
        this.testSyntaxMatches((SnmpValue)result, "^A Test String$", "^A Test$");
    }

    public void testMeetsCriteriaWithObjectID() {
        TestSnmpValue.OidSnmpValue result = new TestSnmpValue.OidSnmpValue(".1.2.3.4.5.6.7.8.9");
        this.testSyntaxEquals((SnmpValue)result, ".1.2.3.4.5.6.7.8.9", "..1.2.3.4.5.6.7.8.9");
        this.testSyntaxMatches((SnmpValue)result, "\\.7\\.", "\\.11\\.");
    }

    public void testMeetsCriteriaWithIPAddr() throws Exception {
        TestSnmpValue.IpAddressSnmpValue result = new TestSnmpValue.IpAddressSnmpValue("10.1.1.1");
        this.testSyntaxEquals((SnmpValue)result, "10.1.1.1", "10.1.1.2");
        this.testSyntaxMatches((SnmpValue)result, "10\\.1\\.1\\.[1-5]", "10\\.1\\.1\\.[02-9]");
    }

    public void testNumericString() {
        TestSnmpValue.StringSnmpValue result = new TestSnmpValue.StringSnmpValue("12345");
        this.testOrderOperations((SnmpValue)result, 12345);
    }

    public void testMeetsCriteriaWithInteger() {
        TestSnmpValue.Integer32SnmpValue result = new TestSnmpValue.Integer32SnmpValue(1234);
        this.testSyntaxEquals((SnmpValue)result, "1234", "2234");
        this.testOrderOperations((SnmpValue)result, 1234);
        this.testSyntaxMatches((SnmpValue)result, "23", "14");
    }

    public void testMeetsCriteriaWithCounter32() {
        TestSnmpValue.Counter32SnmpValue result = new TestSnmpValue.Counter32SnmpValue(1);
        this.testSyntaxEquals((SnmpValue)result, "1", "2");
        this.testOrderOperations((SnmpValue)result, 1);
    }

    public void testMeetsCriteriaWithGauge32() {
        TestSnmpValue.Gauge32SnmpValue result = new TestSnmpValue.Gauge32SnmpValue(1);
        this.testSyntaxEquals((SnmpValue)result, "1", "2");
        this.testOrderOperations((SnmpValue)result, 1);
    }

    public void FIXMEtestMeetsCriteriaWithTimeTicks() {
        TestSnmpValue.TimeticksSnmpValue result = new TestSnmpValue.TimeticksSnmpValue("1");
        this.testSyntaxEquals((SnmpValue)result, "0d 0h 0m 0s 10ms", "1d 1h 1m 1s 10ms");
        this.testSyntaxMatches((SnmpValue)result, "0h", "1h");
        this.testOrderOperations((SnmpValue)result, 1);
    }

    public void testMeetsCriteriaWithCounter64() {
        TestSnmpValue.Counter64SnmpValue result = new TestSnmpValue.Counter64SnmpValue(1L);
        this.testSyntaxEquals((SnmpValue)result, "1", "2");
        this.testOrderOperations((SnmpValue)result, 1);
    }

    public void testErrorConditions() {
        TestSnmpValue.Integer32SnmpValue result = new TestSnmpValue.Integer32SnmpValue(1);
        ThrowableAnticipator ta = new ThrowableAnticipator();
        ta.anticipate((Throwable)new IllegalArgumentException("operator X is unknown"));
        try {
            this.monitor.meetsCriteria((SnmpValue)result, "X", "123");
        }
        catch (Throwable t) {
            ta.throwableReceived(t);
        }
        ta.verifyAnticipated();
    }

    public void testErrorConditions2() {
        TestSnmpValue.Integer32SnmpValue result = new TestSnmpValue.Integer32SnmpValue(1);
        ThrowableAnticipator ta = new ThrowableAnticipator();
        ta.anticipate((Throwable)new NumberFormatException("For input string: \"abc\""));
        try {
            this.monitor.meetsCriteria((SnmpValue)result, "<", "abc");
            SnmpMonitorStrategyTest.fail((String)"expected an exception");
        }
        catch (Throwable t) {
            ta.throwableReceived(t);
        }
        ta.verifyAnticipated();
    }

    private void testSyntaxEquals(SnmpValue result, String eqString, String neString) {
        SnmpMonitorStrategyTest.assertTrue((boolean)this.monitor.meetsCriteria(result, null, null));
        SnmpMonitorStrategyTest.assertTrue((String)("result '" + result + "' should pass equal test with '" + eqString + "'"), (boolean)this.monitor.meetsCriteria(result, "=", eqString));
        SnmpMonitorStrategyTest.assertFalse((String)("result '" + result + "' should fail equal test with '" + neString + "'"), (boolean)this.monitor.meetsCriteria(result, "=", neString));
        SnmpMonitorStrategyTest.assertFalse((String)("result '" + result + "' should fail not equal test with '" + eqString + "'"), (boolean)this.monitor.meetsCriteria(result, "!=", eqString));
        SnmpMonitorStrategyTest.assertTrue((String)("result '" + result + "' should pass not equal test with '" + neString + "'"), (boolean)this.monitor.meetsCriteria(result, "!=", neString));
    }

    private void testSyntaxMatches(SnmpValue result, String matchString, String noMatchString) {
        SnmpMonitorStrategyTest.assertTrue((boolean)this.monitor.meetsCriteria(result, "~", matchString));
        SnmpMonitorStrategyTest.assertFalse((boolean)this.monitor.meetsCriteria(result, "~", noMatchString));
    }

    private void testOrderOperations(SnmpValue result, int value) {
        SnmpMonitorStrategyTest.assertTrue((boolean)this.monitor.meetsCriteria(result, "<", Integer.toString(value + 1)));
        SnmpMonitorStrategyTest.assertFalse((boolean)this.monitor.meetsCriteria(result, "<", Integer.toString(value)));
        SnmpMonitorStrategyTest.assertFalse((boolean)this.monitor.meetsCriteria(result, "<", Integer.toString(value - 1)));
        SnmpMonitorStrategyTest.assertTrue((boolean)this.monitor.meetsCriteria(result, "<=", Integer.toString(value + 1)));
        SnmpMonitorStrategyTest.assertTrue((boolean)this.monitor.meetsCriteria(result, "<=", Integer.toString(value)));
        SnmpMonitorStrategyTest.assertFalse((boolean)this.monitor.meetsCriteria(result, "<=", Integer.toString(value - 1)));
        SnmpMonitorStrategyTest.assertFalse((boolean)this.monitor.meetsCriteria(result, ">", Integer.toString(value + 1)));
        SnmpMonitorStrategyTest.assertFalse((boolean)this.monitor.meetsCriteria(result, ">", Integer.toString(value)));
        SnmpMonitorStrategyTest.assertTrue((boolean)this.monitor.meetsCriteria(result, ">", Integer.toString(value - 1)));
        SnmpMonitorStrategyTest.assertFalse((boolean)this.monitor.meetsCriteria(result, ">=", Integer.toString(value + 1)));
        SnmpMonitorStrategyTest.assertTrue((boolean)this.monitor.meetsCriteria(result, ">=", Integer.toString(value)));
        SnmpMonitorStrategyTest.assertTrue((boolean)this.monitor.meetsCriteria(result, ">=", Integer.toString(value - 1)));
    }
}

