/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.notifd;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.text.DateFormat;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Map;
import org.opennms.netmgt.EventConstants;
import org.opennms.netmgt.config.DatabaseSchemaConfigFactory;
import org.opennms.netmgt.config.notifications.Notification;
import org.opennms.netmgt.filter.FilterDaoFactory;
import org.opennms.netmgt.mock.MockEventUtil;
import org.opennms.netmgt.mock.MockInterface;
import org.opennms.netmgt.mock.MockNode;
import org.opennms.netmgt.mock.MockService;
import org.opennms.netmgt.notifd.NotificationsTestCase;
import org.opennms.netmgt.utils.RowProcessor;
import org.opennms.netmgt.xml.event.Event;
import org.opennms.netmgt.xml.event.Tticket;
import org.opennms.test.ConfigurationTestUtils;

public class NotifdTest
extends NotificationsTestCase {
    protected void setUp() throws Exception {
        super.setUp();
        this.m_anticipator.setExpectedDifference(5000L);
        DatabaseSchemaConfigFactory.setInstance((DatabaseSchemaConfigFactory)new DatabaseSchemaConfigFactory(ConfigurationTestUtils.getReaderForConfigFile((String)"database-schema.xml")));
        FilterDaoFactory.setInstance(null);
        FilterDaoFactory.getInstance();
    }

    public void testWicktorBug_1022_1031() throws Exception {
        Date date = new Date();
        long finished = this.anticipateNotificationsForGroup("High loadavg5 Threshold exceeded", "High loadavg5 Threshold exceeded on 192.168.1.1, loadavg5 with ", "InitialGroup", date, 0L);
        MockInterface iface = this.m_network.getInterface(1, "192.168.1.1");
        Event e = MockEventUtil.createInterfaceEvent("test", "uei.opennms.org/threshold/highThresholdExceeded", iface);
        MockEventUtil.setEventTime(e, date);
        MockEventUtil.addEventParm(e, "ds", "loadavg5");
        this.m_eventMgr.sendEventToListeners(e);
        this.verifyAnticipated(finished, 1000L);
    }

    public void BROKENtestNewSuspect() throws Exception {
        Date date = new Date();
        long finished = this.anticipateNotificationsForGroup("A new interface (10.1.1.1) has been discovered and is being queued for a services scan.", "A new interface (10.1.1.1) has been discovered and is being queued for a services scan.", "InitialGroup", date, 0L);
        Event e = MockEventUtil.createNewSuspectEvent("test", "uei.opennms.org/internal/discovery/newSuspect", "10.1.1.1");
        MockEventUtil.setEventTime(e, date);
        this.m_eventMgr.sendEventToListeners(e);
        this.verifyAnticipated(finished, 1000L);
    }

    public void testNotifdStatus() throws Exception {
        NotifdTest.assertEquals((String)this.m_notifdConfig.getNotificationStatus(), (String)"on");
        this.m_notifdConfig.turnNotifdOff();
        NotifdTest.assertEquals((String)this.m_notifdConfig.getNotificationStatus(), (String)"off");
        this.m_notifdConfig.turnNotifdOn();
        NotifdTest.assertEquals((String)this.m_notifdConfig.getNotificationStatus(), (String)"on");
    }

    public void testMockNotificationBasic() throws Exception {
        MockNode node = this.m_network.getNode(1);
        Date downDate = new Date();
        long finishedDowns = this.anticipateNotificationsForGroup("node 1 down.", "All services are down on node 1.", "InitialGroup", downDate, 0L);
        this.m_eventMgr.sendEventToListeners(node.createDownEvent(downDate));
        this.verifyAnticipated(finishedDowns, 3000L);
        this.m_anticipator.reset();
        Date upDate = new Date();
        this.anticipateNotificationsForGroup("RESOLVED: node 1 down.", "RESOLVED: All services are down on node 1.", "InitialGroup", upDate, 0L);
        long finishedUps = this.anticipateNotificationsForGroup("node 1 up.", "The node which was previously down is now up.", "UpGroup", upDate, 0L);
        this.m_eventMgr.sendEventToListeners(node.createUpEvent(upDate));
        this.verifyAnticipated(finishedUps, 3000L);
    }

    public void testMockNotificationInitialDelay() throws Exception {
        this.m_destinationPathManager.getPath("NoEscalate").setInitialDelay("1800ms");
        MockNode node = this.m_network.getNode(1);
        Date downDate = new Date(new Date().getTime() + 1800L);
        long finished = this.anticipateNotificationsForGroup("node 1 down.", "All services are down on node 1.", "InitialGroup", downDate, 0L);
        this.m_eventMgr.sendEventToListeners(node.createDownEvent(downDate));
        this.verifyAnticipated(finished, 3000L);
    }

    public void testInterval() throws Exception {
        MockService svc = this.m_network.getService(1, "192.168.1.1", "ICMP");
        Date date = new Date();
        long interval = this.computeInterval();
        long endTime = this.anticipateNotificationsForGroup("service ICMP on 192.168.1.1 down.", "Service ICMP is down on interface 192.168.1.1.", "InitialGroup", date, interval);
        this.m_eventMgr.sendEventToListeners(svc.createDownEvent(date));
        this.verifyAnticipated(endTime, 1000L);
    }

    public void testEscalate() throws Exception {
        MockInterface iface = this.m_network.getInterface(1, "192.168.1.1");
        Date now = new Date();
        this.anticipateNotificationsForGroup("interface 192.168.1.1 down.", "All services are down on interface 192.168.1.1, dot1 interface alias.", "InitialGroup", now, 0L);
        long endTime = this.anticipateNotificationsForGroup("interface 192.168.1.1 down.", "All services are down on interface 192.168.1.1, dot1 interface alias.", "EscalationGroup", now.getTime() + 2500L, 0L);
        this.m_eventMgr.sendEventToListeners(iface.createDownEvent(now));
        this.verifyAnticipated(endTime, 3000L);
    }

    public void testManualAcknowledge1() throws Exception {
        this.m_destinationPathManager.getPath("NoEscalate").setInitialDelay("2000ms");
        MockNode node = this.m_network.getNode(1);
        Event e = node.createDownEvent();
        this.m_eventMgr.sendEventToListeners(e);
        this.m_db.acknowledgeNoticesForEvent(e);
        this.verifyAnticipated(0L, 0L, 7000L);
    }

    public void testManualAcknowledge2() throws Exception {
        MockInterface iface = this.m_network.getInterface(1, "192.168.1.1");
        Date downDate = new Date();
        long finishedDowns = this.anticipateNotificationsForGroup("interface 192.168.1.1 down.", "All services are down on interface 192.168.1.1, dot1 interface alias.", "InitialGroup", downDate, 0L);
        Event event = iface.createDownEvent(downDate);
        this.m_eventMgr.sendEventToListeners(event);
        this.sleep(1000L);
        this.m_db.acknowledgeNoticesForEvent(event);
        this.sleep(5000L);
        this.verifyAnticipated(finishedDowns, 1000L);
    }

    public void testAutoAcknowledge1() throws Exception {
        this.m_destinationPathManager.getPath("NoEscalate").setInitialDelay("2000ms");
        MockNode node = this.m_network.getNode(1);
        Event downEvent = node.createDownEvent();
        Tticket tticket = new Tticket();
        tticket.setContent("777");
        tticket.setState("1");
        downEvent.setTticket(tticket);
        this.m_eventMgr.sendEventToListeners(downEvent);
        this.sleep(1000L);
        Date date = new Date();
        Event upEvent = node.createUpEvent(date);
        long endTime = this.anticipateNotificationsForGroup("node 1 up.", "The node which was previously down is now up.", "UpGroup", date, 0L);
        this.m_eventMgr.sendEventToListeners(upEvent);
        this.verifyAnticipated(endTime, 1000L, 5000L);
    }

    public void testAutoAcknowledge2() throws Exception {
        MockInterface iface = this.m_network.getInterface(1, "192.168.1.1");
        Date downDate = new Date();
        this.anticipateNotificationsForGroup("interface 192.168.1.1 down.", "All services are down on interface 192.168.1.1, dot1 interface alias.", "InitialGroup", downDate, 0L);
        Event event = iface.createDownEvent(downDate);
        this.m_eventMgr.sendEventToListeners(event);
        this.sleep(1000L);
        Date date = new Date();
        Event upEvent = iface.createUpEvent(date);
        this.anticipateNotificationsForGroup("RESOLVED: interface 192.168.1.1 down.", "RESOLVED: All services are down on interface 192.168.1.1, dot1 interface alias.", "InitialGroup", date, 0L);
        long endTime = this.anticipateNotificationsForGroup("interface 192.168.1.1 up.", "The interface which was previously down is now up.", "UpGroup", date, 0L);
        this.m_eventMgr.sendEventToListeners(upEvent);
        this.verifyAnticipated(endTime, 1000L, 5000L);
    }

    public void testBug731() throws Exception {
        MockInterface iface = this.m_network.getInterface(1, "192.168.1.1");
        Date downDate = new Date();
        this.anticipateNotificationsForGroup("interface 192.168.1.1 down.", "All services are down on interface 192.168.1.1, dot1 interface alias.", "InitialGroup", downDate, 0L);
        Event event = iface.createDownEvent(downDate);
        this.m_eventMgr.sendEventToListeners(event);
        this.sleep(1000L);
        Date date = new Date();
        Event upEvent = iface.createUpEvent(date);
        this.anticipateNotificationsForGroup("RESOLVED: interface 192.168.1.1 down.", "RESOLVED: All services are down on interface 192.168.1.1, dot1 interface alias.", "InitialGroup", date, 0L);
        long endTime = this.anticipateNotificationsForGroup("interface 192.168.1.1 up.", "The interface which was previously down is now up.", "UpGroup", date, 0L);
        this.m_eventMgr.sendEventToListeners(upEvent);
        this.verifyAnticipated(endTime, 1000L, 5000L);
    }

    public void testBug1114() throws Exception {
        this.m_anticipator.setExpectedDifference(5000L);
        MockService svc = this.m_network.getService(1, "192.168.1.1", "ICMP");
        long interval = this.computeInterval();
        Event event = MockEventUtil.createServiceEvent("Test", "uei.opennms.org/tests/nodeTimeTest", svc, null);
        Date date = EventConstants.parseToDate((String)event.getTime());
        String dateString = DateFormat.getDateTimeInstance(0, 0).format(date);
        long endTime = this.anticipateNotificationsForGroup("time " + dateString + ".", "Timestamp: " + dateString + ".", "InitialGroup", date, interval);
        this.m_eventMgr.sendEventToListeners(event);
        this.verifyAnticipated(endTime - 5000L, 1000L);
    }

    public void testRebuildParameterMap() throws Exception {
        MockInterface iface = this.m_network.getInterface(1, "192.168.1.1");
        Date downDate = new Date();
        this.anticipateNotificationsForGroup("interface 192.168.1.1 down.", "All services are down on interface 192.168.1.1", "InitialGroup", downDate, 0L);
        Event event = iface.createDownEvent(downDate);
        this.m_eventMgr.sendEventToListeners(event);
        this.sleep(1000L);
        Collection<Integer> notifIds = this.m_db.findNoticesForEvent(event);
        Notification[] notification = this.m_notificationManager.getNotifForEvent(event);
        int index = 0;
        for (Integer notifId : notifIds) {
            Map originalMap = this.m_notifd.getBroadcastEventProcessor().buildParameterMap(notification[index], event, notifId.intValue());
            HashMap<String, String> resolutionMap = new HashMap<String, String>(originalMap);
            resolutionMap.put("-subject", "RESOLVED: " + (String)resolutionMap.get("-subject"));
            resolutionMap.put("-tm", "RESOLVED: " + (String)resolutionMap.get("-tm"));
            resolutionMap.put("-nm", "RESOLVED: " + (String)resolutionMap.get("-nm"));
            Map rebuiltMap = this.m_notifd.getBroadcastEventProcessor().rebuildParameterMap(notifId.intValue(), "RESOLVED: ", this.m_notifd.getConfigManager().getConfiguration().isNumericSkipResolutionPrefix());
            NotifdTest.assertEquals(resolutionMap, (Object)rebuiltMap);
            ++index;
        }
    }

    public void testGetUsersNotified() throws Exception {
        MockInterface iface = this.m_network.getInterface(1, "192.168.1.1");
        Date downDate = new Date();
        this.anticipateNotificationsForGroup("interface 192.168.1.1 down.", "All services are down on interface 192.168.1.1, dot1 interface alias.", "InitialGroup", downDate, 0L);
        Event event = iface.createDownEvent(downDate);
        this.m_eventMgr.sendEventToListeners(event);
        this.sleep(1000L);
        LinkedList expectedResults = new LinkedList();
        Collection<String> users = this.getUsersInGroup("InitialGroup");
        for (String userID : users) {
            LinkedList<String> cmdList = new LinkedList<String>();
            cmdList.add(userID);
            cmdList.add("mockNotifier");
            expectedResults.add(cmdList);
        }
        Collection<Integer> notifIds = this.m_db.findNoticesForEvent(event);
        NotifdTest.assertEquals((String)"notification ID size", (int)1, (int)notifIds.size());
        Integer notifId = notifIds.iterator().next();
        NotifdTest.assertNotNull((String)"first notifId should not be null", (Object)notifId);
        final LinkedList actualResults = new LinkedList();
        RowProcessor rp = new RowProcessor(){

            public void processRow(ResultSet rs) throws SQLException {
                LinkedList<String> cmdList = new LinkedList<String>();
                cmdList.add(rs.getString("userID"));
                cmdList.add(rs.getString("media"));
                actualResults.add(cmdList);
            }
        };
        this.m_notificationManager.forEachUserNotification(notifId.intValue(), rp);
        HashSet expectedSet = new HashSet(expectedResults);
        HashSet actualSet = new HashSet(actualResults);
        NotifdTest.assertEquals((String)"Notifications as a set", expectedSet, actualSet);
    }

    public void testRoleNotification() throws Exception {
        MockNode node = this.m_network.getNode(1);
        Date downDate = new Date();
        long finishedDowns = this.anticipateNotificationsForRole("notification test", "Notification Test", "oncall", downDate, 0L);
        this.m_eventMgr.sendEventToListeners(MockEventUtil.createNodeEvent("Test", "uei.opennms.org/test/roleTestEvent", node));
        this.verifyAnticipated(finishedDowns, 1000L);
        this.m_anticipator.reset();
    }
}

