/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.notifd;

import java.io.Reader;
import java.util.Collections;
import java.util.Date;
import org.junit.Test;
import org.opennms.netmgt.config.DatabaseSchemaConfigFactory;
import org.opennms.netmgt.mock.MockEventUtil;
import org.opennms.netmgt.mock.MockService;
import org.opennms.netmgt.notifd.BroadcastEventProcessor;
import org.opennms.netmgt.notifd.NotificationsTestCase;
import org.opennms.netmgt.xml.event.Event;
import org.opennms.test.ConfigurationTestUtils;

public class BroadcastEventProcessorTest
extends NotificationsTestCase {
    private BroadcastEventProcessor m_processor;

    protected void setUp() throws Exception {
        super.setUp();
        this.m_processor = new BroadcastEventProcessor();
        this.m_processor.initExpandRe();
        this.m_anticipator.setExpectedDifference(3000L);
        Reader rdr = ConfigurationTestUtils.getReaderForConfigFile((String)"database-schema.xml");
        DatabaseSchemaConfigFactory.setInstance((DatabaseSchemaConfigFactory)new DatabaseSchemaConfigFactory(rdr));
        rdr.close();
    }

    @Test
    public void testExpandNotifParms() {
        this.m_processor.expandNotifParms("%foo%", Collections.EMPTY_MAP);
    }

    @Test
    public void testExpandNoticeId_Bug1745() throws Exception {
        MockService svc = this.m_network.getService(1, "192.168.1.1", "ICMP");
        Event event = MockEventUtil.createServiceEvent("Test", "uei.opennms.org/test/noticeIdExpansion", svc, null);
        String antNID = Integer.toString(this.m_notificationManager.getNoticeId() + 1);
        Date testDate = new Date();
        long finishedNotifs = this.anticipateNotificationsForGroup("notification '" + antNID + "'", "Notification '" + antNID + "'", "InitialGroup", testDate, 0L);
        MockEventUtil.setEventTime(event, testDate);
        this.m_eventMgr.sendEventToListeners(event);
        this.verifyAnticipated(finishedNotifs, 1000L);
    }
}

