/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.mock;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.opennms.netmgt.collectd.SnmpCollector;
import org.opennms.netmgt.config.DataCollectionConfig;
import org.opennms.netmgt.config.MibObject;
import org.opennms.netmgt.config.datacollection.ResourceType;
import org.opennms.netmgt.model.RrdRepository;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MockDataCollectionConfig
implements DataCollectionConfig {
    public static final String[][] initalMibObjects = new String[][]{{"sysLocation", ".1.3.6.1.2.1.1.6", "0", "string"}, {"sysName", ".1.3.6.1.2.1.1.5", "0", "string"}, {"sysContact", ".1.3.6.1.2.1.1.4", "0", "string"}, {"sysUptime", ".1.3.6.1.2.1.1.3", "0", "timeTicks"}, {"sysOid", ".1.3.6.1.2.1.1.2", "0", "string"}, {"sysDescr", ".1.3.6.1.2.1.1.1", "0", "string"}, {"ifNumber", ".1.3.6.1.2.1.2.1", "0", "integer"}, {"ifInDiscards", ".1.3.6.1.2.1.2.2.1.13", "ifIndex", "counter"}, {"ifOutErrors", ".1.3.6.1.2.1.2.2.1.20", "ifIndex", "counter"}, {"ifInErrors", ".1.3.6.1.2.1.2.2.1.14", "ifIndex", "counter"}, {"ifOutOctets", ".1.3.6.1.2.1.2.2.1.16", "ifIndex", "counter"}, {"ifInOctets", ".1.3.6.1.2.1.2.2.1.10", "ifIndex", "counter"}, {"ifSpeed", ".1.3.6.1.2.1.2.2.1.5", "ifIndex", "gauge"}};
    private List<MibObject> m_attrList;
    private Map<String, MibObject> m_attrMap;

    public MockDataCollectionConfig() {
        this.setAttrList(new ArrayList<MibObject>());
        this.setAttrMap(new TreeMap<String, MibObject>());
        this.addInitialAttributeTypes();
    }

    public void setAttrList(List<MibObject> attrList) {
        this.m_attrList = attrList;
    }

    public List<MibObject> getAttrList() {
        return this.m_attrList;
    }

    public void setAttrMap(Map<String, MibObject> attrMap) {
        this.m_attrMap = attrMap;
    }

    public Map<String, MibObject> getAttrMap() {
        return this.m_attrMap;
    }

    private MibObject createMibObject(String alias, String oid, String instance, String type) {
        MibObject mibObj = new MibObject();
        mibObj.setGroupName("test");
        mibObj.setAlias(alias);
        mibObj.setOid(oid);
        mibObj.setType(type);
        mibObj.setInstance(instance);
        mibObj.setGroupName("ifIndex".equals(instance) ? "interface" : "node");
        mibObj.setGroupIfType("ifIndex".equals(instance) ? "all" : "ignored");
        return mibObj;
    }

    public MibObject createAttributeType(String alias, String oid, String instance, String type) {
        return this.createMibObject(alias, oid, instance, type);
    }

    public MibObject defineAttributeType(String alias, String oid, String instance, String type) {
        MibObject mibObj = this.createAttributeType(alias, oid, instance, type);
        this.getAttrMap().put(mibObj.getAlias(), mibObj);
        this.getAttrMap().put(mibObj.getOid(), mibObj);
        return mibObj;
    }

    public void addInitialAttributeTypes() {
        for (int i = 0; i < initalMibObjects.length; ++i) {
            String[] mibData = initalMibObjects[i];
            this.defineAttributeType(mibData[0], mibData[1], mibData[2], mibData[3]);
        }
    }

    public MibObject getAttributeType(String alias, String oid, String inst, String type) {
        MibObject attrType = this.getAttributeType(alias);
        if (attrType != null) {
            return attrType;
        }
        return this.defineAttributeType(alias, oid, inst, type);
    }

    public MibObject getAttributeType(String aliasOrOid) {
        return this.getAttrMap().get(aliasOrOid);
    }

    public void addAttributeType(String alias, String oid, String inst, String type) {
        MibObject attrType = this.getAttributeType(alias, oid, inst, type);
        this.getAttrList().add(attrType);
    }

    public List<String> getRRAList(String collectionName) {
        return new ArrayList<String>(0);
    }

    public String getRrdPath() {
        return "/tmp";
    }

    public String getSnmpStorageFlag(String collectionName) {
        return SnmpCollector.SNMP_STORAGE_PRIMARY;
    }

    public int getStep(String collectionName) {
        return 300;
    }

    public List<MibObject> getMibObjectList(String cName, String aSysoid, String anAddress, int ifType) {
        return this.getAttrList();
    }

    public Map<String, ResourceType> getConfiguredResourceTypes() {
        return new TreeMap<String, ResourceType>();
    }

    public RrdRepository getRrdRepository(String collectionName) {
        RrdRepository repo = new RrdRepository();
        repo.setRrdBaseDir(new File(this.getRrdPath()));
        repo.setRraList(this.getRRAList(collectionName));
        repo.setStep(this.getStep(collectionName));
        repo.setHeartBeat(2 * this.getStep(collectionName));
        return repo;
    }
}

