/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.eventd.processor;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import org.opennms.core.concurrent.BarrierSignaler;
import org.opennms.netmgt.dao.db.PopulatedTemporaryDatabaseTestCase;
import org.opennms.netmgt.eventd.EventdServiceManager;
import org.opennms.netmgt.eventd.JdbcEventdServiceManager;
import org.opennms.netmgt.eventd.processor.JdbcAlarmWriter;
import org.opennms.netmgt.eventd.processor.JdbcEventWriter;
import org.opennms.netmgt.mock.MockEventUtil;
import org.opennms.netmgt.mock.MockNetwork;
import org.opennms.netmgt.mock.MockNode;
import org.opennms.netmgt.xml.event.AlarmData;
import org.opennms.netmgt.xml.event.Event;
import org.opennms.netmgt.xml.event.Logmsg;
import org.opennms.test.ThrowableAnticipator;
import org.opennms.test.mock.MockUtil;
import org.springframework.jdbc.core.RowCallbackHandler;
import org.springframework.util.StringUtils;

public class JdbcAlarmWriterTest
extends PopulatedTemporaryDatabaseTestCase {
    private JdbcAlarmWriter m_jdbcAlarmWriter;
    private JdbcEventWriter m_jdbcEventWriter;
    private MockNetwork m_mockNetwork = new MockNetwork();

    protected void setUp() throws Exception {
        super.setUp();
        this.m_mockNetwork.createStandardNetwork();
        JdbcEventdServiceManager eventdServiceManager = new JdbcEventdServiceManager();
        eventdServiceManager.setDataSource(this.getDataSource());
        eventdServiceManager.afterPropertiesSet();
        this.m_jdbcEventWriter = new JdbcEventWriter();
        this.m_jdbcEventWriter.setEventdServiceManager((EventdServiceManager)eventdServiceManager);
        this.m_jdbcEventWriter.setDataSource(this.getDataSource());
        this.m_jdbcEventWriter.setGetNextIdString("SELECT nextval('eventsNxtId')");
        this.m_jdbcEventWriter.afterPropertiesSet();
        this.m_jdbcAlarmWriter = new JdbcAlarmWriter();
        this.m_jdbcAlarmWriter.setEventdServiceManager((EventdServiceManager)eventdServiceManager);
        this.m_jdbcAlarmWriter.setDataSource(this.getDataSource());
        this.m_jdbcAlarmWriter.setGetNextIdString("SELECT nextval('alarmsNxtId')");
        this.m_jdbcAlarmWriter.afterPropertiesSet();
    }

    public void testNextAlarmId() {
        int nextId = this.getJdbcTemplate().queryForInt(this.m_jdbcAlarmWriter.getGetNextIdString(), new Object[0]);
        JdbcAlarmWriterTest.assertEquals((int)1, (int)nextId);
    }

    public void testPersistAlarm() throws Exception {
        MockNode node = this.m_mockNetwork.getNode(1);
        JdbcAlarmWriterTest.assertEquals((int)0, (int)this.jdbcTemplate.queryForInt("select count(*) from alarms", new Object[0]));
        this.sendNodeDownEvent("%nodeid%", node);
        Thread.sleep(1000L);
        JdbcAlarmWriterTest.assertEquals((int)1, (int)this.jdbcTemplate.queryForInt("select count(*) from alarms", new Object[0]));
        this.sendNodeDownEvent("%nodeid%", node);
        Thread.sleep(1000L);
        JdbcAlarmWriterTest.assertEquals((int)1, (int)this.jdbcTemplate.queryForInt("select count(*) from alarms", new Object[0]));
        this.sendNodeDownEvent("DontReduceThis", node);
        Thread.sleep(1000L);
        JdbcAlarmWriterTest.assertEquals((int)2, (int)this.jdbcTemplate.queryForInt("select count(*) from alarms", new Object[0]));
        MockUtil.println((String)"Going for the print of the counter column");
        this.getJdbcTemplate().getJdbcOperations().query("select reductionKey, sum(counter) from alarms group by reductionKey", new RowCallbackHandler(){

            public void processRow(ResultSet rs) throws SQLException {
                MockUtil.println((String)("count for reductionKey: " + rs.getString(1) + " is: " + rs.getObject(2)));
            }
        });
    }

    public void testPersistManyAlarmsAtOnce() throws InterruptedException {
        int numberOfAlarmsToReduce = 10;
        JdbcAlarmWriterTest.assertEquals((int)0, (int)this.jdbcTemplate.queryForInt("select count(*) from alarms", new Object[0]));
        String reductionKey = "countThese";
        final MockNode node = this.m_mockNetwork.getNode(1);
        final long millis = System.currentTimeMillis() + 2500L;
        final BarrierSignaler signal = new BarrierSignaler(numberOfAlarmsToReduce);
        for (int i = 1; i <= numberOfAlarmsToReduce; ++i) {
            MockUtil.println((String)("Creating Runnable: " + i + " of " + numberOfAlarmsToReduce + " events to reduce."));
            /*
             * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
             */
            class EventRunner
            implements Runnable {
                EventRunner() {
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    try {
                        while (System.currentTimeMillis() < millis) {
                            try {
                                Thread.sleep(10L);
                            }
                            catch (InterruptedException e) {
                                MockUtil.println((String)e.getMessage());
                            }
                        }
                        JdbcAlarmWriterTest.this.sendNodeDownEvent("countThese", node);
                    }
                    catch (Throwable t) {
                        t.printStackTrace();
                    }
                    finally {
                        signal.signal();
                    }
                }
            }
            EventRunner r = new EventRunner();
            Thread p = new Thread(r);
            p.start();
        }
        signal.waitFor();
        int rowCount = this.jdbcTemplate.queryForInt("select count(*) from alarms", new Object[0]);
        Integer counterColumn = this.jdbcTemplate.queryForInt("select counter from alarms where reductionKey = ?", new Object[]{"countThese"});
        MockUtil.println((String)("rowcCount is: " + rowCount + ", expected 1."));
        MockUtil.println((String)("counterColumn is: " + counterColumn + ", expected " + numberOfAlarmsToReduce));
        JdbcAlarmWriterTest.assertEquals((int)1, (int)rowCount);
        if (numberOfAlarmsToReduce != counterColumn) {
            final ArrayList reducedEvents = new ArrayList();
            this.jdbcTemplate.getJdbcOperations().query("select eventid from events where alarmID is not null", new RowCallbackHandler(){

                public void processRow(ResultSet rs) throws SQLException {
                    reducedEvents.add(rs.getInt(1));
                }
            });
            Collections.sort(reducedEvents);
            final ArrayList nonReducedEvents = new ArrayList();
            this.jdbcTemplate.getJdbcOperations().query("select eventid from events where alarmID is null", new RowCallbackHandler(){

                public void processRow(ResultSet rs) throws SQLException {
                    nonReducedEvents.add(rs.getInt(1));
                }
            });
            Collections.sort(nonReducedEvents);
            JdbcAlarmWriterTest.fail((String)("number of alarms to reduce (" + numberOfAlarmsToReduce + ") were not reduced into a single alarm (only " + counterColumn + " were); " + "events that were reduced: " + StringUtils.collectionToCommaDelimitedString(reducedEvents) + "; events that were not reduced: " + StringUtils.collectionToCommaDelimitedString(nonReducedEvents)));
        }
        Integer alarmId = this.jdbcTemplate.queryForInt("select alarmId from alarms where reductionKey = ?", new Object[]{"countThese"});
        rowCount = this.jdbcTemplate.queryForInt("select count(*) from events where alarmid = ?", new Object[]{alarmId});
        MockUtil.println((String)(String.valueOf(rowCount) + " of events with alarmid: " + alarmId));
        rowCount = this.jdbcTemplate.queryForInt("select count(*) from events where alarmid is null", new Object[0]);
        MockUtil.println((String)(String.valueOf(rowCount) + " of events with null alarmid"));
        JdbcAlarmWriterTest.assertEquals((int)0, (int)rowCount);
    }

    public void testNullEvent() throws Exception {
        ThrowableAnticipator ta = new ThrowableAnticipator();
        ta.anticipate((Throwable)new IllegalArgumentException("event argument must not be null"));
        try {
            this.m_jdbcAlarmWriter.process(null, null);
        }
        catch (Throwable t) {
            ta.throwableReceived(t);
        }
        ta.verifyAnticipated();
    }

    public void testNoLogmsg() throws Exception {
        Event event = new Event();
        event.setAlarmData(new AlarmData());
        ThrowableAnticipator ta = new ThrowableAnticipator();
        ta.anticipate((Throwable)new IllegalArgumentException("event does not have a logmsg"));
        try {
            this.m_jdbcAlarmWriter.process(null, event);
        }
        catch (Throwable t) {
            ta.throwableReceived(t);
        }
        ta.verifyAnticipated();
    }

    public void testNoAlarmData() throws Exception {
        Event event = new Event();
        event.setLogmsg(new Logmsg());
        this.m_jdbcAlarmWriter.process(null, event);
    }

    public void testNoDbid() throws Exception {
        Event event = new Event();
        event.setLogmsg(new Logmsg());
        event.setAlarmData(new AlarmData());
        ThrowableAnticipator ta = new ThrowableAnticipator();
        ta.anticipate((Throwable)new IllegalArgumentException("event does not have a dbid"));
        try {
            this.m_jdbcAlarmWriter.process(null, event);
        }
        catch (Throwable t) {
            ta.throwableReceived(t);
        }
        ta.verifyAnticipated();
    }

    private void sendNodeDownEvent(String reductionKey, MockNode node) throws SQLException {
        Event event = MockEventUtil.createNodeDownEvent("Test", node);
        if (reductionKey != null) {
            AlarmData data = new AlarmData();
            data.setAlarmType(1);
            data.setReductionKey(reductionKey);
            event.setAlarmData(data);
        } else {
            event.setAlarmData(null);
        }
        Logmsg logmsg = new Logmsg();
        logmsg.setDest("logndisplay");
        logmsg.setContent("testing");
        event.setLogmsg(logmsg);
        this.m_jdbcEventWriter.process(null, event);
        this.m_jdbcAlarmWriter.process(null, event);
    }
}

