/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.config;

import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import javax.sql.DataSource;
import junit.framework.TestCase;
import org.exolab.castor.xml.MarshalException;
import org.exolab.castor.xml.ValidationException;
import org.opennms.netmgt.config.DataSourceFactory;
import org.opennms.netmgt.config.MonitoringLocationsFactory;
import org.opennms.netmgt.config.PollerConfigManager;
import org.opennms.netmgt.config.monitoringLocations.LocationDef;
import org.opennms.netmgt.mock.MockDatabase;
import org.opennms.netmgt.mock.MockNetwork;

public class MonitoringLocationsFactoryTest
extends TestCase {
    private MonitoringLocationsFactory m_locationFactory;
    private PollerConfigManager m_pollerConfigManager;

    protected void setUp() throws Exception {
        super.setUp();
        MockNetwork network = new MockNetwork();
        MockDatabase db = new MockDatabase();
        db.populate(network);
        DataSourceFactory.setInstance((DataSource)((Object)db));
        InputStreamReader rdr = new InputStreamReader(((Object)((Object)this)).getClass().getResourceAsStream("/org/opennms/netmgt/config/monitoring-locations.testdata.xml"));
        this.m_locationFactory = new MonitoringLocationsFactory((Reader)rdr);
        ((Reader)rdr).close();
        rdr = new InputStreamReader(((Object)((Object)this)).getClass().getResourceAsStream("/org/opennms/netmgt/config/poller-configuration.testdata.xml"));
        this.m_pollerConfigManager = new TestPollerConfigManager(rdr, "localhost", false);
        ((Reader)rdr).close();
    }

    protected void tearDown() throws Exception {
        super.tearDown();
    }

    public void testGetName() throws MarshalException, ValidationException, IOException {
        String locationName = "RDU";
        LocationDef def = this.m_locationFactory.getDef("RDU");
        MonitoringLocationsFactoryTest.assertNotNull((Object)def);
        MonitoringLocationsFactoryTest.assertEquals((String)"RDU", (String)def.getLocationName());
        MonitoringLocationsFactoryTest.assertEquals((String)"raleigh", (String)def.getMonitoringArea());
        MonitoringLocationsFactoryTest.assertNotNull((Object)this.m_pollerConfigManager.getPackage(def.getPollingPackageName()));
    }

    static class TestPollerConfigManager
    extends PollerConfigManager {
        String m_xml;

        public TestPollerConfigManager(Reader rdr, String localServer, boolean verifyServer) throws MarshalException, ValidationException, IOException {
            super(rdr, localServer, verifyServer);
            this.save();
        }

        public void update() throws IOException, MarshalException, ValidationException {
            this.reloadXML(new StringReader(this.m_xml));
        }

        protected void saveXml(String xml) throws IOException {
            this.m_xml = xml;
        }

        public String getXml() {
            return this.m_xml;
        }
    }
}

