/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.vacuumd;

import java.io.Reader;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.commons.io.IOUtils;
import org.opennms.netmgt.config.DataSourceFactory;
import org.opennms.netmgt.config.VacuumdConfigFactory;
import org.opennms.netmgt.config.vacuumd.Automation;
import org.opennms.netmgt.config.vacuumd.Trigger;
import org.opennms.netmgt.eventd.EventIpcManager;
import org.opennms.netmgt.mock.MockNode;
import org.opennms.netmgt.mock.OpenNMSTestCase;
import org.opennms.netmgt.model.events.EventBuilder;
import org.opennms.netmgt.vacuumd.AutomationProcessor;
import org.opennms.netmgt.vacuumd.Vacuumd;
import org.opennms.netmgt.xml.event.Event;
import org.opennms.test.ConfigurationTestUtils;
import org.opennms.test.mock.MockUtil;

public class VacuumdTest
extends OpenNMSTestCase {
    private static final long TEAR_DOWN_WAIT_MILLIS = 1000L;
    private Vacuumd m_vacuumd;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setUp() throws Exception {
        super.setUp();
        Reader rdr = ConfigurationTestUtils.getReaderForResource((Object)((Object)this), (String)"/org/opennms/netmgt/vacuumd/vacuumd-configuration.xml");
        try {
            VacuumdConfigFactory.setInstance((VacuumdConfigFactory)new VacuumdConfigFactory(rdr));
        }
        finally {
            IOUtils.closeQuietly((Reader)rdr);
        }
        this.m_vacuumd = Vacuumd.getSingleton();
        this.m_vacuumd.setEventManager((EventIpcManager)m_eventdIpcMgr);
        this.m_vacuumd.init();
        MockUtil.println((String)("------------ Finished setup for: " + this.getName() + " --------------------------"));
    }

    protected void tearDown() throws Exception {
        super.tearDown();
        MockUtil.println((String)"Sleeping for 1000 millis in tearDown...");
        Thread.sleep(1000L);
    }

    public final void testRunStatements() {
        this.m_vacuumd.executeStatements();
    }

    public final void testConcurrency() throws InterruptedException {
        VacuumdTest.assertEquals((int)0, (int)this.m_vacuumd.getStatus());
        VacuumdTest.assertEquals((int)0, (int)this.m_vacuumd.getScheduler().getStatus());
        this.m_vacuumd.start();
        VacuumdTest.assertTrue((this.m_vacuumd.getStatus() >= 1 ? 1 : 0) != 0);
        Thread.sleep(200L);
        VacuumdTest.assertEquals((int)2, (int)this.m_vacuumd.getStatus());
        VacuumdTest.assertEquals((int)2, (int)this.m_vacuumd.getScheduler().getStatus());
        this.m_vacuumd.pause();
        Thread.sleep(200L);
        VacuumdTest.assertEquals((int)6, (int)this.m_vacuumd.getStatus());
        VacuumdTest.assertEquals((int)6, (int)this.m_vacuumd.getScheduler().getStatus());
        this.m_vacuumd.resume();
        Thread.sleep(200L);
        VacuumdTest.assertEquals((int)2, (int)this.m_vacuumd.getStatus());
        VacuumdTest.assertEquals((int)2, (int)this.m_vacuumd.getScheduler().getStatus());
        this.bringNodeDownCreatingEvent(1);
        Thread.sleep(5000L);
        VacuumdTest.assertEquals((String)"alarm count", (int)1, (int)this.verifyInitialAlarmState());
        this.bringNodeDownCreatingEvent(1);
        Thread.sleep(1500L);
        VacuumdTest.assertEquals((String)"counter in the alarm", (int)2, (int)this.getJdbcTemplate().queryForInt("select counter from alarms", new Object[0]));
        int currentSeverity = this.getJdbcTemplate().queryForInt("select severity from alarms", new Object[0]);
        Thread.sleep(VacuumdConfigFactory.getInstance().getAutomation("autoEscalate").getInterval() + 100);
        VacuumdTest.assertEquals((String)"alarm severity -- should have been excalated", (int)(currentSeverity + 1), (int)this.verifyAlarmEscalated());
        EventBuilder builder = new EventBuilder("uei.opennms.org/internal/reloadVacuumdConfig", "test");
        Event e = builder.getEvent();
        m_eventdIpcMgr.sendNow(e);
        Thread.sleep(2000L);
        this.m_vacuumd.stop();
    }

    public final void testResultSetHasRequiredActionColumns() throws SQLException {
        Connection conn = DataSourceFactory.getInstance().getConnection();
        Statement stmt = conn.createStatement();
        ResultSet rs = stmt.executeQuery("select * from events");
        ArrayList columns = new ArrayList();
        AutomationProcessor ap = new AutomationProcessor(VacuumdConfigFactory.getInstance().getAutomation("cosmicClear"));
        VacuumdTest.assertTrue((boolean)ap.getAction().resultSetHasRequiredActionColumns(rs, columns));
    }

    public final void testGetAutomations() {
        VacuumdTest.assertEquals((int)6, (int)VacuumdConfigFactory.getInstance().getAutomations().size());
    }

    public final void testGetAutoEvents() {
        VacuumdTest.assertEquals((int)2, (int)VacuumdConfigFactory.getInstance().getAutoEvents().size());
    }

    public final void testGetTriggers() {
        VacuumdTest.assertEquals((int)5, (int)VacuumdConfigFactory.getInstance().getTriggers().size());
    }

    public final void testGetActions() {
        AutomationProcessor ap = new AutomationProcessor(VacuumdConfigFactory.getInstance().getAutomation("cosmicClear"));
        VacuumdTest.assertEquals((int)6, (int)VacuumdConfigFactory.getInstance().getActions().size());
        VacuumdTest.assertEquals((int)2, (int)ap.getAction().getTokenCount(VacuumdConfigFactory.getInstance().getAction("delete").getStatement().getContent()));
    }

    public final void testGetTrigger() {
        VacuumdTest.assertNotNull((Object)VacuumdConfigFactory.getInstance().getTrigger("selectAll"));
        VacuumdTest.assertEquals((int)1, (int)VacuumdConfigFactory.getInstance().getTrigger("selectAll").getRowCount());
        VacuumdTest.assertEquals((String)">=", (String)VacuumdConfigFactory.getInstance().getTrigger("selectAll").getOperator());
        VacuumdTest.assertNotNull((Object)VacuumdConfigFactory.getInstance().getTrigger("selectWithCounter"));
        VacuumdTest.assertNull((Object)VacuumdConfigFactory.getInstance().getTrigger("selectWithCounter").getOperator());
        VacuumdTest.assertEquals((int)0, (int)VacuumdConfigFactory.getInstance().getTrigger("selectWithCounter").getRowCount());
    }

    public final void testGetAction() {
        VacuumdTest.assertNotNull((Object)VacuumdConfigFactory.getInstance().getAction("clear"));
        VacuumdTest.assertNotNull((Object)VacuumdConfigFactory.getInstance().getAction("escalate"));
        VacuumdTest.assertNotNull((Object)VacuumdConfigFactory.getInstance().getAction("delete"));
    }

    public final void testGetAutomation() {
        VacuumdTest.assertNotNull((Object)VacuumdConfigFactory.getInstance().getAutomation("autoEscalate"));
    }

    public final void testRunTrigger() throws InterruptedException {
        Collection triggers = VacuumdConfigFactory.getInstance().getTriggers();
        VacuumdTest.assertEquals((int)5, (int)triggers.size());
        Trigger trigger = VacuumdConfigFactory.getInstance().getTrigger("selectAll");
        String triggerSql = trigger.getStatement().getContent();
        MockUtil.println((String)("Running trigger query: " + triggerSql));
        int count = this.getJdbcTemplate().queryForList(triggerSql, new Object[0]).size();
        AutomationProcessor ap = new AutomationProcessor(VacuumdConfigFactory.getInstance().getAutomation("cosmicClear"));
        VacuumdTest.assertFalse((String)("Testing the result rows:" + count + " with the trigger operator " + trigger.getOperator() + " against the required rows:" + trigger.getRowCount()), (boolean)ap.getTrigger().triggerRowCheck(trigger.getRowCount(), trigger.getOperator(), count));
        VacuumdTest.assertEquals((int)0, (int)count);
    }

    public final void testRunAutomation() throws SQLException, InterruptedException {
        int major = 6;
        this.bringNodeDownCreatingEvent(1);
        Thread.sleep(500L);
        VacuumdTest.assertEquals((int)1, (int)this.verifyInitialAlarmState());
        VacuumdTest.assertEquals((int)6, (int)this.getSingleResultSeverity());
        this.bringNodeDownCreatingEvent(1);
        Thread.sleep(500L);
        AutomationProcessor ap = new AutomationProcessor(VacuumdConfigFactory.getInstance().getAutomation("autoEscalate"));
        Thread.sleep(500L);
        VacuumdTest.assertTrue((boolean)ap.runAutomation());
        VacuumdTest.assertEquals((int)7, (int)this.getSingleResultSeverity());
    }

    public final void testRunAutomationWithNoTrigger() throws InterruptedException, SQLException {
        this.bringNodeDownCreatingEvent(1);
        Thread.sleep(500L);
        VacuumdTest.assertEquals((int)1, (int)this.verifyInitialAlarmState());
        AutomationProcessor ap = new AutomationProcessor(VacuumdConfigFactory.getInstance().getAutomation("cleanUpAlarms"));
        Thread.sleep(2000L);
        VacuumdTest.assertTrue((boolean)ap.runAutomation());
    }

    public final void testRunAutomationWithZeroResultsFromTrigger() throws InterruptedException, SQLException {
        this.bringNodeDownCreatingEvent(1);
        Thread.sleep(500L);
        VacuumdTest.assertEquals((int)1, (int)this.verifyInitialAlarmState());
        AutomationProcessor ap = new AutomationProcessor(VacuumdConfigFactory.getInstance().getAutomation("testZeroResults"));
        Thread.sleep(200L);
        VacuumdTest.assertTrue((boolean)ap.runAutomation());
    }

    public final void testCosmicClearAutomation() throws InterruptedException {
        this.bringNodeDownCreatingEvent(1);
        this.bringNodeDownCreatingEvent(2);
        Thread.sleep(1000L);
        this.bringNodeUpCreatingEvent(1);
        Thread.sleep(1000L);
        VacuumdTest.assertEquals((String)"clearUei for nodeUp", (String)"uei.opennms.org/nodes/nodeDown", (String)((String)this.getJdbcTemplate().queryForObject("select clearUei from alarms where eventUei = ?", String.class, new Object[]{"uei.opennms.org/nodes/nodeUp"})));
        VacuumdTest.assertEquals((String)"should have one alarm for each event", (long)3L, (long)this.getJdbcTemplate().queryForLong("select count(*) from alarms", new Object[0]));
        VacuumdTest.assertEquals((String)"alarms with severity == 2", (long)1L, (long)this.getJdbcTemplate().queryForLong("select count(*) from alarms where severity = 2", new Object[0]));
        VacuumdTest.assertEquals((String)"alarms with severity > 2", (long)2L, (long)this.getJdbcTemplate().queryForLong("select count(*) from alarms where severity > 2", new Object[0]));
        AutomationProcessor ap = new AutomationProcessor(VacuumdConfigFactory.getInstance().getAutomation("cosmicClear"));
        ap.run();
        Thread.sleep(1000L);
        VacuumdTest.assertEquals((String)"alarms with severity == 2", (long)1L, (long)this.getJdbcTemplate().queryForLong("select count(*) from alarms where severity = 2", new Object[0]));
        VacuumdTest.assertEquals((String)"alarms with severity > 2", (long)2L, (long)this.getJdbcTemplate().queryForLong("select count(*) from alarms where severity > 2", new Object[0]));
    }

    public void testGetTokenizedColumns() {
        AutomationProcessor ap = new AutomationProcessor(VacuumdConfigFactory.getInstance().getAutomation("cosmicClear"));
        List tokens = ap.getAction().getActionColumns();
        VacuumdTest.assertFalse((boolean)tokens.isEmpty());
    }

    public final void testGetName() {
        VacuumdTest.assertEquals((String)"OpenNMS.Vacuumd", (String)this.m_vacuumd.getName());
    }

    public final void testRunUpdate() {
    }

    public final void testGetTriggerSqlWithNoTriggerDefined() {
        Automation auto = VacuumdConfigFactory.getInstance().getAutomation("cleanUpAlarms");
        AutomationProcessor ap = new AutomationProcessor(auto);
        VacuumdTest.assertEquals(null, (String)ap.getTrigger().getTriggerSQL());
    }

    private int verifyInitialAlarmState() {
        return (int)this.getJdbcTemplate().queryForLong("select count(*) from alarms", new Object[0]);
    }

    private int verifyAlarmEscalated() {
        return this.getJdbcTemplate().queryForInt("select severity from alarms", new Object[0]);
    }

    private int getSingleResultSeverity() {
        return this.getJdbcTemplate().queryForInt("select severity from alarms", new Object[0]);
    }

    private void bringNodeDownCreatingEvent(int nodeid) {
        MockNode node = m_network.getNode(nodeid);
        m_eventdIpcMgr.sendNow(node.createDownEvent());
    }

    private void bringNodeUpCreatingEvent(int nodeid) {
        MockNode node = m_network.getNode(nodeid);
        m_eventdIpcMgr.sendNow(node.createUpEvent());
    }
}

