/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.utils;

import java.io.File;
import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import junit.framework.TestCase;
import org.opennms.netmgt.utils.JavaMailer;
import org.opennms.netmgt.utils.JavaMailerException;
import org.opennms.test.ThrowableAnticipator;
import org.opennms.test.mock.MockLogAppender;
import org.springframework.core.io.ClassPathResource;

public class JavaMailerTest
extends TestCase {
    private static final String TEST_ADDRESS = "test@opennms.org";

    protected void setUp() throws IOException {
        MockLogAppender.setupLogging();
        ClassPathResource resource = new ClassPathResource("/etc/javamail-configuration.properties");
        File homeDir = resource.getFile().getParentFile().getParentFile();
        System.out.println("homeDir: " + homeDir.getAbsolutePath());
        System.setProperty("opennms.home", homeDir.getAbsolutePath());
    }

    protected void runTest() throws Throwable {
        super.runTest();
        MockLogAppender.assertNoWarningsOrGreater();
    }

    public void testNothing() throws Exception {
    }

    public final void testJavaMailerWithDefaults() throws Exception {
        JavaMailer jm = this.createMailer("Test message from testJavaMailer using details");
        jm.mailSend();
    }

    public final void testJavaMailerWithNullTo() throws Exception {
        JavaMailer jm = this.createMailer("Test message from testJavaMailer without MTA");
        jm.setTo(null);
        ThrowableAnticipator ta = new ThrowableAnticipator();
        ta.anticipate((Throwable)new JavaMailerException("Cannot have a null to address."));
        try {
            jm.mailSend();
        }
        catch (Throwable t) {
            ta.throwableReceived(t);
        }
        ta.verifyAnticipated();
    }

    public final void testJavaMailerWithEmptyTo() throws Exception {
        JavaMailer jm = this.createMailer("Test message from testJavaMailer without MTA");
        jm.setTo("");
        ThrowableAnticipator ta = new ThrowableAnticipator();
        ta.anticipate((Throwable)new JavaMailerException("Cannot have an empty to address."));
        try {
            jm.mailSend();
        }
        catch (Throwable t) {
            ta.throwableReceived(t);
        }
        ta.verifyAnticipated();
    }

    public final void testJavaMailerWithNullFrom() throws Exception {
        JavaMailer jm = this.createMailer("Test message from testJavaMailer without MTA");
        jm.setFrom(null);
        ThrowableAnticipator ta = new ThrowableAnticipator();
        ta.anticipate((Throwable)new JavaMailerException("Cannot have a null from address."));
        try {
            jm.mailSend();
        }
        catch (Throwable t) {
            ta.throwableReceived(t);
        }
        ta.verifyAnticipated();
    }

    public final void testJavaMailerWithEmptyFrom() throws Exception {
        JavaMailer jm = this.createMailer("Test message from testJavaMailer without MTA");
        jm.setFrom("");
        ThrowableAnticipator ta = new ThrowableAnticipator();
        ta.anticipate((Throwable)new JavaMailerException("Cannot have an empty from address."));
        try {
            jm.mailSend();
        }
        catch (Throwable t) {
            ta.throwableReceived(t);
        }
        ta.verifyAnticipated();
    }

    public final void testJavaMailerWithNullSubject() throws Exception {
        JavaMailer jm = this.createMailer("Test message from testJavaMailer without MTA");
        jm.setSubject(null);
        ThrowableAnticipator ta = new ThrowableAnticipator();
        ta.anticipate((Throwable)new JavaMailerException("Cannot have a null subject."));
        try {
            jm.mailSend();
        }
        catch (Throwable t) {
            ta.throwableReceived(t);
        }
        ta.verifyAnticipated();
    }

    public final void testJavaMailerWithEmptySbuject() throws Exception {
        JavaMailer jm = this.createMailer("Test message from testJavaMailer without MTA");
        jm.setSubject("");
        ThrowableAnticipator ta = new ThrowableAnticipator();
        ta.anticipate((Throwable)new JavaMailerException("Cannot have an empty subject."));
        try {
            jm.mailSend();
        }
        catch (Throwable t) {
            ta.throwableReceived(t);
        }
        ta.verifyAnticipated();
    }

    public final void testJavaMailerWithNullMessageText() throws Exception {
        JavaMailer jm = this.createMailer("Test message from testJavaMailer without MTA");
        jm.setMessageText(null);
        ThrowableAnticipator ta = new ThrowableAnticipator();
        ta.anticipate((Throwable)new JavaMailerException("Cannot have a null messageText."));
        try {
            jm.mailSend();
        }
        catch (Throwable t) {
            ta.throwableReceived(t);
        }
        ta.verifyAnticipated();
    }

    public final void testJavaMailerWithEmptyMessageText() throws Exception {
        JavaMailer jm = this.createMailer("Test message from testJavaMailer without MTA");
        jm.setMessageText("");
        ThrowableAnticipator ta = new ThrowableAnticipator();
        ta.anticipate((Throwable)new JavaMailerException("Cannot have an empty messageText."));
        try {
            jm.mailSend();
        }
        catch (Throwable t) {
            ta.throwableReceived(t);
        }
        ta.verifyAnticipated();
    }

    public final void FIXMEtestJavaMailerUsingMTAExplicitly() throws Exception {
        JavaMailer jm = this.createMailer("Test message from testJavaMailer using MTA explicitly");
        if (jm.isSmtpSsl()) {
            return;
        }
        jm.setUseJMTA(true);
        jm.mailSend();
    }

    public final void FIXMEtestJavaMailerUsingMTAByTransport() throws Exception {
        JavaMailer jm = this.createMailer("Test message from testJavaMailer using MTA by transport");
        if (jm.isSmtpSsl()) {
            return;
        }
        jm.setUseJMTA(false);
        jm.setTransport("mta");
        jm.mailSend();
    }

    public final void testJavaMailerWithFileAttachment() throws Exception {
        JavaMailer jm = this.createMailer("Test message with file attachment from testJavaMailer");
        jm.setFileName("/etc/shells");
        jm.mailSend();
    }

    private JavaMailer createMailer(String subject) throws JavaMailerException {
        JavaMailer jm = new JavaMailer();
        jm.setFrom(TEST_ADDRESS);
        jm.setMessageText(subject + ": " + this.getLocalHost());
        jm.setSubject("Testing JavaMailer");
        jm.setTo(TEST_ADDRESS);
        return jm;
    }

    private InetAddress getLocalHost() {
        try {
            return InetAddress.getLocalHost();
        }
        catch (UnknownHostException e) {
            JavaMailerTest.fail((String)("Could not lookup local host address: " + e));
            return null;
        }
    }
}

