/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.translator;

import java.io.Reader;
import java.io.StringReader;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.List;
import javax.sql.DataSource;
import org.exolab.castor.xml.MarshalException;
import org.exolab.castor.xml.ValidationException;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.opennms.netmgt.capsd.EventUtils;
import org.opennms.netmgt.config.DataSourceFactory;
import org.opennms.netmgt.config.EventTranslatorConfig;
import org.opennms.netmgt.config.EventTranslatorConfigFactory;
import org.opennms.netmgt.eventd.EventIpcManager;
import org.opennms.netmgt.mock.EventAnticipator;
import org.opennms.netmgt.mock.MockDatabase;
import org.opennms.netmgt.mock.MockEventIpcManager;
import org.opennms.netmgt.mock.MockEventUtil;
import org.opennms.netmgt.mock.MockNetwork;
import org.opennms.netmgt.mock.OutageAnticipator;
import org.opennms.netmgt.model.events.EventBuilder;
import org.opennms.netmgt.translator.EventTranslator;
import org.opennms.netmgt.xml.event.Event;
import org.opennms.netmgt.xml.event.Logmsg;
import org.opennms.netmgt.xml.event.Parm;
import org.opennms.netmgt.xml.event.Parms;
import org.opennms.netmgt.xml.event.Value;
import org.opennms.test.mock.MockLogAppender;

public class EventTranslatorTest {
    private EventTranslator m_translator;
    private String m_passiveStatusConfiguration = this.getStandardConfig();
    private MockEventIpcManager m_eventMgr;
    private MockDatabase m_db;
    private MockNetwork m_network;
    private EventAnticipator m_anticipator;
    private OutageAnticipator m_outageAnticipator;
    private EventTranslatorConfigFactory m_config;

    @Before
    public void setUp() throws Exception {
        MockLogAppender.setupLogging();
        this.createMockNetwork();
        this.createMockDb();
        this.createAnticipators();
        this.m_eventMgr = new MockEventIpcManager();
        this.m_eventMgr.setEventWriter(this.m_db);
        this.m_eventMgr.setEventAnticipator(this.m_anticipator);
        this.m_eventMgr.addEventListener(this.m_outageAnticipator);
        this.m_eventMgr.setSynchronous(true);
        StringReader rdr = new StringReader(this.m_passiveStatusConfiguration);
        this.m_config = new EventTranslatorConfigFactory((Reader)rdr, (DataSource)((Object)this.m_db));
        EventTranslatorConfigFactory.setInstance((EventTranslatorConfig)this.m_config);
        this.m_translator = EventTranslator.getInstance();
        this.m_translator.setEventManager((EventIpcManager)this.m_eventMgr);
        this.m_translator.setConfig(EventTranslatorConfigFactory.getInstance());
        this.m_translator.setDataSource((DataSource)((Object)this.m_db));
        this.m_translator.init();
        this.m_translator.start();
    }

    @After
    public void tearDown() throws Exception {
        this.m_eventMgr.finishProcessingEvents();
        this.m_translator.stop();
        this.sleep(200L);
        MockLogAppender.assertNoWarningsOrGreater();
        DataSourceFactory.setInstance(null);
        this.m_db.drop();
    }

    private void createAnticipators() {
        this.m_anticipator = new EventAnticipator();
        this.m_outageAnticipator = new OutageAnticipator(this.m_db);
    }

    private void createMockDb() throws Exception {
        this.m_db = new MockDatabase();
        this.m_db.populate(this.m_network);
        DataSourceFactory.setInstance((DataSource)((Object)this.m_db));
    }

    private void createMockNetwork() {
        this.m_network = new MockNetwork();
        this.m_network.setCriticalService("ICMP");
        this.m_network.addNode(1, "Router");
        this.m_network.addInterface("192.168.1.1");
        this.m_network.addService("ICMP");
        this.m_network.addService("SMTP");
        this.m_network.addInterface("192.168.1.2");
        this.m_network.addService("ICMP");
        this.m_network.addService("SMTP");
        this.m_network.addNode(2, "Server");
        this.m_network.addInterface("192.168.1.3");
        this.m_network.addService("ICMP");
        this.m_network.addService("HTTP");
        this.m_network.addNode(3, "Firewall");
        this.m_network.addInterface("192.168.1.4");
        this.m_network.addService("SMTP");
        this.m_network.addService("HTTP");
        this.m_network.addInterface("192.168.1.5");
        this.m_network.addService("SMTP");
        this.m_network.addService("HTTP");
        this.m_network.addNode(100, "localhost");
        this.m_network.addInterface("127.0.0.1");
        this.m_network.addService("PSV");
        this.m_network.addService("PSV2");
    }

    private void sleep(long millis) {
        try {
            Thread.sleep(millis);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    @Test
    public void testSubElementString() throws Exception {
        this.m_passiveStatusConfiguration = this.getSqlSubValueString();
        this.tearDown();
        this.setUp();
        this.testTranslateEvent();
    }

    @Test
    public void testSubElementLong() throws Exception {
        this.m_passiveStatusConfiguration = this.getSqlSubValueLong();
        this.tearDown();
        this.setUp();
        this.testTranslateEvent();
    }

    @Test
    public void testIsTranslationEvent() throws Exception {
        Event pse = this.createTestEvent("someOtherUei", "Router", "192.168.1.1", "ICMP", "Down");
        Assert.assertFalse((boolean)this.m_config.isTranslationEvent(pse));
        Event te = this.createTestEvent("translationTest", "Router", "192.168.1.1", "ICMP", "Down");
        Assert.assertTrue((boolean)this.m_config.isTranslationEvent(te));
        Event teWithNullParms = this.createTestEvent("translationTest", "Router", "192.168.1.1", "ICMP", "Down");
        teWithNullParms.setParms(null);
        Assert.assertFalse((boolean)this.m_config.isTranslationEvent(teWithNullParms));
        Event teWithNoParms = this.createTestEvent("translationTest", "Router", "192.168.1.1", "ICMP", "Down");
        Parms parms = teWithNoParms.getParms();
        parms.removeAllParm();
        Assert.assertFalse((boolean)this.m_config.isTranslationEvent(teWithNoParms));
        Event teWithWrongParms = this.createTestEvent("translationTest", "Router", "192.168.1.1", "ICMP", "Down");
        Parms p = teWithWrongParms.getParms();
        p.getParm(2).setParmName("unmatching");
        Assert.assertFalse((boolean)this.m_config.isTranslationEvent(teWithWrongParms));
        Event te2 = this.createTestEvent("translationTest", "Router", "xxx192.168.1.1xxx", "ICMP", "Down");
        Assert.assertTrue((boolean)this.m_config.isTranslationEvent(te2));
        Event te3 = this.createTestEvent("translationTest", "Router", "xxx192.168.1.2", "ICMP", "Down");
        Assert.assertFalse((boolean)this.m_config.isTranslationEvent(te3));
    }

    @Test
    public void testTranslateEvent() throws MarshalException, ValidationException {
        Event pse = this.createTestEvent("someOtherUei", "Router", "192.168.1.1", "ICMP", "Down");
        Assert.assertTrue((boolean)this.m_config.translateEvent(pse).isEmpty());
        Event te = this.createTestEvent("translationTest", "Router", "192.168.1.1", "ICMP", "This node is way Down!");
        List translatedEvents = this.m_config.translateEvent(te);
        Assert.assertNotNull((Object)translatedEvents);
        Assert.assertEquals((long)1L, (long)translatedEvents.size());
        this.validateTranslatedEvent((Event)translatedEvents.get(0));
        Event teWithNullParms = this.createTestEvent("translationTest", "Router", "192.168.1.1", "ICMP", "Down");
        teWithNullParms.setParms(null);
        Assert.assertTrue((boolean)this.m_config.translateEvent(teWithNullParms).isEmpty());
        Event teWithNoParms = this.createTestEvent("translationTest", "Router", "192.168.1.1", "ICMP", "Down");
        Parms parms = teWithNoParms.getParms();
        parms.removeAllParm();
        Assert.assertTrue((boolean)this.m_config.translateEvent(teWithNoParms).isEmpty());
        Event teWithWrongParms = this.createTestEvent("translationTest", "Router", "192.168.1.1", "ICMP", "Down");
        Parms p = teWithWrongParms.getParms();
        p.getParm(2).setParmName("unmatching");
        Assert.assertTrue((boolean)this.m_config.translateEvent(teWithWrongParms).isEmpty());
        Event te2 = this.createTestEvent("translationTest", "Router", "xxx192.168.1.1xxx", "ICMP", "Down");
        Assert.assertNotNull((Object)this.m_config.translateEvent(te2));
        Assert.assertEquals((long)1L, (long)translatedEvents.size());
        this.validateTranslatedEvent((Event)translatedEvents.get(0));
        Event te3 = this.createTestEvent("translationTest", "Router", "xxx192.168.1.2", "ICMP", "Down");
        Assert.assertTrue((boolean)this.m_config.translateEvent(te3).isEmpty());
    }

    @Test
    public void testTranslateLinkDown() throws MarshalException, ValidationException, SQLException {
        StringReader rdr = new StringReader(this.getLinkDownTranslation());
        this.m_config = new EventTranslatorConfigFactory((Reader)rdr, (DataSource)((Object)this.m_db));
        EventTranslatorConfigFactory.setInstance((EventTranslatorConfig)this.m_config);
        this.m_translator = EventTranslator.getInstance();
        this.m_translator.setEventManager((EventIpcManager)this.m_eventMgr);
        this.m_translator.setConfig(EventTranslatorConfigFactory.getInstance());
        Connection c = this.m_db.getConnection();
        Statement stmt = c.createStatement();
        stmt.executeUpdate("update snmpinterface set snmpifname = 'david', snmpifalias = 'p-brane' WHERE nodeid = 1 and snmpifindex = 2");
        stmt.close();
        c.close();
        List translatedEvents = this.m_config.translateEvent(this.createLinkDownEvent());
        Assert.assertNotNull((Object)translatedEvents);
        Assert.assertEquals((long)1L, (long)translatedEvents.size());
        Assert.assertEquals((long)3L, (long)((Event)translatedEvents.get(0)).getParms().getParmCount());
        Assert.assertEquals((Object)".1.3.6.1.2.1.2.2.1.1.2", (Object)((Event)translatedEvents.get(0)).getParms().getParm(0).getParmName());
        Assert.assertEquals((Object)"ifName", (Object)((Event)translatedEvents.get(0)).getParms().getParm(1).getParmName());
        Assert.assertEquals((Object)"ifAlias", (Object)((Event)translatedEvents.get(0)).getParms().getParm(2).getParmName());
        Assert.assertEquals((Object)"david", (Object)((Event)translatedEvents.get(0)).getParms().getParm(1).getValue().getContent());
        Assert.assertEquals((Object)"p-brane", (Object)((Event)translatedEvents.get(0)).getParms().getParm(2).getValue().getContent());
    }

    private String getLinkDownTranslation() {
        String linkDownConfig = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<event-translator-configuration xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"\n  xsi:schemaLocation=\"http://xmlns.opennms.org/xsd/translator-configuration http://www.opennms.org/xsd/config/translator-configuration.xsd \">\n  <translation>\n    <!-- This translation is predifined for integration with Hyperic-HQ server and the OpenNMS integrations found in\n         the $OPENNMS_HOME/contrib/hyperic-integration directory -->\n    <event-translation-spec uei=\"uei.opennms.org/generic/traps/SNMP_Link_Down\">\n      <mappings>\n        <mapping>\n          <assignment name=\"ifName\" type=\"parameter\">\n            <value type=\"sql\" result=\"SELECT snmp.snmpIfName FROM snmpInterface snmp WHERE snmp.nodeid = ?::integer AND snmp.snmpifindex = ?::integer\" >\n              <value type=\"field\" name=\"nodeid\" matches=\".*\" result=\"${0}\" />\n              <value type=\"parameter\" name=\"~^\\.1\\.3\\.6\\.1\\.2\\.1\\.2\\.2\\.1\\.1\\.([0-9]*)$\" matches=\".*\" result=\"${0}\" />\n            </value>\n          </assignment>\n          <assignment name=\"ifAlias\" type=\"parameter\">\n            <value type=\"sql\" result=\"SELECT snmp.snmpIfAlias FROM snmpInterface snmp WHERE snmp.nodeid = ?::integer AND snmp.snmpifindex = ?::integer\" >\n              <value type=\"field\" name=\"nodeid\" matches=\".*\" result=\"${0}\" />\n              <value type=\"parameter\" name=\"~^\\.1\\.3\\.6\\.1\\.2\\.1\\.2\\.2\\.1\\.1\\.([0-9]*)$\" matches=\".*\" result=\"${0}\" />\n            </value>\n          </assignment>\n        </mapping>\n      </mappings>\n    </event-translation-spec>\n  </translation>\n</event-translator-configuration>";
        return linkDownConfig;
    }

    private void validateTranslatedEvent(Event event) {
        Assert.assertEquals((Object)this.m_translator.getName(), (Object)event.getSource());
        Assert.assertEquals((long)3L, (long)event.getNodeid());
        Assert.assertEquals((Object)"www.opennms.org", (Object)event.getHost());
        Assert.assertEquals((Object)"a generated event", (Object)event.getDescr());
        Assert.assertEquals((Object)"192.168.1.1", (Object)event.getInterface());
        Assert.assertEquals((Object)"Switch", (Object)EventUtils.getParm((Event)event, (String)"nodeLabel"));
        Assert.assertEquals((Object)"PSV", (Object)event.getService());
        Assert.assertEquals((Object)"Down", (Object)EventUtils.getParm((Event)event, (String)"passiveStatus"));
    }

    @Test
    public void testUEIList() {
        List ueis = this.m_config.getUEIList();
        Assert.assertEquals((long)1L, (long)ueis.size());
        Assert.assertTrue((boolean)ueis.contains("uei.opennms.org/services/translationTest"));
    }

    private Event createLinkDownEvent() {
        EventBuilder builder = new EventBuilder("uei.opennms.org/generic/traps/SNMP_Link_Down", "Trapd");
        builder.setField("nodeid", "1");
        builder.addParam(".1.3.6.1.2.1.2.2.1.1.2", "2");
        return builder.getEvent();
    }

    private Event createTestEvent(String type, String nodeLabel, String ipAddr, String serviceName, String status) {
        Parms parms = new Parms();
        if (nodeLabel != null) {
            parms.addParm(this.buildParm("passiveNodeLabel", nodeLabel));
        }
        if (ipAddr != null) {
            parms.addParm(this.buildParm("passiveIpAddr", ipAddr));
        }
        if (serviceName != null) {
            parms.addParm(this.buildParm("passiveServiceName", serviceName));
        }
        if (status != null) {
            parms.addParm(this.buildParm("passiveStatus", status));
        }
        return this.createEventWithParms("uei.opennms.org/services/" + type, parms);
    }

    private Event createEventWithParms(String uei, Parms parms) {
        Event e = MockEventUtil.createEvent("Automation", uei);
        e.setHost("localhost");
        e.setParms(parms);
        Logmsg logmsg = new Logmsg();
        logmsg.setContent("Testing Passive Status Keeper with down status");
        e.setLogmsg(logmsg);
        return e;
    }

    private Parm buildParm(String parmName, String parmValue) {
        Value v = new Value();
        v.setContent(parmValue);
        Parm p = new Parm();
        p.setParmName(parmName);
        p.setValue(v);
        return p;
    }

    private String getSqlSubValueLong() {
        return "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<event-translator-configuration \nxmlns=\"http://xmlns.opennms.org/xsd/translator-configuration\" \nxmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" >\n  <translation>\n   <event-translation-spec uei=\"uei.opennms.org/services/translationTest\">\n      <mappings>\n        <mapping>\n          <assignment type=\"field\" name=\"nodeid\">\n            <value type=\"sql\" result=\"select node.nodeid from node, ipInterface where node.nodeLabel=? and ipinterface.ipaddr=? and node.nodeId=ipinterface.nodeid and ipInterface.isManaged != 'D' and node.nodeType != 'D' and to_number(?, '999999') = 9999 \" >\n\t\t\t\t<value type=\"parameter\" name=\"passiveNodeLabel\" matches=\"Router\" result=\"Firewall\" />\n\t\t\t\t<value type=\"constant\" result=\"192.168.1.4\" />\n\t\t\t\t<value type=\"field\" name=\"nodeid\" result=\"9999\" />\n\t\t\t</value>\n          </assignment>\n          <assignment type=\"parameter\" name=\"nodeLabel\">\n            <value type=\"field\" name=\"host\" result=\"Switch\" />\n          </assignment>\n          <assignment type=\"field\" name=\"interface\">\n            <value type=\"parameter\" name=\"passiveIpAddr\" matches=\".*(192\\.168\\.1\\.1).*\" result=\"192.168.1.1\" />\n          </assignment>\n\t\t  <assignment type=\"field\" name=\"host\">\n\t\t\t<value type=\"field\" name=\"host\" result=\"www.opennms.org\" />\n\t\t  </assignment>\n\t\t  <assignment type=\"field\" name=\"descr\">\n\t\t\t<value type=\"constant\" result=\"a generated event\" />\n\t\t  </assignment>\n          <assignment type=\"field\" name=\"service\">\n            <value type=\"parameter\" name=\"passiveServiceName\" result=\"PSV\" />\n          </assignment>\n          <assignment type=\"parameter\" name=\"passiveStatus\">\n            <value type=\"parameter\" name=\"passiveStatus\" matches=\".*(Up|Down).*\" result=\"${1}\" />\n          </assignment>\n        </mapping>\n      </mappings>\n    </event-translation-spec>\n  </translation>\n</event-translator-configuration>\n";
    }

    private String getSqlSubValueString() {
        return "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<event-translator-configuration \nxmlns=\"http://xmlns.opennms.org/xsd/translator-configuration\" \nxmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" >\n  <translation>\n   <event-translation-spec uei=\"uei.opennms.org/services/translationTest\">\n      <mappings>\n        <mapping>\n          <assignment type=\"field\" name=\"nodeid\">\n            <value type=\"sql\" result=\"select node.nodeid from node, ipInterface where node.nodeLabel=? and ipinterface.ipaddr=? and node.nodeId=ipinterface.nodeid and ipInterface.isManaged != 'D' and node.nodeType != 'D' and ? = 'test' \" >\n\t\t\t\t<value type=\"parameter\" name=\"passiveNodeLabel\" matches=\"Router\" result=\"Firewall\" />\n\t\t\t\t<value type=\"constant\" result=\"192.168.1.4\" />\n\t\t\t\t<value type=\"field\" name=\"host\" result=\"test\" />\n\t\t\t</value>\n          </assignment>\n          <assignment type=\"parameter\" name=\"nodeLabel\">\n            <value type=\"field\" name=\"host\" result=\"Switch\" />\n          </assignment>\n          <assignment type=\"field\" name=\"interface\">\n            <value type=\"parameter\" name=\"passiveIpAddr\" matches=\".*(192\\.168\\.1\\.1).*\" result=\"192.168.1.1\" />\n          </assignment>\n\t\t  <assignment type=\"field\" name=\"host\">\n\t\t\t<value type=\"field\" name=\"host\" result=\"www.opennms.org\" />\n\t\t  </assignment>\n\t\t  <assignment type=\"field\" name=\"descr\">\n\t\t\t<value type=\"constant\" result=\"a generated event\" />\n\t\t  </assignment>\n          <assignment type=\"field\" name=\"service\">\n            <value type=\"parameter\" name=\"passiveServiceName\" result=\"PSV\" />\n          </assignment>\n          <assignment type=\"parameter\" name=\"passiveStatus\">\n            <value type=\"parameter\" name=\"passiveStatus\" matches=\".*(Up|Down).*\" result=\"${1}\" />\n          </assignment>\n        </mapping>\n      </mappings>\n    </event-translation-spec>\n  </translation>\n</event-translator-configuration>\n";
    }

    private String getStandardConfig() {
        return "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<event-translator-configuration \nxmlns=\"http://xmlns.opennms.org/xsd/translator-configuration\" \nxmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" >\n  <translation>\n   <event-translation-spec uei=\"uei.opennms.org/services/translationTest\">\n      <mappings>\n        <mapping>\n          <assignment type=\"field\" name=\"nodeid\">\n            <value type=\"sql\" result=\"select node.nodeid from node, ipInterface where node.nodeLabel=? and ipinterface.ipaddr=? and node.nodeId=ipinterface.nodeid and ipInterface.isManaged != 'D' and node.nodeType != 'D'\" >\n\t\t\t\t<value type=\"parameter\" name=\"passiveNodeLabel\" matches=\"Router\" result=\"Firewall\" />\n\t\t\t\t<value type=\"constant\" result=\"192.168.1.4\" />\n\t\t\t</value>\n          </assignment>\n          <assignment type=\"parameter\" name=\"nodeLabel\">\n            <value type=\"field\" name=\"host\" result=\"Switch\" />\n          </assignment>\n          <assignment type=\"field\" name=\"interface\">\n            <value type=\"parameter\" name=\"passiveIpAddr\" matches=\".*(192\\.168\\.1\\.1).*\" result=\"192.168.1.1\" />\n          </assignment>\n\t\t  <assignment type=\"field\" name=\"host\">\n\t\t\t<value type=\"field\" name=\"host\" result=\"www.opennms.org\" />\n\t\t  </assignment>\n\t\t  <assignment type=\"field\" name=\"descr\">\n\t\t\t<value type=\"constant\" result=\"a generated event\" />\n\t\t  </assignment>\n          <assignment type=\"field\" name=\"service\">\n            <value type=\"parameter\" name=\"passiveServiceName\" result=\"PSV\" />\n          </assignment>\n          <assignment type=\"parameter\" name=\"passiveStatus\">\n            <value type=\"parameter\" name=\"passiveStatus\" matches=\".*(Up|Down).*\" result=\"${1}\" />\n          </assignment>\n        </mapping>\n      </mappings>\n    </event-translation-spec>\n  </translation>\n</event-translator-configuration>\n";
    }
}

