/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.threshd;

import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import junit.framework.TestCase;
import org.easymock.EasyMock;
import org.jrobin.core.RrdDb;
import org.jrobin.core.RrdDef;
import org.jrobin.core.Sample;
import org.opennms.netmgt.config.ThresholdingConfigFactory;
import org.opennms.netmgt.config.threshd.Basethresholddef;
import org.opennms.netmgt.rrd.RrdConfig;
import org.opennms.netmgt.rrd.RrdException;
import org.opennms.netmgt.rrd.RrdUtils;
import org.opennms.netmgt.threshd.DefaultThresholdsDao;
import org.opennms.netmgt.threshd.IfInfoGetter;
import org.opennms.netmgt.threshd.SnmpThresholdNetworkInterface;
import org.opennms.netmgt.threshd.SnmpThresholder;
import org.opennms.netmgt.threshd.ThresholdGroup;
import org.opennms.netmgt.threshd.ThresholdNetworkInterface;
import org.opennms.netmgt.threshd.ThresholdResourceType;
import org.opennms.netmgt.threshd.ThresholderTestCase;
import org.opennms.netmgt.threshd.ThresholdsDao;
import org.opennms.netmgt.xml.event.Event;
import org.opennms.netmgt.xml.event.Events;
import org.opennms.test.FileAnticipator;
import org.opennms.test.ThrowableAnticipator;
import org.opennms.test.mock.EasyMockUtils;
import org.springframework.core.io.ClassPathResource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SnmpThresholderTest
extends TestCase {
    private SnmpThresholder m_snmpThresholder;
    private ThresholdNetworkInterface m_iface;
    private SnmpThresholdNetworkInterface m_thresholdInterface;
    private Map<String, String> m_params;
    private DefaultThresholdsDao m_thresholdsDao;
    private FileAnticipator m_fileAnticipator;
    private IfInfoGetter m_ifInfoGetter;
    private EasyMockUtils m_mocks = new EasyMockUtils();

    protected void setUp() throws Exception {
        super.setUp();
        this.m_fileAnticipator = new FileAnticipator();
        int nodeId = 1;
        String ipAddress = "192.168.1.1";
        this.setUpThresholdingConfig();
        this.m_thresholdsDao = new DefaultThresholdsDao();
        this.m_thresholdsDao.setThresholdingConfigFactory(ThresholdingConfigFactory.getInstance());
        this.m_thresholdsDao.afterPropertiesSet();
        this.m_snmpThresholder = new SnmpThresholder();
        this.m_snmpThresholder.setThresholdsDao((ThresholdsDao)this.m_thresholdsDao);
        this.m_ifInfoGetter = (IfInfoGetter)this.m_mocks.createMock(IfInfoGetter.class);
        this.m_snmpThresholder.setIfInfoGetter(this.m_ifInfoGetter);
        this.m_iface = new ThresholderTestCase.ThresholdNetworkInterfaceImpl(nodeId, InetAddress.getByName(ipAddress));
        this.m_params = new HashMap<String, String>();
        this.m_params.put("thresholding-group", "default-snmp");
        this.m_thresholdInterface = new SnmpThresholdNetworkInterface((ThresholdsDao)this.m_thresholdsDao, this.m_iface, this.m_params);
    }

    protected void tearDown() {
        this.m_fileAnticipator.tearDown();
    }

    private void setUpThresholdingConfig() throws Exception {
        ClassPathResource config = new ClassPathResource("/test-thresholds.xml");
        InputStreamReader r = new InputStreamReader(config.getInputStream());
        ThresholdingConfigFactory.setInstance((ThresholdingConfigFactory)new ThresholdingConfigFactory((Reader)r));
        ((Reader)r).close();
    }

    public void testCheckNodeDirNullDirectory() {
        ThrowableAnticipator ta = new ThrowableAnticipator();
        ta.anticipate((Throwable)new IllegalArgumentException("directory argument cannot be null"));
        try {
            this.m_snmpThresholder.checkNodeDir(null, this.m_thresholdInterface, new Date(), new Events());
        }
        catch (Throwable t) {
            ta.throwableReceived(t);
        }
        ta.verifyAnticipated();
    }

    public void testCheckNodeDirNullThresholdNetworkInterface() {
        ThrowableAnticipator ta = new ThrowableAnticipator();
        ta.anticipate((Throwable)new IllegalArgumentException("thresholdNetworkInterface argument cannot be null"));
        try {
            this.m_snmpThresholder.checkNodeDir(new File(""), null, new Date(), new Events());
        }
        catch (Throwable t) {
            ta.throwableReceived(t);
        }
        ta.verifyAnticipated();
    }

    public void FIXMEtestCheckNodeDirNullThresholdConfiguration() {
        ThrowableAnticipator ta = new ThrowableAnticipator();
        ta.anticipate((Throwable)new IllegalArgumentException("thresholdConfiguration argument cannot be null"));
        try {
            this.m_snmpThresholder.checkNodeDir(new File(""), null, new Date(), new Events());
        }
        catch (Throwable t) {
            ta.throwableReceived(t);
        }
        ta.verifyAnticipated();
    }

    public void testCheckNodeDirNullDate() {
        ThrowableAnticipator ta = new ThrowableAnticipator();
        ta.anticipate((Throwable)new IllegalArgumentException("date argument cannot be null"));
        try {
            this.m_snmpThresholder.checkNodeDir(new File(""), this.m_thresholdInterface, null, new Events());
        }
        catch (Throwable t) {
            ta.throwableReceived(t);
        }
        ta.verifyAnticipated();
    }

    public void testCheckNodeDirNullEvents() {
        ThrowableAnticipator ta = new ThrowableAnticipator();
        ta.anticipate((Throwable)new IllegalArgumentException("events argument cannot be null"));
        try {
            this.m_snmpThresholder.checkNodeDir(new File(""), this.m_thresholdInterface, new Date(), null);
        }
        catch (Throwable t) {
            ta.throwableReceived(t);
        }
        ta.verifyAnticipated();
    }

    public void FIXMEtestCheckNodeDirNullSnmpIfaceNodeId() throws Exception {
        ThresholderTestCase.ThresholdNetworkInterfaceImpl intf = new ThresholderTestCase.ThresholdNetworkInterfaceImpl(0, InetAddress.getByName("192.168.1.1"));
        SnmpThresholdNetworkInterface snmpIface = new SnmpThresholdNetworkInterface((ThresholdsDao)this.m_thresholdsDao, (ThresholdNetworkInterface)intf, this.m_params);
        ThrowableAnticipator ta = new ThrowableAnticipator();
        ta.anticipate((Throwable)new IllegalArgumentException("getNodeId() of snmpIface argument cannot be null"));
        try {
            this.m_snmpThresholder.checkNodeDir(new File(""), snmpIface, new Date(), new Events());
        }
        catch (Throwable t) {
            ta.throwableReceived(t);
        }
        ta.verifyAnticipated();
    }

    public void FIXMEtestCheckNodeDirNullSnmpIfaceInetAddress() {
        ThresholderTestCase.ThresholdNetworkInterfaceImpl intf = new ThresholderTestCase.ThresholdNetworkInterfaceImpl(1, null);
        SnmpThresholdNetworkInterface snmpIface = new SnmpThresholdNetworkInterface((ThresholdsDao)this.m_thresholdsDao, (ThresholdNetworkInterface)intf, this.m_params);
        ThrowableAnticipator ta = new ThrowableAnticipator();
        ta.anticipate((Throwable)new IllegalArgumentException("events argument cannot be null"));
        try {
            this.m_snmpThresholder.checkNodeDir(new File(""), snmpIface, new Date(), new Events());
        }
        catch (Throwable t) {
            ta.throwableReceived(t);
        }
        ta.verifyAnticipated();
    }

    public void testCheckNodeDirNullFoo() throws Exception {
        this.setUpRrdStrategy();
        this.m_snmpThresholder.checkNodeDir(new File(""), this.m_thresholdInterface, new Date(), new Events());
    }

    public void testStripRrdExtensionWithValidExtension() throws Exception {
        this.setUpRrdStrategy();
        String strippedName = this.m_snmpThresholder.stripRrdExtension("foo" + RrdUtils.getExtension());
        SnmpThresholderTest.assertNotNull((String)"stripped file name should not be null", (Object)strippedName);
        SnmpThresholderTest.assertEquals((String)"stripped file name", (String)"foo", (String)strippedName);
    }

    public void testStripRrdExtensionWithNoExtension() throws Exception {
        this.setUpRrdStrategy();
        String strippedName = this.m_snmpThresholder.stripRrdExtension("foo");
        SnmpThresholderTest.assertNull((String)("stripped file name should be null, but was: " + strippedName), (Object)strippedName);
    }

    public void testStripRrdExtensionWithValidExtensionTwice() throws Exception {
        this.setUpRrdStrategy();
        String strippedName = this.m_snmpThresholder.stripRrdExtension("foo" + RrdUtils.getExtension() + RrdUtils.getExtension());
        SnmpThresholderTest.assertNotNull((String)"stripped file name should not be null", (Object)strippedName);
        SnmpThresholderTest.assertEquals((String)"stripped file name", (String)("foo" + RrdUtils.getExtension()), (String)strippedName);
    }

    public void testStripRrdExtensionWithValidExtensionNotAtEnd() throws Exception {
        this.setUpRrdStrategy();
        String strippedName = this.m_snmpThresholder.stripRrdExtension("foo" + RrdUtils.getExtension() + ".bar");
        SnmpThresholderTest.assertNull((String)("stripped file name should be null, but was: " + strippedName), (Object)strippedName);
    }

    private void setUpRrdStrategy() throws RrdException {
        RrdConfig.setProperties((Properties)new Properties());
        RrdUtils.initialize();
    }

    public void testThresholdFilters() throws Exception {
        System.err.println("--------------------------------------------------------");
        ThresholdGroup group = this.m_thresholdsDao.get("generic-snmp");
        this.m_thresholdInterface.getThresholdConfiguration().setThresholdGroup(group);
        Collection thresholds = this.m_thresholdsDao.getThresholdingConfigFactory().getThresholds("generic-snmp");
        int count = 0;
        for (Basethresholddef threshold : thresholds) {
            count += threshold.getResourceFilterCount();
        }
        SnmpThresholderTest.assertEquals((int)4, (int)count);
    }

    public void testInterfaces() throws Exception {
        System.err.println("--------------------------------------------------------");
        this.setUpRrdStrategy();
        System.setProperty("org.opennms.rrd.storeByGroup", "true");
        ThresholdGroup group = this.m_thresholdsDao.get("generic-snmp");
        File path = this.m_fileAnticipator.getTempDir();
        File nodeDir = this.m_fileAnticipator.tempDir(path, "1");
        long start = System.currentTimeMillis();
        ArrayList<String> sources = new ArrayList<String>();
        sources.add("ifInOctets");
        sources.add("ifOutOctets");
        sources.add("ifInPackets");
        sources.add("ifOutPackets");
        File intf1Dir = this.m_fileAnticipator.tempDir(nodeDir, "eth0");
        File rrd1 = this.m_fileAnticipator.tempFile(intf1Dir, "mib2-stats.jrb");
        this.createDsProperties(intf1Dir, sources, "mib2-stats");
        ArrayList<String> data1 = new ArrayList<String>();
        data1.add("100:200:300:350");
        this.createAndUpdateRrd(rrd1, start, sources, data1);
        File intf2Dir = this.m_fileAnticipator.tempDir(nodeDir, "wlan0");
        File rrd2 = this.m_fileAnticipator.tempFile(intf2Dir, "mib2-stats.jrb");
        this.createDsProperties(intf2Dir, sources, "mib2-stats");
        ArrayList<String> data2 = new ArrayList<String>();
        data2.add("50:150:400:300");
        this.createAndUpdateRrd(rrd2, start, sources, data2);
        this.m_thresholdInterface.getThresholdConfiguration().setThresholdGroup(group);
        Events events = new Events();
        HashMap<String, String> ifInfoEth0 = new HashMap<String, String>();
        ifInfoEth0.put("snmpifindex", "1");
        ifInfoEth0.put("snmpifdesc", "eth0");
        ifInfoEth0.put("snmpifalias", "ethernet interface");
        EasyMock.expect((Object)this.m_ifInfoGetter.getIfInfoForNodeAndLabel(1, "eth0")).andReturn(ifInfoEth0).times(2);
        HashMap<String, String> ifInfoWlan0 = new HashMap<String, String>();
        ifInfoWlan0.put("snmpifindex", "2");
        ifInfoWlan0.put("snmpifdesc", "wlan0");
        ifInfoWlan0.put("snmpifalias", "wireless interface");
        EasyMock.expect((Object)this.m_ifInfoGetter.getIfInfoForNodeAndLabel(1, "wlan0")).andReturn(ifInfoWlan0).times(2);
        this.m_mocks.replayAll();
        this.m_snmpThresholder.checkIfDir(intf1Dir, this.m_thresholdInterface, new Date(start), events);
        this.m_snmpThresholder.checkIfDir(intf2Dir, this.m_thresholdInterface, new Date(start), events);
        this.m_mocks.verifyAll();
        SnmpThresholderTest.assertEquals((int)2, (int)events.getEventCount());
    }

    public void testThresholdWithGenericResourceTypes() throws Exception {
        System.err.println("--------------------------------------------------------");
        this.setUpRrdStrategy();
        System.setProperty("org.opennms.rrd.storeByGroup", "true");
        ThresholdGroup group = this.m_thresholdsDao.get("generic-snmp");
        SnmpThresholderTest.assertEquals((int)2, (int)((ThresholdResourceType)group.getGenericResourceTypeMap().get("frCircuitIfIndex")).getThresholdMap().size());
        File path = this.m_fileAnticipator.getTempDir();
        File nodeDir = this.m_fileAnticipator.tempDir(path, "1");
        File rtDir = this.m_fileAnticipator.tempDir(nodeDir, "frCircuitIfIndex");
        Properties strings = new Properties();
        long start = System.currentTimeMillis();
        ArrayList<String> sources = new ArrayList<String>();
        sources.add("frSentFrames");
        sources.add("frSentOctets");
        sources.add("frReceivedFrames");
        sources.add("frReceivedOctets");
        File r1Dir = this.m_fileAnticipator.tempDir(rtDir, "Se0.100");
        File rrd1 = this.m_fileAnticipator.tempFile(r1Dir, "rfc1315-frame-relay.jrb");
        this.createDsProperties(r1Dir, sources, "rfc1315-frame-relay");
        strings.setProperty("frName", "caracas");
        strings.setProperty("frDlci", "100");
        strings.setProperty("frIntf", "0");
        File sFile1 = this.m_fileAnticipator.tempFile(r1Dir, "strings.properties");
        strings.store(new FileOutputStream(sFile1), null);
        ArrayList<String> data1 = new ArrayList<String>();
        data1.add("100:200:300:350");
        this.createAndUpdateRrd(rrd1, start, sources, data1);
        File r2Dir = this.m_fileAnticipator.tempDir(rtDir, "Se1.200");
        File rrd2 = this.m_fileAnticipator.tempFile(r2Dir, "rfc1315-frame-relay.jrb");
        this.createDsProperties(r2Dir, sources, "rfc1315-frame-relay");
        strings.setProperty("frDlci", "200");
        strings.setProperty("frIntf", "1");
        File sFile2 = this.m_fileAnticipator.tempFile(r2Dir, "strings.properties");
        strings.store(new FileOutputStream(sFile2), null);
        ArrayList<String> data2 = new ArrayList<String>();
        data2.add("50:150:400:300");
        this.createAndUpdateRrd(rrd2, start, sources, data2);
        this.m_thresholdInterface.getThresholdConfiguration().setThresholdGroup(group);
        Events events = new Events();
        this.m_snmpThresholder.checkResourceDir(rtDir, this.m_thresholdInterface, new Date(start), events);
        SnmpThresholderTest.assertEquals((int)2, (int)events.getEventCount());
        for (Event e : events.getEvent()) {
            SnmpThresholderTest.assertEquals((String)"label", (String)e.getParms().getParm(6).getParmName());
            SnmpThresholderTest.assertEquals((String)"caracas", (String)e.getParms().getParm(6).getValue().getContent());
        }
    }

    public void testExpressionWithGenericResourceTypes() throws Exception {
        System.err.println("--------------------------------------------------------");
        System.setProperty("org.opennms.rrd.storeByGroup", "true");
        ThresholdGroup group = this.m_thresholdsDao.get("generic-snmp");
        SnmpThresholderTest.assertEquals((int)1, (int)((ThresholdResourceType)group.getGenericResourceTypeMap().get("hrStorageIndex")).getThresholdMap().size());
        File path = this.m_fileAnticipator.getTempDir();
        File nodeDir = this.m_fileAnticipator.tempDir(path, "1");
        File rtDir = this.m_fileAnticipator.tempDir(nodeDir, "hrStorageIndex");
        Properties strings = new Properties();
        long start = System.currentTimeMillis();
        ArrayList<String> sources = new ArrayList<String>();
        sources.add("hrStorageAllocUnits");
        sources.add("hrStorageSize");
        sources.add("hrStorageUsed");
        File r1Dir = this.m_fileAnticipator.tempDir(rtDir, "opt");
        File rrd1 = this.m_fileAnticipator.tempFile(r1Dir, "mib2-host-resources-storage.jrb");
        this.createDsProperties(r1Dir, sources, "mib2-host-resources-storage");
        strings.setProperty("hrStorageDescr", "/opt");
        File sFile1 = this.m_fileAnticipator.tempFile(r1Dir, "strings.properties");
        strings.store(new FileOutputStream(sFile1), null);
        ArrayList<String> data1 = new ArrayList<String>();
        data1.add("2:200:80");
        this.createAndUpdateRrd(rrd1, start, sources, data1);
        this.m_thresholdInterface.getThresholdConfiguration().setThresholdGroup(group);
        Events events = new Events();
        this.m_snmpThresholder.checkResourceDir(rtDir, this.m_thresholdInterface, new Date(start), events);
        SnmpThresholderTest.assertEquals((int)1, (int)events.getEventCount());
        for (Event e : events.getEvent()) {
            SnmpThresholderTest.assertEquals((String)"label", (String)e.getParms().getParm(6).getParmName());
            SnmpThresholderTest.assertEquals((String)"/opt", (String)e.getParms().getParm(6).getValue().getContent());
        }
    }

    private void createDsProperties(File dir, List<String> sources, String group) throws Exception {
        Properties ds = new Properties();
        for (String source : sources) {
            ds.setProperty(source, group);
        }
        File dsFile = this.m_fileAnticipator.tempFile(dir, "ds.properties");
        ds.store(new FileOutputStream(dsFile), null);
    }

    private void createAndUpdateRrd(File rrdPath, long start, List<String> sources, List<String> values) throws Exception {
        long ts = start / 1000L;
        RrdDef rrdDef = new RrdDef(rrdPath.getAbsolutePath(), ts - 300L, 300L);
        for (String source : sources) {
            rrdDef.addDatasource(source, "GAUGE", 600L, 0.0, Double.NaN);
        }
        rrdDef.addArchive("AVERAGE", 0.5, 1, 600);
        System.err.println(rrdDef.dump());
        RrdDb rrdDb = new RrdDb(rrdDef);
        rrdDb.close();
        rrdDb = new RrdDb(rrdPath.getAbsolutePath());
        Sample sample = rrdDb.createSample();
        for (String value : values) {
            sample.setAndUpdate(Long.toString(ts) + ":" + value);
            System.err.println(sample.dump());
            ts += 300L;
        }
        rrdDb.close();
    }
}

