/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.statsd;

import java.util.Date;
import java.util.GregorianCalendar;
import java.util.TimeZone;
import junit.framework.TestCase;
import org.opennms.core.utils.TimeKeeper;
import org.opennms.netmgt.statsd.RelativeTime;

public class RelativeTimeTest
extends TestCase {
    public void testYesterdayBeginningDST() {
        final TimeZone usEastern = TimeZone.getTimeZone("US/Eastern");
        RelativeTime yesterday = RelativeTime.YESTERDAY;
        yesterday.setTimeKeeper(new TimeKeeper(){

            public Date getCurrentDate() {
                GregorianCalendar cal = new GregorianCalendar(usEastern);
                cal.set(2006, 3, 3, 10, 0, 0);
                return cal.getTime();
            }

            public long getCurrentTime() {
                return this.getCurrentDate().getTime();
            }
        });
        Date start = yesterday.getStart();
        Date end = yesterday.getEnd();
        RelativeTimeTest.assertEquals((String)"start date", (String)"Sun Apr 02 00:00:00 EST 2006", (String)start.toString());
        RelativeTimeTest.assertEquals((String)"end date", (String)"Mon Apr 03 00:00:00 EDT 2006", (String)end.toString());
        RelativeTimeTest.assertEquals((String)"end date - start date", (long)82800000L, (long)(end.getTime() - start.getTime()));
    }

    public void testYesterdayEndingDST() {
        final TimeZone usEastern = TimeZone.getTimeZone("US/Eastern");
        RelativeTime yesterday = RelativeTime.YESTERDAY;
        yesterday.setTimeKeeper(new TimeKeeper(){

            public Date getCurrentDate() {
                GregorianCalendar cal = new GregorianCalendar(usEastern);
                cal.set(2006, 9, 30, 10, 0, 0);
                return cal.getTime();
            }

            public long getCurrentTime() {
                return this.getCurrentDate().getTime();
            }
        });
        Date start = yesterday.getStart();
        Date end = yesterday.getEnd();
        RelativeTimeTest.assertEquals((String)"start date", (String)"Sun Oct 29 00:00:00 EDT 2006", (String)start.toString());
        RelativeTimeTest.assertEquals((String)"end date", (String)"Mon Oct 30 00:00:00 EST 2006", (String)end.toString());
        RelativeTimeTest.assertEquals((String)"end date - start date", (long)90000000L, (long)(end.getTime() - start.getTime()));
    }
}

