/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.poller.remote;

import java.io.File;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.hibernate.SessionFactory;
import org.opennms.netmgt.dao.db.AbstractTransactionalTemporaryDatabaseSpringContextTests;
import org.opennms.netmgt.eventd.EventIpcManager;
import org.opennms.netmgt.eventd.EventIpcManagerFactory;
import org.opennms.netmgt.mock.MockEventIpcManager;
import org.opennms.netmgt.model.OnmsMonitoringLocationDefinition;
import org.opennms.netmgt.model.PollStatus;
import org.opennms.netmgt.poller.DistributionContext;
import org.opennms.netmgt.poller.remote.PollerBackEnd;
import org.opennms.netmgt.rrd.RrdUtils;
import org.opennms.test.DaoTestConfigBean;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PollerBackEndIntegrationTest
extends AbstractTransactionalTemporaryDatabaseSpringContextTests {
    private PollerBackEnd m_backEnd;
    private SessionFactory m_sessionFactory;

    protected void setUpConfiguration() {
        EventIpcManagerFactory.setIpcManager((EventIpcManager)new MockEventIpcManager());
        DaoTestConfigBean bean = new DaoTestConfigBean();
        bean.afterPropertiesSet();
    }

    protected String[] getConfigLocations() {
        return new String[]{"classpath:/META-INF/opennms/applicationContext-dao.xml", "classpath:/META-INF/opennms/applicationContext-daemon.xml", "classpath:/META-INF/opennms/applicationContext-pollerBackEnd.xml", "classpath:/META-INF/opennms/applicationContext-exportedPollerBackEnd.xml", "classpath:/org/opennms/netmgt/poller/remote/applicationContext-configOverride.xml"};
    }

    public void setPollerBackEnd(PollerBackEnd backEnd) {
        this.m_backEnd = backEnd;
    }

    public void setSessionFactory(SessionFactory sessionFactory) {
        this.m_sessionFactory = sessionFactory;
    }

    public void testRegister() {
        Collection locations = this.m_backEnd.getMonitoringLocations();
        PollerBackEndIntegrationTest.assertNotNull((String)"locations list should not be null", (Object)locations);
        PollerBackEndIntegrationTest.assertFalse((String)"locations list should not be empty", (boolean)locations.isEmpty());
        int initialCount = this.queryForInt("select count(*) from location_monitors", new Object[0]);
        for (OnmsMonitoringLocationDefinition location : locations) {
            int locationMonitorId = this.m_backEnd.registerLocationMonitor(location.getName());
            PollerBackEndIntegrationTest.assertTrue((locationMonitorId > 0 ? 1 : 0) != 0);
            PollerBackEndIntegrationTest.assertEquals((String)"REGISTERED", (String)this.queryForString("select status from location_monitors where id = ?", locationMonitorId));
        }
        PollerBackEndIntegrationTest.assertEquals((int)(initialCount + locations.size()), (int)this.jdbcTemplate.queryForInt("select count(*) from location_monitors"));
    }

    public void testPollingStarted() {
        int locationMonitorId = this.m_backEnd.registerLocationMonitor("RDU");
        this.m_backEnd.pollerStarting(locationMonitorId, this.getPollerDetails());
        PollerBackEndIntegrationTest.assertEquals((String)"STARTED", (String)this.queryForString("select status from location_monitors where id = ?", locationMonitorId));
        PollerBackEndIntegrationTest.assertEquals((int)2, (int)this.queryForInt("select count(*) from location_monitor_details where locationMonitorId = ?", locationMonitorId));
        PollerBackEndIntegrationTest.assertEquals((String)"WonkaOS", (String)this.queryForString("select propertyValue from location_monitor_details where locationMonitorId = ? and property = ?", locationMonitorId, "os.name"));
    }

    public void testPollingStopped() {
        int locationMonitorId = this.m_backEnd.registerLocationMonitor("RDU");
        this.m_backEnd.pollerStarting(locationMonitorId, this.getPollerDetails());
        PollerBackEndIntegrationTest.assertEquals((String)"STARTED", (String)this.queryForString("select status from location_monitors where id = ?", locationMonitorId));
        this.m_backEnd.pollerStopping(locationMonitorId);
        PollerBackEndIntegrationTest.assertEquals((String)"STOPPED", (String)this.queryForString("select status from location_monitors where id = ?", locationMonitorId));
    }

    public void testPollerDisconnected() throws Exception {
        int locationMonitorId = this.m_backEnd.registerLocationMonitor("RDU");
        this.m_backEnd.pollerStarting(locationMonitorId, this.getPollerDetails());
        PollerBackEndIntegrationTest.assertEquals((String)"STARTED", (String)this.queryForString("select status from location_monitors where id = ?", locationMonitorId));
        Thread.sleep(1500L);
        this.m_backEnd.checkForDisconnectedMonitors();
        PollerBackEndIntegrationTest.assertEquals((String)"STARTED", (String)this.queryForString("select status from location_monitors where id = ?", locationMonitorId));
        Thread.sleep(2000L);
        this.m_backEnd.checkForDisconnectedMonitors();
        PollerBackEndIntegrationTest.assertEquals((String)"DISCONNECTED", (String)this.queryForString("select status from location_monitors where id = ?", locationMonitorId));
    }

    public void testGetServiceMonitorLocators() {
        Collection results = this.m_backEnd.getServiceMonitorLocators(DistributionContext.REMOTE_MONITOR);
        PollerBackEndIntegrationTest.assertNotNull((Object)results);
        PollerBackEndIntegrationTest.assertTrue((results.size() > 0 ? 1 : 0) != 0);
    }

    public void testReportResults() {
        this.jdbcTemplate.execute("INSERT INTO node (nodeId, nodeCreateTime) VALUES (1, now())");
        this.jdbcTemplate.execute("INSERT INTO ipInterface (id, nodeId, ipAddr)  VALUES (1, 1, '192.168.1.1')");
        this.jdbcTemplate.execute("INSERT INTO service (serviceId, serviceName) VALUES (1, 'HTTP')");
        this.jdbcTemplate.execute("INSERT INTO ifServices (id, nodeId, ipAddr, serviceId, ipInterfaceId) VALUES (1, 1, '192.168.1.1', 1, 1)");
        int locationMonitorId = this.m_backEnd.registerLocationMonitor("RDU");
        int serviceId = this.findServiceId();
        String ipAddr = this.queryForString("select ipaddr from ifservices where id = ?", serviceId);
        File rrdFile = new File("target/test-data/distributed/" + locationMonitorId + "/" + ipAddr + "/http" + RrdUtils.getExtension());
        if (rrdFile.exists()) {
            rrdFile.delete();
        }
        PollerBackEndIntegrationTest.assertFalse((boolean)rrdFile.exists());
        PollStatus status = PollStatus.available((Double)1234.0);
        this.m_backEnd.reportResult(locationMonitorId, serviceId, status);
        PollerBackEndIntegrationTest.assertEquals((int)1, (int)this.queryForInt("select count(*) from location_specific_status_changes where locationMonitorId = ?", locationMonitorId));
        PollerBackEndIntegrationTest.assertTrue((String)("rrd file doesn't exist at " + rrdFile.getAbsolutePath()), (boolean)rrdFile.exists());
    }

    private int findServiceId() {
        return this.jdbcTemplate.queryForInt("select id from ifservices, service where ifservices.serviceid = service.serviceid and service.servicename='HTTP' limit 1");
    }

    private void flush() {
        this.m_sessionFactory.getCurrentSession().flush();
    }

    private String queryForString(String sql, Object ... args) {
        this.flush();
        return (String)this.jdbcTemplate.queryForObject(sql, args, String.class);
    }

    public int queryForInt(String sql, Object ... args) {
        this.flush();
        return this.jdbcTemplate.queryForInt(sql, args);
    }

    public Map<String, String> getPollerDetails() {
        HashMap<String, String> pollerDetails = new HashMap<String, String>();
        pollerDetails.put("os.name", "WonkaOS");
        pollerDetails.put("os.version", "1.2.3");
        return pollerDetails;
    }
}

