/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.poller.monitors;

import java.net.InetAddress;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import junit.framework.TestCase;
import org.opennms.netmgt.mock.MockMonitoredService;
import org.opennms.netmgt.model.PollStatus;
import org.opennms.netmgt.poller.MonitoredService;
import org.opennms.netmgt.poller.monitors.PageSequenceMonitor;
import org.opennms.test.mock.MockLogAppender;

public class PageSequenceMonitorTest
extends TestCase {
    PageSequenceMonitor m_monitor;
    Map<String, String> m_params;

    protected void setUp() throws Exception {
        super.setUp();
        MockLogAppender.setupLogging();
        this.m_monitor = new PageSequenceMonitor();
        this.m_monitor.initialize(Collections.EMPTY_MAP);
        this.m_params = new HashMap<String, String>();
        this.m_params.put("timeout", "6000");
        this.m_params.put("retries", "1");
    }

    protected MonitoredService getHttpService(String hostname) throws Exception {
        return this.getHttpService(hostname, InetAddress.getByName(hostname).getHostAddress());
    }

    protected MonitoredService getHttpService(String hostname, String ip) throws Exception {
        MockMonitoredService svc = new MockMonitoredService(1, hostname, ip, "HTTP");
        this.m_monitor.initialize((MonitoredService)svc);
        return svc;
    }

    protected void tearDown() throws Exception {
        MockLogAppender.assertNoWarningsOrGreater();
        super.tearDown();
    }

    public void testSimpleGoogle() throws Exception {
        this.setPageSequenceParam("www.google.com");
        PollStatus googleStatus = this.m_monitor.poll(this.getHttpService("www.google.com"), this.m_params);
        PageSequenceMonitorTest.assertTrue((String)("Expected available but was " + googleStatus + ": reason = " + googleStatus.getReason()), (boolean)googleStatus.isAvailable());
    }

    public void testSimpleBogus() throws Exception {
        this.setPageSequenceParam(null);
        PollStatus notLikely = this.m_monitor.poll(this.getHttpService("bogus", "1.1.1.1"), this.m_params);
        PageSequenceMonitorTest.assertTrue((String)"should not be available", (boolean)notLikely.isUnavailable());
    }

    public void testSimpleYahoo() throws Exception {
        this.setPageSequenceParam("www.yahoo.com");
        PollStatus yahooStatus = this.m_monitor.poll(this.getHttpService("www.yahoo.com"), this.m_params);
        PageSequenceMonitorTest.assertTrue((String)"should not be available", (boolean)yahooStatus.isUnavailable());
    }

    private void setPageSequenceParam(String virtualHost) {
        String virtualHostParam = virtualHost == null ? "" : "virtual-host=\"" + virtualHost + "\"";
        this.m_params.put("page-sequence", "<?xml version=\"1.0\"?><page-sequence>\n  <page path=\"/\" port=\"80\" user-agent=\"Mozilla/4.0 (compatible; MSIE 5.5; Windows NT 5.0)\" successMatch=\"I'm Feeling Lucky\" " + virtualHostParam + "/>\n" + "</page-sequence>\n");
    }

    public void _testHttps() throws Exception {
        this.m_params.put("page-sequence", "<?xml version=\"1.0\"?><page-sequence>\n  <page scheme=\"https\" path=\"/ws/eBayISAPI.dll?RegisterEnterInfo\" port=\"443\" user-agent=\"Mozilla/4.0 (compatible; MSIE 5.5; Windows NT 5.0)\" successMatch=\"Hi! Ready to register with eBay?\" virtual-host=\"support.opennms.com\"/>\n</page-sequence>\n");
        PollStatus googleStatus = this.m_monitor.poll(this.getHttpService("scgi.ebay.com"), this.m_params);
        PageSequenceMonitorTest.assertTrue((String)("Expected available but was " + googleStatus + ": reason = " + googleStatus.getReason()), (boolean)googleStatus.isAvailable());
    }

    public void testLogin() throws Exception {
        this.m_params.put("page-sequence", "<?xml version=\"1.0\"?><page-sequence name=\"opennms-login-seq\">\n  <page path=\"/opennms\" port=\"80\" successMatch=\"Password\" />\n  <page path=\"/opennms/j_acegi_security_check\"  port=\"80\" method=\"POST\" failureMatch=\"(?s)Your log-in attempt failed.*Reason: ([^&lt;]*)\" failureMessage=\"Login in Failed: ${1}\" successMatch=\"Log out\">\n    <parameter key=\"j_username\" value=\"demo\"/>\n    <parameter key=\"j_password\" value=\"demo\"/>\n  </page>\n  <page path=\"/opennms/event/index.jsp\" port=\"80\" successMatch=\"Event Queries\" />\n  <page path=\"/opennms/j_acegi_logout\" port=\"80\" successMatch=\"logged off\" />\n</page-sequence>\n");
        PollStatus status = this.m_monitor.poll(this.getHttpService("demo.opennms.org"), this.m_params);
        PageSequenceMonitorTest.assertTrue((String)("Expected available but was " + status + ": reason = " + status.getReason()), (boolean)status.isAvailable());
    }

    public void testVirtualHost() throws Exception {
        this.m_params.put("page-sequence", "<?xml version=\"1.0\"?><page-sequence>\n  <page path=\"/\" port=\"80\" successMatch=\"Zero Bull\" virtual-host=\"www.opennms.com\"/>\n</page-sequence>\n");
        PollStatus status = this.m_monitor.poll(this.getHttpService("www.opennms.com"), this.m_params);
        PageSequenceMonitorTest.assertTrue((String)("Expected available but was " + status + ": reason = " + status.getReason()), (boolean)status.isAvailable());
    }
}

