/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.poller.monitors;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Collections;
import java.util.Map;
import java.util.TreeMap;
import junit.framework.TestCase;
import org.opennms.netmgt.config.poller.Parameter;
import org.opennms.netmgt.mock.MockMonitoredService;
import org.opennms.netmgt.model.PollStatus;
import org.opennms.netmgt.poller.MonitoredService;
import org.opennms.netmgt.poller.monitors.HttpMonitor;
import org.opennms.netmgt.poller.monitors.HttpsMonitor;
import org.opennms.netmgt.xml.event.Parm;
import org.opennms.netmgt.xml.event.Parms;
import org.opennms.netmgt.xml.event.Value;
import org.opennms.test.mock.MockLogAppender;
import org.opennms.test.mock.MockUtil;

public class HttpMonitorTest
extends TestCase {
    private boolean m_runTests = true;

    protected void setUp() throws Exception {
        super.setUp();
        MockLogAppender.setupLogging();
    }

    public void testParms() {
        Parms eventParms = new Parms();
        Parm eventParm = new Parm();
        Value parmValue = new Value();
        HttpMonitorTest.assertTrue((eventParms.getParmCount() == 0 ? 1 : 0) != 0);
        eventParm.setParmName("test");
        parmValue.setContent("test value");
        eventParm.setValue(parmValue);
        eventParms.addParm(eventParm);
        HttpMonitorTest.assertTrue((eventParms.getParmCount() == 1 ? 1 : 0) != 0);
        HttpMonitorTest.assertTrue((eventParms.getParm(0).getParmName() == "test" ? 1 : 0) != 0);
        HttpMonitorTest.assertTrue((eventParms.getParm(0).getValue().getContent() == "test value" ? 1 : 0) != 0);
    }

    public void testPollStatusReason() throws UnknownHostException {
        if (!this.m_runTests) {
            return;
        }
        Map<String, String> m = Collections.synchronizedMap(new TreeMap());
        Parameter p = new Parameter();
        HttpMonitor monitor = new HttpMonitor();
        MonitoredService svc = this.getMonitoredService(99, "1.1.1.1", "HTTP");
        p.setKey("port");
        p.setValue("80");
        m.put(p.getKey(), p.getValue());
        p.setKey("retry");
        p.setValue("1");
        m.put(p.getKey(), p.getValue());
        p.setKey("timeout");
        p.setValue("2000");
        m.put(p.getKey(), p.getValue());
        PollStatus status = monitor.poll(svc, m);
        MockUtil.println((String)("Reason: " + status.getReason()));
        HttpMonitorTest.assertEquals((int)2, (int)status.getStatusCode());
        HttpMonitorTest.assertNotNull((Object)status.getReason());
    }

    public void testResponseRange() throws UnknownHostException {
        if (!this.m_runTests) {
            return;
        }
        Map<String, String> m = Collections.synchronizedMap(new TreeMap());
        Parameter p = new Parameter();
        HttpMonitor monitor = new HttpMonitor();
        MonitoredService svc = this.getMonitoredService(3, "www.google.com", "HTTP");
        p.setKey("port");
        p.setValue("80");
        m.put(p.getKey(), p.getValue());
        p.setKey("retry");
        p.setValue("1");
        m.put(p.getKey(), p.getValue());
        p.setKey("timeout");
        p.setValue("2000");
        m.put(p.getKey(), p.getValue());
        p.setKey("response");
        p.setValue("100-199");
        m.put(p.getKey(), p.getValue());
        PollStatus status = monitor.poll(svc, m);
        MockUtil.println((String)("Reason: " + status.getReason()));
        HttpMonitorTest.assertEquals((int)2, (int)status.getStatusCode());
        HttpMonitorTest.assertNotNull((Object)status.getReason());
        p.setKey("response");
        p.setValue("100,200,302,400-500");
        m.put(p.getKey(), p.getValue());
        monitor = new HttpMonitor();
        status = monitor.poll(svc, m);
        MockUtil.println((String)("Reason: " + status.getReason()));
        HttpMonitorTest.assertEquals((int)1, (int)status.getStatusCode());
        HttpMonitorTest.assertNull((Object)status.getReason());
        p.setKey("response");
        p.setValue("*");
        m.put(p.getKey(), p.getValue());
        monitor = new HttpMonitor();
        status = monitor.poll(svc, m);
        MockUtil.println((String)("Reason: " + status.getReason()));
        HttpMonitorTest.assertEquals((int)1, (int)status.getStatusCode());
        HttpMonitorTest.assertNull((Object)status.getReason());
    }

    public void testMatchingTextInResponse() throws UnknownHostException {
        if (!this.m_runTests) {
            return;
        }
        Map<String, String> m = Collections.synchronizedMap(new TreeMap());
        Parameter p = new Parameter();
        PollStatus status = null;
        HttpMonitor monitor = new HttpMonitor();
        MonitoredService svc = this.getMonitoredService(3, "www.google.com", "HTTP");
        p.setKey("port");
        p.setValue("80");
        m.put(p.getKey(), p.getValue());
        p.setKey("retry");
        p.setValue("0");
        m.put(p.getKey(), p.getValue());
        p.setKey("timeout");
        p.setValue("2000");
        m.put(p.getKey(), p.getValue());
        p.setKey("response");
        p.setValue("100-499");
        m.put(p.getKey(), p.getValue());
        p.setKey("verbose");
        p.setValue("true");
        m.put(p.getKey(), p.getValue());
        p.setKey("host-name");
        p.setValue("www.google.com");
        m.put(p.getKey(), p.getValue());
        p.setKey("url");
        p.setValue("/");
        m.put(p.getKey(), p.getValue());
        p.setKey("response-text");
        p.setValue("opennmsrulz");
        m.put(p.getKey(), p.getValue());
        status = monitor.poll(svc, m);
        MockUtil.println((String)("Reason: " + status.getReason()));
        HttpMonitorTest.assertEquals((int)2, (int)status.getStatusCode());
        HttpMonitorTest.assertNotNull((Object)status.getReason());
        p.setKey("response-text");
        p.setValue("Feeling Lucky");
        m.put(p.getKey(), p.getValue());
        MockUtil.println((String)"\nliteral text check: \"Feeling Lucky\"");
        monitor = new HttpMonitor();
        status = monitor.poll(svc, m);
        MockUtil.println((String)("Reason: " + status.getReason()));
        HttpMonitorTest.assertEquals((int)1, (int)status.getStatusCode());
        HttpMonitorTest.assertNull((Object)status.getReason());
        p.setKey("response-text");
        p.setValue("~.*[Gg]oogle [Ss]earch.*");
        m.put(p.getKey(), p.getValue());
        MockUtil.println((String)"\nregex check: \".*[Gg]oogle [Ss]earch.*\"");
        monitor = new HttpMonitor();
        status = monitor.poll(svc, m);
        MockUtil.println((String)("Reason: " + status.getReason()));
        HttpMonitorTest.assertEquals((int)1, (int)status.getStatusCode());
        HttpMonitorTest.assertNull((Object)status.getReason());
    }

    public void testBase64Encoding() {
        if (!this.m_runTests) {
            return;
        }
        Map<String, String> m = Collections.synchronizedMap(new TreeMap());
        Parameter p = new Parameter();
        HttpMonitor monitor = new HttpMonitor();
        p.setKey("basic-authentication");
        p.setValue("Aladdin:open sesame");
        m.put(p.getKey(), p.getValue());
        HttpMonitorTest.assertEquals((String)"QWxhZGRpbjpvcGVuIHNlc2FtZQ==", (String)monitor.determineBasicAuthentication(m));
        HttpMonitorTest.assertFalse((boolean)"QWxhZGRpbjpvcZVuIHNlc2FtZQ==".equals(monitor.determineBasicAuthentication(m)));
    }

    private MonitoredService getMonitoredService(int nodeId, String hostname, String svcName) throws UnknownHostException {
        return new MockMonitoredService(nodeId, hostname, InetAddress.getByName(hostname).getHostAddress(), svcName);
    }

    public void testBasicAuthentication() throws UnknownHostException {
        if (!this.m_runTests) {
            return;
        }
        Map<String, String> m = Collections.synchronizedMap(new TreeMap());
        Parameter p = new Parameter();
        PollStatus status = null;
        HttpMonitor monitor = new HttpMonitor();
        MonitoredService svc = this.getMonitoredService(1, "prism.library.cornell.edu", "HTTP");
        p.setKey("port");
        p.setValue("80");
        m.put(p.getKey(), p.getValue());
        p.setKey("retry");
        p.setValue("0");
        m.put(p.getKey(), p.getValue());
        p.setKey("timeout");
        p.setValue("2000");
        m.put(p.getKey(), p.getValue());
        p.setKey("response");
        p.setValue("100-302");
        m.put(p.getKey(), p.getValue());
        p.setKey("verbose");
        p.setValue("true");
        m.put(p.getKey(), p.getValue());
        p.setKey("url");
        p.setValue("/control/authBasic/authTest/");
        m.put(p.getKey(), p.getValue());
        p.setKey("basic-authentication");
        p.setValue("test:this");
        m.put(p.getKey(), p.getValue());
        status = monitor.poll(svc, m);
        MockUtil.println((String)("Reason: " + status.getReason()));
        HttpMonitorTest.assertEquals((int)1, (int)status.getStatusCode());
        HttpMonitorTest.assertNull((Object)status.getReason());
        p.setKey("basic-authentication");
        p.setValue("test:that");
        m.put(p.getKey(), p.getValue());
        status = monitor.poll(svc, m);
        MockUtil.println((String)("Reason: " + status.getReason()));
        HttpMonitorTest.assertEquals((int)2, (int)status.getStatusCode());
        HttpMonitorTest.assertNotNull((Object)status.getReason());
    }

    public void _testBasicAuthenticationWithHttps() throws UnknownHostException {
        if (!this.m_runTests) {
            return;
        }
        Map<String, String> m = Collections.synchronizedMap(new TreeMap());
        Parameter p = new Parameter();
        PollStatus status = null;
        HttpsMonitor monitor = new HttpsMonitor();
        MonitoredService svc = this.getMonitoredService(1, "blah.opennms.com", "HTTP");
        p.setKey("port");
        p.setValue("443");
        m.put(p.getKey(), p.getValue());
        p.setKey("retry");
        p.setValue("1");
        m.put(p.getKey(), p.getValue());
        p.setKey("timeout");
        p.setValue("2000");
        m.put(p.getKey(), p.getValue());
        p.setKey("response");
        p.setValue("100-302");
        m.put(p.getKey(), p.getValue());
        p.setKey("verbose");
        p.setValue("true");
        m.put(p.getKey(), p.getValue());
        p.setKey("url");
        p.setValue("/index.php/Main_Page");
        m.put(p.getKey(), p.getValue());
        p.setKey("basic-authentication");
        p.setValue("zzzz:zzzz");
        m.put(p.getKey(), p.getValue());
        status = monitor.poll(svc, m);
        MockUtil.println((String)("Reason: " + status.getReason()));
        HttpMonitorTest.assertEquals((int)1, (int)status.getStatusCode());
        HttpMonitorTest.assertNull((Object)status.getReason());
    }

    public void testWithUrl() throws UnknownHostException {
        if (!this.m_runTests) {
            return;
        }
        Map<String, String> m = Collections.synchronizedMap(new TreeMap());
        Parameter p = new Parameter();
        PollStatus status = null;
        HttpMonitor monitor = new HttpMonitor();
        MonitoredService svc = this.getMonitoredService(3, "www.google.com", "HTTP");
        p.setKey("host-name");
        p.setValue("www.google.com");
        m.put(p.getKey(), p.getValue());
        p.setKey("url");
        p.setValue("/search?hl=en&q=monkey&btnG=Google+Search");
        m.put(p.getKey(), p.getValue());
        p.setKey("port");
        p.setValue("80");
        m.put(p.getKey(), p.getValue());
        p.setKey("retry");
        p.setValue("0");
        m.put(p.getKey(), p.getValue());
        p.setKey("timeout");
        p.setValue("2000");
        m.put(p.getKey(), p.getValue());
        p.setKey("response");
        p.setValue("100-499");
        m.put(p.getKey(), p.getValue());
        p.setKey("response-text");
        p.setValue("Results");
        m.put(p.getKey(), p.getValue());
        p.setKey("verbose");
        p.setValue("true");
        m.put(p.getKey(), p.getValue());
        status = monitor.poll(svc, m);
        MockUtil.println((String)("Reason: " + status.getReason()));
        HttpMonitorTest.assertEquals((int)1, (int)status.getStatusCode());
        HttpMonitorTest.assertNull((Object)status.getReason());
    }

    public void testPollInValidVirtualDomain() throws UnknownHostException {
        if (!this.m_runTests) {
            return;
        }
        Map<String, String> m = Collections.synchronizedMap(new TreeMap());
        Parameter p = new Parameter();
        HttpMonitor monitor = new HttpMonitor();
        MonitoredService svc = this.getMonitoredService(3, "www.google.com", "HTTP");
        p.setKey("port");
        p.setValue("80");
        m.put(p.getKey(), p.getValue());
        p.setKey("retry");
        p.setValue("1");
        m.put(p.getKey(), p.getValue());
        p.setKey("timeout");
        p.setValue("1000");
        m.put(p.getKey(), p.getValue());
        p.setKey("host name");
        p.setValue("opennms.com");
        m.put(p.getKey(), p.getValue());
        p.setKey("url");
        p.setValue("/solutions/");
        m.put(p.getKey(), p.getValue());
        p.setKey("response-text");
        p.setValue("~.*[Ff]eeling [Ll]ucky.*");
        m.put(p.getKey(), p.getValue());
        PollStatus status = monitor.poll(svc, m);
        HttpMonitorTest.assertEquals((String)"poll status not available", (int)2, (int)status.getStatusCode());
    }
}

