/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.passive;

import java.net.UnknownHostException;
import java.util.Map;
import javax.sql.DataSource;
import org.exolab.castor.xml.MarshalException;
import org.exolab.castor.xml.ValidationException;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.opennms.netmgt.config.DataSourceFactory;
import org.opennms.netmgt.eventd.EventIpcManager;
import org.opennms.netmgt.mock.EventAnticipator;
import org.opennms.netmgt.mock.MockDatabase;
import org.opennms.netmgt.mock.MockEventIpcManager;
import org.opennms.netmgt.mock.MockEventUtil;
import org.opennms.netmgt.mock.MockMonitoredService;
import org.opennms.netmgt.mock.MockNetwork;
import org.opennms.netmgt.mock.MockService;
import org.opennms.netmgt.mock.OutageAnticipator;
import org.opennms.netmgt.model.PollStatus;
import org.opennms.netmgt.passive.PassiveStatusKeeper;
import org.opennms.netmgt.poller.MonitoredService;
import org.opennms.netmgt.poller.monitors.PassiveServiceMonitor;
import org.opennms.netmgt.xml.event.Event;
import org.opennms.netmgt.xml.event.Logmsg;
import org.opennms.netmgt.xml.event.Parm;
import org.opennms.netmgt.xml.event.Parms;
import org.opennms.netmgt.xml.event.Value;
import org.opennms.test.mock.MockLogAppender;

public class PassiveStatusKeeperTest {
    private PassiveStatusKeeper m_psk;
    private MockEventIpcManager m_eventMgr;
    private MockDatabase m_db;
    private MockNetwork m_network;
    private EventAnticipator m_anticipator;
    private OutageAnticipator m_outageAnticipator;

    @Before
    public void setUp() throws Exception {
        MockLogAppender.setupLogging();
        this.createMockNetwork();
        this.createMockDb();
        this.createAnticipators();
        this.m_eventMgr = new MockEventIpcManager();
        this.m_eventMgr.setEventWriter(this.m_db);
        this.m_eventMgr.setEventAnticipator(this.m_anticipator);
        this.m_eventMgr.addEventListener(this.m_outageAnticipator);
        this.m_eventMgr.setSynchronous(true);
        this.m_psk = new PassiveStatusKeeper();
        this.m_psk.setEventManager((EventIpcManager)this.m_eventMgr);
        this.m_psk.setDataSource((DataSource)((Object)this.m_db));
        PassiveStatusKeeper.setInstance((PassiveStatusKeeper)this.m_psk);
        this.m_psk.init();
        this.m_psk.start();
    }

    @After
    public void tearDown() throws Exception {
        this.m_eventMgr.finishProcessingEvents();
        this.m_psk.stop();
        this.sleep(200L);
        MockLogAppender.assertNoWarningsOrGreater();
        DataSourceFactory.setInstance(null);
        this.m_db.drop();
    }

    private void createAnticipators() {
        this.m_anticipator = new EventAnticipator();
        this.m_outageAnticipator = new OutageAnticipator(this.m_db);
    }

    private void createMockDb() throws Exception {
        this.m_db = new MockDatabase();
        this.m_db.populate(this.m_network);
        DataSourceFactory.setInstance((DataSource)((Object)this.m_db));
    }

    private void createMockNetwork() {
        this.m_network = new MockNetwork();
        this.m_network.setCriticalService("ICMP");
        this.m_network.addNode(1, "Router");
        this.m_network.addInterface("192.168.1.1");
        this.m_network.addService("ICMP");
        this.m_network.addService("SMTP");
        this.m_network.addInterface("192.168.1.2");
        this.m_network.addService("ICMP");
        this.m_network.addService("SMTP");
        this.m_network.addNode(2, "Server");
        this.m_network.addInterface("192.168.1.3");
        this.m_network.addService("ICMP");
        this.m_network.addService("HTTP");
        this.m_network.addNode(3, "Firewall");
        this.m_network.addInterface("192.168.1.4");
        this.m_network.addService("SMTP");
        this.m_network.addService("HTTP");
        this.m_network.addInterface("192.168.1.5");
        this.m_network.addService("SMTP");
        this.m_network.addService("HTTP");
        this.m_network.addNode(100, "localhost");
        this.m_network.addInterface("127.0.0.1");
        this.m_network.addService("PSV");
        this.m_network.addService("PSV2");
    }

    private void sleep(long millis) {
        try {
            Thread.sleep(millis);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    @Test
    public void testEventWithPassiveStatusParms() {
        Event e = this.createPassiveStatusEvent("Router", "192.168.1.1", "ICMP", "Down");
        Assert.assertTrue((boolean)this.m_psk.isPassiveStatusEvent(e));
    }

    @Test
    public void testIsPassiveStatusEvent() throws MarshalException, ValidationException {
        Event e = this.createPassiveStatusEvent("Router", "192.168.1.1", "ICMP", "Down");
        Assert.assertTrue((boolean)this.m_psk.isPassiveStatusEvent(e));
        e = this.createPassiveStatusEvent("Router", "192.168.1.1", null, "Down");
        Assert.assertFalse((boolean)this.m_psk.isPassiveStatusEvent(e));
        e.setUei("bogusUei");
        Assert.assertFalse((boolean)this.m_psk.isPassiveStatusEvent(e));
    }

    @Test
    public void testSetStatus() {
        this.testSetStatus("localhost", "127.0.0.1", "PSV", PollStatus.up());
    }

    private void testSetStatus(String nodeLabel, String ipAddr, String svcName, PollStatus pollStatus) {
        PassiveStatusKeeper.getInstance().setStatus(nodeLabel, ipAddr, svcName, pollStatus);
        Assert.assertEquals((Object)pollStatus, (Object)PassiveStatusKeeper.getInstance().getStatus(nodeLabel, ipAddr, svcName));
    }

    @Test
    public void testRestart() {
        this.testSetStatus("localhost", "127.0.0.1", "PSV", PollStatus.up());
        this.testSetStatus("localhost", "127.0.0.1", "PSV2", PollStatus.down());
        MockService svc = this.m_network.getService(100, "127.0.0.1", "PSV2");
        Event downEvent = svc.createDownEvent();
        this.m_db.writeEvent(downEvent);
        this.m_db.createOutage(svc, downEvent);
        this.m_psk.stop();
        this.m_psk.setEventManager((EventIpcManager)this.m_eventMgr);
        this.m_psk.setDataSource((DataSource)((Object)this.m_db));
        this.m_psk.init();
        this.m_psk.start();
        Assert.assertEquals((Object)PollStatus.up(), (Object)PassiveStatusKeeper.getInstance().getStatus("localhost", "127.0.0.1", "PSV"));
        Assert.assertEquals((Object)PollStatus.down(), (Object)PassiveStatusKeeper.getInstance().getStatus("localhost", "127.0.0.1", "PSV2"));
    }

    @Test
    public void testDownPassiveStatus() throws InterruptedException, UnknownHostException {
        Event e = this.createPassiveStatusEvent("Router", "192.168.1.1", "ICMP", "Down");
        this.m_eventMgr.sendNow(e);
        PollStatus ps = this.m_psk.getStatus("Router", "192.168.1.1", "ICMP");
        Assert.assertTrue((boolean)ps.isDown());
        MockMonitoredService svc = new MockMonitoredService(1, "Router", "192.168.1.1", "ICMP");
        PassiveServiceMonitor m = new PassiveServiceMonitor();
        m.initialize((Map)null);
        m.initialize((MonitoredService)svc);
        PollStatus ps2 = m.poll((MonitoredService)svc, null);
        m.release((MonitoredService)svc);
        m.release();
        Assert.assertEquals((Object)ps, (Object)ps2);
    }

    private Event createPassiveStatusEvent(String nodeLabel, String ipAddr, String serviceName, String status) {
        Parms parms = new Parms();
        if (nodeLabel != null) {
            parms.addParm(this.buildParm("passiveNodeLabel", nodeLabel));
        }
        if (ipAddr != null) {
            parms.addParm(this.buildParm("passiveIpAddr", ipAddr));
        }
        if (serviceName != null) {
            parms.addParm(this.buildParm("passiveServiceName", serviceName));
        }
        if (status != null) {
            parms.addParm(this.buildParm("passiveStatus", status));
        }
        return this.createEventWithParms("uei.opennms.org/services/passiveServiceStatus", parms);
    }

    private Event createEventWithParms(String uei, Parms parms) {
        Event e = MockEventUtil.createEvent("Test", uei);
        e.setHost("localhost");
        e.setParms(parms);
        Logmsg logmsg = new Logmsg();
        logmsg.setContent("Testing Passive Status Keeper with down status");
        e.setLogmsg(logmsg);
        return e;
    }

    private Parm buildParm(String parmName, String parmValue) {
        Value v = new Value();
        v.setContent(parmValue);
        Parm p = new Parm();
        p.setParmName(parmName);
        p.setValue(v);
        return p;
    }

    private String getTranslationTestConfig() {
        return "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<passive-status-configuration \nxmlns=\"http://xmlns.opennms.org/xsd/passive-status-configuration\" \nxmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" >\n  <translation>\n   <event-translation-spec uei=\"uei.opennms.org/services/translationEvent\">\n      <mappings>\n        <mapping>\n          <assignment type=\"field\" name=\"nodeid\">\n            <value type=\"sql\" result=\"select node.nodeid from node, ipInterface where node.nodeLabel=? and ipinterface.ipaddr=? and node.nodeId=ipinterface.nodeid and ipInterface.isManaged != 'D' and node.nodeType != 'D'\" >\n\t\t\t\t<value type=\"parameter\" name=\"passiveNodeLabel\" matches=\"Router\" result=\"Firewall\" />\n\t\t\t\t<value type=\"constant\" result=\"192.168.1.4\" />\n\t\t\t</value>\n          </assignment>\n          <assignment type=\"parameter\" name=\"nodeLabel\">\n            <value type=\"field\" name=\"host\" result=\"Switch\" />\n          </assignment>\n          <assignment type=\"field\" name=\"interface\">\n            <value type=\"parameter\" name=\"passiveIpAddr\" matches=\".*(192\\.168\\.1\\.1).*\" result=\"192.168.1.1\" />\n          </assignment>\n\t\t  <assignment type=\"field\" name=\"host\">\n\t\t\t<value type=\"field\" name=\"host\" result=\"www.opennms.org\" />\n\t\t  </assignment>\n\t\t  <assignment type=\"field\" name=\"descr\">\n\t\t\t<value type=\"constant\" result=\"a generated event\" />\n\t\t  </assignment>\n          <assignment type=\"field\" name=\"service\">\n            <value type=\"parameter\" name=\"passiveServiceName\" result=\"PSV\" />\n          </assignment>\n          <assignment type=\"parameter\" name=\"passiveStatus\">\n            <value type=\"parameter\" name=\"passiveStatus\" matches=\".*(Up|Down).*\" result=\"${1}\" />\n          </assignment>\n        </mapping>\n      </mappings>\n    </event-translation-spec>\n  </translation>\n</passive-status-configuration>\n";
    }

    private String getStandardConfig() {
        return "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<passive-status-configuration \nxmlns=\"http://xmlns.opennms.org/xsd/passive-status-configuration\" \nxmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" >\n  <translation>\n   <event-translation-spec uei=\"uei.opennms.org/services/translationEvent\">\n      <mappings>\n        <mapping>\n          <assignment type=\"field\" name=\"nodeid\">\n            <value type=\"sql\" result=\"select node.nodeid from node, ipInterface where node.nodeLabel=? and ipinterface.ipaddr=? and node.nodeId=ipinterface.nodeid and ipInterface.isManaged != 'D' and node.nodeType != 'D'\" >\n\t\t\t\t<value type=\"parameter\" name=\"passiveNodeLabel\" matches=\"Router\" result=\"Firewall\" />\n\t\t\t\t<value type=\"constant\" result=\"192.168.1.4\" />\n\t\t\t</value>\n          </assignment>\n          <assignment type=\"parameter\" name=\"nodeLabel\">\n            <value type=\"field\" name=\"host\" result=\"Switch\" />\n          </assignment>\n          <assignment type=\"field\" name=\"interface\">\n            <value type=\"parameter\" name=\"passiveIpAddr\" matches=\".*(192\\.168\\.1\\.1).*\" result=\"192.168.1.1\" />\n          </assignment>\n\t\t  <assignment type=\"field\" name=\"host\">\n\t\t\t<value type=\"field\" name=\"host\" result=\"www.opennms.org\" />\n\t\t  </assignment>\n\t\t  <assignment type=\"field\" name=\"descr\">\n\t\t\t<value type=\"constant\" result=\"a generated event\" />\n\t\t  </assignment>\n          <assignment type=\"field\" name=\"service\">\n            <value type=\"parameter\" name=\"passiveServiceName\" result=\"PSV\" />\n          </assignment>\n          <assignment type=\"parameter\" name=\"passiveStatus\">\n            <value type=\"parameter\" name=\"passiveStatus\" matches=\".*(Up|Down).*\" result=\"${1}\" />\n          </assignment>\n        </mapping>\n      </mappings>\n    </event-translation-spec>\n  </translation>\n  <passive-events>\n    <passive-event uei=\"uei.opennms.org/services/passiveServiceStatus\">\n      <status-key>\n        <node-label>\n          <event-token is-parm=\"true\" name=\"passiveNodeLabel\" value=\"Router\"/>\n        </node-label>\n        <ipaddr>\n          <event-token is-parm=\"true\" name=\"passiveIpAddr\" value=\"192.168.1.1\"/>\n        </ipaddr>\n        <service-name>\n          <event-token is-parm=\"true\" name=\"passiveServiceName\" value=\"ICMP\"/>\n        </service-name>\n        <status>\n          <event-token is-parm=\"true\" name=\"passiveStatus\" value=\"Down\"/>\n        </status>\n      </status-key>\n    </passive-event>\n  </passive-events>\n</passive-status-configuration>\n";
    }

    private String getLiteralFieldConfig() {
        return "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<this:passive-status-configuration \nxmlns:this=\"http://xmlns.opennms.org/xsd/passive-status-configuration\" \nxmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" >\n  <this:passive-events>\n    <this:passive-event uei=\"uei.opennms.org/services/passiveServiceStatus\">\n      <this:status-key>\n        <this:node-label>\n          <this:event-token is-parm=\"false\" name=\"host\" value=\"Router\"/>\n        </this:node-label>\n        <this:ipaddr>\n          <this:event-token is-parm=\"false\" name=\"source\" value=\"192.168.1.1\"/>\n        </this:ipaddr>\n        <this:service-name>\n          <this:event-token is-parm=\"false\" name=\"service\" value=\"ICMP\"/>\n        </this:service-name>\n        <this:status>\n          <this:event-token is-parm=\"false\" name=\"descr\" value=\"Down\"/>\n        </this:status>\n      </this:status-key>\n    </this:passive-event>\n  </this:passive-events>\n</this:passive-status-configuration>\n";
    }

    private String getLiteralParmConfig() {
        return "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<this:passive-status-configuration \nxmlns:this=\"http://xmlns.opennms.org/xsd/passive-status-configuration\" \nxmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" >\n  <this:passive-events>\n    <this:passive-event uei=\"uei.opennms.org/services/passiveServiceStatus\">\n      <this:status-key>\n        <this:node-label>\n          <this:event-token is-parm=\"true\" name=\"passiveNodeLabel\" value=\"Router\"/>\n        </this:node-label>\n        <this:ipaddr>\n          <this:event-token is-parm=\"true\" name=\"passiveIpAddr\" value=\"192.168.1.1\"/>\n        </this:ipaddr>\n        <this:service-name>\n          <this:event-token is-parm=\"true\" name=\"passiveServiceName\" value=\"ICMP\"/>\n        </this:service-name>\n        <this:status>\n          <this:event-token is-parm=\"true\" name=\"passiveStatus\" value=\"Down\"/>\n        </this:status>\n      </this:status-key>\n    </this:passive-event>\n  </this:passive-events>\n</this:passive-status-configuration>\n";
    }

    private String getRegExFieldConfig() {
        return "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<this:passive-status-configuration \nxmlns:this=\"http://xmlns.opennms.org/xsd/passive-status-configuration\" \nxmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" >\n  <this:passive-events>\n    <this:passive-event uei=\"uei.opennms.org/services/passiveServiceStatus\">\n      <this:status-key>\n        <this:node-label>\n          <this:event-token is-parm=\"false\" name=\"host\" value=\"~.*\"/>\n        </this:node-label>\n        <this:ipaddr>\n          <this:event-token is-parm=\"false\" name=\"source\" value=\"~.*(192\\.168\\.1\\.1).*\"/>\n        </this:ipaddr>\n        <this:service-name>\n          <this:event-token is-parm=\"false\" name=\"service\" value=\"~.*(ICMP).*\" format=\"$1\"/>\n        </this:service-name>\n        <this:status>\n          <this:event-token is-parm=\"false\" name=\"descr\" value=\"~.*is(Down).*\" format=\"$1\"/>\n        </this:status>\n      </this:status-key>\n    </this:passive-event>\n  </this:passive-events>\n</this:passive-status-configuration>\n";
    }

    private String getRegExParmConfig() {
        return "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<this:passive-status-configuration \nxmlns:this=\"http://xmlns.opennms.org/xsd/passive-status-configuration\" \nxmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" >\n  <translation>\n   <event-translation-spec uei=\"uei.opennms.org/services/translationEvent\">\n      <mappings>\n        <mapping>\n          <assignment type=\"field\" name=\"uei\">\n            <value type=\"constant\" result=\"uei.opennms.org/services/passiveServiceStatus\" />\n          </assignment>\n        </mapping>\n      </mappings>\n    </event-translation-spec>\n  </translation>\n</this:passive-status-configuration>\n";
    }
}

