/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.notifd.mock;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.opennms.core.utils.Argument;
import org.opennms.netmgt.notifd.NotificationStrategy;
import org.opennms.netmgt.notifd.mock.MockNotification;
import org.opennms.netmgt.notifd.mock.NotificationAnticipator;
import org.opennms.test.mock.MockUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MockNotificationStrategy
implements NotificationStrategy {
    private static NotificationAnticipator s_anticpator = null;
    Map notificationsSent = new HashMap();

    public MockNotificationStrategy() {
        MockUtil.println((String)("Created a " + MockNotificationStrategy.class.getName()));
    }

    public int send(List<Argument> arguments) {
        MockUtil.println((String)("Message sent with arguments:" + arguments));
        MockNotification notification = new MockNotification();
        for (Argument arg : arguments) {
            if (arg.getSwitch().equals("-subject")) {
                notification.setSubject(arg.getValue());
                continue;
            }
            if (arg.getSwitch().equals("-email")) {
                notification.setEmail(arg.getValue());
                continue;
            }
            if (!arg.getSwitch().equals("-tm")) continue;
            notification.setTextMsg(arg.getValue());
        }
        notification.setExpectedTime(System.currentTimeMillis());
        NotificationAnticipator anticipator = MockNotificationStrategy.getAnticpator();
        if (anticipator == null) {
            throw new NullPointerException("anticipator is null");
        }
        anticipator.notificationReceived(notification);
        return 0;
    }

    public static NotificationAnticipator getAnticpator() {
        return s_anticpator;
    }

    public static void setAnticpator(NotificationAnticipator anticpator) {
        s_anticpator = anticpator;
    }

    static {
        MockUtil.println((String)("Static initializer on " + MockNotificationStrategy.class.getName()));
    }
}

