/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.mock;

import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import javax.sql.DataSource;
import junit.framework.TestCase;
import org.junit.Test;
import org.opennms.netmgt.config.DataSourceFactory;
import org.opennms.netmgt.config.DefaultEventConfDao;
import org.opennms.netmgt.config.EventConfDao;
import org.opennms.netmgt.config.EventconfFactory;
import org.opennms.netmgt.config.SnmpPeerFactory;
import org.opennms.netmgt.eventd.BroadcastEventProcessor;
import org.opennms.netmgt.eventd.DefaultEventHandlerImpl;
import org.opennms.netmgt.eventd.EventHandler;
import org.opennms.netmgt.eventd.EventIpcBroadcaster;
import org.opennms.netmgt.eventd.EventIpcManager;
import org.opennms.netmgt.eventd.EventIpcManagerDefaultImpl;
import org.opennms.netmgt.eventd.EventIpcManagerFactory;
import org.opennms.netmgt.eventd.Eventd;
import org.opennms.netmgt.eventd.EventdServiceManager;
import org.opennms.netmgt.eventd.JdbcEventdServiceManager;
import org.opennms.netmgt.eventd.adaptors.EventIpcManagerEventHandlerProxy;
import org.opennms.netmgt.eventd.adaptors.tcp.TcpEventReceiver;
import org.opennms.netmgt.eventd.adaptors.udp.UdpEventReceiver;
import org.opennms.netmgt.eventd.processor.EventExpander;
import org.opennms.netmgt.eventd.processor.EventIpcBroadcastProcessor;
import org.opennms.netmgt.eventd.processor.JdbcAlarmWriter;
import org.opennms.netmgt.eventd.processor.JdbcEventWriter;
import org.opennms.netmgt.mock.MockDatabase;
import org.opennms.netmgt.mock.MockNetwork;
import org.opennms.netmgt.model.events.EventProxy;
import org.opennms.netmgt.snmp.SnmpUtils;
import org.opennms.test.ConfigurationTestUtils;
import org.opennms.test.mock.MockLogAppender;
import org.opennms.test.mock.MockUtil;
import org.springframework.core.io.FileSystemResource;
import org.springframework.core.io.Resource;
import org.springframework.jdbc.core.simple.SimpleJdbcTemplate;
import org.springframework.jdbc.datasource.DataSourceTransactionManager;
import org.springframework.transaction.PlatformTransactionManager;

public class OpenNMSTestCase
extends TestCase {
    protected static MockDatabase m_db;
    protected static MockNetwork m_network;
    protected static Eventd m_eventd;
    protected static EventIpcManagerDefaultImpl m_eventdIpcMgr;
    protected static boolean m_runSupers;
    private boolean m_startEventd = true;
    int m_version = 1;
    private EventProxy m_eventProxy;
    protected PlatformTransactionManager m_transMgr;

    public String getSnmpConfig() throws IOException {
        return ConfigurationTestUtils.getConfigForResourceWithReplacements((Object)((Object)this), (String)"/org/opennms/netmgt/mock/snmp-config.xml", (String[][])new String[][]{{"@myVersion@", this.myVersion()}, {"@myLocalHost@", this.myLocalHost()}});
    }

    protected String myLocalHost() {
        return "127.0.0.1";
    }

    protected String myVersion() {
        switch (this.m_version) {
            case 1: {
                return "v1";
            }
            case 2: {
                return "v2c";
            }
            case 3: {
                return "v3";
            }
        }
        return "v1";
    }

    public void setVersion(int version) {
        this.m_version = version;
    }

    protected void setUp() throws Exception {
        super.setUp();
        MockUtil.println((String)("------------ Begin Test " + (Object)((Object)this) + " --------------------------"));
        MockLogAppender.setupLogging();
        if (m_runSupers) {
            this.createMockNetwork();
            this.populateDatabase();
            DataSourceFactory.setInstance((DataSource)((Object)m_db));
            StringReader rdr = new StringReader(this.getSnmpConfig());
            SnmpPeerFactory.setInstance((SnmpPeerFactory)new SnmpPeerFactory((Reader)rdr));
            if (this.isStartEventd()) {
                m_eventdIpcMgr = new EventIpcManagerDefaultImpl();
                JdbcEventdServiceManager eventdServiceManager = new JdbcEventdServiceManager();
                eventdServiceManager.setDataSource((DataSource)((Object)m_db));
                eventdServiceManager.afterPropertiesSet();
                File configFile = ConfigurationTestUtils.getFileForResource((Object)((Object)this), (String)"/org/opennms/netmgt/mock/eventconf.xml");
                DefaultEventConfDao eventConfDao = new DefaultEventConfDao();
                eventConfDao.setConfigResource((Resource)new FileSystemResource(configFile));
                eventConfDao.afterPropertiesSet();
                EventconfFactory.setInstance((EventConfDao)eventConfDao);
                EventExpander eventExpander = new EventExpander();
                eventExpander.setEventConfDao((EventConfDao)eventConfDao);
                eventExpander.afterPropertiesSet();
                JdbcEventWriter jdbcEventWriter = new JdbcEventWriter();
                jdbcEventWriter.setEventdServiceManager((EventdServiceManager)eventdServiceManager);
                jdbcEventWriter.setDataSource((DataSource)((Object)m_db));
                jdbcEventWriter.setGetNextIdString("select nextVal('eventsNxtId')");
                jdbcEventWriter.afterPropertiesSet();
                EventIpcBroadcastProcessor eventIpcBroadcastProcessor = new EventIpcBroadcastProcessor();
                eventIpcBroadcastProcessor.setEventIpcBroadcaster((EventIpcBroadcaster)m_eventdIpcMgr);
                eventIpcBroadcastProcessor.afterPropertiesSet();
                JdbcAlarmWriter jdbcAlarmWriter = new JdbcAlarmWriter();
                jdbcAlarmWriter.setEventdServiceManager((EventdServiceManager)eventdServiceManager);
                jdbcAlarmWriter.setDataSource((DataSource)((Object)m_db));
                jdbcAlarmWriter.setGetNextIdString("select nextVal('alarmsNxtId')");
                jdbcAlarmWriter.afterPropertiesSet();
                ArrayList<Object> eventProcessors = new ArrayList<Object>(3);
                eventProcessors.add(eventExpander);
                eventProcessors.add(jdbcEventWriter);
                eventProcessors.add(eventIpcBroadcastProcessor);
                eventProcessors.add(jdbcAlarmWriter);
                DefaultEventHandlerImpl eventHandler = new DefaultEventHandlerImpl();
                eventHandler.setEventProcessors(eventProcessors);
                eventHandler.afterPropertiesSet();
                m_eventdIpcMgr.setHandlerPoolSize(5);
                m_eventdIpcMgr.setEventHandler((EventHandler)eventHandler);
                m_eventdIpcMgr.afterPropertiesSet();
                this.m_eventProxy = m_eventdIpcMgr;
                EventIpcManagerFactory.setIpcManager((EventIpcManager)m_eventdIpcMgr);
                EventIpcManagerEventHandlerProxy proxy = new EventIpcManagerEventHandlerProxy();
                proxy.setEventIpcManager((EventIpcManager)m_eventdIpcMgr);
                proxy.afterPropertiesSet();
                ArrayList<EventIpcManagerEventHandlerProxy> eventHandlers = new ArrayList<EventIpcManagerEventHandlerProxy>(1);
                eventHandlers.add(proxy);
                TcpEventReceiver tcpEventReceiver = new TcpEventReceiver();
                tcpEventReceiver.setPort(Integer.valueOf(5837));
                tcpEventReceiver.setEventHandlers(eventHandlers);
                UdpEventReceiver udpEventReceiver = new UdpEventReceiver();
                udpEventReceiver.setPort(Integer.valueOf(5837));
                tcpEventReceiver.setEventHandlers(eventHandlers);
                ArrayList<Object> eventReceivers = new ArrayList<Object>(2);
                eventReceivers.add(tcpEventReceiver);
                eventReceivers.add(udpEventReceiver);
                m_eventd = new Eventd();
                m_eventd.setEventdServiceManager((EventdServiceManager)eventdServiceManager);
                m_eventd.setEventReceivers(eventReceivers);
                m_eventd.setReceiver(new BroadcastEventProcessor((EventIpcManager)m_eventdIpcMgr, (EventConfDao)eventConfDao));
                m_eventd.init();
                m_eventd.start();
            }
        }
        this.m_transMgr = new DataSourceTransactionManager(DataSourceFactory.getInstance());
    }

    protected void populateDatabase() throws Exception {
        m_db = new MockDatabase();
        m_db.populate(m_network);
    }

    protected void createMockNetwork() {
        m_network = new MockNetwork();
        m_network.createStandardNetwork();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void runTest() throws Throwable {
        try {
            super.runTest();
            MockLogAppender.assertNoWarningsOrGreater();
        }
        finally {
            MockUtil.println((String)("------------ End Test " + (Object)((Object)this) + " --------------------------"));
        }
    }

    protected void tearDown() throws Exception {
        if (m_runSupers && this.isStartEventd()) {
            m_eventd.stop();
        }
        super.tearDown();
    }

    protected void setStartEventd(boolean startEventd) {
        this.m_startEventd = startEventd;
    }

    protected boolean isStartEventd() {
        return this.m_startEventd;
    }

    @Test
    public void testDoNothing() {
        this.sleep(200L);
    }

    protected void sleep(long millis) {
        try {
            Thread.sleep(millis);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    protected EventProxy getEventProxy() {
        return this.m_eventProxy;
    }

    protected void setEventProxy(EventProxy eventProxy) {
        this.m_eventProxy = eventProxy;
    }

    public SimpleJdbcTemplate getJdbcTemplate() {
        return m_db.getJdbcTemplate();
    }

    public String toString() {
        return super.toString() + " - " + this.getSnmpImplementation() + " " + this.myVersion();
    }

    private String getSnmpImplementation() {
        return SnmpUtils.getStrategy().getClass().getSimpleName();
    }

    public EventIpcManager getEventIpcManager() {
        return m_eventdIpcMgr;
    }

    static {
        m_runSupers = true;
    }
}

