/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.mock;

import java.util.Enumeration;
import junit.framework.TestCase;
import org.opennms.netmgt.config.poller.Package;
import org.opennms.netmgt.config.poller.Service;
import org.opennms.netmgt.mock.MockNetwork;
import org.opennms.netmgt.mock.MockPollerConfig;

public class MockPollerConfigTest
extends TestCase {
    MockPollerConfig m_pollerConfig;

    public void setUp() {
        MockNetwork network = new MockNetwork();
        network.setCriticalService("ICMP");
        network.addNode(1, "Router");
        network.addInterface("192.168.1.1");
        network.addService("ICMP");
        network.addService("SMTP");
        network.addInterface("192.168.1.2");
        network.addService("ICMP");
        network.addService("SMTP");
        network.addNode(2, "Server");
        network.addInterface("192.168.1.3");
        network.addService("ICMP");
        network.addService("HTTP");
        network.addInterface("192.168.1.2");
        this.m_pollerConfig = new MockPollerConfig(network);
        this.m_pollerConfig.addPackage("TestPackage");
        this.m_pollerConfig.addDowntime(1000L, 0L, -1L, false);
        this.m_pollerConfig.setDefaultPollInterval(1000L);
        this.m_pollerConfig.populatePackage(network);
        this.m_pollerConfig.setPollInterval("ICMP", 500L);
    }

    public void testPollerConfig() {
        this.m_pollerConfig.setNodeOutageProcessingEnabled(true);
        this.m_pollerConfig.setPollInterval("HTTP", 750L);
        this.m_pollerConfig.setPollerThreads(5);
        this.m_pollerConfig.setCriticalService("YAHOO");
        MockPollerConfigTest.assertTrue((boolean)this.m_pollerConfig.nodeOutageProcessingEnabled());
        Enumeration<Package> pkgs = this.m_pollerConfig.enumeratePackage();
        MockPollerConfigTest.assertNotNull(pkgs);
        int pkgCount = 0;
        Package pkg = null;
        while (pkgs.hasMoreElements()) {
            pkg = pkgs.nextElement();
            ++pkgCount;
        }
        MockPollerConfigTest.assertTrue((pkgCount > 0 ? 1 : 0) != 0);
        MockPollerConfigTest.assertTrue((boolean)this.m_pollerConfig.interfaceInPackage("192.168.1.1", pkg));
        MockPollerConfigTest.assertFalse((boolean)this.m_pollerConfig.interfaceInPackage("192.168.1.7", pkg));
        Enumeration svcs = pkg.enumerateService();
        MockPollerConfigTest.assertNotNull((Object)svcs);
        int svcCount = 0;
        boolean icmpFound = false;
        boolean httpFound = false;
        while (svcs.hasMoreElements()) {
            Service svc = (Service)svcs.nextElement();
            ++svcCount;
            if ("ICMP".equals(svc.getName())) {
                icmpFound = true;
                MockPollerConfigTest.assertEquals((long)500L, (long)svc.getInterval());
                continue;
            }
            if ("HTTP".equals(svc.getName())) {
                httpFound = true;
                MockPollerConfigTest.assertEquals((long)750L, (long)svc.getInterval());
                continue;
            }
            MockPollerConfigTest.assertEquals((long)1000L, (long)svc.getInterval());
        }
        MockPollerConfigTest.assertTrue((boolean)icmpFound);
        MockPollerConfigTest.assertTrue((boolean)httpFound);
        MockPollerConfigTest.assertEquals((int)3, (int)svcCount);
        MockPollerConfigTest.assertEquals((int)5, (int)this.m_pollerConfig.getThreads());
        MockPollerConfigTest.assertEquals((String)"YAHOO", (String)this.m_pollerConfig.getCriticalService());
        MockPollerConfigTest.assertNotNull((Object)this.m_pollerConfig.getServiceMonitor("SMTP"));
    }
}

