/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.mock;

import org.opennms.netmgt.mock.MockContainer;
import org.opennms.netmgt.mock.MockEventUtil;
import org.opennms.netmgt.mock.MockInterface;
import org.opennms.netmgt.mock.MockNetwork;
import org.opennms.netmgt.mock.MockVisitor;
import org.opennms.netmgt.xml.event.Event;

public class MockNode
extends MockContainer {
    String m_label;
    int m_nodeid;
    int m_nextIfIndex = 1;

    public MockNode(MockNetwork network, int nodeid, String label) {
        super(network);
        this.m_nodeid = nodeid;
        this.m_label = label;
    }

    public MockInterface addInterface(String ipAddr) {
        return (MockInterface)this.addMember(new MockInterface(this, ipAddr));
    }

    public MockInterface getInterface(String ipAddr) {
        return (MockInterface)this.getMember(ipAddr);
    }

    Object getKey() {
        return new Integer(this.m_nodeid);
    }

    public String getLabel() {
        return this.m_label;
    }

    public MockNetwork getNetwork() {
        return (MockNetwork)this.getParent();
    }

    public int getNodeId() {
        return this.m_nodeid;
    }

    public int getNextIfIndex() {
        return this.m_nextIfIndex++;
    }

    public void removeInterface(MockInterface iface) {
        this.removeMember(iface);
    }

    public String toString() {
        return "Node[" + this.m_nodeid + "," + this.m_label + "]";
    }

    public void visit(MockVisitor v) {
        super.visit(v);
        v.visitNode(this);
        this.visitMembers(v);
    }

    public Event createUpEvent() {
        return MockEventUtil.createNodeUpEvent("Test", this);
    }

    public Event createDownEvent() {
        return MockEventUtil.createNodeDownEvent("Test", this);
    }

    public Event createDeleteEvent() {
        return MockEventUtil.createNodeDeletedEvent("Test", this);
    }
}

