/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.mock;

import java.sql.Timestamp;
import java.text.ParseException;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.opennms.core.utils.ThreadCategory;
import org.opennms.netmgt.EventConstants;
import org.opennms.netmgt.mock.MockInterface;
import org.opennms.netmgt.mock.MockNode;
import org.opennms.netmgt.mock.MockService;
import org.opennms.netmgt.xml.event.Event;
import org.opennms.netmgt.xml.event.Parm;
import org.opennms.netmgt.xml.event.Parms;
import org.opennms.netmgt.xml.event.Value;
import org.opennms.test.mock.MockUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MockEventUtil {
    public static void addEventParm(Event event, String parmName, int parmValue) {
        MockEventUtil.addEventParm(event, parmName, String.valueOf(parmValue));
    }

    public static void addEventParm(Event event, String parmName, String parmValue) {
        Parms parms = event.getParms();
        if (parms == null) {
            parms = new Parms();
            event.setParms(parms);
        }
        Parm parm = new Parm();
        parm.setParmName(parmName);
        Value value = new Value();
        value.setContent(parmValue);
        parm.setValue(value);
        parms.addParm(parm);
    }

    public static Event createNodeLostServiceEvent(String source, MockService svc, String reason) {
        return MockEventUtil.createServiceEvent(source, "uei.opennms.org/nodes/nodeLostService", svc, reason);
    }

    public static Event createNodeLostServiceEvent(String source, MockService svc) {
        return MockEventUtil.createServiceEvent(source, "uei.opennms.org/nodes/nodeLostService", svc, null);
    }

    public static Event createNodeRegainedServiceEvent(String source, MockService svc) {
        return MockEventUtil.createServiceEvent(source, "uei.opennms.org/nodes/nodeRegainedService", svc, null);
    }

    public static Event createServiceUnresponsiveEvent(String source, MockService svc, String reason) {
        return MockEventUtil.createServiceEvent(source, "uei.opennms.org/nodes/serviceUnresponsive", svc, reason);
    }

    public static Event createServiceResponsiveEvent(String source, MockService svc) {
        return MockEventUtil.createServiceEvent(source, "uei.opennms.org/nodes/serviceResponsive", svc, null);
    }

    public static Event createDemandPollServiceEvent(String source, MockService svc, int demandPollId) {
        Event event = MockEventUtil.createServiceEvent(source, "uei.opennms.org/internal/demandPollService", svc, null);
        MockEventUtil.addEventParm(event, "demandPollId", demandPollId);
        return event;
    }

    public static Event createNodeGainedServiceEvent(String source, MockService svc) {
        return MockEventUtil.createServiceEvent(source, "uei.opennms.org/nodes/nodeGainedService", svc, null);
    }

    public static Event createServiceDeletedEvent(String source, MockService svc) {
        return MockEventUtil.createServiceEvent(source, "uei.opennms.org/nodes/serviceDeleted", svc, null);
    }

    public static Event createSuspendPollingServiceEvent(String source, MockService svc) {
        return MockEventUtil.createServiceEvent(source, "uei.opennms.org/internal/poller/suspendPollingService", svc, null);
    }

    public static Event createResumePollingServiceEvent(String source, MockService svc) {
        return MockEventUtil.createServiceEvent(source, "uei.opennms.org/internal/poller/resumePollingService", svc, null);
    }

    public static Event createServiceEvent(String source, String uei, MockService svc, String reason) {
        return MockEventUtil.createEvent(source, uei, svc.getNodeId(), svc.getIpAddr(), svc.getSvcName(), reason);
    }

    public static Event createInterfaceDownEvent(String source, MockInterface iface) {
        return MockEventUtil.createInterfaceEvent(source, "uei.opennms.org/nodes/interfaceDown", iface);
    }

    public static Event createInterfaceUpEvent(String source, MockInterface iface) {
        return MockEventUtil.createInterfaceEvent(source, "uei.opennms.org/nodes/interfaceUp", iface);
    }

    public static Event createInterfaceDeletedEvent(String source, MockInterface iface) {
        return MockEventUtil.createInterfaceEvent(source, "uei.opennms.org/nodes/interfaceDeleted", iface);
    }

    public static Event createInterfaceEvent(String source, String uei, MockInterface iface) {
        return MockEventUtil.createEvent(source, uei, iface.getNodeId(), iface.getIpAddr(), null, null);
    }

    public static Event createNodeDownEvent(String source, MockNode node) {
        return MockEventUtil.createNodeEvent(source, "uei.opennms.org/nodes/nodeDown", node);
    }

    public static Event createNodeUpEvent(String source, MockNode node) {
        return MockEventUtil.createNodeEvent(source, "uei.opennms.org/nodes/nodeUp", node);
    }

    public static Event createNodeDeletedEvent(String source, MockNode node) {
        return MockEventUtil.createNodeEvent(source, "uei.opennms.org/nodes/nodeDeleted", node);
    }

    public static Event createNodeEvent(String source, String uei, MockNode node) {
        return MockEventUtil.createEvent(source, uei, node.getNodeId(), null, null, null);
    }

    public static Event createNewSuspectEvent(String source, String uei, String ipAddr) {
        Event event = MockEventUtil.createEvent(source, uei);
        event.setInterface(ipAddr);
        return event;
    }

    public static Event createBgpBkTnEvent(String source, MockNode node, String ipAddr, int peerState) {
        Event event = MockEventUtil.createEvent(source, "http://uei.opennms.org/standards/rfc1657/traps/bgpBackwardTransition", node.getNodeId(), null, null, null);
        event.setInterface("1.2.3.4");
        MockEventUtil.addEventParm(event, ".1.3.6.1.2.1.15.3.1.7." + ipAddr, peerState);
        return event;
    }

    public static void setEventTime(Event event, Date date) {
        event.setTime(EventConstants.formatToString((Date)date));
    }

    public static Event createEvent(String source, String uei, int nodeId, String ipAddr, String svcName, String reason) {
        Event event = MockEventUtil.createEvent(source, uei);
        event.setNodeid((long)nodeId);
        event.setInterface(ipAddr);
        event.setService(svcName);
        if (reason != null) {
            Parms eventParms = new Parms();
            Parm eventParm = new Parm();
            Value parmValue = new Value();
            eventParm.setParmName("eventReason");
            parmValue.setContent(reason);
            eventParm.setValue(parmValue);
            eventParms.addParm(eventParm);
            event.setParms(eventParms);
        }
        return event;
    }

    public static Event createEvent(String source, String uei) {
        Event event = new Event();
        event.setSource(source);
        event.setUei(uei);
        String eventTime = EventConstants.formatToString((Date)new Date());
        event.setCreationTime(eventTime);
        event.setTime(eventTime);
        return event;
    }

    public static Event createReparentEvent(String source, String ipAddr, int oldNode, int newNode) {
        Event event = MockEventUtil.createEvent(source, "uei.opennms.org/nodes/interfaceReparented", oldNode, ipAddr, null, null);
        MockEventUtil.addEventParm(event, "oldNodeID", oldNode);
        MockEventUtil.addEventParm(event, "newNodeID", newNode);
        return event;
    }

    public static Timestamp convertEventTimeIntoTimestamp(String eventTime) {
        Timestamp timestamp = null;
        try {
            Date date = EventConstants.parseToDate((String)eventTime);
            timestamp = new Timestamp(date.getTime());
        }
        catch (ParseException e) {
            ThreadCategory.getInstance(MockEventUtil.class).warn((Object)("Failed to convert event time " + eventTime + " to timestamp."), (Throwable)e);
            timestamp = new Timestamp(new Date().getTime());
        }
        return timestamp;
    }

    public static boolean eventsMatch(Event e1, Event e2) {
        if (e1 == e2) {
            return true;
        }
        if (e1 == null || e2 == null) {
            return false;
        }
        if (!(e1.getUei() == e2.getUei() || e1.getUei() != null && e2.getUei() != null && e1.getUei().equals(e2.getUei()))) {
            return false;
        }
        if (e1.getNodeid() != e2.getNodeid()) {
            return false;
        }
        if (!(e1.getInterface() == e2.getInterface() || e1.getInterface() != null && e2.getInterface() != null && e1.getInterface().equals(e2.getInterface()))) {
            return false;
        }
        return e1.getService() == e2.getService() || e1.getService() != null && e2.getService() != null && e1.getService().equals(e2.getService());
    }

    public static boolean eventsMatchDeep(Event e1, Event e2) {
        if (e1.getTime() != null || e2.getTime() != null) {
            if (e1.getTime() == null || e2.getTime() == null) {
                return false;
            }
            if (!e1.getTime().equals(e2.getTime())) {
                return false;
            }
        }
        if (!MockEventUtil.eventsMatch(e1, e2)) {
            return false;
        }
        if (e1.getParms() != null || e2.getParms() != null) {
            Map<String, String> m2;
            if (e1.getParms() == null || e2.getParms() == null) {
                return false;
            }
            Parms p1 = e1.getParms();
            Parms p2 = e2.getParms();
            if (p1.getParmCount() != p2.getParmCount()) {
                return false;
            }
            Map<String, String> m1 = MockEventUtil.convertParmsToMap(p1.getParmCollection());
            if (!((Object)m1).equals(m2 = MockEventUtil.convertParmsToMap(p2.getParmCollection()))) {
                return false;
            }
        }
        return true;
    }

    private static Map<String, String> convertParmsToMap(List<Parm> parms) {
        HashMap<String, String> map = new HashMap<String, String>();
        for (Parm p : parms) {
            map.put(p.getParmName(), p.getValue().getContent());
        }
        return map;
    }

    public static void printEvent(String prefix, Event event) {
        if (!MockUtil.printEnabled()) {
            return;
        }
        if (prefix == null) {
            prefix = "Event";
        }
        System.err.println(prefix + ": " + event.getUei() + "/" + event.getNodeid() + "/" + event.getInterface() + "/" + event.getService());
    }

    public static void printEvents(String prefix, Collection<Event> events) {
        if (!MockUtil.printEnabled()) {
            return;
        }
        for (Event event : events) {
            MockEventUtil.printEvent(prefix, event);
        }
    }
}

