/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.mock;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.opennms.netmgt.mock.MockElement;
import org.opennms.netmgt.mock.MockService;
import org.opennms.netmgt.mock.MockVisitor;
import org.opennms.netmgt.mock.MockVisitorAdapter;
import org.opennms.netmgt.mock.PollAnticipator;
import org.opennms.netmgt.model.PollStatus;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class MockContainer
extends MockElement {
    private Map<Object, MockElement> m_members = new HashMap<Object, MockElement>();

    protected MockContainer(MockContainer parent) {
        super(parent);
    }

    @Override
    public void addAnticipator(final PollAnticipator trigger) {
        MockVisitorAdapter triggerAdder = new MockVisitorAdapter(){

            public void visitService(MockService service) {
                service.addAnticipator(trigger);
            }
        };
        this.visit(triggerAdder);
    }

    protected MockElement addMember(MockElement element) {
        this.m_members.put(element.getKey(), element);
        element.setParent(this);
        return element;
    }

    protected MockElement getMember(Object key) {
        return this.m_members.get(key);
    }

    protected List<MockElement> getMembers() {
        return new ArrayList<MockElement>(this.m_members.values());
    }

    @Override
    public int getPollCount() {
        class PollCounter
        extends MockVisitorAdapter {
            int pollCount = 0;

            PollCounter() {
            }

            int getPollCount() {
                return this.pollCount;
            }

            public void visitService(MockService service) {
                this.pollCount += service.getPollCount();
            }
        }
        PollCounter pollCounter = new PollCounter();
        this.visit(pollCounter);
        return pollCounter.getPollCount();
    }

    @Override
    public PollStatus getPollStatus() {
        for (MockElement element : this.m_members.values()) {
            if (!element.getPollStatus().isUp()) continue;
            return PollStatus.up();
        }
        return PollStatus.down();
    }

    @Override
    public void removeAnticipator(final PollAnticipator trigger) {
        MockVisitorAdapter triggerRemover = new MockVisitorAdapter(){

            public void visitService(MockService service) {
                service.removeAnticipator(trigger);
            }
        };
        this.visit(triggerRemover);
    }

    protected void removeMember(MockElement element) {
        this.m_members.remove(element.getKey());
        element.setParent(null);
    }

    @Override
    public void resetPollCount() {
        class PollCountReset
        extends MockVisitorAdapter {
            PollCountReset() {
            }

            public void visitService(MockService service) {
                service.resetPollCount();
            }
        }
        PollCountReset pollCounter = new PollCountReset();
        this.visit(pollCounter);
    }

    @Override
    public void visit(MockVisitor v) {
        super.visit(v);
        v.visitContainer(this);
    }

    protected void visitMembers(MockVisitor v) {
        for (MockElement element : this.m_members.values()) {
            element.visit(v);
        }
    }
}

