/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.mock;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.Enumeration;
import org.exolab.castor.xml.MarshalException;
import org.exolab.castor.xml.Unmarshaller;
import org.exolab.castor.xml.ValidationException;
import org.opennms.netmgt.config.CatFactory;
import org.opennms.netmgt.config.categories.Categories;
import org.opennms.netmgt.config.categories.Category;
import org.opennms.netmgt.config.categories.Categorygroup;
import org.opennms.netmgt.config.categories.Catinfo;

public class MockCategoryFactory
implements CatFactory {
    private Catinfo m_config;
    private static final String CATEGORY_CONFIG = "<catinfo> <header>  <rev>1.3</rev>  <created>Wednesday, February 6, 2002 10:10:00 AM EST</created>  <mstation>checkers</mstation> </header> <categorygroup>  <name>WebConsole</name>  <comment>Service Level Availability by Functional Group</comment>  <common>   <rule><![CDATA[ipaddr IPLIKE *.*.*.*]]></rule>  </common>  <categories>   <category>    <label><![CDATA[Network Interfaces]]></label>    <comment>This is a very simple category</comment>    <normal>99</normal>    <warning>97</warning>    <service>ICMP</service>    <service>SNMP</service>    <rule><![CDATA[(isICMP | isSNMP) & (ipaddr != \"0.0.0.0\")]]></rule>   </category> <category>    <label><![CDATA[Web Servers]]></label>    <comment>This is a more complex category</comment>    <normal>99</normal>    <warning>97</warning>    <service>HTTP</service>    <service>HTTPS</service>    <rule><![CDATA[isHTTP | isHTTPS]]></rule>   </category>  </categories> </categorygroup></catinfo>";

    public MockCategoryFactory() throws MarshalException, ValidationException, IOException {
        this.m_config = (Catinfo)Unmarshaller.unmarshal(Catinfo.class, (Reader)new StringReader(CATEGORY_CONFIG));
    }

    public MockCategoryFactory(String config) throws MarshalException, ValidationException, IOException {
        this.m_config = (Catinfo)Unmarshaller.unmarshal(Catinfo.class, (Reader)new StringReader(config));
    }

    public synchronized Catinfo getConfig() {
        return this.m_config;
    }

    public synchronized Category getCategory(String name) {
        Enumeration enumCG = this.m_config.enumerateCategorygroup();
        while (enumCG.hasMoreElements()) {
            Categorygroup cg = (Categorygroup)enumCG.nextElement();
            Categories cats = cg.getCategories();
            Enumeration enumCat = cats.enumerateCategory();
            while (enumCat.hasMoreElements()) {
                Category cat = (Category)enumCat.nextElement();
                if (!cat.getLabel().equals(name)) continue;
                return cat;
            }
        }
        return null;
    }

    public synchronized String getEffectiveRule(String catlabel) {
        Enumeration enumCG = this.m_config.enumerateCategorygroup();
        while (enumCG.hasMoreElements()) {
            Categorygroup cg = (Categorygroup)enumCG.nextElement();
            Categories cats = cg.getCategories();
            Enumeration enumCat = cats.enumerateCategory();
            while (enumCat.hasMoreElements()) {
                Category cat = (Category)enumCat.nextElement();
                if (!cat.getLabel().equals(catlabel)) continue;
                String catRule = "(" + cg.getCommon().getRule() + ") & (" + cat.getRule() + ")";
                return catRule;
            }
        }
        return null;
    }

    public double getNormal(String catlabel) {
        return 0.0;
    }

    public double getWarning(String catlabel) {
        return 0.0;
    }
}

