/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.eventd;

import org.opennms.core.utils.Base64;
import org.opennms.netmgt.eventd.EventUtil;
import org.opennms.netmgt.eventd.db.Constants;
import org.opennms.netmgt.mock.MockEventUtil;
import org.opennms.netmgt.mock.MockService;
import org.opennms.netmgt.mock.OpenNMSTestCase;
import org.opennms.netmgt.xml.event.Event;
import org.opennms.netmgt.xml.event.Tticket;
import org.opennms.netmgt.xml.event.Value;

public class EventUtilTest
extends OpenNMSTestCase {
    private MockService m_svc;
    private Event m_svcLostEvent;
    private Event m_nodeDownEvent;
    private Event m_bgpBkTnEvent;

    protected void setUp() throws Exception {
        super.setUp();
        this.m_svc = m_network.getService(1, "192.168.1.1", "SMTP");
        this.m_svcLostEvent = MockEventUtil.createNodeLostServiceEvent("Test", this.m_svc);
        this.m_nodeDownEvent = MockEventUtil.createNodeDownEvent("Text", m_network.getNode(1));
        this.m_bgpBkTnEvent = MockEventUtil.createBgpBkTnEvent("Test", m_network.getNode(1), "128.64.32.16", 2);
    }

    protected void tearDown() throws Exception {
        super.tearDown();
    }

    public void testGetValueAsString() {
        Value v = new Value();
        v.setContent(new String(Base64.encodeBase64((byte[])new String("test").getBytes())));
        v.setEncoding("base64");
        EventUtilTest.assertEquals((String)"test", (String)EventUtil.getValueAsString((Value)v));
    }

    public void testEscape() {
        EventUtilTest.assertEquals((String)"m%onkeys%47rock", (String)EventUtil.escape((String)"m%onkeys/rock", (char)'/'));
    }

    public void testGetValueOfParm() {
        String testString = EventUtil.getValueOfParm((String)"uei", (Event)this.m_svcLostEvent);
        EventUtilTest.assertEquals((String)"uei.opennms.org/nodes/nodeLostService", (String)testString);
        this.m_svcLostEvent.setSeverity(Constants.getSeverityString((int)5));
        testString = EventUtil.getValueOfParm((String)"severity", (Event)this.m_svcLostEvent);
        EventUtilTest.assertEquals((String)"Minor", (String)testString);
        Event event = MockEventUtil.createNodeLostServiceEvent("Test", this.m_svc, "noReasonAtAll");
        EventUtilTest.assertEquals((String)"noReasonAtAll", (String)EventUtil.getNamedParmValue((String)"parm[eventReason]", (Event)event));
    }

    public void testExpandParms() {
        String testString = "%uei%:%dpname%:%nodeid%:%interface%:%service%";
        String newString = EventUtil.expandParms((String)testString, (Event)this.m_svcLostEvent);
        EventUtilTest.assertEquals((String)"uei.opennms.org/nodes/nodeLostService::1:192.168.1.1:SMTP", (String)newString);
    }

    public void testExpandParmNames() {
        String testString = "%uei%:%dpname%:%nodeid%:%parm[name-#1]%";
        String newString = EventUtil.expandParms((String)testString, (Event)this.m_bgpBkTnEvent);
        EventUtilTest.assertEquals((String)"http://uei.opennms.org/standards/rfc1657/traps/bgpBackwardTransition::1:.1.3.6.1.2.1.15.3.1.7.128.64.32.16", (String)newString);
    }

    public void testSplitAndExtractParmNamePositive() {
        String testString = "%uei%:%dpname%:%nodeid%:%parm[name-#1.1]%.%parm[name-#1.3]%.%parm[name-#1.5]%.%parm[name-#1.7]%";
        String newString = EventUtil.expandParms((String)testString, (Event)this.m_bgpBkTnEvent);
        EventUtilTest.assertEquals((String)"http://uei.opennms.org/standards/rfc1657/traps/bgpBackwardTransition::1:1.6.2.15", (String)newString);
    }

    public void testSplitAndExtractParmNameNegative() {
        String testString = "%uei%:%dpname%:%nodeid%:%parm[name-#1.-4]%.%parm[name-#1.-3]%.%parm[name-#1.-2]%.%parm[name-#1.-1]%";
        String newString = EventUtil.expandParms((String)testString, (Event)this.m_bgpBkTnEvent);
        EventUtilTest.assertEquals((String)"http://uei.opennms.org/standards/rfc1657/traps/bgpBackwardTransition::1:128.64.32.16", (String)newString);
    }

    public void testSplitAndExtractParmNameRangePositive() {
        String testString = "%uei%:%dpname%:%nodeid%:%parm[name-#1.1:4]%";
        String newString = EventUtil.expandParms((String)testString, (Event)this.m_bgpBkTnEvent);
        EventUtilTest.assertEquals((String)"http://uei.opennms.org/standards/rfc1657/traps/bgpBackwardTransition::1:1.3.6.1", (String)newString);
    }

    public void testSplitAndExtractParmNameRangePositiveToEnd() {
        String testString = "%uei%:%dpname%:%nodeid%:%parm[name-#1.5:]%";
        String newString = EventUtil.expandParms((String)testString, (Event)this.m_bgpBkTnEvent);
        EventUtilTest.assertEquals((String)"http://uei.opennms.org/standards/rfc1657/traps/bgpBackwardTransition::1:2.1.15.3.1.7.128.64.32.16", (String)newString);
    }

    public void testSplitAndExtractParmNameRangeNegative() {
        String testString = "%uei%:%dpname%:%nodeid%:%parm[name-#1.-4:2]%";
        String newString = EventUtil.expandParms((String)testString, (Event)this.m_bgpBkTnEvent);
        EventUtilTest.assertEquals((String)"http://uei.opennms.org/standards/rfc1657/traps/bgpBackwardTransition::1:128.64", (String)newString);
    }

    public void testSplitAndExtractParmNameRangeNegativeToEnd() {
        String testString = "%uei%:%dpname%:%nodeid%:%parm[name-#1.-5:]%";
        String newString = EventUtil.expandParms((String)testString, (Event)this.m_bgpBkTnEvent);
        EventUtilTest.assertEquals((String)"http://uei.opennms.org/standards/rfc1657/traps/bgpBackwardTransition::1:7.128.64.32.16", (String)newString);
    }

    public void testExpandTticketId() {
        String testString = "%tticketid%";
        String newString = EventUtil.expandParms((String)testString, (Event)this.m_nodeDownEvent);
        EventUtilTest.assertEquals((String)"", (String)newString);
        Tticket ticket = new Tticket();
        ticket.setContent("777");
        ticket.setState("1");
        this.m_nodeDownEvent.setTticket(ticket);
        newString = EventUtil.expandParms((String)testString, (Event)this.m_nodeDownEvent);
        EventUtilTest.assertEquals((String)"777", (String)newString);
    }
}

