/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.config;

import java.io.Reader;
import java.io.StringReader;
import java.net.InetAddress;
import java.net.UnknownHostException;
import junit.framework.TestCase;
import org.opennms.netmgt.config.SnmpPeerFactory;
import org.opennms.netmgt.snmp.SnmpAgentConfig;
import org.opennms.test.mock.MockLogAppender;

public class SnmpPeerFactoryTest
extends TestCase {
    private int m_version;

    protected void setUp() throws Exception {
        this.setVersion(2);
        StringReader rdr = new StringReader(this.getSnmpConfig());
        SnmpPeerFactory.setInstance((SnmpPeerFactory)new SnmpPeerFactory((Reader)rdr));
        MockLogAppender.setupLogging((boolean)false);
    }

    public void setVersion(int version) {
        this.m_version = version;
    }

    public String getSnmpConfig() {
        return "<?xml version=\"1.0\"?>\n<snmp-config  retry=\"3\" timeout=\"3000\"\n read-community=\"public\" write-community=\"private\"\n port=\"161\"\n version=\"v1\">\n\n   <definition port=\"9161\" version=\"" + this.myVersion() + "\" " + "       security-name=\"opennmsUser\" \n" + "       auth-passphrase=\"0p3nNMSv3\" \n" + "       privacy-passphrase=\"0p3nNMSv3\" >\n" + "       <specific>" + this.myLocalHost() + "</specific>\n" + "   </definition>\n" + "\n" + "   <definition version=\"v1\" read-community=\"specificv1\">\n" + "       <specific>10.0.0.1</specific>\n" + "   </definition>\n" + "\n" + "   <definition version=\"v1\" read-community=\"specificv1\" max-request-size=\"484\">\n" + "       <specific>10.0.0.2</specific>\n" + "   </definition>\n" + "\n" + "   <definition version=\"v1\" read-community=\"specificv1\" proxy-host=\"" + this.myLocalHost() + "\">\n" + "       <specific>10.0.0.3</specific>\n" + "   </definition>\n" + "\n" + "   <definition version=\"v3\" " + "       security-name=\"opennmsUser\" \n" + "       auth-passphrase=\"0p3nNMSv3\" >\n" + "       <specific>20.20.20.20</specific>\n" + "   </definition>\n" + "   <definition version=\"v3\" " + "       security-name=\"opennmsRangeUser\" \n" + "       auth-passphrase=\"0p3nNMSv3\" >\n" + "       <range begin=\"1.1.1.1\" end=\"1.1.1.100\"/>\n" + "   </definition>\n" + "\n" + "   <definition version=\"v1\" read-community=\"rangev1\" max-vars-per-pdu=\"55\"> \n" + "       <range begin=\"10.0.0.101\" end=\"10.0.0.200\"/>\n" + "   </definition>\n" + "\n" + "   <definition version=\"v2c\" read-community=\"rangev2c\">\n" + "       <range begin=\"10.0.1.100\" end=\"10.0.5.100\"/>\n" + "       <range begin=\"10.7.20.100\" end=\"10.7.25.100\"/>\n" + "   </definition>\n" + "\n" + "   <definition version=\"v2c\" read-community=\"specificv2c\">\n" + "       <specific>192.168.0.50</specific>\n" + "   </definition>\n" + "\n" + "   <definition version=\"v2c\" read-community=\"ipmatch\" max-vars-per-pdu=\"128\" max-repetitions=\"7\" >\n" + "       <ip-match>77.5-12,15.1-255.255</ip-match>\n" + "   </definition>\n" + "\n" + "</snmp-config>";
    }

    protected String myLocalHost() {
        return "127.0.0.1";
    }

    private String myVersion() {
        switch (this.m_version) {
            case 1: {
                return "v1";
            }
            case 2: {
                return "v2c";
            }
            case 3: {
                return "v3";
            }
        }
        return "v1";
    }

    protected void tearDown() {
    }

    public void testProxiedAgent() throws UnknownHostException {
        SnmpAgentConfig agentConfig = SnmpPeerFactory.getInstance().getAgentConfig(InetAddress.getByName("10.0.0.3"));
        SnmpPeerFactoryTest.assertEquals((String)"10.0.0.3", (String)agentConfig.getProxyFor().getHostAddress());
        SnmpPeerFactoryTest.assertEquals((String)"127.0.0.1", (String)agentConfig.getAddress().getHostAddress());
        agentConfig.toString();
    }

    public void testDefaultMaxRequestSize() throws UnknownHostException {
        SnmpAgentConfig agentConfig = SnmpPeerFactory.getInstance().getAgentConfig(InetAddress.getByName("10.0.0.1"));
        SnmpPeerFactoryTest.assertEquals((int)65535, (int)agentConfig.getMaxRequestSize());
        agentConfig = SnmpPeerFactory.getInstance().getAgentConfig(InetAddress.getByName("10.0.0.2"));
        SnmpPeerFactoryTest.assertEquals((int)484, (int)agentConfig.getMaxRequestSize());
    }

    public void testDefaultMaxVarsPerPdu() throws UnknownHostException {
        SnmpAgentConfig agentConfig = SnmpPeerFactory.getInstance().getAgentConfig(InetAddress.getByName(this.myLocalHost()));
        SnmpPeerFactoryTest.assertEquals((int)10, (int)agentConfig.getMaxVarsPerPdu());
    }

    public void testConfigureDefaultMaxVarsPerPdu() throws UnknownHostException {
        SnmpAgentConfig agentConfig = SnmpPeerFactory.getInstance().getAgentConfig(InetAddress.getByName("10.0.0.150"));
        SnmpPeerFactoryTest.assertEquals((int)55, (int)agentConfig.getMaxVarsPerPdu());
    }

    public void testCountChar() {
        SnmpPeerFactoryTest.assertEquals((int)2, (int)SnmpPeerFactory.countChar((char)'-', (String)"test-this-please"));
        SnmpPeerFactoryTest.assertEquals((int)3, (int)SnmpPeerFactory.countChar((char)'-', (String)"test-this-please-"));
        SnmpPeerFactoryTest.assertEquals((int)4, (int)SnmpPeerFactory.countChar((char)'-', (String)"-test-this-please-"));
    }

    public void testMatchRange() {
        SnmpPeerFactoryTest.assertTrue((boolean)SnmpPeerFactory.matchRange((String)"192", (String)"191-193"));
        SnmpPeerFactoryTest.assertTrue((boolean)SnmpPeerFactory.matchRange((String)"192", (String)"192"));
        SnmpPeerFactoryTest.assertTrue((boolean)SnmpPeerFactory.matchRange((String)"192", (String)"192-200"));
        SnmpPeerFactoryTest.assertTrue((boolean)SnmpPeerFactory.matchRange((String)"192", (String)"1-255"));
        SnmpPeerFactoryTest.assertTrue((boolean)SnmpPeerFactory.matchRange((String)"192", (String)"*"));
        SnmpPeerFactoryTest.assertFalse((boolean)SnmpPeerFactory.matchRange((String)"192", (String)"1-9"));
    }

    public void testMatchOctet() {
        SnmpPeerFactoryTest.assertTrue((boolean)SnmpPeerFactory.matchNumericListOrRange((String)"192", (String)"191,192,193"));
        SnmpPeerFactoryTest.assertFalse((boolean)SnmpPeerFactory.matchNumericListOrRange((String)"192", (String)"190,191,194"));
        SnmpPeerFactoryTest.assertTrue((boolean)SnmpPeerFactory.matchNumericListOrRange((String)"192", (String)"10,172,190-193"));
        SnmpPeerFactoryTest.assertFalse((boolean)SnmpPeerFactory.matchNumericListOrRange((String)"192", (String)"10,172,193-199"));
        SnmpPeerFactoryTest.assertTrue((boolean)SnmpPeerFactory.matchNumericListOrRange((String)"205", (String)"200-300,400-500"));
        SnmpPeerFactoryTest.assertTrue((boolean)SnmpPeerFactory.matchNumericListOrRange((String)"405", (String)"200-300,400-500"));
        SnmpPeerFactoryTest.assertFalse((boolean)SnmpPeerFactory.matchNumericListOrRange((String)"505", (String)"200-300,400-500"));
    }

    public void testVerifyIpMatch() {
        SnmpPeerFactoryTest.assertTrue((boolean)SnmpPeerFactory.verifyIpMatch((String)"192.168.0.1", (String)"*.*.*.*"));
        SnmpPeerFactoryTest.assertTrue((boolean)SnmpPeerFactory.verifyIpMatch((String)"192.168.0.1", (String)"192.*.*.*"));
        SnmpPeerFactoryTest.assertTrue((boolean)SnmpPeerFactory.verifyIpMatch((String)"192.168.0.1", (String)"*.168.*.*"));
        SnmpPeerFactoryTest.assertTrue((boolean)SnmpPeerFactory.verifyIpMatch((String)"192.168.0.1", (String)"*.*.0.*"));
        SnmpPeerFactoryTest.assertTrue((boolean)SnmpPeerFactory.verifyIpMatch((String)"192.168.0.1", (String)"*.*.*.1"));
        SnmpPeerFactoryTest.assertTrue((boolean)SnmpPeerFactory.verifyIpMatch((String)"192.168.0.1", (String)"*.*.*.0-7"));
        SnmpPeerFactoryTest.assertTrue((boolean)SnmpPeerFactory.verifyIpMatch((String)"192.168.0.1", (String)"192.168.0.0-7"));
        SnmpPeerFactoryTest.assertTrue((boolean)SnmpPeerFactory.verifyIpMatch((String)"192.168.0.1", (String)"192.166,167,168.*.0,1,5-10"));
        SnmpPeerFactoryTest.assertFalse((boolean)SnmpPeerFactory.verifyIpMatch((String)"192.168.0.1", (String)"10.0.0.1"));
        SnmpPeerFactoryTest.assertFalse((boolean)SnmpPeerFactory.verifyIpMatch((String)"192.168.0.1", (String)"*.168.*.2"));
        SnmpPeerFactoryTest.assertFalse((boolean)SnmpPeerFactory.verifyIpMatch((String)"192.168.0.1", (String)"10.168.0.1"));
        SnmpPeerFactoryTest.assertTrue((boolean)SnmpPeerFactory.verifyIpMatch((String)"10.1.1.1", (String)"10.1.1.1"));
    }

    public void testGetMaxRepetitions() throws UnknownHostException {
        SnmpAgentConfig agentConfig = SnmpPeerFactory.getInstance().getAgentConfig(InetAddress.getByName("77.5.5.255"));
        SnmpPeerFactoryTest.assertEquals((String)"ipmatch", (String)agentConfig.getReadCommunity());
        SnmpPeerFactoryTest.assertEquals((int)7, (int)agentConfig.getMaxRepetitions());
        agentConfig = SnmpPeerFactory.getInstance().getAgentConfig(InetAddress.getByName("10.0.0.1"));
        SnmpPeerFactoryTest.assertEquals((String)"specificv1", (String)agentConfig.getReadCommunity());
        SnmpPeerFactoryTest.assertEquals((int)2, (int)agentConfig.getMaxRepetitions());
    }

    public void testGetTargetFromPatterns() throws UnknownHostException {
        SnmpAgentConfig agentConfig = SnmpPeerFactory.getInstance().getAgentConfig(InetAddress.getByName("77.5.5.255"));
        SnmpPeerFactoryTest.assertEquals((String)"ipmatch", (String)agentConfig.getReadCommunity());
        SnmpPeerFactoryTest.assertFalse((10 == agentConfig.getMaxVarsPerPdu() ? 1 : 0) != 0);
        SnmpPeerFactoryTest.assertEquals((int)128, (int)agentConfig.getMaxVarsPerPdu());
        agentConfig = SnmpPeerFactory.getInstance().getAgentConfig(InetAddress.getByName("77.15.80.255"));
        SnmpPeerFactoryTest.assertEquals((String)"ipmatch", (String)agentConfig.getReadCommunity());
        SnmpPeerFactoryTest.assertEquals((int)7, (int)agentConfig.getMaxRepetitions());
        agentConfig = SnmpPeerFactory.getInstance().getAgentConfig(InetAddress.getByName("77.4.5.255"));
        SnmpPeerFactoryTest.assertEquals((String)"public", (String)agentConfig.getReadCommunity());
        agentConfig = SnmpPeerFactory.getInstance().getAgentConfig(InetAddress.getByName("77.6.0.255"));
        SnmpPeerFactoryTest.assertEquals((String)"public", (String)agentConfig.getReadCommunity());
    }

    public void testGetSnmpAgentConfig() throws UnknownHostException {
        SnmpAgentConfig agentConfig = SnmpPeerFactory.getInstance().getAgentConfig(InetAddress.getByName(this.myLocalHost()));
        SnmpPeerFactoryTest.assertEquals((int)2, (int)agentConfig.getVersion());
    }

    public void testGetConfig() throws UnknownHostException {
        SnmpPeerFactoryTest.assertNotNull((Object)SnmpPeerFactory.getInstance().getAgentConfig(InetAddress.getLocalHost()));
    }

    public void testGetv2cInRange() throws UnknownHostException {
        SnmpAgentConfig agentConfig = SnmpPeerFactory.getInstance().getAgentConfig(InetAddress.getByName("10.7.23.100"));
        SnmpPeerFactoryTest.assertNotNull((Object)agentConfig);
        SnmpPeerFactoryTest.assertEquals((int)2, (int)agentConfig.getVersion());
        SnmpPeerFactoryTest.assertEquals((String)"rangev2c", (String)agentConfig.getReadCommunity());
    }

    public void testGetv3ConfigInRange() throws UnknownHostException {
        SnmpAgentConfig agentConfig = SnmpPeerFactory.getInstance().getAgentConfig(InetAddress.getByName("1.1.1.50"));
        SnmpPeerFactoryTest.assertNotNull((Object)agentConfig);
        SnmpPeerFactoryTest.assertEquals((int)3, (int)agentConfig.getVersion());
        SnmpPeerFactoryTest.assertEquals((String)"opennmsRangeUser", (String)agentConfig.getSecurityName());
    }

    public void testGetV1Config() throws UnknownHostException {
        SnmpAgentConfig agentConfig = SnmpPeerFactory.getInstance().getAgentConfig(InetAddress.getByName("10.0.0.1"));
        SnmpPeerFactoryTest.assertNotNull((Object)agentConfig);
        SnmpPeerFactoryTest.assertTrue((agentConfig.getVersion() == 1 ? 1 : 0) != 0);
        SnmpPeerFactoryTest.assertEquals((String)"specificv1", (String)agentConfig.getReadCommunity());
    }

    public void testGetV2cConfig() throws UnknownHostException {
        SnmpAgentConfig agentConfig = SnmpPeerFactory.getInstance().getAgentConfig(InetAddress.getByName("192.168.0.50"));
        SnmpPeerFactoryTest.assertNotNull((Object)agentConfig);
        SnmpPeerFactoryTest.assertEquals((int)agentConfig.getVersion(), (int)2);
        SnmpPeerFactoryTest.assertEquals((String)"specificv2c", (String)agentConfig.getReadCommunity());
    }
}

