/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.config;

import java.io.File;
import java.util.List;
import junit.framework.TestCase;
import org.apache.commons.io.FileUtils;
import org.opennms.netmgt.config.DefaultEventConfDao;
import org.opennms.netmgt.xml.eventconf.Event;
import org.opennms.netmgt.xml.eventconf.Logmsg;
import org.opennms.test.FileAnticipator;
import org.springframework.core.io.FileSystemResource;
import org.springframework.core.io.Resource;

public class EventconfFactorySaveTest
extends TestCase {
    private static final String knownUEI1 = "uei.opennms.org/internal/capsd/snmpConflictsWithDb";
    private static final String knownSubfileUEI1 = "uei.opennms.org/IETF/Bridge/traps/newRoot";
    private static final String newUEI = "uei.opennms.org/custom/addedUEI";
    private static final String newEventLabel = "A New Event which is added to the eventconf";
    private static final String newDescr = "A slightly longer descriptive bit of text";
    private static final String newDest = "logndisplay";
    private static final String newContent = "Test message";
    private static final String newSeverity = "Warning";
    private FileAnticipator m_fa;
    private DefaultEventConfDao m_eventConfDao;

    protected void setUp() throws Exception {
        super.setUp();
        this.m_fa = new FileAnticipator();
        File origHome = new File("src/test/resources");
        File origEtc = new File(origHome, "etc");
        File origEvents = new File(origEtc, "events");
        File tempHome = this.m_fa.getTempDir();
        File tempEtc = this.m_fa.expecting(tempHome, "etc");
        File tempEvents = this.m_fa.expecting(tempEtc, "events");
        File eventConf = this.createTempCopy(this.m_fa, origEtc, tempEtc, "eventconf.xml");
        this.createTempCopy(this.m_fa, origEvents, tempEvents, "Standard.events.xml");
        this.createTempCopy(this.m_fa, origEvents, tempEvents, "Syslog.test.events.xml");
        this.m_eventConfDao = new DefaultEventConfDao();
        this.m_eventConfDao.setConfigResource((Resource)new FileSystemResource(eventConf));
        this.m_eventConfDao.afterPropertiesSet();
    }

    protected void tearDown() throws Exception {
        this.m_fa.deleteExpected();
        this.m_fa.tearDown();
        super.tearDown();
    }

    private File createTempCopy(FileAnticipator fa, File sourceDir, File destDir, String file) throws Exception {
        FileUtils.copyFile((File)new File(sourceDir, file), (File)new File(destDir, file));
        return fa.expecting(destDir, file);
    }

    public void testSave() throws Exception {
        String newUEI1 = "uei.opennms.org/custom/newTestUEI1";
        String newUEI2 = "uei.opennms.org/custom/newTestUEI2";
        this.m_eventConfDao.reload();
        List events = this.m_eventConfDao.getEvents(knownUEI1);
        Event event = (Event)events.get(0);
        event.setUei(newUEI1);
        this.m_eventConfDao.saveCurrent();
        this.m_eventConfDao.reload();
        events = this.m_eventConfDao.getEvents(knownUEI1);
        EventconfFactorySaveTest.assertNull((String)"Shouldn't be any events by that uei", (Object)events);
        events = this.m_eventConfDao.getEvents(newUEI1);
        EventconfFactorySaveTest.assertNotNull((String)"Should be at least one event", (Object)events);
        EventconfFactorySaveTest.assertEquals((String)"Should be only one event", (int)1, (int)events.size());
        event = (Event)events.get(0);
        EventconfFactorySaveTest.assertEquals((String)"Should be the new UEI", (String)newUEI1, (String)event.getUei());
        events = this.m_eventConfDao.getEvents(knownSubfileUEI1);
        event = (Event)events.get(0);
        event.setUei(newUEI2);
        this.m_eventConfDao.saveCurrent();
        this.m_eventConfDao.reload();
        events = this.m_eventConfDao.getEvents(knownSubfileUEI1);
        EventconfFactorySaveTest.assertNull((String)"Shouldn't be any events by that uei", (Object)events);
        events = this.m_eventConfDao.getEvents(newUEI2);
        EventconfFactorySaveTest.assertNotNull((String)"Should be at least one event", (Object)events);
        EventconfFactorySaveTest.assertEquals((String)"Should be only one event", (int)1, (int)events.size());
        event = (Event)events.get(0);
        EventconfFactorySaveTest.assertEquals((String)"Should be the new UEI", (String)newUEI2, (String)event.getUei());
    }

    private Event getAddableEvent() {
        Event event = new Event();
        event.setUei(newUEI);
        event.setEventLabel(newEventLabel);
        event.setDescr(newDescr);
        Logmsg logmsg = new Logmsg();
        logmsg.setDest(newDest);
        logmsg.setContent(newContent);
        event.setLogmsg(logmsg);
        event.setSeverity(newSeverity);
        return event;
    }

    private void checkAddableEvent(Event event) {
        EventconfFactorySaveTest.assertEquals((String)"Should be the new UEI", (String)newUEI, (String)event.getUei());
        EventconfFactorySaveTest.assertEquals((String)newEventLabel, (String)event.getEventLabel());
        EventconfFactorySaveTest.assertEquals((String)newDescr, (String)event.getDescr());
        EventconfFactorySaveTest.assertEquals((String)newDest, (String)event.getLogmsg().getDest());
        EventconfFactorySaveTest.assertEquals((String)newContent, (String)event.getLogmsg().getContent());
        EventconfFactorySaveTest.assertEquals((String)newSeverity, (String)event.getSeverity());
    }

    public void testAddEvent() {
        Event event = this.getAddableEvent();
        this.m_eventConfDao.addEvent(event);
        List events = this.m_eventConfDao.getEvents(newUEI);
        EventconfFactorySaveTest.assertNotNull((String)"Should be at least one event", (Object)events);
        EventconfFactorySaveTest.assertEquals((String)"Should be only one event", (int)1, (int)events.size());
        Event fetchedEvent = (Event)events.get(0);
        this.checkAddableEvent(fetchedEvent);
        this.m_eventConfDao.saveCurrent();
        this.m_eventConfDao.reload();
        events = this.m_eventConfDao.getEvents(newUEI);
        EventconfFactorySaveTest.assertNotNull((String)"Should be at least one event", (Object)events);
        EventconfFactorySaveTest.assertEquals((String)"Should be only one event", (int)1, (int)events.size());
        fetchedEvent = (Event)events.get(0);
        this.checkAddableEvent(fetchedEvent);
    }

    public void testAddEventToProgrammaticStore() {
        Event event = this.getAddableEvent();
        this.m_eventConfDao.addEventToProgrammaticStore(event);
        List events = this.m_eventConfDao.getEvents(newUEI);
        EventconfFactorySaveTest.assertNotNull((String)"Should be at least one event", (Object)events);
        EventconfFactorySaveTest.assertEquals((String)"Should be only one event", (int)1, (int)events.size());
        Event fetchedEvent = (Event)events.get(0);
        this.checkAddableEvent(fetchedEvent);
        this.m_eventConfDao.saveCurrent();
        this.m_eventConfDao.reload();
        this.m_fa.expecting(new File(this.m_fa.getTempDir().getAbsolutePath() + File.separator + "etc" + File.separator + "events"), "programmatic.events.xml");
        events = this.m_eventConfDao.getEvents(newUEI);
        EventconfFactorySaveTest.assertNotNull((String)"Should be at least one event", (Object)events);
        EventconfFactorySaveTest.assertEquals((String)"Should be only one event", (int)1, (int)events.size());
        fetchedEvent = (Event)events.get(0);
        this.checkAddableEvent(fetchedEvent);
    }

    public void testRemoveEventToProgrammaticStore() {
        Event event = this.getAddableEvent();
        this.m_eventConfDao.addEventToProgrammaticStore(event);
        List events = this.m_eventConfDao.getEvents(newUEI);
        EventconfFactorySaveTest.assertNotNull((String)"Should be at least one event", (Object)events);
        EventconfFactorySaveTest.assertEquals((String)"Should be only one event", (int)1, (int)events.size());
        Event fetchedEvent = (Event)events.get(0);
        this.checkAddableEvent(fetchedEvent);
        EventconfFactorySaveTest.assertTrue((String)"remove should have returned true", (boolean)this.m_eventConfDao.removeEventFromProgrammaticStore(event));
        events = this.m_eventConfDao.getEvents(newUEI);
        EventconfFactorySaveTest.assertNull((Object)events);
        this.m_eventConfDao.saveCurrent();
        this.m_eventConfDao.reload();
        EventconfFactorySaveTest.assertFalse((String)"remove should have returned false", (boolean)this.m_eventConfDao.removeEventFromProgrammaticStore(event));
        events = this.m_eventConfDao.getEvents(newUEI);
        EventconfFactorySaveTest.assertNull((Object)events);
    }
}

