/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.collectd;

import java.io.File;
import java.io.Reader;
import java.io.StringReader;
import java.util.Collections;
import javax.sql.DataSource;
import org.opennms.mock.snmp.MockSnmpAgent;
import org.opennms.netmgt.collectd.AbstractCollectorTest;
import org.opennms.netmgt.collectd.CollectionAgent;
import org.opennms.netmgt.collectd.CollectionSet;
import org.opennms.netmgt.collectd.CollectionSpecification;
import org.opennms.netmgt.collectd.ServiceCollector;
import org.opennms.netmgt.collectd.SnmpCollector;
import org.opennms.netmgt.config.DataSourceFactory;
import org.opennms.netmgt.config.SnmpPeerFactory;
import org.opennms.netmgt.dao.support.RrdTestUtils;
import org.opennms.netmgt.eventd.EventIpcManager;
import org.opennms.netmgt.eventd.EventIpcManagerFactory;
import org.opennms.netmgt.mock.MockDatabase;
import org.opennms.netmgt.mock.MockEventIpcManager;
import org.opennms.netmgt.mock.MockNetwork;
import org.opennms.netmgt.model.OnmsIpInterface;
import org.opennms.netmgt.model.OnmsNode;
import org.opennms.netmgt.model.OnmsSnmpInterface;
import org.opennms.netmgt.rrd.RrdDataSource;
import org.opennms.netmgt.rrd.RrdStrategy;
import org.opennms.netmgt.rrd.RrdUtils;
import org.opennms.test.mock.MockLogAppender;
import org.opennms.test.mock.MockUtil;
import org.springframework.core.io.ClassPathResource;
import org.springframework.core.io.Resource;

public class SnmpCollectorTest
extends AbstractCollectorTest {
    private SnmpCollector m_snmpCollector;
    private MockSnmpAgent m_agent;
    final String SNMP_CONFIG = "<?xml version=\"1.0\"?>\n<snmp-config port=\"1691\" retry=\"3\" timeout=\"800000\"\n               read-community=\"public\"\n               version=\"v2c\">\n</snmp-config>\n";

    protected void setUp() throws Exception {
        super.setUp();
        MockUtil.println((String)("------------ Begin Test " + this.getName() + " --------------------------"));
        MockLogAppender.setupLogging();
        MockNetwork m_network = new MockNetwork();
        m_network.setCriticalService("ICMP");
        m_network.addNode(1, "Router");
        m_network.addInterface("127.0.0.1");
        m_network.addService("ICMP");
        MockDatabase m_db = new MockDatabase();
        m_db.populate(m_network);
        DataSourceFactory.setInstance((DataSource)((Object)m_db));
        MockEventIpcManager eventIpcManager = new MockEventIpcManager();
        EventIpcManagerFactory.setIpcManager((EventIpcManager)eventIpcManager);
        RrdTestUtils.initialize();
        SnmpPeerFactory.setInstance((SnmpPeerFactory)new SnmpPeerFactory((Reader)new StringReader("<?xml version=\"1.0\"?>\n<snmp-config port=\"1691\" retry=\"3\" timeout=\"800000\"\n               read-community=\"public\"\n               version=\"v2c\">\n</snmp-config>\n")));
        this.initializeDatabaseSchemaConfig("/org/opennms/netmgt/config/test-database-schema.xml");
        this.setTransMgr();
        this.setFileAnticipator();
    }

    public void runTest() throws Throwable {
        super.runTest();
        MockLogAppender.assertNoWarningsOrGreater();
        this.m_fileAnticipator.deleteExpected();
    }

    protected void tearDown() throws Exception {
        if (this.m_agent != null) {
            this.m_agent.shutDownAndWait();
        }
        this.m_fileAnticipator.deleteExpected(true);
        this.m_fileAnticipator.tearDown();
        MockUtil.println((String)("------------ End Test " + this.getName() + " --------------------------"));
        super.tearDown();
    }

    public void testCollect() throws Exception {
        this.initializeAgent("/org/opennms/netmgt/snmp/snmpTestData1.properties");
        this.initializeDataCollectionConfig("/org/opennms/netmgt/config/datacollection-config.xml");
        this.createSnmpCollector();
        OnmsIpInterface iface = this.createInterface();
        CollectionSpecification spec = this.createCollectionSpec("SNMP", (ServiceCollector)this.m_snmpCollector, "default");
        CollectionAgent agent = this.createCollectionAgent(iface);
        File nodeDir = this.anticipatePath(this.getSnmpRrdDirectory(), "1");
        this.anticipateRrdFiles(nodeDir, "tcpActiveOpens", "tcpAttemptFails");
        this.anticipateRrdFiles(nodeDir, "tcpPassiveOpens", "tcpRetransSegs");
        this.anticipateRrdFiles(nodeDir, "tcpCurrEstab", "tcpEstabResets");
        this.anticipateRrdFiles(nodeDir, "tcpInErrors", "tcpInSegs");
        this.anticipateRrdFiles(nodeDir, "tcpOutRsts", "tcpOutSegs");
        File ifDir = this.anticipatePath(nodeDir, "fw0");
        this.anticipateRrdFiles(ifDir, "ifInDiscards", "ifInErrors", "ifInNUcastpkts", "ifInOctets", "ifInUcastpkts", "ifOutErrors", "ifOutNUcastPkts", "ifOutOctets", "ifOutUcastPkts");
        spec.initialize(agent);
        CollectionSet collectionSet = spec.collect(agent);
        SnmpCollectorTest.assertEquals((String)"collection status", (int)1, (int)collectionSet.getStatus());
        this.persistCollectionSet(spec, collectionSet);
        System.err.println("FIRST COLLECTION FINISHED");
        Thread.sleep(1000L);
        SnmpCollectorTest.assertEquals((String)"collection status", (int)1, (int)spec.collect(agent).getStatus());
        System.err.println("SECOND COLLECTION FINISHED");
        spec.release(agent);
        Thread.sleep(1000L);
    }

    public void testPersist() throws Exception {
        this.initializeAgent("/org/opennms/netmgt/snmp/snmpTestData1.properties");
        this.initializeDataCollectionConfig("/org/opennms/netmgt/config/datacollection-persistTest-config.xml");
        this.createSnmpCollector();
        OnmsIpInterface iface = this.createInterface();
        CollectionSpecification spec = this.createCollectionSpec("SNMP", (ServiceCollector)this.m_snmpCollector, "default");
        CollectionAgent agent = this.createCollectionAgent(iface);
        File nodeDir = this.anticipatePath(this.getSnmpRrdDirectory(), "1");
        this.anticipateRrdFiles(nodeDir, "tcpCurrEstab");
        File ifDir = this.anticipatePath(nodeDir, "fw0");
        this.anticipateRrdFiles(ifDir, "ifInOctets");
        File rrdFile = new File(nodeDir, this.rrd("tcpCurrEstab"));
        File ifRrdFile = new File(ifDir, this.rrd("ifInOctets"));
        int numUpdates = 2;
        int stepSizeInSecs = 1;
        int stepSizeInMillis = stepSizeInSecs * 1000;
        spec.initialize(agent);
        this.collectNTimes(spec, agent, numUpdates);
        SnmpCollectorTest.assertEquals((Object)123.0, (Object)RrdUtils.fetchLastValueInRange((String)rrdFile.getAbsolutePath(), (String)"tcpCurrEstab", (int)stepSizeInMillis, (int)stepSizeInMillis));
        SnmpCollectorTest.assertEquals((Object)1234567.0, (Object)RrdUtils.fetchLastValueInRange((String)ifRrdFile.getAbsolutePath(), (String)"ifInOctets", (int)stepSizeInMillis, (int)stepSizeInMillis));
        this.m_agent.updateIntValue(".1.3.6.1.2.1.6.9.0", 456);
        this.m_agent.updateCounter32Value(".1.3.6.1.2.1.2.2.1.10.6", 7654321);
        this.collectNTimes(spec, agent, numUpdates);
        SnmpCollectorTest.assertEquals((Object)456.0, (Object)RrdUtils.fetchLastValueInRange((String)rrdFile.getAbsolutePath(), (String)"tcpCurrEstab", (int)stepSizeInMillis, (int)stepSizeInMillis));
        SnmpCollectorTest.assertEquals((Object)7654321.0, (Object)RrdUtils.fetchLastValueInRange((String)ifRrdFile.getAbsolutePath(), (String)"ifInOctets", (int)stepSizeInMillis, (int)stepSizeInMillis));
        spec.release(agent);
        Thread.sleep(1000L);
    }

    public void testUsingFetch() throws Exception {
        int stepSize = 1;
        int numUpdates = 2;
        long start = System.currentTimeMillis();
        File snmpDir = this.getSnmpRrdDirectory();
        this.anticipateRrdFiles(snmpDir, "test");
        File rrdFile = new File(snmpDir, this.rrd("test"));
        RrdStrategy m_rrdStrategy = RrdUtils.getStrategy();
        RrdDataSource rrdDataSource = new RrdDataSource("testAttr", "GAUGE", stepSize * 2, "U", "U");
        Object def = m_rrdStrategy.createDefinition("test", snmpDir.getAbsolutePath(), "test", stepSize, Collections.singletonList(rrdDataSource), Collections.singletonList("RRA:AVERAGE:0.5:1:100"));
        m_rrdStrategy.createFile(def);
        Object rrdFileObject = m_rrdStrategy.openFile(rrdFile.getAbsolutePath());
        for (int i = 0; i < numUpdates; ++i) {
            m_rrdStrategy.updateFile(rrdFileObject, "test", start / 1000L - (long)(stepSize * (numUpdates - i)) + ":1");
        }
        m_rrdStrategy.closeFile(rrdFileObject);
        SnmpCollectorTest.assertEquals((Object)1.0, (Object)m_rrdStrategy.fetchLastValueInRange(rrdFile.getAbsolutePath(), "testAttr", stepSize * 1000, stepSize * 1000));
    }

    public void testBrocadeCollect() throws Exception {
        this.initializeAgent("/org/opennms/netmgt/snmp/brocadeTestData1.properties");
        this.initializeDataCollectionConfig("/org/opennms/netmgt/config/datacollection-brocade-config.xml");
        this.createSnmpCollector();
        OnmsIpInterface iface = this.createInterface();
        CollectionSpecification spec = this.createCollectionSpec("SNMP", (ServiceCollector)this.m_snmpCollector, "default");
        CollectionAgent agent = this.createCollectionAgent(iface);
        File brocadeDir = this.anticipatePath(this.getSnmpRrdDirectory(), "1", "brocadeFCPortIndex");
        for (int i = 1; i <= 8; ++i) {
            File brocadeIndexDir = this.anticipatePath(brocadeDir, Integer.toString(i));
            this.anticipateFiles(brocadeIndexDir, "strings.properties");
            this.anticipateRrdFiles(brocadeIndexDir, "swFCPortTxWords", "swFCPortRxWords");
        }
        spec.initialize(agent);
        CollectionSet collectionSet = spec.collect(agent);
        SnmpCollectorTest.assertEquals((String)"collection status", (int)1, (int)collectionSet.getStatus());
        this.persistCollectionSet(spec, collectionSet);
        System.err.println("FIRST COLLECTION FINISHED");
        Thread.sleep(1000L);
        SnmpCollectorTest.assertEquals((String)"collection status", (int)1, (int)spec.collect(agent).getStatus());
        System.err.println("SECOND COLLECTION FINISHED");
        spec.release(agent);
        Thread.sleep(1000L);
    }

    public void testBug2447_GenericIndexedOnlyCollect() throws Exception {
        this.initializeAgent("/org/opennms/netmgt/snmp/brocadeTestData1.properties");
        this.initializeDataCollectionConfig("/org/opennms/netmgt/config/datacollection-brocade-no-ifaces-config.xml");
        this.createSnmpCollector();
        OnmsIpInterface iface = this.createInterface();
        CollectionSpecification spec = this.createCollectionSpec("SNMP", (ServiceCollector)this.m_snmpCollector, "default");
        CollectionAgent agent = this.createCollectionAgent(iface);
        File brocadeDir = this.anticipatePath(this.getSnmpRrdDirectory(), "1", "brocadeFCPortIndex");
        for (int i = 1; i <= 8; ++i) {
            File brocadeIndexDir = this.anticipatePath(brocadeDir, Integer.toString(i));
            this.anticipateFiles(brocadeIndexDir, "strings.properties");
            this.anticipateRrdFiles(brocadeIndexDir, "swFCPortTxWords", "swFCPortRxWords");
        }
        spec.initialize(agent);
        CollectionSet collectionSet = spec.collect(agent);
        SnmpCollectorTest.assertEquals((String)"collection status", (int)1, (int)collectionSet.getStatus());
        this.persistCollectionSet(spec, collectionSet);
        System.err.println("FIRST COLLECTION FINISHED");
        Thread.sleep(1000L);
        SnmpCollectorTest.assertEquals((String)"collection status", (int)1, (int)spec.collect(agent).getStatus());
        System.err.println("SECOND COLLECTION FINISHED");
        spec.release(agent);
        Thread.sleep(1000L);
    }

    private void createSnmpCollector() {
        this.m_snmpCollector = new SnmpCollector();
        this.m_snmpCollector.initialize(null);
    }

    private OnmsIpInterface createInterface() {
        OnmsNode node = new OnmsNode();
        node.setId(new Integer(1));
        node.setSysObjectId(".1.3.6.1.4.1.1588.2.1.1.1");
        OnmsSnmpInterface snmpIface = new OnmsSnmpInterface("127.0.0.1", 1, node);
        snmpIface.setIfName("lo0");
        snmpIface.setPhysAddr("00:11:22:33:44");
        OnmsSnmpInterface snmpIfaceA = new OnmsSnmpInterface("127.0.0.1", 2, node);
        snmpIfaceA.setIfName("gif0");
        snmpIfaceA.setPhysAddr("00:11:22:33:45");
        snmpIfaceA.setIfType(Integer.valueOf(55));
        OnmsSnmpInterface snmpIfaceB = new OnmsSnmpInterface("127.0.0.1", 3, node);
        snmpIfaceB.setIfName("stf0");
        snmpIfaceB.setPhysAddr("00:11:22:33:46");
        snmpIfaceB.setIfType(Integer.valueOf(57));
        OnmsSnmpInterface snmpIface2 = new OnmsSnmpInterface("127.0.0.1", 6, node);
        snmpIface2.setIfName("fw0");
        snmpIface2.setPhysAddr("44:33:22:11:00");
        snmpIface2.setIfType(Integer.valueOf(144));
        OnmsIpInterface iface = new OnmsIpInterface("127.0.0.1", node);
        iface.setId(Integer.valueOf(27));
        iface.setIsSnmpPrimary(OnmsIpInterface.CollectionType.PRIMARY);
        iface.setSnmpInterface(snmpIface2);
        snmpIface2.addIpInterface(iface);
        return iface;
    }

    private void initializeAgent(String testData) throws InterruptedException {
        this.m_agent = MockSnmpAgent.createAgentAndRun((Resource)new ClassPathResource(testData), (String)"127.0.0.1/1691");
    }
}

