/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.collectd;

import java.io.File;
import java.io.IOException;
import java.net.InetAddress;
import java.util.HashMap;
import javax.sql.DataSource;
import org.exolab.castor.xml.MarshalException;
import org.exolab.castor.xml.ValidationException;
import org.junit.Ignore;
import org.junit.Test;
import org.opennms.netmgt.collectd.AbstractCollectorTest;
import org.opennms.netmgt.collectd.CollectionAgent;
import org.opennms.netmgt.collectd.CollectionSet;
import org.opennms.netmgt.collectd.CollectionSpecification;
import org.opennms.netmgt.collectd.HttpCollector;
import org.opennms.netmgt.collectd.ServiceCollector;
import org.opennms.netmgt.config.DataSourceFactory;
import org.opennms.netmgt.config.HttpCollectionConfigFactory;
import org.opennms.netmgt.dao.support.RrdTestUtils;
import org.opennms.netmgt.eventd.EventIpcManager;
import org.opennms.netmgt.eventd.EventIpcManagerFactory;
import org.opennms.netmgt.mock.MockDatabase;
import org.opennms.netmgt.mock.MockEventIpcManager;
import org.opennms.netmgt.mock.MockNetwork;
import org.opennms.netmgt.model.OnmsDistPoller;
import org.opennms.netmgt.model.OnmsIpInterface;
import org.opennms.netmgt.model.OnmsNode;
import org.opennms.netmgt.rrd.RrdUtils;
import org.opennms.test.mock.MockLogAppender;
import org.opennms.test.mock.MockUtil;

public class HttpCollectorTest
extends AbstractCollectorTest {
    private HttpCollectionConfigFactory m_factory;
    private String m_testHostName = "www.opennms.org";

    protected void setUp() throws Exception {
        super.setUp();
        System.setProperty("opennms.home", "/opt/opennms");
        MockUtil.println((String)("------------ Begin Test " + this.getName() + " --------------------------"));
        MockLogAppender.setupLogging();
        MockNetwork m_network = new MockNetwork();
        m_network.setCriticalService("ICMP");
        m_network.addNode(1, "testnode");
        m_network.addInterface(InetAddress.getByName(this.m_testHostName).getHostAddress());
        m_network.addService("ICMP");
        m_network.addService("HTTP");
        MockDatabase m_db = new MockDatabase();
        m_db.populate(m_network);
        DataSourceFactory.setInstance((DataSource)((Object)m_db));
        MockEventIpcManager eventIpcManager = new MockEventIpcManager();
        EventIpcManagerFactory.setIpcManager((EventIpcManager)eventIpcManager);
        RrdTestUtils.initialize();
        this.initializeDatabaseSchemaConfig("/org/opennms/netmgt/config/test-database-schema.xml");
        this.setTransMgr();
        this.setFileAnticipator();
    }

    private void initializeHttpDatacollectionConfigFactory(String pathName) throws MarshalException, ValidationException, IOException {
        this.m_factory = new HttpCollectionConfigFactory(this.getDataCollectionConfigReader(pathName));
        HttpCollectionConfigFactory.setInstance((HttpCollectionConfigFactory)this.m_factory);
        HttpCollectionConfigFactory.init();
    }

    protected void tearDown() throws Exception {
        super.tearDown();
    }

    @Test
    @Ignore
    public final void XXXtestCollect() throws Exception {
        InetAddress opennmsDotOrg = InetAddress.getByName(this.m_testHostName);
        this.initializeHttpDatacollectionConfigFactory("/org/opennms/netmgt/config/http-datacollection-config.xml");
        RrdTestUtils.initializeNullStrategy();
        HttpCollector collector = new HttpCollector();
        OnmsDistPoller distPoller = new OnmsDistPoller("localhost", "127.0.0.1");
        OnmsNode node = new OnmsNode(distPoller);
        node.setId(Integer.valueOf(1));
        OnmsIpInterface iface = new OnmsIpInterface(opennmsDotOrg.getHostAddress(), node);
        iface.setId(Integer.valueOf(2));
        node.addIpInterface(iface);
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put("collection", "default");
        collector.initialize(parameters);
        CollectionSpecification spec = this.createCollectionSpec("HTTP", (ServiceCollector)collector, "default");
        CollectionAgent agent = this.createCollectionAgent(iface);
        File nodeDir = this.anticipatePath(this.getSnmpRrdDirectory(), "1");
        this.anticipateRrdFiles(nodeDir, "documentCount");
        this.anticipateRrdFiles(nodeDir, "documentType");
        this.anticipateRrdFiles(nodeDir, "greatAnswer");
        spec.initialize(agent);
        CollectionSet collectionSet = spec.collect(agent);
        HttpCollectorTest.assertEquals((String)"collection status", (int)1, (int)collectionSet.getStatus());
        this.persistCollectionSet(spec, collectionSet);
        spec.release(agent);
        Thread.sleep(1000L);
    }

    @Test
    @Ignore
    public final void XXXtestPersist() throws Exception {
        InetAddress opennmsDotOrg = InetAddress.getByName(this.m_testHostName);
        this.initializeHttpDatacollectionConfigFactory("/org/opennms/netmgt/config/http-datacollection-persist-test-config.xml");
        RrdTestUtils.initialize();
        HttpCollector collector = new HttpCollector();
        OnmsDistPoller distPoller = new OnmsDistPoller("localhost", "127.0.0.1");
        OnmsNode node = new OnmsNode(distPoller);
        node.setId(Integer.valueOf(1));
        OnmsIpInterface iface = new OnmsIpInterface(opennmsDotOrg.getHostAddress(), node);
        iface.setId(Integer.valueOf(2));
        node.addIpInterface(iface);
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put("collection", "default");
        collector.initialize(parameters);
        CollectionSpecification spec = this.createCollectionSpec("HTTP", (ServiceCollector)collector, "default");
        CollectionAgent agent = this.createCollectionAgent(iface);
        File nodeDir = this.anticipatePath(this.getSnmpRrdDirectory(), "1");
        this.anticipateRrdFiles(nodeDir, "documentCount", "documentType", "greatAnswer");
        File documentCountRrdFile = new File(nodeDir, this.rrd("documentCount"));
        File someNumberRrdFile = new File(nodeDir, this.rrd("someNumber"));
        File greatAnswerRrdFile = new File(nodeDir, this.rrd("greatAnswer"));
        int numUpdates = 2;
        int stepSizeInSecs = 1;
        int stepSizeInMillis = stepSizeInSecs * 1000;
        spec.initialize(agent);
        this.collectNTimes(spec, agent, numUpdates);
        HttpCollectorTest.assertEquals((Object)5.0, (Object)RrdUtils.fetchLastValueInRange((String)documentCountRrdFile.getAbsolutePath(), (String)"documentCount", (int)stepSizeInMillis, (int)stepSizeInMillis));
        HttpCollectorTest.assertEquals((Object)17.0, (Object)RrdUtils.fetchLastValueInRange((String)someNumberRrdFile.getAbsolutePath(), (String)"someNumber", (int)stepSizeInMillis, (int)stepSizeInMillis));
        HttpCollectorTest.assertEquals((Object)42.0, (Object)RrdUtils.fetchLastValueInRange((String)greatAnswerRrdFile.getAbsolutePath(), (String)"greatAnswer", (int)stepSizeInMillis, (int)stepSizeInMillis));
        spec.release(agent);
        Thread.sleep(1000L);
    }
}

