/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.collectd;

import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.util.Collections;
import java.util.HashMap;
import java.util.Properties;
import junit.framework.TestCase;
import org.easymock.EasyMock;
import org.opennms.netmgt.collectd.AttributeDefinition;
import org.opennms.netmgt.collectd.AttributeGroupType;
import org.opennms.netmgt.collectd.BasePersister;
import org.opennms.netmgt.collectd.CollectionAgent;
import org.opennms.netmgt.collectd.CollectionAttribute;
import org.opennms.netmgt.collectd.CollectionResource;
import org.opennms.netmgt.collectd.DefaultCollectionAgent;
import org.opennms.netmgt.collectd.NodeInfo;
import org.opennms.netmgt.collectd.NodeResourceType;
import org.opennms.netmgt.collectd.OnmsSnmpCollection;
import org.opennms.netmgt.collectd.ResourceType;
import org.opennms.netmgt.collectd.ServiceParameters;
import org.opennms.netmgt.collectd.SnmpAttribute;
import org.opennms.netmgt.collectd.SnmpAttributeType;
import org.opennms.netmgt.collectd.StringAttributeType;
import org.opennms.netmgt.config.DataCollectionConfig;
import org.opennms.netmgt.config.MibObject;
import org.opennms.netmgt.dao.IpInterfaceDao;
import org.opennms.netmgt.mock.MockDataCollectionConfig;
import org.opennms.netmgt.mock.MockPlatformTransactionManager;
import org.opennms.netmgt.model.OnmsIpInterface;
import org.opennms.netmgt.model.OnmsNode;
import org.opennms.netmgt.model.RrdRepository;
import org.opennms.netmgt.rrd.RrdConfig;
import org.opennms.netmgt.rrd.RrdStrategy;
import org.opennms.netmgt.rrd.RrdUtils;
import org.opennms.netmgt.rrd.jrobin.JRobinRrdStrategy;
import org.opennms.netmgt.snmp.SnmpUtils;
import org.opennms.test.FileAnticipator;
import org.opennms.test.mock.EasyMockUtils;
import org.opennms.test.mock.MockLogAppender;
import org.opennms.test.mock.MockUtil;
import org.springframework.transaction.PlatformTransactionManager;

public class BasePersisterTest
extends TestCase {
    private static boolean s_rrdInitialized = false;
    private FileAnticipator m_fileAnticipator;
    private File m_snmpDirectory;
    private BasePersister m_persister;
    private OnmsIpInterface m_intf;
    private OnmsNode m_node;
    private PlatformTransactionManager m_transMgr = new MockPlatformTransactionManager();
    private EasyMockUtils m_easyMockUtils = new EasyMockUtils();
    private IpInterfaceDao m_ifDao;

    protected void setUp() throws Exception {
        super.setUp();
        MockUtil.println((String)("------------ Begin Test " + this.getName() + " --------------------------"));
        MockLogAppender.setupLogging();
        this.m_fileAnticipator = new FileAnticipator();
        this.m_intf = new OnmsIpInterface();
        this.m_node = new OnmsNode();
        this.m_node.setId(Integer.valueOf(1));
        this.m_intf.setId(Integer.valueOf(25));
        this.m_intf.setNode(this.m_node);
        this.m_intf.setIpAddress("1.1.1.1");
        this.m_ifDao = (IpInterfaceDao)this.m_easyMockUtils.createMock(IpInterfaceDao.class);
        if (!s_rrdInitialized) {
            RrdConfig.setProperties((Properties)new Properties());
            RrdUtils.setStrategy((RrdStrategy)new JRobinRrdStrategy());
            RrdUtils.initialize();
            s_rrdInitialized = true;
        }
    }

    protected void runTest() throws Throwable {
        super.runTest();
        MockLogAppender.assertNoWarningsOrGreater();
        this.m_fileAnticipator.deleteExpected();
    }

    protected void tearDown() throws Exception {
        this.m_fileAnticipator.deleteExpected(true);
        this.m_fileAnticipator.tearDown();
        MockUtil.println((String)("------------ End Test " + this.getName() + " --------------------------"));
        super.tearDown();
    }

    public void testPersistStringAttributeWithExistingPropertiesFile() throws Exception {
        this.initPersister();
        File nodeDir = this.m_fileAnticipator.tempDir(this.getSnmpRrdDirectory(), this.m_node.getId().toString());
        this.m_fileAnticipator.tempFile(nodeDir, "strings.properties", "#just a test");
        SnmpAttribute attribute = this.buildStringAttribute();
        this.m_persister.persistStringAttribute((CollectionAttribute)attribute);
    }

    public void testPersistStringAttributeWithParentDirectory() throws Exception {
        this.initPersister();
        File nodeDir = this.m_fileAnticipator.tempDir(this.getSnmpRrdDirectory(), this.m_node.getId().toString());
        this.m_fileAnticipator.expecting(nodeDir, "strings.properties");
        SnmpAttribute attribute = this.buildStringAttribute();
        this.m_persister.persistStringAttribute((CollectionAttribute)attribute);
    }

    public void testPersistStringAttributeWithNoParentDirectory() throws Exception {
        this.initPersister();
        File nodeDir = this.m_fileAnticipator.expecting(this.getSnmpRrdDirectory(), this.m_node.getId().toString());
        this.m_fileAnticipator.expecting(nodeDir, "strings.properties");
        SnmpAttribute attribute = this.buildStringAttribute();
        this.m_persister.persistStringAttribute((CollectionAttribute)attribute);
    }

    public void testPersistStringAttributeUsingBuilder() throws Exception {
        this.initPersister();
        File nodeDir = this.m_fileAnticipator.expecting(this.getSnmpRrdDirectory(), this.m_node.getId().toString());
        this.m_fileAnticipator.expecting(nodeDir, "strings.properties");
        SnmpAttribute attribute = this.buildStringAttribute();
        this.m_persister.pushShouldPersist(attribute.getResource());
        this.m_persister.pushShouldPersist((CollectionAttribute)attribute);
        this.m_persister.createBuilder(attribute.getResource(), attribute.getName(), (AttributeDefinition)attribute.getAttributeType());
        this.m_persister.storeAttribute((CollectionAttribute)attribute);
        this.m_persister.commitBuilder();
        this.m_persister.popShouldPersist();
    }

    private SnmpAttribute buildStringAttribute() {
        EasyMock.expect((Object)this.m_ifDao.load((Serializable)this.m_intf.getId())).andReturn((Object)this.m_intf).anyTimes();
        this.m_easyMockUtils.replayAll();
        CollectionAgent agent = DefaultCollectionAgent.create((Integer)this.m_intf.getId(), (IpInterfaceDao)this.m_ifDao, (PlatformTransactionManager)this.m_transMgr);
        MockDataCollectionConfig dataCollectionConfig = new MockDataCollectionConfig();
        OnmsSnmpCollection collection = new OnmsSnmpCollection(agent, new ServiceParameters(new HashMap()), (DataCollectionConfig)dataCollectionConfig);
        NodeResourceType resourceType = new NodeResourceType(agent, collection);
        NodeInfo resource = new NodeInfo(resourceType, agent);
        MibObject mibObject = new MibObject();
        mibObject.setOid(".1.1.1.1");
        mibObject.setAlias("mibObjectAlias");
        mibObject.setType("string");
        mibObject.setInstance("0");
        mibObject.setMaxval(null);
        mibObject.setMinval(null);
        StringAttributeType attributeType = new StringAttributeType((ResourceType)resourceType, "some-collection", mibObject, new AttributeGroupType("mibGroup", "ignore"));
        return new SnmpAttribute((CollectionResource)resource, (SnmpAttributeType)attributeType, SnmpUtils.getValueFactory().getOctetString("foo".getBytes()));
    }

    private void initPersister() throws IOException {
        this.m_persister = new BasePersister();
        this.m_persister.setRepository(this.createRrdRepository());
    }

    private RrdRepository createRrdRepository() throws IOException {
        RrdRepository repository = new RrdRepository();
        repository.setRrdBaseDir(this.getSnmpRrdDirectory());
        repository.setHeartBeat(600);
        repository.setStep(300);
        repository.setRraList(Collections.singletonList("RRA:AVERAGE:0.5:1:100"));
        return repository;
    }

    private File getSnmpRrdDirectory() throws IOException {
        if (this.m_snmpDirectory == null) {
            this.m_snmpDirectory = this.m_fileAnticipator.tempDir("snmp");
        }
        return this.m_snmpDirectory;
    }
}

