/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.charts;

import java.awt.image.BufferedImage;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringReader;
import java.sql.SQLException;
import org.apache.log4j.Category;
import org.exolab.castor.xml.MarshalException;
import org.exolab.castor.xml.ValidationException;
import org.jfree.chart.JFreeChart;
import org.opennms.core.utils.ThreadCategory;
import org.opennms.netmgt.charts.ChartUtils;
import org.opennms.netmgt.config.ChartConfigFactory;
import org.opennms.netmgt.config.charts.BarChart;
import org.opennms.netmgt.mock.OpenNMSTestCase;

public class ChartUtilsTest
extends OpenNMSTestCase {
    private static final String CHART_CONFIG = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<tns:chart-configuration xmlns:tns=\"http://xmlns.opennms.org/xsd/config/charts\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xsi:schemaLocation=\"http://xmlns.opennms.org/xsd/config/charts ../src/services/org/opennms/netmgt/config/chart-configuration.xsd \">\n\n  <tns:bar-chart name=\"sample-bar-chart\" \n   variation=\"2d\" \n   domain-axis-label=\"Severity\" \n   show-legend=\"true\" \n   plot-orientation=\"vertical\" \n   draw-bar-outline=\"true\" \n   range-axis-label=\"Count\" \n   show-urls=\"false\"\n    show-tool-tips=\"false\">\n      \n    <tns:title font=\"SansSerif\" style=\"\" value=\"Alarms\" pitch=\"12\" />\n    <tns:image-size>\n      <tns:hz-size>\n        <tns:pixels>300</tns:pixels>\n      </tns:hz-size>\n      <tns:vt-size>\n        <tns:pixels>300</tns:pixels>\n      </tns:vt-size>\n    </tns:image-size>\n    <tns:sub-title position=\"top\" horizontal-alignment=\"center\">\n           <tns:title font=\"SansSerif\" style=\"\" value=\"Severity Chart\" pitch=\"10\" />\n    </tns:sub-title>\n    <tns:grid-lines visible=\"true\">\n        <tns:rgb>\n            <tns:red>\n                <tns:rgb-color>255</tns:rgb-color>\n            </tns:red>\n            <tns:green>\n                <tns:rgb-color>255</tns:rgb-color>\n            </tns:green>\n            <tns:blue>\n                <tns:rgb-color>255</tns:rgb-color>\n            </tns:blue>\n        </tns:rgb>\n    </tns:grid-lines>\n    <tns:series-def number=\"1\" series-name=\"Events\" use-labels=\"true\" >\n     <tns:jdbc-data-set db-name=\"opennms\" sql=\"select eventseverity, count(*) from events where eventseverity &gt; 4 group by eventseverity\" />\n      <tns:rgb>\n        <tns:red>\n          <tns:rgb-color>255</tns:rgb-color>\n        </tns:red>\n        <tns:green>\n          <tns:rgb-color>255</tns:rgb-color>\n        </tns:green>\n        <tns:blue>\n          <tns:rgb-color>0</tns:rgb-color>\n        </tns:blue>\n      </tns:rgb>\n    </tns:series-def>\n    <tns:series-def number=\"1\" series-name=\"Alarms\" use-labels=\"true\" >\n     <tns:jdbc-data-set db-name=\"opennms\" sql=\"select severity, count(*) from alarms where severity &gt; 4 group by severity\" />\n      <tns:rgb>\n        <tns:red>\n          <tns:rgb-color>255</tns:rgb-color>\n        </tns:red>\n        <tns:green>\n          <tns:rgb-color>0</tns:rgb-color>\n        </tns:green>\n        <tns:blue>\n          <tns:rgb-color>0</tns:rgb-color>\n        </tns:blue>\n      </tns:rgb>\n    </tns:series-def>\n  </tns:bar-chart>\n</tns:chart-configuration>\n";

    protected void setUp() throws Exception {
        super.setUp();
        System.setProperty("java.awt.headless", "true");
        this.initalizeChartFactory();
    }

    protected void tearDown() throws Exception {
        super.tearDown();
    }

    public void testGetBarChartConfig() throws MarshalException, ValidationException, FileNotFoundException, IOException {
        ChartUtilsTest.assertNotNull((Object)ChartUtils.getBarChartConfigByName((String)"sample-bar-chart"));
        ChartUtilsTest.assertTrue((ChartUtils.getBarChartConfigByName((String)"sample-bar-chart").getClass() == BarChart.class ? 1 : 0) != 0);
    }

    public void testGetBarChart() throws MarshalException, ValidationException, IOException, SQLException {
        JFreeChart barChart = ChartUtils.getBarChart((String)"sample-bar-chart");
        ChartUtilsTest.assertNotNull((Object)barChart);
        ChartUtilsTest.assertEquals((int)2, (int)barChart.getSubtitleCount());
    }

    public void testGetChartWithInvalidChartName() throws MarshalException, ValidationException, IOException, SQLException {
        JFreeChart chart = null;
        try {
            chart = ChartUtils.getBarChart((String)"opennms-rules!");
        }
        catch (IllegalArgumentException e) {
            this.log().debug((Object)"testGetChartWithInvalidChartName: Good, this test is working.");
        }
        ChartUtilsTest.assertNull((Object)chart);
    }

    public void testGetChartAsFileOutputStream() throws FileNotFoundException, IOException, SQLException, ValidationException, MarshalException {
        FileOutputStream stream = new FileOutputStream("//tmp//sample-bar-chart.png");
        ChartUtils.getBarChart((String)"sample-bar-chart", (OutputStream)stream);
        ((OutputStream)stream).close();
    }

    public void testGetChartAsBufferedImage() throws MarshalException, ValidationException, IOException, SQLException {
        BufferedImage bi = ChartUtils.getChartAsBufferedImage((String)"sample-bar-chart");
        ChartUtilsTest.assertEquals((int)300, (int)bi.getHeight());
    }

    private void initalizeChartFactory() throws MarshalException, ValidationException, IOException {
        ChartConfigFactory.setInstance((ChartConfigFactory)new ChartConfigFactory());
        StringReader rdr = new StringReader(CHART_CONFIG);
        ChartConfigFactory.parseXml((Reader)rdr);
        ((Reader)rdr).close();
    }

    private Category log() {
        return ThreadCategory.getInstance(((Object)((Object)this)).getClass());
    }
}

