/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.xmlrpcd;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import org.apache.xmlrpc.DefaultXmlRpcTransport;

public class TimeoutSecureXmlRpcTransport
extends DefaultXmlRpcTransport {
    protected int timeout = 0;

    public TimeoutSecureXmlRpcTransport(URL url, String auth, int timeout) {
        super(url, auth);
        this.timeout = timeout;
    }

    public TimeoutSecureXmlRpcTransport(URL url, int timeout) {
        super(url, null);
        this.timeout = timeout;
    }

    public InputStream sendXmlRpc(byte[] request) throws IOException {
        this.con = this.url.openConnection();
        System.err.println("Setting read timeout to 60000");
        this.con.setReadTimeout(this.timeout);
        this.con.setDoInput(true);
        this.con.setDoOutput(true);
        this.con.setUseCaches(false);
        this.con.setAllowUserInteraction(false);
        this.con.setRequestProperty("Content-Length", Integer.toString(request.length));
        this.con.setRequestProperty("Content-Type", "text/xml");
        if (this.auth != null) {
            this.con.setRequestProperty("Authorization", "Basic " + this.auth);
        }
        OutputStream out = this.con.getOutputStream();
        out.write(request);
        out.flush();
        out.close();
        return this.con.getInputStream();
    }
}

