/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.vmmgr;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.UndeclaredThrowableException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.management.MBeanServer;
import javax.management.ObjectInstance;
import javax.management.ObjectName;
import org.apache.log4j.Category;
import org.opennms.core.utils.ThreadCategory;
import org.opennms.netmgt.config.ServiceConfigFactory;
import org.opennms.netmgt.config.service.Argument;
import org.opennms.netmgt.config.service.Attribute;
import org.opennms.netmgt.config.service.Invoke;
import org.opennms.netmgt.config.service.Service;
import org.opennms.netmgt.config.service.types.InvokeAtType;
import org.opennms.netmgt.vmmgr.InvokerResult;
import org.opennms.netmgt.vmmgr.InvokerService;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Invoker {
    private MBeanServer m_server;
    private InvokeAtType m_atType;
    private boolean m_reverse = false;
    private boolean m_failFast = true;
    private List<InvokerService> m_services;

    public static ServiceConfigFactory getDefaultServiceConfigFactory() {
        try {
            ServiceConfigFactory.init();
            return ServiceConfigFactory.getInstance();
        }
        catch (Throwable t) {
            throw new UndeclaredThrowableException(t);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void instantiateClasses() {
        for (InvokerService invokerService : this.getServices()) {
            Service service = invokerService.getService();
            try {
                Object var8_10;
                Object bean;
                if (this.log().isDebugEnabled()) {
                    this.log().debug((Object)("loading class " + service.getClassName()));
                }
                Class<?> clazz = Class.forName(service.getClassName());
                if (this.log().isDebugEnabled()) {
                    this.log().debug((Object)("create new instance of " + service.getClassName()));
                }
                String log4jPrefix = ThreadCategory.getPrefix();
                try {
                    bean = clazz.newInstance();
                    var8_10 = null;
                }
                catch (Throwable throwable) {
                    var8_10 = null;
                    ThreadCategory.setPrefix((String)log4jPrefix);
                    throw throwable;
                }
                ThreadCategory.setPrefix((String)log4jPrefix);
                if (this.log().isDebugEnabled()) {
                    this.log().debug((Object)("registering mbean instance " + service.getName()));
                }
                ObjectName name = new ObjectName(service.getName());
                invokerService.setMbean(this.getServer().registerMBean(bean, name));
                Attribute[] attribs = service.getAttribute();
                if (attribs == null) continue;
                for (int j = 0; j < attribs.length; ++j) {
                    if (this.log().isDebugEnabled()) {
                        this.log().debug((Object)("setting attribute " + attribs[j].getName()));
                    }
                    this.getServer().setAttribute(name, this.getAttribute(attribs[j]));
                }
            }
            catch (Throwable t) {
                this.log().error((Object)("An error occurred loading the mbean " + service.getName() + " of type " + service.getClassName() + ": " + t), t);
                invokerService.setBadThrowable(t);
            }
        }
    }

    public void getObjectInstances() {
        for (InvokerService invokerService : this.getServices()) {
            Service service = invokerService.getService();
            try {
                if (this.log().isDebugEnabled()) {
                    this.log().debug((Object)("finding mbean instance " + service.getName()));
                }
                ObjectName name = new ObjectName(service.getName());
                invokerService.setMbean(this.getServer().getObjectInstance(name));
            }
            catch (Throwable t) {
                this.log().error((Object)("An error occurred loading the mbean " + service.getName() + " of type " + service.getClassName() + " it will be skipped"), t);
                invokerService.setBadThrowable(t);
            }
        }
    }

    public List<InvokerResult> invokeMethods() {
        List<InvokerService> invokerServicesOrdered;
        if (this.isReverse()) {
            invokerServicesOrdered = new ArrayList<InvokerService>(this.getServices());
            Collections.reverse(invokerServicesOrdered);
        } else {
            invokerServicesOrdered = this.getServices();
        }
        ArrayList<InvokerResult> resultInfo = new ArrayList<InvokerResult>(invokerServicesOrdered.size());
        int end = this.getLastPass();
        for (int pass = 0; pass <= end; ++pass) {
            if (this.log().isDebugEnabled()) {
                this.log().debug((Object)("starting pass " + pass));
            }
            for (InvokerService invokerService : invokerServicesOrdered) {
                Service service = invokerService.getService();
                String name = invokerService.getService().getName();
                ObjectInstance mbean = invokerService.getMbean();
                if (invokerService.isBadService()) {
                    resultInfo.add(new InvokerResult(service, mbean, null, invokerService.getBadThrowable()));
                    if (this.isFailFast()) {
                        return resultInfo;
                    }
                }
                for (Invoke invoke : invokerService.getService().getInvoke()) {
                    if (invoke.getPass() != pass || !this.getAtType().equals(invoke.getAt())) continue;
                    if (this.log().isDebugEnabled()) {
                        this.log().debug((Object)("pass " + pass + " on service " + name + " will invoke method \"" + invoke.getMethod() + "\""));
                    }
                    try {
                        Object result = this.invoke(invoke, mbean);
                        resultInfo.add(new InvokerResult(service, mbean, result, null));
                    }
                    catch (Throwable t) {
                        resultInfo.add(new InvokerResult(service, mbean, null, t));
                        if (!this.isFailFast()) continue;
                        return resultInfo;
                    }
                }
            }
            if (!this.log().isDebugEnabled()) continue;
            this.log().debug((Object)("completed pass " + pass));
        }
        return resultInfo;
    }

    private int getLastPass() {
        List<InvokerService> invokerServices = this.getServices();
        int end = 0;
        for (InvokerService invokerService : invokerServices) {
            Invoke[] invokes = invokerService.getService().getInvoke();
            if (invokes == null) continue;
            for (Invoke invoke : invokes) {
                if (invoke.getPass() <= end) continue;
                end = invoke.getPass();
            }
        }
        return end;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object invoke(Invoke invoke, ObjectInstance mbean) throws Throwable {
        Object object;
        Argument[] args = invoke.getArgument();
        Object[] parms = new Object[]{};
        String[] sig = new String[]{};
        if (args != null && args.length > 0) {
            parms = new Object[args.length];
            sig = new String[args.length];
            for (int k = 0; k < parms.length; ++k) {
                try {
                    parms[k] = this.getArgument(args[k]);
                }
                catch (Throwable t) {
                    this.log().error((Object)("An error occurred building argument " + k + " for operation " + invoke.getMethod() + " on MBean " + mbean.getObjectName() + ": " + t), t);
                    throw t;
                }
                sig[k] = parms[k].getClass().getName();
            }
        }
        if (this.log().isDebugEnabled()) {
            this.log().debug((Object)("Invoking " + invoke.getMethod() + " on object " + mbean.getObjectName()));
        }
        try {
            String log4jPrefix = ThreadCategory.getPrefix();
            try {
                object = this.getServer().invoke(mbean.getObjectName(), invoke.getMethod(), parms, sig);
                Object var9_11 = null;
            }
            catch (Throwable throwable) {
                Object var9_12 = null;
                ThreadCategory.setPrefix((String)log4jPrefix);
                throw throwable;
            }
            ThreadCategory.setPrefix((String)log4jPrefix);
            {
            }
        }
        catch (Throwable t) {
            this.log().error((Object)("An error occurred invoking operation " + invoke.getMethod() + " on MBean " + mbean.getObjectName() + ": " + t), t);
            throw t;
        }
        this.log().debug((Object)"Invocation successful.");
        return object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private javax.management.Attribute getAttribute(Attribute attrib) throws Exception {
        Object value;
        Class<?> attribClass = Class.forName(attrib.getValue().getType());
        Constructor<?> construct = attribClass.getConstructor(String.class);
        String log4jPrefix = ThreadCategory.getPrefix();
        try {
            value = construct.newInstance(attrib.getValue().getContent());
            Object var7_6 = null;
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            ThreadCategory.setPrefix((String)log4jPrefix);
            throw throwable;
        }
        ThreadCategory.setPrefix((String)log4jPrefix);
        return new javax.management.Attribute(attrib.getName(), value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object getArgument(Argument arg) throws ClassNotFoundException, SecurityException, NoSuchMethodException, IllegalArgumentException, InstantiationException, IllegalAccessException, InvocationTargetException {
        Object obj;
        Class<?> argClass = Class.forName(arg.getType());
        Constructor<?> construct = argClass.getConstructor(String.class);
        String log4jPrefix = ThreadCategory.getPrefix();
        try {
            obj = construct.newInstance(arg.getContent());
            Object var7_6 = null;
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            ThreadCategory.setPrefix((String)log4jPrefix);
            throw throwable;
        }
        ThreadCategory.setPrefix((String)log4jPrefix);
        return obj;
    }

    private Category log() {
        return ThreadCategory.getInstance(this.getClass());
    }

    public InvokeAtType getAtType() {
        return this.m_atType;
    }

    public void setAtType(InvokeAtType atType) {
        this.m_atType = atType;
    }

    public boolean isFailFast() {
        return this.m_failFast;
    }

    public void setFailFast(boolean failFast) {
        this.m_failFast = failFast;
    }

    public boolean isReverse() {
        return this.m_reverse;
    }

    public void setReverse(boolean reverse) {
        this.m_reverse = reverse;
    }

    public MBeanServer getServer() {
        return this.m_server;
    }

    public void setServer(MBeanServer server) {
        this.m_server = server;
    }

    public List<InvokerService> getServices() {
        return this.m_services;
    }

    public void setServices(List<InvokerService> services) {
        this.m_services = services;
    }
}

