/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.vacuumd;

import java.beans.PropertyVetoException;
import java.io.IOException;
import java.lang.reflect.UndeclaredThrowableException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.List;
import javax.sql.DataSource;
import org.exolab.castor.xml.MarshalException;
import org.exolab.castor.xml.ValidationException;
import org.opennms.core.utils.ThreadCategory;
import org.opennms.netmgt.config.DataSourceFactory;
import org.opennms.netmgt.config.VacuumdConfigFactory;
import org.opennms.netmgt.config.vacuumd.Action;
import org.opennms.netmgt.config.vacuumd.Automation;
import org.opennms.netmgt.config.vacuumd.Statement;
import org.opennms.netmgt.config.vacuumd.Trigger;
import org.opennms.netmgt.daemon.AbstractServiceDaemon;
import org.opennms.netmgt.eventd.EventIpcManager;
import org.opennms.netmgt.model.events.EventListener;
import org.opennms.netmgt.scheduler.LegacyScheduler;
import org.opennms.netmgt.scheduler.Schedule;
import org.opennms.netmgt.scheduler.Scheduler;
import org.opennms.netmgt.vacuumd.AutomationInterval;
import org.opennms.netmgt.vacuumd.AutomationProcessor;
import org.opennms.netmgt.xml.event.Event;

public class Vacuumd
extends AbstractServiceDaemon
implements Runnable,
EventListener {
    public static final String RELOAD_CONFIG_UEI = "uei.opennms.org/internal/reloadVacuumdConfig";
    private static volatile Vacuumd m_singleton;
    private volatile Thread m_thread;
    private volatile long m_startTime;
    private volatile boolean m_stopped = false;
    private volatile LegacyScheduler m_scheduler;
    private volatile EventIpcManager m_eventMgr;

    public static synchronized Vacuumd getSingleton() {
        if (m_singleton == null) {
            m_singleton = new Vacuumd();
        }
        return m_singleton;
    }

    public Vacuumd() {
        super("OpenNMS.Vacuumd");
    }

    protected void onInit() {
        try {
            this.log().info((Object)"Loading the configuration file.");
            VacuumdConfigFactory.init();
            this.getEventManager().addEventListener(this, RELOAD_CONFIG_UEI);
            this.initializeDataSources();
        }
        catch (Exception ex) {
            this.log().error((Object)"Failed to load outage configuration", (Throwable)ex);
            throw new UndeclaredThrowableException(ex);
        }
        this.log().info((Object)"Vaccumd initialization complete");
        this.createScheduler();
        this.scheduleAutomations();
    }

    private void initializeDataSources() throws MarshalException, ValidationException, IOException, ClassNotFoundException, PropertyVetoException, SQLException {
        for (Trigger trigger : this.getVacuumdConfig().getTriggers()) {
            DataSourceFactory.init((String)trigger.getDataSource());
        }
        for (Action action : this.getVacuumdConfig().getActions()) {
            DataSourceFactory.init((String)action.getDataSource());
        }
    }

    protected void onStart() {
        this.m_startTime = System.currentTimeMillis();
        this.m_thread = new Thread((Runnable)this, "Vacuumd-Thread");
        this.m_thread.start();
        this.m_scheduler.start();
    }

    protected void onStop() {
        this.m_stopped = true;
        this.m_scheduler.stop();
    }

    protected void onPause() {
        this.m_scheduler.pause();
        this.m_stopped = true;
    }

    protected void onResume() {
        this.m_thread = new Thread((Runnable)this, "Vacuumd-Thread");
        this.m_thread.start();
        this.m_scheduler.resume();
    }

    public void run() {
        ThreadCategory.setPrefix((String)this.getName());
        this.log().info((Object)"Vacuumd scheduling started");
        long now = System.currentTimeMillis();
        long period = this.getVacuumdConfig().getPeriod();
        this.log().info((Object)("Vacuumd sleeping until time to execute statements period = " + period));
        long waitTime = 500L;
        while (!this.m_stopped) {
            try {
                now = this.waitPeriod(now, period, waitTime);
                this.log().info((Object)"Vacuumd beginning to execute statements");
                this.executeStatements();
                this.m_startTime = System.currentTimeMillis();
            }
            catch (Exception e) {
                this.log().error((Object)"Unexpected exception: ", (Throwable)e);
            }
        }
    }

    protected void executeStatements() {
        if (!this.m_stopped) {
            List<Statement> statements = this.getVacuumdConfig().getStatements();
            for (Statement statement : statements) {
                this.runUpdate(statement.getContent(), statement.getTransactional());
            }
        }
    }

    private long waitPeriod(long now, long period, long waitTime) {
        int count = 0;
        while (!this.m_stopped && now - this.m_startTime < period) {
            try {
                if (count % 100 == 0) {
                    this.log().debug((Object)("Vacuumd: " + (period - now + this.m_startTime) + "ms remaining to execution."));
                }
                Thread.sleep(waitTime);
                now = System.currentTimeMillis();
                ++count;
            }
            catch (InterruptedException e) {}
        }
        return now;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void runUpdate(String sql, boolean transactional) {
        boolean commitRequired;
        Connection dbConn;
        block26: {
            this.log().info((Object)("Vacuumd executing statement: " + sql));
            dbConn = null;
            commitRequired = false;
            boolean autoCommitFlag = !transactional;
            dbConn = this.getDataSourceFactory().getConnection();
            dbConn.setAutoCommit(autoCommitFlag);
            PreparedStatement stmt = dbConn.prepareStatement(sql);
            int count = stmt.executeUpdate();
            stmt.close();
            if (this.log().isDebugEnabled()) {
                this.log().debug((Object)("Vacuumd: Ran update " + sql + ": this affected " + count + " rows"));
            }
            commitRequired = transactional;
            Object var9_9 = null;
            if (dbConn == null) return;
            if (commitRequired) {
                dbConn.commit();
                break block26;
            }
            if (!transactional) break block26;
            dbConn.rollback();
        }
        Object var12_12 = null;
        if (dbConn == null) return;
        try {
            dbConn.close();
            return;
        }
        catch (Exception e) {}
        return;
        {
            catch (SQLException ex2) {
                Object var12_13 = null;
                if (dbConn == null) return;
                try {
                    dbConn.close();
                    return;
                }
                catch (Exception e) {}
                return;
            }
        }
        catch (Throwable throwable) {
            Object var12_14 = null;
            if (dbConn == null) throw throwable;
            try {
                dbConn.close();
                throw throwable;
            }
            catch (Exception e) {
                // empty catch block
            }
            throw throwable;
        }
        {
            catch (SQLException ex) {
                block27: {
                    this.log().error((Object)("Vacuumd:  Database error execuating statement  " + sql), (Throwable)ex);
                    Object var9_10 = null;
                    if (dbConn == null) return;
                    if (commitRequired) {
                        dbConn.commit();
                        break block27;
                    }
                    if (!transactional) break block27;
                    dbConn.rollback();
                }
                Object var12_15 = null;
                if (dbConn == null) return;
                try {
                    dbConn.close();
                    return;
                }
                catch (Exception e) {}
                return;
                {
                    catch (SQLException ex2) {
                        Object var12_16 = null;
                        if (dbConn == null) return;
                        try {
                            dbConn.close();
                            return;
                        }
                        catch (Exception e) {}
                        return;
                    }
                }
                catch (Throwable throwable) {
                    Object var12_17 = null;
                    if (dbConn == null) throw throwable;
                    try {
                        dbConn.close();
                        throw throwable;
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                    throw throwable;
                }
            }
        }
        catch (Throwable throwable) {
            block28: {
                Object var9_11 = null;
                if (dbConn == null) throw throwable;
                if (commitRequired) {
                    dbConn.commit();
                    break block28;
                }
                if (!transactional) break block28;
                dbConn.rollback();
            }
            Object var12_18 = null;
            if (dbConn == null) throw throwable;
            try {
                dbConn.close();
                throw throwable;
            }
            catch (Exception e) {}
            throw throwable;
            {
                catch (SQLException ex2) {
                    Object var12_19 = null;
                    if (dbConn == null) throw throwable;
                    try {
                        dbConn.close();
                        throw throwable;
                    }
                    catch (Exception e) {}
                    throw throwable;
                }
            }
            catch (Throwable throwable2) {
                Object var12_20 = null;
                if (dbConn == null) throw throwable2;
                try {
                    dbConn.close();
                    throw throwable2;
                }
                catch (Exception e) {
                    // empty catch block
                }
                throw throwable2;
            }
        }
    }

    private void createScheduler() {
        try {
            this.log().debug((Object)"init: Creating Vacuumd scheduler");
            this.m_scheduler = new LegacyScheduler("Vacuumd", 2);
        }
        catch (RuntimeException e) {
            this.log().fatal((Object)("init: Failed to create Vacuumd scheduler: " + e), (Throwable)e);
            throw e;
        }
    }

    public Scheduler getScheduler() {
        return this.m_scheduler;
    }

    private void scheduleAutomations() {
        for (Automation auto : this.getVacuumdConfig().getAutomations()) {
            this.scheduleAutomation(auto);
        }
    }

    private void scheduleAutomation(Automation auto) {
        if (auto.getActive()) {
            AutomationProcessor ap = new AutomationProcessor(auto);
            Schedule s = new Schedule(ap, new AutomationInterval(auto.getInterval()), this.m_scheduler);
            ap.setSchedule(s);
            s.schedule();
        }
    }

    public EventIpcManager getEventManager() {
        return this.m_eventMgr;
    }

    public void setEventManager(EventIpcManager eventMgr) {
        this.m_eventMgr = eventMgr;
    }

    public void onEvent(Event event) {
        if (RELOAD_CONFIG_UEI.equals(event.getUei())) {
            try {
                this.log().info((Object)"onEvent: reloading configuration.");
                this.log().debug((Object)("onEvent: Number of elements in schedule:" + this.m_scheduler.getScheduled()));
                this.log().debug((Object)"onEvent: calling stop on scheduler.");
                this.stop();
                while (this.m_scheduler.getRunner().getStatus() != 4 || this.m_scheduler.getStatus() != 4) {
                    this.log().debug((Object)("onEvent: waiting for scheduler to stop. Current status of scheduler: " + this.m_scheduler.getStatus() + "; Current status of runner: " + this.m_scheduler.getRunner().getStatus()));
                    Thread.sleep(500L);
                }
                this.log().debug((Object)("onEvent: Current status of scheduler: " + this.m_scheduler.getStatus() + "; Current status of runner: " + this.m_scheduler.getRunner().getStatus()));
                this.log().debug((Object)("onEvent: Number of elements in schedule:" + this.m_scheduler.getScheduled()));
                this.log().debug((Object)"onEvent: reloading vacuumd configuration.");
                VacuumdConfigFactory.reload();
                this.log().debug((Object)"onEvent: creating new schedule and rescheduling automations.");
                this.init();
                this.log().debug((Object)"onEvent: restarting vacuumd and scheduler.");
                this.start();
                this.log().debug((Object)("onEvent: Number of elements in schedule:" + this.m_scheduler.getScheduled()));
            }
            catch (MarshalException e) {
                this.log().error((Object)("onEvent: problem marshaling vacuumd configuration: " + (Object)((Object)e)), (Throwable)e);
            }
            catch (ValidationException e) {
                this.log().error((Object)("onEvent: problem validating vacuumd configuration: " + (Object)((Object)e)), (Throwable)e);
            }
            catch (IOException e) {
                this.log().error((Object)("onEvent: IO problem reading vacuumd configuration: " + e), (Throwable)e);
            }
            catch (InterruptedException e) {
                this.log().error((Object)("onEvent: Problem interrupting current Vacuumd Thread: " + e), (Throwable)e);
            }
            this.log().info((Object)"onEvent: completed configuration reload.");
        }
    }

    private VacuumdConfigFactory getVacuumdConfig() {
        return VacuumdConfigFactory.getInstance();
    }

    private DataSource getDataSourceFactory() {
        return DataSourceFactory.getInstance();
    }
}

