/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.utils;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.log4j.Category;
import org.opennms.core.resource.Vault;
import org.opennms.core.utils.ThreadCategory;
import org.opennms.protocols.ip.IPv4Address;

public class NodeLabel {
    static final String SQL_DB_UPDATE_NODE_LABEL = "UPDATE node SET nodelabel=?,nodelabelsource=? WHERE nodeid=?";
    static final String SQL_DB_RETRIEVE_NETBIOS_NAME = "SELECT nodenetbiosname FROM node WHERE nodeid=?";
    static final String SQL_DB_RETRIEVE_MANAGED_INTERFACES = "SELECT ipaddr,iphostname FROM ipinterface WHERE nodeid=? AND ismanaged='M'";
    static final String SQL_DB_RETRIEVE_NON_MANAGED_INTERFACES = "SELECT ipaddr,iphostname FROM ipinterface WHERE nodeid=? AND ismanaged!='M'";
    static final String SQL_DB_RETRIEVE_SYSNAME = "SELECT nodesysname FROM node WHERE nodeid=?";
    static final String SQL_DB_RETRIEVE_NODELABEL = "SELECT nodelabel,nodelabelsource FROM node WHERE nodeid=?";
    public static final char SOURCE_USERDEFINED = 'U';
    public static final char SOURCE_NETBIOS = 'N';
    public static final char SOURCE_HOSTNAME = 'H';
    public static final char SOURCE_SYSNAME = 'S';
    public static final char SOURCE_ADDRESS = 'A';
    public static final char SOURCE_UNKNOWN = 'X';
    public static final int MAX_NODE_LABEL_LENGTH = 256;
    private static final String SELECT_METHOD_MIN = "min";
    private static final String SELECT_METHOD_MAX = "max";
    private static final String DEFAULT_SELECT_METHOD = "min";
    private String m_nodeLabel;
    private char m_nodeLabelSource;

    public NodeLabel() {
        this.m_nodeLabel = null;
        this.m_nodeLabelSource = (char)88;
    }

    public NodeLabel(String nodeLabel, char nodeLabelSource) {
        this.m_nodeLabel = nodeLabel;
        this.m_nodeLabelSource = nodeLabelSource;
    }

    public String getLabel() {
        return this.m_nodeLabel;
    }

    public char getSource() {
        return this.m_nodeLabelSource;
    }

    public void setLabel(String nodeLabel) {
        this.m_nodeLabel = nodeLabel;
    }

    public void setSource(char nodeLabelSource) {
        this.m_nodeLabelSource = nodeLabelSource;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static NodeLabel retrieveLabel(int nodeID) throws SQLException {
        NodeLabel label = null;
        Connection dbConnection = Vault.getDbConnection();
        try {
            label = NodeLabel.retrieveLabel(nodeID, dbConnection);
            Object var4_3 = null;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            Vault.releaseDbConnection((Connection)dbConnection);
            throw throwable;
        }
        Vault.releaseDbConnection((Connection)dbConnection);
        return label;
    }

    public static NodeLabel retrieveLabel(int nodeID, Connection dbConnection) throws SQLException {
        String nodeLabel = null;
        String nodeLabelSource = null;
        PreparedStatement stmt = dbConnection.prepareStatement(SQL_DB_RETRIEVE_NODELABEL);
        Category log = ThreadCategory.getInstance(NodeLabel.class);
        if (log.isDebugEnabled()) {
            log.debug((Object)("NodeLabel.retrieveLabel: sql: SELECT nodelabel,nodelabelsource FROM node WHERE nodeid=? node id: " + nodeID));
        }
        stmt.setInt(1, nodeID);
        try {
            ResultSet rs = stmt.executeQuery();
            if (rs.next()) {
                nodeLabel = rs.getString(1);
                nodeLabelSource = rs.getString(2);
            }
            rs.close();
            Object var8_8 = null;
        }
        catch (Throwable throwable) {
            Object var8_9 = null;
            stmt.close();
            throw throwable;
        }
        stmt.close();
        if (nodeLabelSource != null) {
            char[] temp = nodeLabelSource.toCharArray();
            return new NodeLabel(nodeLabel, temp[0]);
        }
        return new NodeLabel(nodeLabel, 'X');
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void assignLabel(int nodeID, NodeLabel nodeLabel) throws SQLException {
        Connection dbConnection = Vault.getDbConnection();
        try {
            NodeLabel.assignLabel(nodeID, nodeLabel, dbConnection);
            Object var4_3 = null;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            Vault.releaseDbConnection((Connection)dbConnection);
            throw throwable;
        }
        Vault.releaseDbConnection((Connection)dbConnection);
    }

    public static void assignLabel(int nodeID, NodeLabel nodeLabel, Connection dbConnection) throws SQLException {
        Category log = ThreadCategory.getInstance(NodeLabel.class);
        if (nodeLabel == null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"NodeLabel.assignLabel: nodeLabel obj is null, computing label...");
            }
            nodeLabel = NodeLabel.computeLabel(nodeID, dbConnection);
        }
        PreparedStatement stmt = dbConnection.prepareStatement(SQL_DB_UPDATE_NODE_LABEL);
        int column = 1;
        if (log.isDebugEnabled()) {
            log.debug((Object)("NodeLabel.assignLabel: Node label: " + nodeLabel.getLabel() + " source: " + nodeLabel.getSource()));
        }
        if (nodeLabel.getLabel() != null) {
            String label = nodeLabel.getLabel();
            if (label.length() > 256) {
                label = label.substring(0, 256);
            }
            stmt.setString(column++, label);
        } else {
            stmt.setNull(column++, 12);
        }
        stmt.setString(column++, String.valueOf(nodeLabel.getSource()));
        stmt.setInt(column++, nodeID);
        try {
            stmt.executeUpdate();
            Object var8_8 = null;
        }
        catch (Throwable throwable) {
            Object var8_9 = null;
            stmt.close();
            throw throwable;
        }
        stmt.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static NodeLabel computeLabel(int nodeID) throws SQLException {
        NodeLabel nodeLabel;
        Connection dbConnection = Vault.getDbConnection();
        try {
            nodeLabel = NodeLabel.computeLabel(nodeID, dbConnection);
            Object var4_3 = null;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            Vault.releaseDbConnection((Connection)dbConnection);
            throw throwable;
        }
        Vault.releaseDbConnection((Connection)dbConnection);
        return nodeLabel;
    }

    public static NodeLabel computeLabel(int nodeID, Connection dbConnection) throws SQLException {
        NodeLabel nodeLabel;
        int index;
        String primaryHostName;
        Category log = ThreadCategory.getInstance(NodeLabel.class);
        String netbiosName = null;
        PreparedStatement stmt = dbConnection.prepareStatement(SQL_DB_RETRIEVE_NETBIOS_NAME);
        if (log.isDebugEnabled()) {
            log.debug((Object)("NodeLabel.computeLabel: sql: SELECT nodenetbiosname FROM node WHERE nodeid=? node id: " + nodeID));
        }
        stmt.setInt(1, nodeID);
        try {
            ResultSet rs = stmt.executeQuery();
            while (rs.next()) {
                netbiosName = rs.getString(1);
            }
            rs.close();
            Object var7_7 = null;
        }
        catch (Throwable throwable) {
            Object var7_8 = null;
            stmt.close();
            throw throwable;
        }
        stmt.close();
        if (netbiosName != null) {
            if (netbiosName.length() > 256) {
                netbiosName = netbiosName.substring(0, 256);
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)("NodeLabel.computeLabel: returning NetBIOS name as nodeLabel: " + netbiosName));
            }
            NodeLabel nodeLabel2 = new NodeLabel(netbiosName, 'N');
            return nodeLabel2;
        }
        String method = System.getProperty("org.opennms.bluebird.dp.primaryInterfaceSelectMethod");
        if (method == null) {
            log.warn((Object)"NodeLabel.computeLabel: unable to retrieve property 'org.opennms.bluebird.dp.primaryInterfaceSelectMethod', will use default value: min");
            method = "min";
        }
        if (!method.equals("min") && !method.equals(SELECT_METHOD_MAX)) {
            log.warn((Object)"NodeLabel.computeLabel: retrieved value for property 'org.opennms.bluebird.dp.primaryInterfaceSelectMethod' is invalid.");
            log.warn((Object)("Retrieved value is '" + method + "'.  Valid values are 'min' & 'max'.  Will use default value: " + "min"));
            method = "min";
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("NodeLabel.computeLabel: primary interface select method: " + method));
        }
        ArrayList ipv4AddrList = new ArrayList();
        ArrayList ipHostNameList = new ArrayList();
        stmt = dbConnection.prepareStatement(SQL_DB_RETRIEVE_MANAGED_INTERFACES);
        if (log.isDebugEnabled()) {
            log.debug((Object)("NodeLabel.computeLabel: sql: SELECT ipaddr,iphostname FROM ipinterface WHERE nodeid=? AND ismanaged='M' node id: " + nodeID));
        }
        stmt.setInt(1, nodeID);
        try {
            ResultSet rs = stmt.executeQuery();
            NodeLabel.loadAddressList(rs, ipv4AddrList, ipHostNameList);
            rs.close();
            Object var10_13 = null;
        }
        catch (Throwable throwable) {
            Object var10_14 = null;
            stmt.close();
            throw throwable;
        }
        stmt.close();
        IPv4Address primaryAddr = NodeLabel.selectPrimaryAddress(ipv4AddrList, method);
        if (primaryAddr == null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("NodeLabel.computeLabel: unable to find a primary address for node " + nodeID + ", returning null"));
            }
            ipv4AddrList = new ArrayList();
            ipHostNameList = new ArrayList();
            stmt = dbConnection.prepareStatement(SQL_DB_RETRIEVE_NON_MANAGED_INTERFACES);
            if (log.isDebugEnabled()) {
                log.debug((Object)("NodeLabel.computeLabel: sql: SELECT ipaddr,iphostname FROM ipinterface WHERE nodeid=? AND ismanaged!='M' node id: " + nodeID));
            }
            stmt.setInt(1, nodeID);
            try {
                ResultSet rs = stmt.executeQuery();
                NodeLabel.loadAddressList(rs, ipv4AddrList, ipHostNameList);
                rs.close();
                Object var12_19 = null;
            }
            catch (Throwable throwable) {
                Object var12_20 = null;
                stmt.close();
                throw throwable;
            }
            stmt.close();
            primaryAddr = NodeLabel.selectPrimaryAddress(ipv4AddrList, method);
        }
        if ((primaryHostName = (String)ipHostNameList.get(index = ipv4AddrList.indexOf(primaryAddr))).length() != 0) {
            if (primaryHostName.length() > 256) {
                primaryHostName = primaryHostName.substring(0, 256);
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)("NodeLabel.computeLabel: returning hostname as nodeLabel: " + primaryHostName));
            }
            NodeLabel nodeLabel3 = new NodeLabel(primaryHostName, 'H');
            return nodeLabel3;
        }
        String primarySysName = null;
        stmt = dbConnection.prepareStatement(SQL_DB_RETRIEVE_SYSNAME);
        if (log.isDebugEnabled()) {
            log.debug((Object)("NodeLabel.computeLabel: sql: SELECT nodesysname FROM node WHERE nodeid=? node id: " + nodeID));
        }
        stmt.setInt(1, nodeID);
        try {
            ResultSet rs = stmt.executeQuery();
            while (rs.next()) {
                primarySysName = rs.getString(1);
            }
            rs.close();
            Object var14_25 = null;
        }
        catch (Throwable throwable) {
            Object var14_26 = null;
            stmt.close();
            throw throwable;
        }
        stmt.close();
        if (primarySysName != null && primarySysName.length() > 0) {
            if (primarySysName.length() > 256) {
                primarySysName = primarySysName.substring(0, 256);
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)("NodeLabel.computeLabel: returning sysName as nodeLabel: " + primarySysName));
            }
            nodeLabel = new NodeLabel(primarySysName, 'S');
            return nodeLabel;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("NodeLabel.computeLabel: returning IP Address as nodeLabel: " + primaryAddr.toString()));
        }
        nodeLabel = new NodeLabel(primaryAddr.toString(), 'A');
        return nodeLabel;
    }

    private static void loadAddressList(ResultSet rs, List ipv4AddrList, List ipHostNameList) throws SQLException {
        Category log = ThreadCategory.getInstance(NodeLabel.class);
        while (rs.next()) {
            IPv4Address ipv4Addr = new IPv4Address(rs.getString(1));
            ipv4AddrList.add(ipv4Addr);
            String hostName = rs.getString(2);
            if (hostName == null || hostName.equals(ipv4Addr.toString())) {
                ipHostNameList.add("");
            } else {
                ipHostNameList.add(hostName);
            }
            if (!log.isDebugEnabled()) continue;
            log.debug((Object)("NodeLabel.computeLabel: adding address " + ipv4Addr.toString() + " with hostname: " + hostName));
        }
    }

    private static IPv4Address selectPrimaryAddress(List ipv4AddrList, String method) {
        Category log = ThreadCategory.getInstance(NodeLabel.class);
        IPv4Address primaryAddr = null;
        Iterator iter = ipv4AddrList.iterator();
        while (iter.hasNext()) {
            if (primaryAddr == null) {
                primaryAddr = (IPv4Address)iter.next();
                if (!log.isDebugEnabled()) continue;
                log.debug((Object)("NodeLabel.computeLabel: primaryAddr: " + primaryAddr.toString()));
                continue;
            }
            IPv4Address currentAddr = (IPv4Address)iter.next();
            int current = currentAddr.getAddress();
            int primary = primaryAddr.getAddress();
            if (current < 0) {
                current = (int)((long)current + 0x80000000L);
            }
            if (primary < 0) {
                primary = (int)((long)primary + 0x80000000L);
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)("NodeLabel.computeLabel: comparing current: " + current + " with primary: " + primary + " using method: " + method));
            }
            if (method.equals("min")) {
                if (current >= primary) continue;
                primaryAddr = currentAddr;
                if (!log.isDebugEnabled()) continue;
                log.debug((Object)("NodeLabel.computeLabel: new primaryAddr: " + primaryAddr.toString()));
                continue;
            }
            if (current <= primary) continue;
            primaryAddr = currentAddr;
            if (!log.isDebugEnabled()) continue;
            log.debug((Object)("NodeLabel.computeLabel: new primaryAddr: " + primaryAddr.toString()));
        }
        return primaryAddr;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append(this.m_nodeLabel);
        buffer.append(":");
        buffer.append(this.m_nodeLabelSource);
        return buffer.toString();
    }
}

