/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.trapd;

import java.util.HashMap;
import java.util.Map;
import org.opennms.netmgt.dao.IpInterfaceDao;
import org.opennms.netmgt.trapd.TrapdIpMgr;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;

public class HibernateTrapdIpMgr
implements TrapdIpMgr,
InitializingBean {
    private IpInterfaceDao m_ipInterfaceDao;
    private Map<String, Integer> m_knownips = new HashMap<String, Integer>();

    @Transactional(readOnly=true)
    public synchronized void dataSourceSync() {
        this.m_knownips = this.m_ipInterfaceDao.getInterfacesForNodes();
    }

    public synchronized long getNodeId(String addr) {
        if (addr == null) {
            return -1L;
        }
        return HibernateTrapdIpMgr.longValue(this.m_knownips.get(addr));
    }

    public synchronized long setNodeId(String addr, long nodeid) {
        if (addr == null || nodeid == -1L) {
            return -1L;
        }
        return HibernateTrapdIpMgr.longValue(this.m_knownips.put(addr, new Integer((int)nodeid)));
    }

    public synchronized long removeNodeId(String addr) {
        if (addr == null) {
            return -1L;
        }
        return HibernateTrapdIpMgr.longValue(this.m_knownips.remove(addr));
    }

    public synchronized void clearKnownIpsMap() {
        this.m_knownips.clear();
    }

    private static long longValue(Integer result) {
        return result == null ? -1L : result.longValue();
    }

    public void afterPropertiesSet() throws Exception {
        Assert.state((this.m_ipInterfaceDao != null ? 1 : 0) != 0, (String)"property ipInterfaceDao must be set");
    }

    public IpInterfaceDao getIpInterfaceDao() {
        return this.m_ipInterfaceDao;
    }

    public void setIpInterfaceDao(IpInterfaceDao ipInterfaceDao) {
        this.m_ipInterfaceDao = ipInterfaceDao;
    }
}

