/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.tl1d;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import org.opennms.core.fiber.PausableFiber;
import org.opennms.netmgt.config.tl1d.Tl1Element;
import org.opennms.netmgt.daemon.AbstractServiceDaemon;
import org.opennms.netmgt.dao.Tl1ConfigurationDao;
import org.opennms.netmgt.eventd.EventIpcManager;
import org.opennms.netmgt.model.events.EventBuilder;
import org.opennms.netmgt.model.events.EventListener;
import org.opennms.netmgt.tl1d.Tl1AutonomousMessage;
import org.opennms.netmgt.tl1d.Tl1AutonomousMessageProcessor;
import org.opennms.netmgt.tl1d.Tl1Client;
import org.opennms.netmgt.xml.event.Event;
import org.springframework.beans.factory.InitializingBean;

public class Tl1d
extends AbstractServiceDaemon
implements PausableFiber,
InitializingBean,
EventListener {
    private volatile int m_status = 0;
    private volatile Thread m_tl1MesssageProcessor;
    private volatile EventIpcManager m_eventManager;
    private volatile Tl1ConfigurationDao m_configurationDao;
    private final BlockingQueue<Tl1AutonomousMessage> m_tl1Queue = new LinkedBlockingQueue<Tl1AutonomousMessage>();
    private final List<Tl1Client> m_tl1Clients = new ArrayList<Tl1Client>();

    public Tl1d() {
        super("OpenNMS.Tl1d");
    }

    public void setConfigurationDao(Tl1ConfigurationDao configurationDao) {
        this.m_configurationDao = configurationDao;
    }

    public void setEventManager(EventIpcManager eventManager) {
        this.m_eventManager = eventManager;
    }

    public synchronized void onInit() {
        this.log().info((Object)"onInit: Initializing Tl1d connections.");
        List configElements = this.m_configurationDao.getElements();
        for (Tl1Element element : configElements) {
            try {
                Tl1Client client = (Tl1Client)Class.forName(element.getTl1ClientApi()).newInstance();
                client.setHost(element.getHost());
                client.setPort(element.getPort());
                client.setTl1Queue(this.m_tl1Queue);
                client.setMessageProcessor((Tl1AutonomousMessageProcessor)Class.forName(element.getTl1MessageParser()).newInstance());
                client.setLog(this.log());
                client.setReconnectionDelay(element.getReconnectDelay());
                this.m_tl1Clients.add(client);
            }
            catch (InstantiationException e) {
                this.log().error((Object)"onInit: could not instantiate specified class.", (Throwable)e);
            }
            catch (IllegalAccessException e) {
                this.log().error((Object)"onInit: could not access specified class.", (Throwable)e);
            }
            catch (ClassNotFoundException e) {
                this.log().error((Object)"onInit: could not find specified class.", (Throwable)e);
            }
        }
        this.log().info((Object)"onInit: Finished Initializing Tl1d connections.");
    }

    public synchronized void onStart() {
        this.log().info((Object)"onStart: Initializing Tl1d message processing.");
        this.m_tl1MesssageProcessor = new Thread("Tl1-Message-Processor"){

            public void run() {
                Tl1d.this.doMessageProcessing();
            }
        };
        this.m_tl1MesssageProcessor.start();
        for (Tl1Client client : this.m_tl1Clients) {
            client.start();
        }
        this.log().info((Object)"onStart: Finished Initializing Tl1d connections.");
    }

    public synchronized void onStop() {
        for (Tl1Client client : this.m_tl1Clients) {
            client.stop();
        }
        this.m_tl1MesssageProcessor.interrupt();
    }

    private void processMessage(Tl1AutonomousMessage message) {
        this.log().debug((Object)("processMessage: Processing message: " + message));
        EventBuilder bldr = new EventBuilder("uei.opennms.org/api/tl1d/message/autonomous", "Tl1d");
        bldr.setHost(message.getHost());
        bldr.setInterface(message.getHost());
        bldr.setService("TL-1");
        bldr.setSeverity(message.getId().getHighestSeverity());
        bldr.setTime(message.getTimestamp());
        bldr.addParam("raw-message", message.getRawMessage());
        bldr.addParam("alarm-code", message.getId().getAlarmCode());
        bldr.addParam("atag", message.getId().getAlarmTag());
        bldr.addParam("verb", message.getId().getVerb());
        bldr.addParam("autoblock", message.getAutoBlock().getBlock());
        bldr.addParam("aid", message.getAutoBlock().getAid());
        bldr.addParam("additionalParams", message.getAutoBlock().getAdditionalParams());
        this.m_eventManager.sendNow(bldr.getEvent());
        this.log().debug((Object)("processMessage: Message processed: " + message));
    }

    public void onPause() {
    }

    public void onResume() {
    }

    public synchronized int getStatus() {
        return this.m_status;
    }

    private void doMessageProcessing() {
        this.log().debug((Object)"doMessageProcessing: Processing messages.");
        boolean cont = true;
        while (cont) {
            try {
                Tl1AutonomousMessage message = this.m_tl1Queue.take();
                this.processMessage(message);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
        this.log().debug((Object)"doMessageProcessing: Exiting processing messages.");
    }

    public void onEvent(Event e) {
    }
}

