/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.tl1d;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.StringTokenizer;
import org.opennms.netmgt.tl1d.Tl1AutonomousMessage;
import org.opennms.netmgt.tl1d.Tl1MessageProcessor;

public class Tl1AutonomousMessageProcessor
implements Tl1MessageProcessor {
    private static final SimpleDateFormat SDF = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");

    public Tl1AutonomousMessage process(String rawMessage, int messageType) {
        StringTokenizer lineParser = new StringTokenizer(rawMessage, "\n");
        Tl1AutonomousMessage message = new Tl1AutonomousMessage(rawMessage);
        try {
            this.processHeader(lineParser, message);
            this.processId(lineParser, message);
            this.processAutoBlock(lineParser, message);
        }
        catch (IllegalStateException e) {
            return null;
        }
        return message;
    }

    private void processHeader(StringTokenizer lineParser, Tl1AutonomousMessage message) {
        boolean foundHeader = false;
        while (!foundHeader) {
            while (lineParser.hasMoreTokens() && !foundHeader) {
                String line = lineParser.nextToken();
                if (line == null || line.equals(message.getTerminator())) continue;
                try {
                    foundHeader = Tl1AutonomousMessageProcessor.parseHeader(line, message);
                }
                catch (IllegalArgumentException e) {}
            }
        }
        if (!foundHeader) {
            throw new IllegalStateException("No TL1 Header found in: " + lineParser.toString());
        }
    }

    private static boolean parseHeader(String line, Tl1AutonomousMessage message) throws IllegalArgumentException {
        StringTokenizer headerParser = new StringTokenizer(line);
        if (headerParser.countTokens() != 3) {
            throw new IllegalArgumentException("The line: " + line + " is not an Autonomous message header");
        }
        message.getHeader().setRawMessage(line);
        message.getHeader().setSid(headerParser.nextToken());
        message.setHost(message.getHeader().getSid());
        message.getHeader().setDate(headerParser.nextToken());
        message.getHeader().setTime(headerParser.nextToken());
        try {
            message.getHeader().setTimestamp(SDF.parse(message.getHeader().getDate() + " " + message.getHeader().getTime()));
            message.setTimestamp(message.getHeader().getTimestamp());
        }
        catch (ParseException e) {
            throw new IllegalArgumentException("The line: " + line + ", doesn't contain date and time in the format: " + SDF.toLocalizedPattern());
        }
        return true;
    }

    private void processId(StringTokenizer lineParser, Tl1AutonomousMessage message) {
        boolean foundId = false;
        while (!foundId) {
            while (lineParser.hasMoreElements() && !foundId) {
                String line = (String)lineParser.nextElement();
                if (line == null || line.equals(message.getTerminator())) continue;
                foundId = this.parseId(line, message);
            }
        }
    }

    private boolean parseId(String line, Tl1AutonomousMessage message) {
        StringTokenizer idParser = new StringTokenizer(line);
        if (idParser.countTokens() < 3) {
            throw new IllegalArgumentException("The line: " + line + " is not an Autonomouse message id.  Expected 3 or more tokens " + "and received: " + idParser.countTokens());
        }
        message.getId().setRawMessage(line);
        message.getId().setAlarmCode(idParser.nextToken());
        message.getId().setAlarmTag(idParser.nextToken());
        StringBuilder bldr = new StringBuilder();
        while (idParser.hasMoreTokens()) {
            bldr.append(idParser.nextToken());
            bldr.append(" ");
        }
        message.getId().setVerb(bldr.toString().trim());
        return true;
    }

    private void processAutoBlock(StringTokenizer lineParser, Tl1AutonomousMessage message) {
        boolean foundId = false;
        while (!foundId) {
            while (lineParser.hasMoreElements() && !foundId) {
                String line = (String)lineParser.nextElement();
                if (line == null || line.equals(message.getTerminator())) continue;
                foundId = true;
                foundId = this.parseAutoBlock(line.trim(), message);
            }
        }
    }

    private boolean parseAutoBlock(String line, Tl1AutonomousMessage message) {
        message.getAutoBlock().setBlock(line);
        StringTokenizer autoBlockParser = new StringTokenizer(line, ",");
        System.out.println("parseAutoBlock: Autoblock: " + line);
        String aidAndCode = autoBlockParser.nextToken().trim();
        System.out.println("parseAutoBlock: aidAndCode: " + aidAndCode);
        StringTokenizer aidParser = new StringTokenizer(aidAndCode, ":");
        message.getAutoBlock().setAid(aidParser.nextToken().substring(1));
        String ntfcncde = aidParser.nextToken().trim();
        StringTokenizer codeParser = new StringTokenizer(ntfcncde, "=");
        if (codeParser.hasMoreTokens()) {
            codeParser.nextToken();
            ntfcncde = codeParser.nextToken().trim();
        }
        message.getAutoBlock().setNtfcncde(ntfcncde);
        String addParms = null;
        while (autoBlockParser.hasMoreTokens()) {
            addParms = addParms + autoBlockParser.nextToken() + ",";
        }
        message.getAutoBlock().setAdditionalParams(addParms.trim());
        return true;
    }
}

