/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.threshd;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Collections;
import java.util.Date;
import java.util.Enumeration;
import java.util.Map;
import java.util.TreeMap;
import org.apache.log4j.Category;
import org.opennms.netmgt.EventConstants;
import org.opennms.netmgt.config.PollOutagesConfigFactory;
import org.opennms.netmgt.config.threshd.Package;
import org.opennms.netmgt.config.threshd.Parameter;
import org.opennms.netmgt.config.threshd.Service;
import org.opennms.netmgt.model.events.EventProxy;
import org.opennms.netmgt.poller.IPv4NetworkInterface;
import org.opennms.netmgt.scheduler.LegacyScheduler;
import org.opennms.netmgt.scheduler.ReadyRunnable;
import org.opennms.netmgt.threshd.ServiceThresholder;
import org.opennms.netmgt.threshd.Threshd;
import org.opennms.netmgt.threshd.ThresholdNetworkInterface;
import org.opennms.netmgt.threshd.ThresholderUpdates;
import org.opennms.netmgt.xml.event.Event;

final class ThresholdableService
extends IPv4NetworkInterface
implements ThresholdNetworkInterface,
ReadyRunnable {
    private int m_nodeId;
    private Package m_package;
    private final Service m_service;
    private int m_status;
    private long m_lastThresholdCheckTime;
    private long m_lastScheduledThresholdCheckTime;
    private final EventProxy m_proxy;
    private final LegacyScheduler m_scheduler;
    private ThresholderUpdates m_updates;
    private static final boolean ABORT_THRESHOLD_CHECK = true;
    private static Map m_properties = new TreeMap();
    private ServiceThresholder m_thresholder;
    private final String m_svcPropKey;
    private static Map SVC_PROP_MAP = Collections.synchronizedMap(new TreeMap());
    private Threshd m_threshd;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    ThresholdableService(Threshd threshd, int dbNodeId, InetAddress address, String svcName, Package pkg) {
        super(address);
        this.m_nodeId = dbNodeId;
        this.m_package = pkg;
        this.m_status = 1;
        this.m_threshd = threshd;
        this.m_proxy = threshd.getEventProxy();
        this.m_scheduler = threshd.getScheduler();
        this.m_thresholder = threshd.getServiceThresholder(svcName);
        this.m_updates = new ThresholderUpdates();
        this.m_lastScheduledThresholdCheckTime = System.currentTimeMillis();
        this.m_lastThresholdCheckTime = System.currentTimeMillis();
        Service svc = null;
        Enumeration esvc = this.m_package.enumerateService();
        while (esvc.hasMoreElements()) {
            Service s = (Service)esvc.nextElement();
            if (!s.getName().equalsIgnoreCase(svcName)) continue;
            svc = s;
            break;
        }
        if (svc == null) {
            throw new RuntimeException("Service name not part of package!");
        }
        this.m_service = svc;
        this.m_svcPropKey = this.m_package.getName() + "." + this.m_service.getName();
        Map map = SVC_PROP_MAP;
        synchronized (map) {
            if (!SVC_PROP_MAP.containsKey(this.m_svcPropKey)) {
                Map<String, String> m = Collections.synchronizedMap(new TreeMap());
                Enumeration ep = this.m_service.enumerateParameter();
                while (ep.hasMoreElements()) {
                    Parameter p = (Parameter)ep.nextElement();
                    m.put(p.getKey(), p.getValue());
                }
                m.put("interval", Integer.toString((int)this.m_service.getInterval()));
                SVC_PROP_MAP.put(this.m_svcPropKey, m);
            }
        }
    }

    public int getNodeId() {
        return this.m_nodeId;
    }

    public void setNodeId(int nodeId) {
        this.m_nodeId = nodeId;
    }

    public String getServiceName() {
        return this.m_service.getName();
    }

    public String getPackageName() {
        return this.m_package.getName();
    }

    public void refreshPackage() {
        Package refreshedPackage = this.m_threshd.getPackage(this.getPackageName());
        if (refreshedPackage != null) {
            this.m_package = refreshedPackage;
        }
    }

    public ThresholderUpdates getThresholderUpdates() {
        return this.m_updates;
    }

    public boolean isReady() {
        boolean ready = false;
        if (!this.m_threshd.isSchedulingCompleted()) {
            return false;
        }
        ready = this.m_service.getInterval() < 1L ? true : this.m_service.getInterval() - (System.currentTimeMillis() - this.m_lastScheduledThresholdCheckTime) < 1L;
        return ready;
    }

    public long getInterval() {
        return this.m_service.getInterval();
    }

    private void sendEvent(String uei) {
        Category log = this.log();
        Event event = new Event();
        event.setUei(uei);
        event.setNodeid((long)this.m_nodeId);
        event.setInterface(this.m_address.getHostAddress());
        event.setService("SNMP");
        event.setSource("OpenNMS.Threshd");
        try {
            event.setHost(InetAddress.getLocalHost().getHostAddress());
        }
        catch (UnknownHostException ex) {
            event.setHost("unresolved.host");
        }
        event.setTime(EventConstants.formatToString((Date)new Date()));
        try {
            this.m_proxy.send(event);
        }
        catch (Exception ex) {
            log.error((Object)("Failed to send the event " + uei + " for interface " + this.m_address.getHostAddress()), (Throwable)ex);
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("sendEvent: Sent event " + uei + " for " + this.m_nodeId + "/" + this.m_address.getHostAddress() + "/" + this.m_service.getName()));
        }
    }

    public void run() {
        Category log = this.log();
        if (this.processUpdates()) {
            return;
        }
        this.m_lastScheduledThresholdCheckTime = System.currentTimeMillis();
        if (this.scheduledOutage()) {
            this.m_scheduler.schedule(this, this.m_service.getInterval());
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("run: starting new threshold check for " + this.m_address.getHostAddress()));
        }
        int status = 2;
        Map propertiesMap = (Map)SVC_PROP_MAP.get(this.m_svcPropKey);
        try {
            status = this.m_thresholder.check(this, this.m_proxy, propertiesMap);
        }
        catch (Throwable t) {
            log.error((Object)("run: An undeclared throwable was caught during SNMP thresholding for interface " + this.m_address.getHostAddress()), t);
        }
        this.m_lastThresholdCheckTime = System.currentTimeMillis();
        if (status != this.m_status) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"run: change in thresholding status, generating event.");
            }
            switch (status) {
                case 1: {
                    this.sendEvent("uei.opennms.org/nodes/thresholdingSucceeded");
                    break;
                }
                case 2: {
                    this.sendEvent("uei.opennms.org/nodes/thresholdingFailed");
                    break;
                }
            }
        }
        this.m_status = status;
        this.m_scheduler.schedule(this, this.getInterval());
    }

    Map getPropertyMap() {
        return (Map)SVC_PROP_MAP.get(this.m_svcPropKey);
    }

    private boolean scheduledOutage() {
        boolean outageFound = false;
        PollOutagesConfigFactory outageFactory = PollOutagesConfigFactory.getInstance();
        for (String outageName : this.m_package.getOutageCalendarCollection()) {
            if (!outageFactory.isCurTimeInOutage(outageName) || !outageFactory.isNodeIdInOutage((long)this.m_nodeId, outageName) && !outageFactory.isInterfaceInOutage(this.m_address.getHostAddress(), outageName)) continue;
            if (this.log().isDebugEnabled()) {
                this.log().debug((Object)("scheduledOutage: configured outage '" + outageName + "' applies, interface " + this.m_address.getHostAddress() + " will not be thresholded for " + this.m_service));
            }
            outageFound = true;
            break;
        }
        return outageFound;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean processUpdates() {
        Category log = this.log();
        ThresholdableService thresholdableService = this;
        synchronized (thresholdableService) {
            if (!this.m_updates.hasUpdates()) {
                return false;
            }
            if (this.m_updates.isDeletionFlagSet()) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Collector for  " + this.m_address.getHostAddress() + " is marked for deletion...skipping thresholding, will not reschedule."));
                }
                return true;
            }
            if (this.m_updates.isReinitializationFlagSet()) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("ReinitializationFlag set for " + this.m_address.getHostAddress()));
                }
                try {
                    this.m_thresholder.release(this);
                    this.m_thresholder.initialize(this, this.getPropertyMap());
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("Completed reinitializing SNMP collector for " + this.m_address.getHostAddress()));
                    }
                }
                catch (RuntimeException rE) {
                    log.warn((Object)("Unable to reschedule " + this.m_address.getHostAddress() + " for " + this.m_service.getName() + " thresholding, reason: " + rE.getMessage()));
                }
                catch (Throwable t) {
                    log.error((Object)("Uncaught exception, failed to reschedule interface " + this.m_address.getHostAddress() + " for " + this.m_service.getName() + " thresholding"), t);
                }
            }
            if (this.m_updates.isReparentingFlagSet()) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("ReparentingFlag set for " + this.m_address.getHostAddress()));
                }
                int newNodeId = -1;
                try {
                    newNodeId = Integer.parseInt(this.m_updates.getReparentNewNodeId());
                }
                catch (NumberFormatException nfE) {
                    log.warn((Object)("Unable to convert new nodeId value to an int while processing reparenting update: " + this.m_updates.getReparentNewNodeId()));
                }
                this.m_nodeId = newNodeId;
                try {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("Reinitializing SNMP thresholder for " + this.m_address.getHostAddress()));
                    }
                    this.m_thresholder.release(this);
                    this.m_thresholder.initialize(this, this.getPropertyMap());
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("Completed reinitializing SNMP thresholder for " + this.m_address.getHostAddress()));
                    }
                }
                catch (RuntimeException rE) {
                    log.warn((Object)("Unable to initialize " + this.m_address.getHostAddress() + " for " + this.m_service.getName() + " thresholding, reason: " + rE.getMessage()));
                }
                catch (Throwable t) {
                    log.error((Object)("Uncaught exception, failed to initialize interface " + this.m_address.getHostAddress() + " for " + this.m_service.getName() + " thresholding"), t);
                }
            }
            this.m_updates.reset();
        }
        return false;
    }
}

