/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.threshd;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Date;
import org.apache.log4j.Category;
import org.opennms.core.utils.ThreadCategory;
import org.opennms.netmgt.EventConstants;
import org.opennms.netmgt.threshd.BaseThresholdDefConfigWrapper;
import org.opennms.netmgt.threshd.ThresholdEvaluator;
import org.opennms.netmgt.threshd.ThresholdEvaluatorState;
import org.opennms.netmgt.xml.event.Event;
import org.opennms.netmgt.xml.event.Parm;
import org.opennms.netmgt.xml.event.Parms;
import org.opennms.netmgt.xml.event.Value;
import org.springframework.util.Assert;

public class ThresholdEvaluatorRearmingAbsoluteChange
implements ThresholdEvaluator {
    private static final String TYPE = "rearmingAbsoluteChange";

    public ThresholdEvaluatorState getThresholdEvaluatorState(BaseThresholdDefConfigWrapper threshold) {
        return new ThresholdEvaluatorStateRearmingAbsoluteChange(threshold);
    }

    public boolean supportsType(String type) {
        return TYPE.equals(type);
    }

    public static class ThresholdEvaluatorStateRearmingAbsoluteChange
    implements ThresholdEvaluatorState {
        private BaseThresholdDefConfigWrapper m_thresholdConfig;
        private double m_lastSample = Double.NaN;
        private double m_previousTriggeringSample = Double.NaN;
        private int m_triggerCount = 0;

        public ThresholdEvaluatorStateRearmingAbsoluteChange(BaseThresholdDefConfigWrapper threshold) {
            Assert.notNull((Object)threshold, (String)"threshold argument cannot be null");
            this.setThresholdConfig(threshold);
        }

        public String getType() {
            return this.getThresholdConfig().getType().toString();
        }

        public void setThresholdConfig(BaseThresholdDefConfigWrapper thresholdConfig) {
            Assert.notNull((Object)thresholdConfig.getType(), (String)"threshold must have a 'type' value set");
            Assert.notNull((Object)thresholdConfig.getDatasourceExpression(), (String)"threshold must have a 'ds-name' value set");
            Assert.notNull((Object)thresholdConfig.getDsType(), (String)"threshold must have a 'ds-type' value set");
            Assert.isTrue((boolean)thresholdConfig.hasValue(), (String)"threshold must have a 'value' value set");
            Assert.isTrue((boolean)thresholdConfig.hasRearm(), (String)"threshold must have a 'rearm' value set");
            Assert.isTrue((boolean)thresholdConfig.hasTrigger(), (String)"threshold must have a 'trigger' value set");
            Assert.isTrue((boolean)ThresholdEvaluatorRearmingAbsoluteChange.TYPE.equals(thresholdConfig.getType()), (String)("threshold for ds-name '" + thresholdConfig.getDatasourceExpression() + "' has type of '" + thresholdConfig.getType() + "', but this evaluator only supports thresholds with a 'type' value of '" + ThresholdEvaluatorRearmingAbsoluteChange.TYPE + "'"));
            Assert.isTrue((thresholdConfig.getValue() != Double.NaN ? 1 : 0) != 0, (String)"threshold must have a 'value' value that is a number");
            Assert.isTrue((thresholdConfig.getValue() != Double.POSITIVE_INFINITY && thresholdConfig.getValue() != Double.NEGATIVE_INFINITY ? 1 : 0) != 0, (String)"threshold must have a 'value' value that is not positive or negative infinity");
            this.m_thresholdConfig = thresholdConfig;
        }

        public BaseThresholdDefConfigWrapper getThresholdConfig() {
            return this.m_thresholdConfig;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public ThresholdEvaluatorState.Status evaluate(double dsValue) {
            block6: {
                block5: {
                    try {
                        if (Double.valueOf(this.getPreviousTriggeringSample()).isNaN()) break block5;
                        ++this.m_triggerCount;
                        if (!this.wasTriggered(dsValue) && this.m_triggerCount >= this.getThresholdConfig().getTrigger()) {
                            this.setPreviousTriggeringSample(Double.NaN);
                            this.m_triggerCount = 0;
                            this.log().debug((Object)("rearmingAbsoluteChange threshold rearmed, sample value=" + dsValue));
                            ThresholdEvaluatorState.Status status = ThresholdEvaluatorState.Status.RE_ARMED;
                            Object var5_4 = null;
                            this.setLastSample(dsValue);
                            return status;
                        }
                        break block6;
                    }
                    catch (Throwable throwable) {
                        Object var5_7 = null;
                        this.setLastSample(dsValue);
                        throw throwable;
                    }
                }
                if (!this.wasTriggered(dsValue)) break block6;
                this.setPreviousTriggeringSample(this.getLastSample());
                this.m_triggerCount = 0;
                this.log().debug((Object)("rearmingAbsoluteChange threshold triggered, sample value=" + dsValue));
                ThresholdEvaluatorState.Status status = ThresholdEvaluatorState.Status.TRIGGERED;
                Object var5_5 = null;
                this.setLastSample(dsValue);
                return status;
            }
            Object var5_6 = null;
            this.setLastSample(dsValue);
            return ThresholdEvaluatorState.Status.NO_CHANGE;
        }

        private boolean wasTriggered(double dsValue) {
            if (Double.valueOf(dsValue).isNaN()) {
                return false;
            }
            if (Double.valueOf(this.getLastSample()).isNaN()) {
                return false;
            }
            double threshold = Math.abs(this.getLastSample() - dsValue);
            return threshold >= this.getThresholdConfig().getValue();
        }

        public Double getLastSample() {
            return this.m_lastSample;
        }

        public void setLastSample(double lastSample) {
            this.m_lastSample = lastSample;
        }

        public Event getEventForState(ThresholdEvaluatorState.Status status, Date date, double dsValue, String dsInstance) {
            if (status == ThresholdEvaluatorState.Status.TRIGGERED) {
                String uei = this.getThresholdConfig().getTriggeredUEI();
                if (uei == null || "".equals(uei)) {
                    uei = "uei.opennms.org/threshold/rearmingAbsoluteChangeExceeded";
                }
                return this.createBasicEvent(uei, date, dsValue, dsInstance);
            }
            if (status == ThresholdEvaluatorState.Status.RE_ARMED) {
                String uei = this.getThresholdConfig().getRearmedUEI();
                if (uei == null || "".equals(uei)) {
                    uei = "uei.opennms.org/threshold/rearmingAbsoluteChangeRearmed";
                }
                return this.createBasicEvent(uei, date, dsValue, dsInstance);
            }
            return null;
        }

        private Event createBasicEvent(String uei, Date date, double dsValue, String dsInstance) {
            Event event = new Event();
            event.setUei(uei);
            event.setSource("OpenNMS.Threshd." + this.getThresholdConfig().getDatasourceExpression());
            try {
                event.setHost(InetAddress.getLocalHost().getHostName());
            }
            catch (UnknownHostException e) {
                event.setHost("unresolved.host");
                this.log().warn((Object)("Failed to resolve local hostname: " + e), (Throwable)e);
            }
            event.setTime(EventConstants.formatToString((Date)date));
            Parms eventParms = new Parms();
            Parm eventParm = null;
            Value parmValue = null;
            eventParm = new Parm();
            eventParm.setParmName("ds");
            parmValue = new Value();
            parmValue.setContent(this.getThresholdConfig().getDatasourceExpression());
            eventParm.setValue(parmValue);
            eventParms.addParm(eventParm);
            eventParm = new Parm();
            eventParm.setParmName("value");
            parmValue = new Value();
            parmValue.setContent(Double.toString(dsValue));
            eventParm.setValue(parmValue);
            eventParms.addParm(eventParm);
            eventParm = new Parm();
            eventParm.setParmName("previousValue");
            parmValue = new Value();
            parmValue.setContent(Double.toString(this.getPreviousTriggeringSample()));
            eventParm.setValue(parmValue);
            eventParms.addParm(eventParm);
            eventParm = new Parm();
            eventParm.setParmName("threshold");
            parmValue = new Value();
            parmValue.setContent(Double.toString(this.getThresholdConfig().getValue()));
            eventParm.setValue(parmValue);
            eventParms.addParm(eventParm);
            eventParm = new Parm();
            eventParm.setParmName("trigger");
            parmValue = new Value();
            parmValue.setContent(Integer.toString(this.getThresholdConfig().getTrigger()));
            eventParm.setValue(parmValue);
            eventParms.addParm(eventParm);
            eventParm = new Parm();
            eventParm.setParmName("instance");
            parmValue = new Value();
            parmValue.setContent(dsInstance != null ? dsInstance : "null");
            eventParm.setValue(parmValue);
            eventParms.addParm(eventParm);
            event.setParms(eventParms);
            return event;
        }

        public double getPreviousTriggeringSample() {
            return this.m_previousTriggeringSample;
        }

        public void setPreviousTriggeringSample(double previousTriggeringSample) {
            this.m_previousTriggeringSample = previousTriggeringSample;
        }

        private final Category log() {
            return ThreadCategory.getInstance(this.getClass());
        }

        public ThresholdEvaluatorState getCleanClone() {
            return new ThresholdEvaluatorStateRearmingAbsoluteChange(this.m_thresholdConfig);
        }
    }
}

