/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.threshd;

import java.io.File;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Category;
import org.opennms.core.utils.ThreadCategory;
import org.opennms.netmgt.rrd.RrdException;
import org.opennms.netmgt.rrd.RrdUtils;
import org.opennms.netmgt.threshd.BaseThresholdDefConfigWrapper;
import org.opennms.netmgt.threshd.LatencyInterface;
import org.opennms.netmgt.threshd.LatencyParameters;
import org.opennms.netmgt.threshd.ThresholdEvaluator;
import org.opennms.netmgt.threshd.ThresholdEvaluatorAbsoluteChange;
import org.opennms.netmgt.threshd.ThresholdEvaluatorHighLow;
import org.opennms.netmgt.threshd.ThresholdEvaluatorRearmingAbsoluteChange;
import org.opennms.netmgt.threshd.ThresholdEvaluatorRelativeChange;
import org.opennms.netmgt.threshd.ThresholdEvaluatorState;
import org.opennms.netmgt.threshd.ThresholdExpressionException;
import org.opennms.netmgt.threshd.ThresholdingException;
import org.opennms.netmgt.xml.event.Event;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ThresholdEntity
implements Cloneable {
    private static List<ThresholdEvaluator> s_thresholdEvaluators = new LinkedList<ThresholdEvaluator>();
    private Map<String, List<ThresholdEvaluatorState>> m_thresholdEvaluatorStates = new HashMap<String, List<ThresholdEvaluatorState>>();

    public ThresholdEntity() {
        this.m_thresholdEvaluatorStates.put(null, new LinkedList());
    }

    public BaseThresholdDefConfigWrapper getThresholdConfig() {
        return this.m_thresholdEvaluatorStates.get(null).get(0).getThresholdConfig();
    }

    private boolean hasThresholds() {
        return this.m_thresholdEvaluatorStates.get(null).size() != 0;
    }

    public String getDataSourceExpression() {
        if (this.hasThresholds()) {
            return this.getThresholdConfig().getDatasourceExpression();
        }
        throw new IllegalStateException("No thresholds have been added.");
    }

    public String getDatasourceType() {
        if (this.hasThresholds()) {
            return this.getThresholdConfig().getDsType();
        }
        throw new IllegalStateException("No thresholds have been added.");
    }

    public String getDatasourceLabel() {
        if (this.hasThresholds()) {
            return this.getThresholdConfig().getDsLabel();
        }
        return null;
    }

    public Collection<String> getRequiredDatasources() {
        if (this.hasThresholds()) {
            return this.getThresholdConfig().getRequiredDatasources();
        }
        throw new IllegalStateException("No thresholds have been added.");
    }

    public ThresholdEntity clone() {
        ThresholdEntity clone = new ThresholdEntity();
        for (ThresholdEvaluatorState thresholdItem : this.getThresholdEvaluatorStates(null)) {
            clone.addThreshold(thresholdItem.getThresholdConfig());
        }
        return clone;
    }

    public String toString() {
        if (!this.hasThresholds()) {
            return "";
        }
        StringBuffer buffer = new StringBuffer();
        buffer.append("dsName=").append(this.getDataSourceExpression());
        buffer.append(", dsType=").append(this.getDatasourceType());
        for (ThresholdEvaluatorState item : this.getThresholdEvaluatorStates(null)) {
            buffer.append(", ds=").append(item.getThresholdConfig().getDatasourceExpression());
            buffer.append(", value=").append(item.getThresholdConfig().getValue());
            buffer.append(", rearm=").append(item.getThresholdConfig().getRearm());
            buffer.append(", trigger=").append(item.getThresholdConfig().getTrigger());
        }
        return buffer.toString();
    }

    public List<Event> evaluateAndCreateEvents(Map<String, Double> values, Date date) {
        return this.evaluateAndCreateEvents(null, values, date);
    }

    public List<Event> evaluateAndCreateEvents(String instance, Map<String, Double> values, Date date) {
        LinkedList<Event> events = new LinkedList<Event>();
        double dsValue = 0.0;
        try {
            if (this.getThresholdEvaluatorStates(instance).size() <= 0) {
                throw new IllegalStateException("No thresholds have been added.");
            }
            dsValue = this.getThresholdConfig().evaluate(values);
        }
        catch (ThresholdExpressionException e) {
            this.log().warn((Object)"Failed to evaluate: ", (Throwable)e);
            return events;
        }
        if (this.log().isDebugEnabled()) {
            this.log().debug((Object)("evaluate: value= " + dsValue + " against threshold: " + this));
        }
        for (ThresholdEvaluatorState item : this.getThresholdEvaluatorStates(instance)) {
            ThresholdEvaluatorState.Status status;
            Event event = item.getEventForState(status = item.evaluate(dsValue), date, dsValue, instance);
            if (event == null) continue;
            events.add(event);
        }
        return events;
    }

    private final Category log() {
        return ThreadCategory.getInstance(ThresholdEntity.class);
    }

    public Double fetchLastValue(LatencyInterface latIface, LatencyParameters latParms) throws ThresholdingException {
        String datasource = this.getDataSourceExpression();
        Double dsValue = null;
        try {
            if (this.getDatasourceType().equals("if")) {
                File rrdFile;
                if (this.log().isDebugEnabled()) {
                    this.log().debug((Object)("Fetching last value from dataSource '" + datasource + "'"));
                }
                if (!(rrdFile = new File(latIface.getLatencyDir(), datasource + RrdUtils.getExtension())).exists()) {
                    this.log().info((Object)("rrd file " + rrdFile + " does not exist"));
                    return null;
                }
                if (!rrdFile.canRead()) {
                    this.log().error((Object)("Unable to read existing rrd file " + rrdFile));
                    return null;
                }
                dsValue = latParms.getRange() == 0 ? RrdUtils.fetchLastValue((String)rrdFile.getAbsolutePath(), (String)datasource, (int)latParms.getInterval()) : RrdUtils.fetchLastValueInRange((String)rrdFile.getAbsolutePath(), (String)datasource, (int)latParms.getInterval(), (int)latParms.getRange());
            } else {
                throw new ThresholdingException("expr types not yet implemented", 2);
            }
            if (this.log().isDebugEnabled()) {
                this.log().debug((Object)("Last value from dataSource '" + datasource + "' was " + dsValue));
            }
        }
        catch (NumberFormatException nfe) {
            this.log().warn((Object)("Unable to convert retrieved value for datasource '" + datasource + "' to a double, skipping evaluation."));
        }
        catch (RrdException e) {
            this.log().error((Object)("An error occurred retriving the last value for datasource '" + datasource + "': " + (Object)((Object)e)), (Throwable)e);
        }
        return dsValue;
    }

    public void addThreshold(BaseThresholdDefConfigWrapper threshold) {
        ThresholdEvaluator evaluator = this.getEvaluatorForThreshold(threshold);
        List<ThresholdEvaluatorState> defaultList = this.m_thresholdEvaluatorStates.get(null);
        for (ThresholdEvaluatorState item : defaultList) {
            if (item.getThresholdConfig().getType() != threshold.getType()) continue;
            throw new IllegalStateException(threshold.getType().toString() + " threshold already set.");
        }
        defaultList.add(evaluator.getThresholdEvaluatorState(threshold));
    }

    private ThresholdEvaluator getEvaluatorForThreshold(BaseThresholdDefConfigWrapper threshold) {
        for (ThresholdEvaluator evaluator : ThresholdEntity.getThresholdEvaluators()) {
            if (!evaluator.supportsType(threshold.getType())) continue;
            return evaluator;
        }
        String message = "Threshold type '" + threshold.getType().toString() + "' for " + threshold.getDatasourceExpression() + " is not supported";
        this.log().warn((Object)message);
        throw new IllegalArgumentException(message);
    }

    public List<ThresholdEvaluatorState> getThresholdEvaluatorStates(String instance) {
        List<ThresholdEvaluatorState> result = this.m_thresholdEvaluatorStates.get(instance);
        if (result == null) {
            List<ThresholdEvaluatorState> defaultList = this.m_thresholdEvaluatorStates.get(null);
            result = new LinkedList<ThresholdEvaluatorState>();
            for (ThresholdEvaluatorState state : defaultList) {
                result.add(state.getCleanClone());
            }
            this.m_thresholdEvaluatorStates.put(instance, result);
        }
        return result;
    }

    public static final List<ThresholdEvaluator> getThresholdEvaluators() {
        return s_thresholdEvaluators;
    }

    static {
        s_thresholdEvaluators.add(new ThresholdEvaluatorHighLow());
        s_thresholdEvaluators.add(new ThresholdEvaluatorRelativeChange());
        s_thresholdEvaluators.add(new ThresholdEvaluatorAbsoluteChange());
        s_thresholdEvaluators.add(new ThresholdEvaluatorRearmingAbsoluteChange());
    }
}

