/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.threshd;

import java.io.File;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Category;
import org.opennms.core.utils.ThreadCategory;
import org.opennms.netmgt.config.ThresholdingConfigFactory;
import org.opennms.netmgt.config.threshd.Basethresholddef;
import org.opennms.netmgt.threshd.BaseThresholdDefConfigWrapper;
import org.opennms.netmgt.threshd.ThresholdEntity;
import org.opennms.netmgt.threshd.ThresholdExpressionException;
import org.opennms.netmgt.threshd.ThresholdGroup;
import org.opennms.netmgt.threshd.ThresholdResourceType;
import org.opennms.netmgt.threshd.ThresholdsDao;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.util.Assert;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultThresholdsDao
implements ThresholdsDao,
InitializingBean {
    private ThresholdingConfigFactory m_thresholdingConfigFactory;

    @Override
    public ThresholdGroup get(String name) {
        ThresholdGroup group = new ThresholdGroup(name);
        File rrdRepository = new File(this.getThresholdingConfigFactory().getRrdRepository(name));
        group.setRrdRepository(rrdRepository);
        ThresholdResourceType nodeType = this.createType(name, "node");
        group.setNodeResourceType(nodeType);
        ThresholdResourceType ifType = this.createType(name, "if");
        group.setIfResourceType(ifType);
        for (Basethresholddef thresh : this.getThresholdingConfigFactory().getThresholds(name)) {
            ThresholdResourceType genericType;
            String id = thresh.getDsType();
            if (id.equals("if") || id.equals("node") || group.getGenericResourceTypeMap().containsKey(id) || (genericType = this.createType(name, id)).getThresholdMap().size() <= 0) continue;
            this.log().info((Object)("Adding " + name + "::" + id + " with " + genericType.getThresholdMap().size() + " elements"));
            group.getGenericResourceTypeMap().put(id, genericType);
        }
        return group;
    }

    private Map<String, Set<ThresholdEntity>> createThresholdStateMap(String type, String groupName) {
        HashMap<String, Set<ThresholdEntity>> thresholdMap = new HashMap<String, Set<ThresholdEntity>>();
        for (Basethresholddef thresh : this.getThresholdingConfigFactory().getThresholds(groupName)) {
            if (!thresh.getDsType().equals(type)) continue;
            try {
                BaseThresholdDefConfigWrapper wrapper = BaseThresholdDefConfigWrapper.getConfigWrapper(thresh);
                LinkedHashSet thresholdEntitySet = (LinkedHashSet)thresholdMap.get(wrapper.getDatasourceExpression());
                if (thresholdEntitySet == null) {
                    thresholdEntitySet = new LinkedHashSet();
                    thresholdMap.put(wrapper.getDatasourceExpression(), thresholdEntitySet);
                }
                try {
                    ThresholdEntity thresholdEntity = new ThresholdEntity();
                    thresholdEntity.addThreshold(wrapper);
                    ((Set)thresholdMap.get(wrapper.getDatasourceExpression())).add(thresholdEntity);
                }
                catch (IllegalStateException e) {
                    this.log().warn((Object)("Encountered duplicate " + thresh.getType() + " for datasource " + wrapper.getDatasourceExpression() + ": " + e), (Throwable)e);
                }
            }
            catch (ThresholdExpressionException e) {
                this.log().warn((Object)("Could not parse threshold expression: " + e.getMessage()), (Throwable)e);
            }
        }
        return thresholdMap;
    }

    ThresholdResourceType createType(String groupName, String type) {
        ThresholdResourceType resourceType = new ThresholdResourceType(type);
        resourceType.setThresholdMap(this.createThresholdStateMap(type, groupName));
        return resourceType;
    }

    private Category log() {
        return ThreadCategory.getInstance(this.getClass());
    }

    @Override
    public ThresholdingConfigFactory getThresholdingConfigFactory() {
        return this.m_thresholdingConfigFactory;
    }

    public void setThresholdingConfigFactory(ThresholdingConfigFactory thresholdingConfigFactory) {
        this.m_thresholdingConfigFactory = thresholdingConfigFactory;
    }

    public void afterPropertiesSet() throws Exception {
        Assert.state((this.m_thresholdingConfigFactory != null ? 1 : 0) != 0, (String)"thresholdingConfigFactory property not set");
    }
}

