/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.rtc;

import java.text.ParseException;
import java.util.Date;
import java.util.Enumeration;
import org.apache.log4j.Category;
import org.opennms.core.utils.ThreadCategory;
import org.opennms.netmgt.EventConstants;
import org.opennms.netmgt.rtc.DataManager;
import org.opennms.netmgt.rtc.RTCManager;
import org.opennms.netmgt.xml.event.Event;
import org.opennms.netmgt.xml.event.Parm;
import org.opennms.netmgt.xml.event.Parms;
import org.opennms.netmgt.xml.event.Value;

final class DataUpdater
implements Runnable {
    private Event m_event;

    private void handleNodeGainedService(long nodeid, String ip, String svcName) {
        Category log = ThreadCategory.getInstance(DataUpdater.class);
        if (nodeid == -1L || ip == null || svcName == null) {
            log.warn((Object)(this.m_event.getUei() + " ignored - info incomplete - nodeid/ip/svc: " + nodeid + "/" + ip + "/" + svcName));
            return;
        }
        DataManager dataMgr = RTCManager.getDataManager();
        dataMgr.nodeGainedService(nodeid, ip, svcName);
        if (log.isDebugEnabled()) {
            log.debug((Object)(this.m_event.getUei() + " added " + nodeid + ": " + ip + ": " + svcName + " to data store"));
        }
    }

    private void handleNodeLostService(long nodeid, String ip, String svcName, long eventTime) {
        Category log = ThreadCategory.getInstance(DataUpdater.class);
        if (nodeid == -1L || ip == null || svcName == null || eventTime == -1L) {
            log.warn((Object)(this.m_event.getUei() + " ignored - info incomplete - nodeid/ip/svc/eventtime: " + nodeid + "/" + ip + "/" + svcName + "/" + eventTime));
            return;
        }
        DataManager dataMgr = RTCManager.getDataManager();
        dataMgr.nodeLostService(nodeid, ip, svcName, eventTime);
        if (log.isDebugEnabled()) {
            log.debug((Object)("Added nodeLostService to nodeid: " + nodeid + " ip: " + ip + " svcName: " + svcName));
        }
    }

    private void handleInterfaceDown(long nodeid, String ip, long eventTime) {
        Category log = ThreadCategory.getInstance(DataUpdater.class);
        if (nodeid == -1L || ip == null || eventTime == -1L) {
            log.warn((Object)(this.m_event.getUei() + " ignored - info incomplete - nodeid/ip/eventtime: " + nodeid + "/" + ip + "/" + eventTime));
            return;
        }
        DataManager dataMgr = RTCManager.getDataManager();
        dataMgr.interfaceDown(nodeid, ip, eventTime);
        if (log.isDebugEnabled()) {
            log.debug((Object)("Recorded interfaceDown for nodeid: " + nodeid + " ip: " + ip));
        }
    }

    private void handleNodeDown(long nodeid, long eventTime) {
        Category log = ThreadCategory.getInstance(DataUpdater.class);
        if (nodeid == -1L || eventTime == -1L) {
            log.warn((Object)(this.m_event.getUei() + " ignored - info incomplete - nodeid/eventtime: " + nodeid + "/" + eventTime));
            return;
        }
        DataManager dataMgr = RTCManager.getDataManager();
        dataMgr.nodeDown(nodeid, eventTime);
        if (log.isDebugEnabled()) {
            log.debug((Object)("Recorded nodeDown for nodeid: " + nodeid));
        }
    }

    private void handleNodeUp(long nodeid, long eventTime) {
        Category log = ThreadCategory.getInstance(DataUpdater.class);
        if (nodeid == -1L || eventTime == -1L) {
            log.warn((Object)(this.m_event.getUei() + " ignored - info incomplete - nodeid/eventtime: " + nodeid + "/" + eventTime));
            return;
        }
        DataManager dataMgr = RTCManager.getDataManager();
        dataMgr.nodeUp(nodeid, eventTime);
        if (log.isDebugEnabled()) {
            log.debug((Object)("Recorded nodeUp for nodeid: " + nodeid));
        }
    }

    private void handleInterfaceUp(long nodeid, String ip, long eventTime) {
        Category log = ThreadCategory.getInstance(DataUpdater.class);
        if (nodeid == -1L || ip == null || eventTime == -1L) {
            log.warn((Object)(this.m_event.getUei() + " ignored - info incomplete - nodeid/ip/eventtime: " + nodeid + "/" + ip + "/" + eventTime));
            return;
        }
        DataManager dataMgr = RTCManager.getDataManager();
        dataMgr.interfaceUp(nodeid, ip, eventTime);
        if (log.isDebugEnabled()) {
            log.debug((Object)("Recorded interfaceUp for nodeid: " + nodeid + " ip: " + ip));
        }
    }

    private void handleNodeRegainedService(long nodeid, String ip, String svcName, long eventTime) {
        Category log = ThreadCategory.getInstance(DataUpdater.class);
        if (nodeid == -1L || ip == null || svcName == null || eventTime == -1L) {
            log.warn((Object)(this.m_event.getUei() + " ignored - info incomplete - nodeid/ip/svc/eventtime: " + nodeid + "/" + ip + "/" + svcName + "/" + eventTime));
            return;
        }
        DataManager dataMgr = RTCManager.getDataManager();
        dataMgr.nodeRegainedService(nodeid, ip, svcName, eventTime);
        if (log.isDebugEnabled()) {
            log.debug((Object)("Added nodeRegainedService to nodeid: " + nodeid + " ip: " + ip + " svcName: " + svcName));
        }
    }

    private void handleServiceDeleted(long nodeid, String ip, String svcName) {
        Category log = ThreadCategory.getInstance(DataUpdater.class);
        if (nodeid == -1L || ip == null || svcName == null) {
            log.warn((Object)(this.m_event.getUei() + " ignored - info incomplete - nodeid/ip/svc: " + nodeid + "/" + ip + "/" + svcName));
            return;
        }
        DataManager dataMgr = RTCManager.getDataManager();
        dataMgr.serviceDeleted(nodeid, ip, svcName);
        if (log.isDebugEnabled()) {
            log.debug((Object)(this.m_event.getUei() + " deleted " + nodeid + ": " + ip + ": " + svcName + " from data store"));
        }
    }

    private void handleInterfaceReparented(String ip, Parms eventParms) {
        Category log = ThreadCategory.getInstance(DataUpdater.class);
        if (ip == null || eventParms == null) {
            log.warn((Object)(this.m_event.getUei() + " ignored - info incomplete - ip/parms: " + ip + "/" + eventParms));
            return;
        }
        long oldNodeId = -1L;
        long newNodeId = -1L;
        String parmName = null;
        Value parmValue = null;
        String parmContent = null;
        Enumeration parmEnum = eventParms.enumerateParm();
        while (parmEnum.hasMoreElements()) {
            String temp;
            Parm parm = (Parm)parmEnum.nextElement();
            parmName = parm.getParmName();
            parmValue = parm.getValue();
            if (parmValue == null) continue;
            parmContent = parmValue.getContent();
            if (parmName.equals("oldNodeID")) {
                temp = parmContent;
                try {
                    oldNodeId = Long.valueOf(temp);
                }
                catch (NumberFormatException nfe) {
                    log.warn((Object)"Parameter oldNodeID cannot be non-numeric", (Throwable)nfe);
                    oldNodeId = -1L;
                }
                continue;
            }
            if (!parmName.equals("newNodeID")) continue;
            temp = parmContent;
            try {
                newNodeId = Long.valueOf(temp);
            }
            catch (NumberFormatException nfe) {
                log.warn((Object)"Parameter newNodeID cannot be non-numeric", (Throwable)nfe);
                newNodeId = -1L;
            }
        }
        if (oldNodeId == -1L || newNodeId == -1L) {
            log.warn((Object)(this.m_event.getUei() + " did not have all required information for " + ip + " Values contained old nodeid: " + oldNodeId + " new nodeid: " + newNodeId));
        } else {
            DataManager dataMgr = RTCManager.getDataManager();
            dataMgr.interfaceReparented(ip, oldNodeId, newNodeId);
            if (log.isDebugEnabled()) {
                log.debug((Object)(this.m_event.getUei() + " reparented ip: " + ip + " from " + oldNodeId + " to " + newNodeId));
            }
        }
    }

    private void handleRtcSubscribe(Parms eventParms) {
        Category log = ThreadCategory.getInstance(DataUpdater.class);
        if (eventParms == null) {
            log.warn((Object)(this.m_event.getUei() + " ignored - info incomplete - parms: " + eventParms));
            return;
        }
        String url = null;
        String clabel = null;
        String user = null;
        String passwd = null;
        String parmName = null;
        Value parmValue = null;
        String parmContent = null;
        Enumeration parmEnum = eventParms.enumerateParm();
        while (parmEnum.hasMoreElements()) {
            Parm parm = (Parm)parmEnum.nextElement();
            parmName = parm.getParmName();
            parmValue = parm.getValue();
            if (parmValue == null) continue;
            parmContent = parmValue.getContent();
            if (parmName.equals("url")) {
                url = parmContent;
                continue;
            }
            if (parmName.equals("catlabel")) {
                clabel = parmContent;
                continue;
            }
            if (parmName.equals("user")) {
                user = parmContent;
                continue;
            }
            if (!parmName.equals("passwd")) continue;
            passwd = parmContent;
        }
        if (url == null || clabel == null || user == null || passwd == null) {
            log.warn((Object)(this.m_event.getUei() + " did not have all required information. Values contained url:  " + url + " catlabel: " + clabel + " user: " + user + "passwd: " + passwd));
        } else {
            RTCManager.getInstance().getDataSender().subscribe(url, clabel, user, passwd);
            if (log.isDebugEnabled()) {
                log.debug((Object)(this.m_event.getUei() + " subscribed " + url + ": " + clabel + ": " + user));
            }
        }
    }

    private void handleRtcUnsubscribe(Parms eventParms) {
        Category log = ThreadCategory.getInstance(DataUpdater.class);
        if (eventParms == null) {
            log.warn((Object)(this.m_event.getUei() + " ignored - info incomplete - parms: " + eventParms));
            return;
        }
        String url = null;
        String parmName = null;
        Value parmValue = null;
        String parmContent = null;
        Enumeration parmEnum = eventParms.enumerateParm();
        while (parmEnum.hasMoreElements()) {
            Parm parm = (Parm)parmEnum.nextElement();
            parmName = parm.getParmName();
            parmValue = parm.getValue();
            if (parmValue == null) continue;
            parmContent = parmValue.getContent();
            if (!parmName.equals("url")) continue;
            url = parmContent;
        }
        if (url == null) {
            log.warn((Object)(this.m_event.getUei() + " did not have required information.  Value of url:  " + url));
        } else {
            RTCManager.getInstance().getDataSender().unsubscribe(url);
            if (log.isDebugEnabled()) {
                log.debug((Object)(this.m_event.getUei() + " unsubscribed " + url));
            }
        }
    }

    private void handleAssetInfoChangedEvent(long nodeid) {
        Category log = ThreadCategory.getInstance(DataUpdater.class);
        DataManager dataMgr = RTCManager.getDataManager();
        dataMgr.assetInfoChanged(nodeid);
        if (log.isDebugEnabled()) {
            log.debug((Object)(this.m_event.getUei() + " asset info changed for node " + nodeid));
        }
    }

    private void handleNodeCategoryMembershipChanged(long nodeid) {
        Category log = ThreadCategory.getInstance(DataUpdater.class);
        DataManager dataMgr = RTCManager.getDataManager();
        dataMgr.nodeCategoryMembershipChanged(nodeid);
        if (log.isDebugEnabled()) {
            log.debug((Object)(this.m_event.getUei() + " surveillance category membership changed for node " + nodeid));
        }
    }

    private void processEvent() {
        Category log = ThreadCategory.getInstance(DataUpdater.class);
        if (this.m_event == null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"Event is null, nothing to process");
            }
            return;
        }
        String eventUEI = this.m_event.getUei();
        if (eventUEI == null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"Event received with null UEI, ignoring event");
            }
            return;
        }
        long nodeid = -1L;
        if (this.m_event.hasNodeid()) {
            nodeid = this.m_event.getNodeid();
        }
        String ip = this.m_event.getInterface();
        String svcName = this.m_event.getService();
        long eventTime = -1L;
        String eventTimeStr = this.m_event.getTime();
        try {
            Date date = EventConstants.parseToDate((String)eventTimeStr);
            eventTime = date.getTime();
        }
        catch (ParseException pe) {
            log.warn((Object)("Failed to convert time " + eventTime + " to java.util.Date, Setting current time instead"), (Throwable)pe);
            eventTime = new Date().getTime();
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("Event UEI: " + eventUEI + "\tnodeid: " + nodeid + "\tip: " + ip + "\tsvcName: " + svcName + "\teventTime: " + eventTimeStr));
        }
        if (eventUEI.equals("uei.opennms.org/nodes/nodeGainedService")) {
            this.handleNodeGainedService(nodeid, ip, svcName);
        } else if (eventUEI.equals("uei.opennms.org/nodes/nodeLostService")) {
            this.handleNodeLostService(nodeid, ip, svcName, eventTime);
        } else if (eventUEI.equals("uei.opennms.org/nodes/interfaceDown")) {
            this.handleInterfaceDown(nodeid, ip, eventTime);
        } else if (eventUEI.equals("uei.opennms.org/nodes/nodeDown")) {
            this.handleNodeDown(nodeid, eventTime);
        } else if (eventUEI.equals("uei.opennms.org/nodes/nodeUp")) {
            this.handleNodeUp(nodeid, eventTime);
        } else if (eventUEI.equals("uei.opennms.org/nodes/interfaceUp")) {
            this.handleInterfaceUp(nodeid, ip, eventTime);
        } else if (eventUEI.equals("uei.opennms.org/nodes/nodeRegainedService")) {
            this.handleNodeRegainedService(nodeid, ip, svcName, eventTime);
        } else if (eventUEI.equals("uei.opennms.org/nodes/serviceDeleted")) {
            this.handleServiceDeleted(nodeid, ip, svcName);
        } else if (eventUEI.equals("uei.opennms.org/nodes/serviceUnmanaged")) {
            this.handleServiceDeleted(nodeid, ip, svcName);
        } else if (eventUEI.equals("uei.opennms.org/nodes/interfaceReparented")) {
            this.handleInterfaceReparented(ip, this.m_event.getParms());
        } else if (eventUEI.equals("uei.opennms.org/internal/rtc/subscribe")) {
            this.handleRtcSubscribe(this.m_event.getParms());
        } else if (eventUEI.equals("uei.opennms.org/internal/rtc/unsubscribe")) {
            this.handleRtcUnsubscribe(this.m_event.getParms());
        } else if (eventUEI.equals("uei.opennms.org/nodes/assetInfoChanged")) {
            this.handleAssetInfoChangedEvent(nodeid);
        } else if (eventUEI.equals("uei.opennms.org/nodes/nodeCategoryMembershipChanged")) {
            this.handleNodeCategoryMembershipChanged(nodeid);
        } else if (log.isDebugEnabled()) {
            log.debug((Object)("Event subscribed for not handled?!: " + eventUEI));
        }
        RTCManager.getInstance().incrementCounter();
    }

    public DataUpdater(Event event) {
        this.m_event = event;
    }

    public void run() {
        Category log = ThreadCategory.getInstance(DataUpdater.class);
        try {
            this.processEvent();
        }
        catch (Throwable t) {
            log.warn((Object)"Unexpected exception processing event", t);
        }
    }
}

