/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.poller.pollables;

import java.net.InetAddress;
import java.util.Date;
import org.apache.log4j.Category;
import org.opennms.core.utils.ThreadCategory;
import org.opennms.netmgt.model.PollStatus;
import org.opennms.netmgt.poller.pollables.PollContext;
import org.opennms.netmgt.poller.pollables.PollEvent;
import org.opennms.netmgt.poller.pollables.PollableContainer;
import org.opennms.netmgt.poller.pollables.PollableElement;
import org.opennms.netmgt.poller.pollables.PollableInterface;
import org.opennms.netmgt.poller.pollables.PollableNode;
import org.opennms.netmgt.poller.pollables.PollableService;
import org.opennms.netmgt.poller.pollables.PollableVisitor;
import org.opennms.netmgt.poller.pollables.PollableVisitorAdaptor;
import org.opennms.netmgt.poller.pollables.Scope;
import org.opennms.netmgt.xml.event.Event;

public class PollableNetwork
extends PollableContainer {
    private final PollContext m_context;

    public PollableNetwork(PollContext context) {
        super(null, Scope.NETWORK);
        this.m_context = context;
    }

    public PollContext getContext() {
        return this.m_context;
    }

    public PollableNode createNode(int nodeId, String nodeLabel) {
        PollableNode node = new PollableNode(this, nodeId, nodeLabel);
        this.addMember(node);
        return node;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PollableNode createNodeIfNecessary(int nodeId, String nodeLabel) {
        PollableNetwork pollableNetwork = this;
        synchronized (pollableNetwork) {
            PollableNode node = this.getNode(nodeId);
            return node != null ? node : this.createNode(nodeId, nodeLabel);
        }
    }

    public PollableNode getNode(int nodeId) {
        return (PollableNode)this.getMember(new Integer(nodeId));
    }

    public int getNodeCount() {
        return this.getMemberCount();
    }

    public PollableInterface createInterface(int nodeId, String nodeLabel, InetAddress addr) {
        return this.createNodeIfNecessary(nodeId, nodeLabel).createInterface(addr);
    }

    public PollableInterface getInterface(int nodeId, InetAddress addr) {
        PollableNode node = this.getNode(nodeId);
        return node == null ? null : node.getInterface(addr);
    }

    public PollableService createService(int nodeId, String nodeLabel, InetAddress addr, String svcName) {
        return this.createNodeIfNecessary(nodeId, nodeLabel).createService(addr, svcName);
    }

    public PollableService getService(int nodeId, InetAddress addr, String svcName) {
        PollableNode node = this.getNode(nodeId);
        return node == null ? null : node.getService(addr, svcName);
    }

    protected Object createMemberKey(PollableElement member) {
        PollableNode node = (PollableNode)member;
        return new Integer(node.getNodeId());
    }

    protected void visitThis(PollableVisitor v) {
        super.visitThis(v);
        v.visitNetwork(this);
    }

    public PollStatus pollRemainingMembers(PollableElement member) {
        return this.getMemberStatus();
    }

    public Event createDownEvent(Date date) {
        throw new UnsupportedOperationException("No down event for the network");
    }

    public Event createUpEvent(Date date) {
        throw new UnsupportedOperationException("No up event for the network");
    }

    public void dump() {
        Category log = ThreadCategory.getInstance(this.getClass());
        DumpVisitor dumper = new DumpVisitor(log);
        this.visit(dumper);
    }

    public void delete() {
        throw new UnsupportedOperationException("Can't delete the entire network");
    }

    public PollStatus poll(PollableElement elem) {
        PollableElement member = this.findMemberWithDescendent(elem);
        return member.poll(elem);
    }

    public void processStatusChange(Date date) {
        this.processMemberStatusChanges(date);
    }

    public void recalculateStatus() {
        PollableContainer.Iter iter = new PollableContainer.Iter(){

            public void forEachElement(PollableElement elem) {
                elem.recalculateStatus();
            }
        };
        this.forEachMember(iter);
    }

    public void resetStatusChanged() {
        super.resetStatusChanged();
        PollableContainer.Iter iter = new PollableContainer.Iter(){

            public void forEachElement(PollableElement elem) {
                elem.resetStatusChanged();
            }
        };
        this.forEachMember(iter);
    }

    public PollableElement getLockRoot() {
        return this;
    }

    public void obtainTreeLock(long timeout) {
    }

    public void releaseTreeLock() {
    }

    public PollEvent extrapolateCause() {
        PollableContainer.Iter iter = new PollableContainer.Iter(){

            public void forEachElement(PollableElement elem) {
                elem.extrapolateCause();
            }
        };
        this.forEachMember(iter);
        return null;
    }

    public void propagateInitialCause() {
        this.extrapolateCause();
        this.inheritParentalCause();
    }

    class DumpVisitor
    extends PollableVisitorAdaptor {
        private Category m_log;

        public DumpVisitor(Category log) {
            this.m_log = log;
        }

        public void visitNode(PollableNode pNode) {
            this.m_log.debug((Object)(" nodeid=" + pNode.getNodeId() + " status=" + this.getStatusString(pNode)));
        }

        public void visitInterface(PollableInterface pIf) {
            this.m_log.debug((Object)("     interface=" + pIf.getIpAddr() + " status=" + this.getStatusString(pIf)));
        }

        public void visitService(PollableService pSvc) {
            this.m_log.debug((Object)("         service=" + pSvc.getSvcName() + " status=" + this.getStatusString(pSvc)));
        }

        private String getStatusString(PollableElement e) {
            return e.getStatus().isUp() ? e.getStatus().toString() : e.getStatus().toString() + "(" + e.getCause().getEventId() + ")";
        }
    }
}

