/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.poller.monitors;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.httpclient.Credentials;
import org.apache.commons.httpclient.DefaultHttpMethodRetryHandler;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpException;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.NameValuePair;
import org.apache.commons.httpclient.URI;
import org.apache.commons.httpclient.URIException;
import org.apache.commons.httpclient.UsernamePasswordCredentials;
import org.apache.commons.httpclient.auth.AuthScope;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.commons.httpclient.methods.PostMethod;
import org.apache.commons.httpclient.params.HttpClientParams;
import org.apache.commons.io.IOUtils;
import org.exolab.castor.xml.MarshalException;
import org.exolab.castor.xml.ValidationException;
import org.opennms.core.utils.MatchTable;
import org.opennms.core.utils.PropertiesUtils;
import org.opennms.netmgt.config.pagesequence.Page;
import org.opennms.netmgt.config.pagesequence.PageSequence;
import org.opennms.netmgt.config.pagesequence.Parameter;
import org.opennms.netmgt.dao.castor.CastorUtils;
import org.opennms.netmgt.model.PollStatus;
import org.opennms.netmgt.poller.Distributable;
import org.opennms.netmgt.poller.MonitoredService;
import org.opennms.netmgt.poller.monitors.IPv4Monitor;
import org.opennms.netmgt.utils.ParameterMap;

@Distributable
public class PageSequenceMonitor
extends IPv4Monitor {
    private static final int DEFAULT_TIMEOUT = 3000;
    private static final int DEFAULT_RETRY = 0;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public PollStatus poll(MonitoredService svc, Map parameterMap) {
        PollStatus pollStatus;
        HttpClient client = null;
        try {
            try {
                PageSequenceMonitorParameters parms = PageSequenceMonitorParameters.get(parameterMap);
                client = parms.createHttpClient();
                long startTime = System.nanoTime();
                parms.getPageSequence().execute(client, svc);
                long endTime = System.nanoTime();
                double responseTime = (double)(endTime - startTime) / 1000000.0;
                pollStatus = PollStatus.available((Double)responseTime);
                Object var13_13 = null;
                if (client == null) return pollStatus;
            }
            catch (PageSequenceMonitorException e) {
                PollStatus pollStatus2 = PollStatus.unavailable((String)e.getMessage());
                Object var13_14 = null;
                if (client == null) return pollStatus2;
                client.getHttpConnectionManager().closeIdleConnections(0L);
                return pollStatus2;
            }
            catch (IllegalArgumentException e) {
                this.log().error((Object)("Invalid parameters to monitor: " + e), (Throwable)e);
                PollStatus pollStatus3 = PollStatus.unavailable((String)("Invalid parameter to monitor: " + e.getMessage() + ".  See log for details."));
                Object var13_15 = null;
                if (client == null) return pollStatus3;
                client.getHttpConnectionManager().closeIdleConnections(0L);
                return pollStatus3;
            }
        }
        catch (Throwable throwable) {
            Object var13_16 = null;
            if (client == null) throw throwable;
            client.getHttpConnectionManager().closeIdleConnections(0L);
            throw throwable;
        }
        client.getHttpConnectionManager().closeIdleConnections(0L);
        return pollStatus;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class PageSequenceMonitorParameters {
        public static final String KEY = PageSequenceMonitorParameters.class.getName();
        private Map<String, String> m_parameterMap;
        private HttpClientParams m_clientParams;
        private HttpPageSequence m_pageSequence;

        static synchronized PageSequenceMonitorParameters get(Map paramterMap) {
            PageSequenceMonitorParameters parms = (PageSequenceMonitorParameters)paramterMap.get(KEY);
            if (parms == null) {
                parms = new PageSequenceMonitorParameters(paramterMap);
                paramterMap.put(KEY, parms);
            }
            return parms;
        }

        PageSequenceMonitorParameters(Map<String, String> parameterMap) {
            this.m_parameterMap = parameterMap;
            String pageSequence = this.getStringParm("page-sequence", null);
            if (pageSequence == null) {
                throw new IllegalArgumentException("page-sequence must be set in monitor parameters");
            }
            PageSequence sequence = this.parsePageSequence(pageSequence);
            this.m_pageSequence = new HttpPageSequence(sequence);
            this.createClientParams();
        }

        Map<String, String> getParameterMap() {
            return this.m_parameterMap;
        }

        HttpPageSequence getPageSequence() {
            return this.m_pageSequence;
        }

        PageSequence parsePageSequence(String sequenceString) {
            try {
                return (PageSequence)CastorUtils.unmarshal(PageSequence.class, (Reader)new StringReader(sequenceString));
            }
            catch (MarshalException e) {
                throw new IllegalArgumentException("Unable to parse page-sequence for HttpMonitor: " + (Object)((Object)e) + "\nConfig: " + sequenceString, e);
            }
            catch (ValidationException e) {
                throw new IllegalArgumentException("Unable to validate page-sequence for HttpMonitor: " + (Object)((Object)e) + "\nConfig: " + sequenceString, e);
            }
        }

        private String getStringParm(String key, String deflt) {
            return ParameterMap.getKeyedString(this.getParameterMap(), key, deflt);
        }

        private int getIntParm(String key, int defValue) {
            return ParameterMap.getKeyedInteger(this.getParameterMap(), key, defValue);
        }

        private void createClientParams() {
            this.m_clientParams = new HttpClientParams();
            this.m_clientParams.setConnectionManagerTimeout((long)this.getTimeout());
            this.m_clientParams.setSoTimeout(this.getTimeout());
            this.m_clientParams.setParameter("http.method.retry-handler", (Object)new DefaultHttpMethodRetryHandler(this.getRetries(), false));
            this.m_clientParams.setCookiePolicy("compatibility");
        }

        public int getRetries() {
            return this.getIntParm("retry", 0);
        }

        public int getTimeout() {
            return this.getIntParm("timeout", 3000);
        }

        public HttpClientParams getClientParams() {
            return this.m_clientParams;
        }

        HttpClient createHttpClient() {
            HttpClient client = new HttpClient(this.getClientParams());
            client.getHttpConnectionManager().getParams().setConnectionTimeout(this.getTimeout());
            return client;
        }
    }

    public static class HttpPage {
        private Page m_page;
        private HttpResponseRange m_range;
        private Pattern m_successPattern;
        private Pattern m_failurePattern;
        private NameValuePair[] m_parms;

        HttpPage(HttpPageSequence parent, Page page) {
            this.m_page = page;
            this.m_range = new HttpResponseRange(page.getResponseRange());
            this.m_successPattern = page.getSuccessMatch() == null ? null : Pattern.compile(page.getSuccessMatch());
            this.m_failurePattern = page.getFailureMatch() == null ? null : Pattern.compile(page.getFailureMatch());
            ArrayList<NameValuePair> parms = new ArrayList<NameValuePair>();
            for (Parameter parm : this.m_page.getParameter()) {
                parms.add(new NameValuePair(parm.getKey(), parm.getValue()));
            }
            this.m_parms = parms.toArray(new NameValuePair[parms.size()]);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void execute(HttpClient client, MonitoredService svc) {
            try {
                Matcher matcher;
                String userInfo;
                String[] streetCred;
                URI uri = this.getURI(svc);
                PageSequenceHttpMethod method = this.getMethod();
                method.setURI(uri);
                if (this.getVirtualHost() != null) {
                    method.getParams().setVirtualHost(this.getVirtualHost());
                }
                if (this.getUserAgent() != null) {
                    method.addRequestHeader("User-Agent", this.getUserAgent());
                }
                if (this.m_parms.length > 0) {
                    method.setParameters(this.m_parms);
                }
                if (this.m_page.getUserInfo() != null && (streetCred = (userInfo = this.m_page.getUserInfo()).split(":", 2)).length == 2) {
                    client.getState().setCredentials(new AuthScope(AuthScope.ANY), (Credentials)new UsernamePasswordCredentials(streetCred[0], streetCred[1]));
                    method.setDoAuthentication(true);
                }
                int code = client.executeMethod((HttpMethod)method);
                if (!this.getRange().contains(code)) {
                    throw new PageSequenceMonitorException("response code out of range for uri:" + uri + ".  Expected " + this.getRange() + " but received " + code);
                }
                InputStream inputStream = method.getResponseBodyAsStream();
                ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
                try {
                    IOUtils.copy((InputStream)inputStream, (OutputStream)outputStream);
                    Object var9_12 = null;
                }
                catch (Throwable throwable) {
                    Object var9_13 = null;
                    IOUtils.closeQuietly((InputStream)inputStream);
                    IOUtils.closeQuietly((OutputStream)outputStream);
                    throw throwable;
                }
                IOUtils.closeQuietly((InputStream)inputStream);
                IOUtils.closeQuietly((OutputStream)outputStream);
                String responseString = outputStream.toString();
                if (this.getFailurePattern() != null && (matcher = this.getFailurePattern().matcher(responseString)).find()) {
                    throw new PageSequenceMonitorException(this.getResolvedFailureMessage(matcher));
                }
                if (this.getSuccessPattern() != null && !(matcher = this.getSuccessPattern().matcher(responseString)).find()) {
                    throw new PageSequenceMonitorException("failed to find '" + this.getSuccessPattern() + "' in page content at " + uri);
                }
            }
            catch (URIException e) {
                throw new IllegalArgumentException("unable to construct URL for page: " + (Object)((Object)e), e);
            }
            catch (HttpException e) {
                throw new PageSequenceMonitorException("HTTP Error " + (Object)((Object)e), e);
            }
            catch (IOException e) {
                throw new PageSequenceMonitorException("I/O Error " + e, e);
            }
        }

        private String getUserAgent() {
            return this.m_page.getUserAgent();
        }

        private String getVirtualHost() {
            return this.m_page.getVirtualHost();
        }

        private URI getURI(MonitoredService svc) throws URIException {
            Properties p = this.getServiceProperties(svc);
            return new URI(this.getScheme(), this.getUserInfo(), this.getHost(p), this.getPort(), this.getPath(p), this.getQuery(p), this.getFragment(p));
        }

        private String getFragment(Properties p) {
            return PropertiesUtils.substitute((String)this.m_page.getFragment(), (Properties)p);
        }

        private String getQuery(Properties p) {
            return PropertiesUtils.substitute((String)this.m_page.getQuery(), (Properties)p);
        }

        private String getPath(Properties p) {
            return PropertiesUtils.substitute((String)this.m_page.getPath(), (Properties)p);
        }

        private int getPort() {
            return this.m_page.getPort();
        }

        private String getHost(Properties p) {
            return PropertiesUtils.substitute((String)this.m_page.getHost(), (Properties)p);
        }

        private Properties getServiceProperties(MonitoredService svc) {
            Properties properties = new Properties();
            properties.put("ipaddr", svc.getIpAddr());
            properties.put("nodeid", (Object)svc.getNodeId());
            return properties;
        }

        private String getUserInfo() {
            return this.m_page.getUserInfo();
        }

        private String getScheme() {
            return this.m_page.getScheme();
        }

        private PageSequenceHttpMethod getMethod() {
            String method = this.m_page.getMethod();
            return "GET".equalsIgnoreCase(method) ? new PageSequenceHttpGetMethod() : new PageSequenceHttpPostMethod();
        }

        private HttpResponseRange getRange() {
            return this.m_range;
        }

        private Pattern getSuccessPattern() {
            return this.m_successPattern;
        }

        private Pattern getFailurePattern() {
            return this.m_failurePattern;
        }

        private String getFailureMessage() {
            return this.m_page.getFailureMessage();
        }

        private String getResolvedFailureMessage(Matcher matcher) {
            return PropertiesUtils.substitute((String)this.getFailureMessage(), (PropertiesUtils.SymbolTable)new MatchTable(matcher));
        }
    }

    public static class PageSequenceHttpGetMethod
    extends GetMethod
    implements PageSequenceHttpMethod {
        public void setParameters(NameValuePair[] parms) {
            this.setQueryString(parms);
        }
    }

    public static class PageSequenceHttpPostMethod
    extends PostMethod
    implements PageSequenceHttpMethod {
        public void setParameters(NameValuePair[] parms) {
            this.setRequestBody(parms);
        }

        public boolean getFollowRedirects() {
            return true;
        }
    }

    public static interface PageSequenceHttpMethod
    extends HttpMethod {
        public void setParameters(NameValuePair[] var1);
    }

    public static class HttpResponseRange {
        private static final Pattern RANGE_PATTERN = Pattern.compile("([1-5][0-9][0-9])(?:-([1-5][0-9][0-9]))?");
        private int m_begin;
        private int m_end;

        HttpResponseRange(String rangeSpec) {
            Matcher matcher = RANGE_PATTERN.matcher(rangeSpec);
            if (!matcher.matches()) {
                throw new IllegalArgumentException("Invalid range spec: " + rangeSpec);
            }
            String beginSpec = matcher.group(1);
            String endSpec = matcher.group(2);
            this.m_begin = Integer.parseInt(beginSpec);
            this.m_end = endSpec == null ? this.m_begin : Integer.parseInt(endSpec);
        }

        public boolean contains(int responseCode) {
            return this.m_begin <= responseCode && responseCode <= this.m_end;
        }

        public String toString() {
            if (this.m_begin == this.m_end) {
                return Integer.toString(this.m_begin);
            }
            return Integer.toString(this.m_begin) + '-' + Integer.toString(this.m_end);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class HttpPageSequence {
        PageSequence m_sequence;
        List<HttpPage> m_pages;

        HttpPageSequence(PageSequence sequence) {
            this.m_sequence = sequence;
            this.m_pages = new ArrayList<HttpPage>(this.m_sequence.getPageCount());
            for (Page page : this.m_sequence.getPage()) {
                this.m_pages.add(new HttpPage(this, page));
            }
        }

        List<HttpPage> getPages() {
            return this.m_pages;
        }

        private void execute(HttpClient client, MonitoredService svc) {
            for (HttpPage page : this.getPages()) {
                page.execute(client, svc);
            }
        }
    }

    public static class PageSequenceMonitorException
    extends RuntimeException {
        private static final long serialVersionUID = 1346757238604080088L;

        public PageSequenceMonitorException(String message) {
            super(message);
        }

        public PageSequenceMonitorException(Throwable cause) {
            super(cause);
        }

        public PageSequenceMonitorException(String message, Throwable cause) {
            super(message, cause);
        }
    }
}

