/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.poller.monitors;

import java.io.IOException;
import java.net.InetAddress;
import java.util.Map;
import org.apache.log4j.Category;
import org.apache.log4j.Level;
import org.opennms.core.utils.ThreadCategory;
import org.opennms.netmgt.model.PollStatus;
import org.opennms.netmgt.poller.Distributable;
import org.opennms.netmgt.poller.DistributionContext;
import org.opennms.netmgt.poller.MonitoredService;
import org.opennms.netmgt.poller.NetworkInterface;
import org.opennms.netmgt.poller.NetworkInterfaceNotSupportedException;
import org.opennms.netmgt.poller.monitors.IPv4Monitor;
import org.opennms.netmgt.poller.monitors.TimeoutTracker;
import org.opennms.netmgt.utils.ExecRunner;
import org.opennms.netmgt.utils.ParameterMap;

@Distributable(value={DistributionContext.DAEMON})
public final class GpMonitor
extends IPv4Monitor {
    private static final int DEFAULT_RETRY = 0;
    private static final int DEFAULT_TIMEOUT = 3000;

    public PollStatus poll(MonitoredService svc, Map parameters) {
        NetworkInterface iface = svc.getNetInterface();
        Category log = ThreadCategory.getInstance(this.getClass());
        if (iface.getType() != 1) {
            throw new NetworkInterfaceNotSupportedException("Unsupported interface type, only TYPE_IPV4 currently supported");
        }
        TimeoutTracker tracker = new TimeoutTracker(parameters, 0, 3000);
        String hoption = ParameterMap.getKeyedString(parameters, "hoption", "--hostname");
        String toption = ParameterMap.getKeyedString(parameters, "toption", "--timeout");
        String args = ParameterMap.getKeyedString(parameters, "args", null);
        String script = ParameterMap.getKeyedString(parameters, "script", null);
        if (script == null) {
            throw new RuntimeException("GpMonitor: required parameter 'script' is not present in supplied properties.");
        }
        String strBannerMatch = (String)parameters.get("banner");
        InetAddress ipv4Addr = (InetAddress)iface.getAddress();
        if (log.isDebugEnabled()) {
            log.debug((Object)("poll: address = " + ipv4Addr.getHostAddress() + ", script = " + script + ", arguments = " + args + ", " + tracker));
        }
        PollStatus serviceStatus = PollStatus.unavailable();
        tracker.reset();
        while (tracker.shouldRetry() && !serviceStatus.isAvailable()) {
            try {
                tracker.startAttempt();
                int exitStatus = 100;
                int timeoutInSeconds = (int)tracker.getTimeoutInSeconds();
                ExecRunner er = new ExecRunner();
                er.setMaxRunTimeSecs(timeoutInSeconds);
                exitStatus = args == null ? er.exec(script + " " + hoption + " " + ipv4Addr.getHostAddress() + " " + toption + " " + timeoutInSeconds) : er.exec(script + " " + hoption + " " + ipv4Addr.getHostAddress() + " " + toption + " " + timeoutInSeconds + " " + args);
                double responseTime = tracker.elapsedTimeInMillis();
                if (exitStatus != 0) {
                    serviceStatus = this.logDown(Level.DEBUG, script + " failed with exit code " + exitStatus);
                }
                if (er.isMaxRunTimeExceeded()) {
                    serviceStatus = this.logDown(Level.DEBUG, script + " failed. Timeout exceeded");
                } else if (exitStatus == 0) {
                    String scriptoutput = "";
                    scriptoutput = er.getOutString();
                    String scripterror = "";
                    scripterror = er.getErrString();
                    if (!scriptoutput.equals("")) {
                        log.debug((Object)(script + " output  = " + scriptoutput));
                    } else {
                        log.debug((Object)(script + " returned no output"));
                    }
                    if (!scripterror.equals("")) {
                        log.debug((Object)(script + " error = " + scripterror));
                    }
                    serviceStatus = strBannerMatch == null || strBannerMatch.equals("*") ? PollStatus.available((Double)responseTime) : (scriptoutput.indexOf(strBannerMatch) > -1 ? PollStatus.available((Double)responseTime) : PollStatus.unavailable((String)(script + "banner not contained in output banner='" + strBannerMatch + "' output='" + scriptoutput + "'")));
                }
            }
            catch (ArrayIndexOutOfBoundsException e) {
                serviceStatus = this.logDown(Level.DEBUG, script + " ArrayIndexOutOfBoundsException", e);
            }
            catch (IOException e) {
                serviceStatus = this.logDown(Level.DEBUG, "IOException occurred. Check for proper operation of " + script, e);
            }
            catch (Exception e) {
                serviceStatus = this.logDown(Level.DEBUG, script + "Exception occurred", e);
            }
            tracker.nextAttempt();
        }
        log.debug((Object)("poll: GP - serviceStatus= " + serviceStatus + "  " + ipv4Addr.getHostAddress()));
        return serviceStatus;
    }
}

