/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.poller.monitors;

import java.io.IOException;
import java.lang.reflect.UndeclaredThrowableException;
import java.net.InetAddress;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Level;
import org.exolab.castor.xml.MarshalException;
import org.exolab.castor.xml.ValidationException;
import org.opennms.netmgt.config.SnmpPeerFactory;
import org.opennms.netmgt.model.PollStatus;
import org.opennms.netmgt.poller.Distributable;
import org.opennms.netmgt.poller.DistributionContext;
import org.opennms.netmgt.poller.MonitoredService;
import org.opennms.netmgt.poller.NetworkInterface;
import org.opennms.netmgt.poller.monitors.SnmpMonitorStrategy;
import org.opennms.netmgt.snmp.SnmpAgentConfig;
import org.opennms.netmgt.snmp.SnmpObjId;
import org.opennms.netmgt.snmp.SnmpUtils;
import org.opennms.netmgt.snmp.SnmpValue;
import org.opennms.netmgt.utils.ParameterMap;

@Distributable(value={DistributionContext.DAEMON})
public final class BgpSessionMonitor
extends SnmpMonitorStrategy {
    private static final String m_serviceName = "BGP_Session";
    static final String SNMP_AGENTCONFIG_KEY = "org.opennms.netmgt.snmp.SnmpAgentConfig";
    private static final String BGP_PEER_STATE_OID = ".1.3.6.1.2.1.15.3.1.2";
    private static final String BGP_PEER_ADMIN_STATE_OID = ".1.3.6.1.2.1.15.3.1.3";
    private static final String BGP_PEER_REMOTEAS_OID = ".1.3.6.1.2.1.15.3.1.9";
    private static final String BGP_PEER_LAST_ERROR_OID = ".1.3.6.1.2.1.15.3.1.14";
    private static final String BGP_PEER_FSM_EST_TIME_OID = ".1.3.6.1.2.1.15.3.1.16";
    private static final int BGP_STATE_ESTABLISHED = 6;

    public String serviceName() {
        return m_serviceName;
    }

    public void initialize(Map parameters) {
        try {
            SnmpPeerFactory.init();
        }
        catch (MarshalException ex) {
            this.log().fatal((Object)"initialize: Failed to load SNMP configuration", (Throwable)ex);
            throw new UndeclaredThrowableException(ex);
        }
        catch (ValidationException ex) {
            this.log().fatal((Object)"initialize: Failed to load SNMP configuration", (Throwable)ex);
            throw new UndeclaredThrowableException(ex);
        }
        catch (IOException ex) {
            this.log().fatal((Object)"initialize: Failed to load SNMP configuration", (Throwable)ex);
            throw new UndeclaredThrowableException(ex);
        }
    }

    public void initialize(MonitoredService svc) {
        NetworkInterface iface = svc.getNetInterface();
        super.initialize(svc);
        InetAddress ipAddr = (InetAddress)iface.getAddress();
        SnmpAgentConfig agentConfig = SnmpPeerFactory.getInstance().getAgentConfig(ipAddr);
        if (this.log().isDebugEnabled()) {
            this.log().debug((Object)("initialize: SnmpAgentConfig address: " + agentConfig));
        }
        if (this.log().isDebugEnabled()) {
            this.log().debug((Object)("initialize: BgpSessionMonitor setting SNMP peer attribute for interface " + ipAddr.getHostAddress()));
        }
        iface.setAttribute(SNMP_AGENTCONFIG_KEY, agentConfig);
        this.log().debug((Object)("initialize: interface: " + agentConfig.getAddress() + " initialized."));
    }

    public PollStatus poll(MonitoredService svc, Map parameters) {
        NetworkInterface iface = svc.getNetInterface();
        String returnValue = new String();
        PollStatus status = PollStatus.unavailable();
        InetAddress ipaddr = (InetAddress)iface.getAddress();
        SnmpAgentConfig agentConfig = (SnmpAgentConfig)iface.getAttribute(SNMP_AGENTCONFIG_KEY);
        if (agentConfig == null) {
            throw new RuntimeException("SnmpAgentConfig object not available for interface " + ipaddr);
        }
        String bgpPeerIp = ParameterMap.getKeyedString(parameters, "bgpPeerIp", null);
        agentConfig.setTimeout(ParameterMap.getKeyedInteger(parameters, "timeout", agentConfig.getTimeout()));
        agentConfig.setRetries(ParameterMap.getKeyedInteger(parameters, "retry", ParameterMap.getKeyedInteger(parameters, "retries", agentConfig.getRetries())));
        agentConfig.setPort(ParameterMap.getKeyedInteger(parameters, "port", agentConfig.getPort()));
        try {
            if (this.log().isDebugEnabled()) {
                this.log().debug((Object)("BgpSessionMonitor.poll: SnmpAgentConfig address: " + agentConfig));
            }
            if (bgpPeerIp == null) {
                this.log().warn((Object)"BgpSessionMonitor.poll: No BGP-Peer IP Defined! ");
                return status;
            }
            SnmpObjId bgpPeerStateSnmpObject = SnmpObjId.get((String)(".1.3.6.1.2.1.15.3.1.2." + bgpPeerIp));
            SnmpValue bgpPeerState = SnmpUtils.get((SnmpAgentConfig)agentConfig, (SnmpObjId)bgpPeerStateSnmpObject);
            if (this.log().isDebugEnabled()) {
                this.log().debug((Object)("BgpSessionMonitor.poll: bgpPeerState: " + bgpPeerState));
            }
            SnmpObjId bgpPeerAdminStateSnmpObject = SnmpObjId.get((String)(".1.3.6.1.2.1.15.3.1.3." + bgpPeerIp));
            SnmpValue bgpPeerAdminState = SnmpUtils.get((SnmpAgentConfig)agentConfig, (SnmpObjId)bgpPeerAdminStateSnmpObject);
            if (this.log().isDebugEnabled()) {
                this.log().debug((Object)("BgpSessionMonitor.poll: bgpPeerAdminState: " + bgpPeerAdminState));
            }
            SnmpObjId bgpPeerRemoteAsSnmpObject = SnmpObjId.get((String)(".1.3.6.1.2.1.15.3.1.9." + bgpPeerIp));
            SnmpValue bgpPeerRemoteAs = SnmpUtils.get((SnmpAgentConfig)agentConfig, (SnmpObjId)bgpPeerRemoteAsSnmpObject);
            if (this.log().isDebugEnabled()) {
                this.log().debug((Object)("BgpSessionMonitor.poll: bgpPeerRemoteAs: " + bgpPeerRemoteAs));
            }
            SnmpObjId bgpPeerLastErrorSnmpObject = SnmpObjId.get((String)(".1.3.6.1.2.1.15.3.1.14." + bgpPeerIp));
            SnmpValue bgpPeerLastError = SnmpUtils.get((SnmpAgentConfig)agentConfig, (SnmpObjId)bgpPeerLastErrorSnmpObject);
            if (this.log().isDebugEnabled()) {
                this.log().debug((Object)("BgpSessionMonitor.poll: bgpPeerLastError: " + bgpPeerLastError.toHexString() + " - decoded: " + this.resolveBgpErrorCode(bgpPeerLastError.toHexString())));
            }
            SnmpObjId bgpPeerFsmEstTimeSnmpObject = SnmpObjId.get((String)(".1.3.6.1.2.1.15.3.1.16." + bgpPeerIp));
            SnmpValue bgpPeerFsmEstTime = SnmpUtils.get((SnmpAgentConfig)agentConfig, (SnmpObjId)bgpPeerFsmEstTimeSnmpObject);
            if (this.log().isDebugEnabled()) {
                this.log().debug((Object)("BgpSessionMonitor.poll: bgpPeerFsmEstTime: " + bgpPeerFsmEstTime));
            }
            if (bgpPeerState == null || bgpPeerState.isNull()) {
                this.log().debug((Object)("BgpSessionMonitor poll failed: no results, addr=" + ipaddr.getHostAddress() + " oid=" + bgpPeerStateSnmpObject));
                returnValue = "No result for " + bgpPeerIp;
                status = PollStatus.unavailable((String)returnValue);
            }
            if (bgpPeerState.toInt() != 6) {
                returnValue = "BGP Session to AS" + bgpPeerRemoteAs + " via " + bgpPeerIp + " is not established! Last peer " + "error message is " + this.resolveBgpErrorCode(bgpPeerLastError.toHexString()) + ". BGP admin state is " + bgpPeerAdminState + ". BGP Session established time: " + bgpPeerFsmEstTime;
                status = PollStatus.unavailable((String)returnValue);
            }
            if (bgpPeerState.toInt() == 6) {
                status = PollStatus.available();
            }
        }
        catch (NumberFormatException e) {
            status = this.logDown(Level.ERROR, "Number operator used on a non-number " + e.getMessage());
        }
        catch (IllegalArgumentException e) {
            status = this.logDown(Level.ERROR, "Invalid Snmp Criteria: " + e.getMessage());
        }
        catch (Throwable t) {
            status = this.logDown(Level.WARN, "Unexpected exception during SNMP poll of interface " + ipaddr.getHostAddress(), t);
        }
        return status;
    }

    public String resolveBgpErrorCode(String bgpCode) {
        String clearCode = "unknown error";
        HashMap<String, String> codeMap = new HashMap<String, String>();
        codeMap.put("0100", "Message Header Error");
        codeMap.put("0101", "Message Header Error - Connection Not Synchronized");
        codeMap.put("0102", "Message Header Error - Bad Message Length");
        codeMap.put("0103", "Message Header Error - Bad Message Type");
        codeMap.put("0200", "OPEN Message Error");
        codeMap.put("0201", "OPEN Message Error - Unsupported Version Number");
        codeMap.put("0202", "OPEN Message Error - Bad Peer AS");
        codeMap.put("0203", "OPEN Message Error - Bad BGP Identifier");
        codeMap.put("0204", "OPEN Message Error - Unsupported Optional Parameter");
        codeMap.put("0205", "OPEN Message Error (deprecated)");
        codeMap.put("0206", "OPEN Message Error - Unacceptable Hold Time");
        codeMap.put("0300", "UPDATE Message Error");
        codeMap.put("0301", "UPDATE Message Error - Malformed Attribute List");
        codeMap.put("0302", "UPDATE Message Error - Unrecognized Well-known Attribute");
        codeMap.put("0303", "UPDATE Message Error - Missing Well-known Attribute");
        codeMap.put("0304", "UPDATE Message Error - Attribute Flags Error");
        codeMap.put("0305", "UPDATE Message Error - Attribute Length Error");
        codeMap.put("0306", "UPDATE Message Error - Invalid ORIGIN Attribute");
        codeMap.put("0307", "UPDATE Message Error (deprecated)");
        codeMap.put("0308", "UPDATE Message Error - Invalid NEXT_HOP Attribute");
        codeMap.put("0309", "UPDATE Message Error - Optional Attribute Error");
        codeMap.put("030A", "UPDATE Message Error - Invalid Network Field");
        codeMap.put("030B", "UPDATE Message Error - Malformed AS_PATH");
        codeMap.put("0400", "Hold Timer Expired");
        codeMap.put("0500", "Finite State Machine Error");
        codeMap.put("0600", "Cease");
        codeMap.put("0601", "Cease - Maximum Number of Prefixes Reached");
        codeMap.put("0602", "Cease - Administrative Shutdown");
        codeMap.put("0603", "Cease - Peer De-configured");
        codeMap.put("0604", "Cease - Administrative Reset");
        codeMap.put("0605", "Cease - Connection Rejected");
        codeMap.put("0606", "Cease - Other Configuration Change");
        codeMap.put("0607", "Cease - Connection Collision Resolution");
        codeMap.put("0608", "Cease - Out of Resources");
        if (codeMap.containsKey(bgpCode)) {
            clearCode = (String)codeMap.get(bgpCode);
        }
        return clearCode;
    }
}

