/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.poller;

import java.lang.reflect.UndeclaredThrowableException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.Date;
import java.util.Enumeration;
import javax.sql.DataSource;
import org.apache.log4j.Category;
import org.apache.log4j.Level;
import org.apache.log4j.Priority;
import org.opennms.core.utils.ThreadCategory;
import org.opennms.netmgt.config.PollOutagesConfig;
import org.opennms.netmgt.config.PollerConfig;
import org.opennms.netmgt.config.poller.Package;
import org.opennms.netmgt.daemon.AbstractServiceDaemon;
import org.opennms.netmgt.eventd.EventIpcManager;
import org.opennms.netmgt.model.PollStatus;
import org.opennms.netmgt.poller.PollerEventProcessor;
import org.opennms.netmgt.poller.QueryManager;
import org.opennms.netmgt.poller.ServiceMonitor;
import org.opennms.netmgt.poller.pollables.DbPollEvent;
import org.opennms.netmgt.poller.pollables.PollableNetwork;
import org.opennms.netmgt.poller.pollables.PollableNode;
import org.opennms.netmgt.poller.pollables.PollableService;
import org.opennms.netmgt.poller.pollables.PollableServiceConfig;
import org.opennms.netmgt.poller.pollables.PollableVisitorAdaptor;
import org.opennms.netmgt.scheduler.LegacyScheduler;
import org.opennms.netmgt.scheduler.Schedule;
import org.opennms.netmgt.scheduler.Scheduler;
import org.opennms.netmgt.utils.Querier;
import org.opennms.netmgt.utils.Updater;

public class Poller
extends AbstractServiceDaemon {
    private static final Poller m_singleton = new Poller();
    private boolean m_initialized = false;
    private LegacyScheduler m_scheduler = null;
    private PollerEventProcessor m_eventProcessor;
    private PollableNetwork m_network;
    private QueryManager m_queryManager;
    private PollerConfig m_pollerConfig;
    private PollOutagesConfig m_pollOutagesConfig;
    private EventIpcManager m_eventMgr;
    private DataSource m_dataSource;

    public Poller() {
        super("OpenNMS.Poller");
    }

    public void setDataSource(DataSource dataSource) {
        this.m_dataSource = dataSource;
    }

    public EventIpcManager getEventManager() {
        return this.m_eventMgr;
    }

    public void setEventManager(EventIpcManager eventMgr) {
        this.m_eventMgr = eventMgr;
    }

    public PollerEventProcessor getEventProcessor() {
        return this.m_eventProcessor;
    }

    public void setEventProcessor(PollerEventProcessor eventProcessor) {
        this.m_eventProcessor = eventProcessor;
    }

    public PollableNetwork getNetwork() {
        return this.m_network;
    }

    public void setNetwork(PollableNetwork network) {
        this.m_network = network;
    }

    public void setQueryManager(QueryManager queryManager) {
        this.m_queryManager = queryManager;
    }

    public QueryManager getQueryManager() {
        return this.m_queryManager;
    }

    public PollerConfig getPollerConfig() {
        return this.m_pollerConfig;
    }

    public void setPollerConfig(PollerConfig pollerConfig) {
        this.m_pollerConfig = pollerConfig;
    }

    public PollOutagesConfig getPollOutagesConfig() {
        return this.m_pollOutagesConfig;
    }

    public void setPollOutagesConfig(PollOutagesConfig pollOutagesConfig) {
        this.m_pollOutagesConfig = pollOutagesConfig;
    }

    public Scheduler getScheduler() {
        return this.m_scheduler;
    }

    public void setScheduler(LegacyScheduler scheduler) {
        this.m_scheduler = scheduler;
    }

    protected void onInit() {
        this.log().debug((Object)("init: serviceUnresponsive behavior: " + (this.getPollerConfig().serviceUnresponsiveEnabled() ? "enabled" : "disabled")));
        this.createScheduler();
        try {
            this.log().debug((Object)"init: Closing outages for unmanaged services");
            this.closeOutagesForUnmanagedServices();
        }
        catch (Exception e) {
            this.log().error((Object)"init: Failed to close ouates for unmanage services", (Throwable)e);
        }
        try {
            this.log().debug((Object)"start: Scheduling existing interfaces");
            this.scheduleExistingServices();
        }
        catch (Exception sqlE) {
            this.log().error((Object)"start: Failed to schedule existing interfaces", (Throwable)sqlE);
        }
        try {
            this.log().debug((Object)"start: Creating event broadcast event processor");
            this.setEventProcessor(new PollerEventProcessor(this));
        }
        catch (Throwable t) {
            this.log().fatal((Object)"start: Failed to initialized the broadcast event receiver", t);
            throw new UndeclaredThrowableException(t);
        }
        this.m_initialized = true;
    }

    private void closeOutagesForUnmanagedServices() {
        Timestamp closeTime = new Timestamp(new Date().getTime());
        String DB_CLOSE_OUTAGES_FOR_UNMANAGED_SERVICES = "UPDATE outages set ifregainedservice = ? where outageid in (select outages.outageid from outages, ifservices where ((outages.nodeid = ifservices.nodeid) AND (outages.ipaddr = ifservices.ipaddr) AND (outages.serviceid = ifservices.serviceid) AND ((ifservices.status = 'D') OR (ifservices.status = 'F') OR (ifservices.status = 'U')) AND (outages.ifregainedservice IS NULL)))";
        Updater svcUpdater = new Updater(this.m_dataSource, "UPDATE outages set ifregainedservice = ? where outageid in (select outages.outageid from outages, ifservices where ((outages.nodeid = ifservices.nodeid) AND (outages.ipaddr = ifservices.ipaddr) AND (outages.serviceid = ifservices.serviceid) AND ((ifservices.status = 'D') OR (ifservices.status = 'F') OR (ifservices.status = 'U')) AND (outages.ifregainedservice IS NULL)))");
        svcUpdater.execute(closeTime);
        String DB_CLOSE_OUTAGES_FOR_UNMANAGED_INTERFACES = "UPDATE outages set ifregainedservice = ? where outageid in (select outages.outageid from outages, ipinterface where ((outages.nodeid = ipinterface.nodeid) AND (outages.ipaddr = ipinterface.ipaddr) AND ((ipinterface.ismanaged = 'F') OR (ipinterface.ismanaged = 'U')) AND (outages.ifregainedservice IS NULL)))";
        Updater ifUpdater = new Updater(this.m_dataSource, "UPDATE outages set ifregainedservice = ? where outageid in (select outages.outageid from outages, ipinterface where ((outages.nodeid = ipinterface.nodeid) AND (outages.ipaddr = ipinterface.ipaddr) AND ((ipinterface.ismanaged = 'F') OR (ipinterface.ismanaged = 'U')) AND (outages.ifregainedservice IS NULL)))");
        ifUpdater.execute(closeTime);
    }

    public void closeOutagesForNode(Date closeDate, int eventId, int nodeId) {
        Timestamp closeTime = new Timestamp(closeDate.getTime());
        String DB_CLOSE_OUTAGES_FOR_NODE = "UPDATE outages set ifregainedservice = ?, svcRegainedEventId = ? where outages.nodeId = ? AND (outages.ifregainedservice IS NULL)";
        Updater svcUpdater = new Updater(this.m_dataSource, "UPDATE outages set ifregainedservice = ?, svcRegainedEventId = ? where outages.nodeId = ? AND (outages.ifregainedservice IS NULL)");
        svcUpdater.execute(closeTime, new Integer(eventId), new Integer(nodeId));
    }

    public void closeOutagesForInterface(Date closeDate, int eventId, int nodeId, String ipAddr) {
        Timestamp closeTime = new Timestamp(closeDate.getTime());
        String DB_CLOSE_OUTAGES_FOR_IFACE = "UPDATE outages set ifregainedservice = ?, svcRegainedEventId = ? where outages.nodeId = ? AND outages.ipAddr = ? AND (outages.ifregainedservice IS NULL)";
        Updater svcUpdater = new Updater(this.m_dataSource, "UPDATE outages set ifregainedservice = ?, svcRegainedEventId = ? where outages.nodeId = ? AND outages.ipAddr = ? AND (outages.ifregainedservice IS NULL)");
        svcUpdater.execute(closeTime, new Integer(eventId), new Integer(nodeId), ipAddr);
    }

    public void closeOutagesForService(Date closeDate, int eventId, int nodeId, String ipAddr, String serviceName) {
        Timestamp closeTime = new Timestamp(closeDate.getTime());
        String DB_CLOSE_OUTAGES_FOR_SERVICE = "UPDATE outages set ifregainedservice = ?, svcRegainedEventId = ? where outageid in (select outages.outageid from outages, service where outages.nodeid = ? AND outages.ipaddr = ? AND outages.serviceid = service.serviceId AND service.servicename = ? AND outages.ifregainedservice IS NULL)";
        Updater svcUpdater = new Updater(this.m_dataSource, "UPDATE outages set ifregainedservice = ?, svcRegainedEventId = ? where outageid in (select outages.outageid from outages, service where outages.nodeid = ? AND outages.ipaddr = ? AND outages.serviceid = service.serviceId AND service.servicename = ? AND outages.ifregainedservice IS NULL)");
        svcUpdater.execute(closeTime, new Integer(eventId), new Integer(nodeId), ipAddr, serviceName);
    }

    private void createScheduler() {
        Category log = ThreadCategory.getInstance(this.getClass());
        try {
            log.debug((Object)"init: Creating poller scheduler");
            this.setScheduler(new LegacyScheduler("Poller", this.getPollerConfig().getThreads()));
        }
        catch (RuntimeException e) {
            log.fatal((Object)"init: Failed to create poller scheduler", (Throwable)e);
            throw e;
        }
    }

    protected void onStart() {
        try {
            if (this.log().isDebugEnabled()) {
                this.log().debug((Object)"start: Starting poller scheduler");
            }
            this.getScheduler().start();
        }
        catch (RuntimeException e) {
            if (this.log().isEnabledFor((Priority)Level.FATAL)) {
                this.log().fatal((Object)"start: Failed to start scheduler", (Throwable)e);
            }
            throw e;
        }
    }

    protected void onStop() {
        if (this.getScheduler() != null) {
            this.getScheduler().stop();
        }
        if (this.getEventProcessor() != null) {
            this.getEventProcessor().close();
        }
        this.releaseServiceMonitors();
        this.setScheduler(null);
    }

    private void releaseServiceMonitors() {
        this.getPollerConfig().releaseAllServiceMonitors();
    }

    protected void onPause() {
        this.getScheduler().pause();
    }

    protected void onResume() {
        this.getScheduler().resume();
    }

    public static Poller getInstance() {
        return m_singleton;
    }

    public ServiceMonitor getServiceMonitor(String svcName) {
        return this.getPollerConfig().getServiceMonitor(svcName);
    }

    private void scheduleExistingServices() throws Exception {
        Category log = ThreadCategory.getInstance(this.getClass());
        this.scheduleMatchingServices(null);
        this.getNetwork().recalculateStatus();
        this.getNetwork().propagateInitialCause();
        this.getNetwork().resetStatusChanged();
        if (log.isDebugEnabled()) {
            log.debug((Object)"scheduleExistingServices: dumping content of pollable network: ");
            this.getNetwork().dump();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void scheduleService(final int nodeId, String nodeLabel, final String ipAddr, final String svcName) {
        final Category log = ThreadCategory.getInstance(this.getClass());
        try {
            PollableNode node;
            PollableNetwork pollableNetwork = this.getNetwork();
            synchronized (pollableNetwork) {
                node = this.getNetwork().getNode(nodeId);
                if (node == null) {
                    node = this.getNetwork().createNode(nodeId, nodeLabel);
                }
            }
            final PollableNode svcNode = node;
            Runnable r = new Runnable(){

                public void run() {
                    int matchCount = Poller.this.scheduleMatchingServices("ifServices.nodeId = " + nodeId + " AND ifServices.ipAddr = '" + ipAddr + "' AND service.serviceName = '" + svcName + "'");
                    if (matchCount > 0) {
                        svcNode.recalculateStatus();
                        svcNode.processStatusChange(new Date());
                    } else {
                        log.warn((Object)("Attempt to schedule service " + nodeId + "/" + ipAddr + "/" + svcName + " found no active service"));
                    }
                }
            };
            node.withTreeLock(r);
        }
        catch (Exception e) {
            log.error((Object)("Unable to schedule service " + nodeId + "/" + ipAddr + "/" + svcName), (Throwable)e);
        }
    }

    private int scheduleMatchingServices(String criteria) {
        String sql = "SELECT ifServices.nodeId AS nodeId, node.nodeLabel AS nodeLabel, ifServices.ipAddr AS ipAddr, ifServices.serviceId AS serviceId, service.serviceName AS serviceName, outages.svcLostEventId AS svcLostEventId, events.eventUei AS svcLostEventUei, outages.ifLostService AS ifLostService, outages.ifRegainedService AS ifRegainedService FROM ifServices JOIN node ON ifServices.nodeId = node.nodeId JOIN service ON ifServices.serviceId = service.serviceId LEFT OUTER JOIN outages ON ifServices.nodeId = outages.nodeId AND ifServices.ipAddr = outages.ipAddr AND ifServices.serviceId = outages.serviceId AND ifRegainedService IS NULL LEFT OUTER JOIN events ON outages.svcLostEventId = events.eventid WHERE ifServices.status = 'A'" + (criteria == null ? "" : " AND " + criteria);
        Querier querier = new Querier(this.m_dataSource, sql){

            public void processRow(ResultSet rs) throws SQLException {
                Poller.this.scheduleService(rs.getInt("nodeId"), rs.getString("nodeLabel"), rs.getString("ipAddr"), rs.getString("serviceName"), (Number)rs.getObject("svcLostEventId"), rs.getTimestamp("ifLostService"), rs.getString("svcLostEventUei"));
            }
        };
        querier.execute();
        return querier.getCount();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void scheduleService(int nodeId, String nodeLabel, String ipAddr, String serviceName, Number svcLostEventId, Date date, String svcLostUei) {
        InetAddress addr;
        Category log = ThreadCategory.getInstance();
        Package pkg = this.findPackageForService(ipAddr, serviceName);
        if (pkg == null) {
            log.warn((Object)("Active service " + serviceName + " on " + ipAddr + " not configured for any package"));
            return;
        }
        ServiceMonitor monitor = this.m_pollerConfig.getServiceMonitor(serviceName);
        if (monitor == null) {
            log.info((Object)("Could not find service monitor associated with service " + serviceName));
            return;
        }
        try {
            addr = InetAddress.getByName(ipAddr);
        }
        catch (UnknownHostException e) {
            log.error((Object)("Could not convert " + ipAddr + " as an InetAddress " + ipAddr));
            return;
        }
        PollableService svc = this.getNetwork().createService(nodeId, nodeLabel, addr, serviceName);
        PollableServiceConfig pollConfig = new PollableServiceConfig(svc, this.m_pollerConfig, this.m_pollOutagesConfig, pkg, this.getScheduler());
        svc.setPollConfig(pollConfig);
        PollableService pollableService = svc;
        synchronized (pollableService) {
            if (svc.getSchedule() == null) {
                Schedule schedule = new Schedule(svc, pollConfig, this.getScheduler());
                svc.setSchedule(schedule);
            }
        }
        if (svcLostEventId == null) {
            if (svc.getParent().getStatus().isUnknown()) {
                svc.updateStatus(PollStatus.up());
            } else {
                svc.updateStatus(svc.getParent().getStatus());
            }
        } else {
            svc.updateStatus(PollStatus.down());
            DbPollEvent cause = new DbPollEvent(svcLostEventId.intValue(), svcLostUei, date);
            svc.setCause(cause);
        }
        svc.schedule();
    }

    private Package findPackageForService(String ipAddr, String serviceName) {
        Enumeration<Package> en = this.m_pollerConfig.enumeratePackage();
        Package lastPkg = null;
        while (en.hasMoreElements()) {
            Package pkg = en.nextElement();
            if (!this.pollableServiceInPackage(ipAddr, serviceName, pkg)) continue;
            lastPkg = pkg;
        }
        return lastPkg;
    }

    protected boolean pollableServiceInPackage(String ipAddr, String serviceName, Package pkg) {
        if (pkg.getRemote()) {
            this.log().debug((Object)("pollableServiceInPackage: this package: " + pkg.getName() + ", is a remote monitor package."));
            return false;
        }
        if (!this.m_pollerConfig.serviceInPackageAndEnabled(serviceName, pkg)) {
            return false;
        }
        boolean inPkg = this.m_pollerConfig.interfaceInPackage(ipAddr, pkg);
        if (inPkg) {
            return true;
        }
        if (this.m_initialized) {
            this.m_pollerConfig.rebuildPackageIpListMap();
            return this.m_pollerConfig.interfaceInPackage(ipAddr, pkg);
        }
        return false;
    }

    public boolean packageIncludesIfAndSvc(Package pkg, String ipAddr, String svcName) {
        Category log = ThreadCategory.getInstance();
        if (!this.getPollerConfig().serviceInPackageAndEnabled(svcName, pkg)) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("packageIncludesIfAndSvc: address/service: " + ipAddr + "/" + svcName + " not scheduled, service is not enabled or does not exist in package: " + pkg.getName()));
            }
            return false;
        }
        if (!this.getPollerConfig().interfaceInPackage(ipAddr, pkg)) {
            if (this.m_initialized) {
                this.getPollerConfig().rebuildPackageIpListMap();
                if (!this.getPollerConfig().interfaceInPackage(ipAddr, pkg)) {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("packageIncludesIfAndSvc: interface " + ipAddr + " gained service " + svcName + ", but the interface was not in package: " + pkg.getName()));
                    }
                    return false;
                }
            } else {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("packageIncludesIfAndSvc: address/service: " + ipAddr + "/" + svcName + " not scheduled, interface does not belong to package: " + pkg.getName()));
                }
                return false;
            }
        }
        return true;
    }

    public void refreshServicePackages() {
        PollableVisitorAdaptor visitor = new PollableVisitorAdaptor(){

            public void visitService(PollableService service) {
                service.refreshConfig();
            }
        };
        this.getNetwork().visit(visitor);
    }
}

