/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.poller;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.sql.DataSource;
import org.apache.log4j.Category;
import org.opennms.core.utils.ThreadCategory;
import org.opennms.netmgt.EventConstants;
import org.opennms.netmgt.config.OpennmsServerConfigFactory;
import org.opennms.netmgt.poller.IfKey;
import org.opennms.netmgt.poller.Poller;
import org.opennms.netmgt.poller.QueryManager;
import org.opennms.netmgt.utils.Querier;
import org.opennms.netmgt.utils.SingleResultQuerier;
import org.opennms.netmgt.utils.Updater;

public class DefaultQueryManager
implements QueryManager {
    static final String SQL_RETRIEVE_INTERFACES = "SELECT nodeid,ipaddr FROM ifServices, service WHERE ifServices.serviceid = service.serviceid AND service.servicename = ? AND ifServices.status='A'";
    static final String SQL_RETRIEVE_SERVICE_IDS = "SELECT serviceid,servicename  FROM service";
    static final String SQL_RETRIEVE_SERVICE_STATUS = "SELECT ifregainedservice,iflostservice FROM outages WHERE nodeid = ? AND ipaddr = ? AND serviceid = ? AND iflostservice = (SELECT max(iflostservice) FROM outages WHERE nodeid = ? AND ipaddr = ? AND serviceid = ?)";
    static final String SQL_COUNT_IFSERVICE_STATUS = "select count(*) FROM ifServices, service WHERE nodeid=? AND ipaddr=? AND status='A' AND ifServices.serviceid=service.serviceid AND service.servicename=?";
    static final String SQL_COUNT_IFSERVICES_TO_POLL = "SELECT COUNT(*) FROM ifservices WHERE status = 'A' AND ipaddr = ?";
    static final String SQL_FETCH_IFSERVICES_TO_POLL = "SELECT if.serviceid FROM ifservices if, service s WHERE if.serviceid = s.serviceid AND if.status = 'A' AND if.ipaddr = ?";
    private DataSource m_dataSource;

    public void setDataSource(DataSource dataSource) {
        this.m_dataSource = dataSource;
    }

    public DataSource getDataSource() {
        return this.m_dataSource;
    }

    private Connection getConnection() throws SQLException {
        return this.getDataSource().getConnection();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public boolean activeServiceExists(String whichEvent, int nodeId, String ipAddr, String serviceName) {
        block25: {
            ResultSet rs;
            PreparedStatement stmt;
            Connection dbConn;
            Category log;
            block24: {
                block22: {
                    log = this.log();
                    dbConn = null;
                    stmt = null;
                    rs = null;
                    dbConn = this.getConnection();
                    stmt = dbConn.prepareStatement(SQL_COUNT_IFSERVICE_STATUS);
                    stmt.setInt(1, nodeId);
                    stmt.setString(2, ipAddr);
                    stmt.setString(3, serviceName);
                    rs = stmt.executeQuery();
                    if (!rs.next()) break block22;
                    boolean bl = rs.getInt(1) > 0;
                    Object var11_11 = null;
                    try {
                        if (rs != null) {
                            rs.close();
                        }
                        if (stmt != null) {
                            stmt.close();
                        }
                        if (dbConn != null) {
                            dbConn.close();
                        }
                    }
                    catch (SQLException sqlE2) {
                        // empty catch block
                    }
                    return bl;
                }
                if (!log.isDebugEnabled()) break block24;
                log.debug((Object)(whichEvent + nodeId + "/" + ipAddr + "/" + serviceName + " active"));
            }
            Object var11_12 = null;
            try {
                if (rs != null) {
                    rs.close();
                }
                if (stmt != null) {
                    stmt.close();
                }
                if (dbConn != null) {
                    dbConn.close();
                }
                break block25;
            }
            catch (SQLException sqlE2) {}
            break block25;
            {
                catch (SQLException sqlE) {
                    log.error((Object)"SQLException during check to see if nodeid/ip/service is active", (Throwable)sqlE);
                    Object var11_13 = null;
                    try {
                        if (rs != null) {
                            rs.close();
                        }
                        if (stmt != null) {
                            stmt.close();
                        }
                        if (dbConn != null) {
                            dbConn.close();
                        }
                        break block25;
                    }
                    catch (SQLException sqlE2) {}
                }
            }
            catch (Throwable throwable) {
                Object var11_14 = null;
                try {
                    if (rs != null) {
                        rs.close();
                    }
                    if (stmt != null) {
                        stmt.close();
                    }
                    if (dbConn != null) {
                        dbConn.close();
                    }
                }
                catch (SQLException sqlE2) {
                    // empty catch block
                }
                throw throwable;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List getActiveServiceIdsForInterface(String ipaddr) throws SQLException {
        ArrayList<Object> arrayList;
        PreparedStatement stmt;
        Connection dbConn;
        block7: {
            dbConn = this.getConnection();
            stmt = null;
            ResultSet rs = null;
            try {
                ArrayList<Object> serviceIds = new ArrayList<Object>();
                Category log = this.log();
                stmt = dbConn.prepareStatement(SQL_FETCH_IFSERVICES_TO_POLL);
                stmt.setString(1, ipaddr);
                rs = stmt.executeQuery();
                if (log.isDebugEnabled()) {
                    log.debug((Object)("restartPollingInterfaceHandler: retrieve active service to poll on interface: " + ipaddr));
                }
                while (rs.next()) {
                    serviceIds.add(rs.getObject(1));
                }
                arrayList = serviceIds;
                Object var9_8 = null;
                if (rs == null) break block7;
            }
            catch (Throwable throwable) {
                Object var9_9 = null;
                if (rs != null) {
                    rs.close();
                }
                if (stmt != null) {
                    stmt.close();
                }
                dbConn.close();
                throw throwable;
            }
            rs.close();
        }
        if (stmt != null) {
            stmt.close();
        }
        dbConn.close();
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getNodeIDForInterface(String ipaddr) throws SQLException {
        Category log = this.log();
        int nodeid = -1;
        Connection dbConn = null;
        Statement stmt = null;
        ResultSet rs = null;
        try {
            dbConn = this.getConnection();
            stmt = dbConn.createStatement();
            String sql = "SELECT node.nodeid FROM node, ipinterface WHERE ipinterface.ipaddr='" + ipaddr + "' AND ipinterface.nodeid=node.nodeid";
            rs = stmt.executeQuery(sql);
            if (rs.next()) {
                nodeid = rs.getInt(1);
                if (log.isDebugEnabled()) {
                    log.debug((Object)("getNodeLabel: ipaddr=" + ipaddr + " nodeid=" + nodeid));
                }
            }
            Object var9_8 = null;
        }
        catch (Throwable throwable) {
            block18: {
                Object var9_9 = null;
                try {
                    if (rs != null) {
                        rs.close();
                    }
                    if (stmt != null) {
                        stmt.close();
                    }
                }
                catch (Exception e) {
                    log.debug((Object)"getNodeLabel: an exception occured closing the SQL statement", (Throwable)e);
                }
                if (dbConn != null) {
                    try {
                        dbConn.close();
                    }
                    catch (Throwable t) {
                        if (!log.isDebugEnabled()) break block18;
                        log.debug((Object)"getNodeLabel: an exception occured closing the SQL connection", t);
                    }
                }
            }
            throw throwable;
        }
        try {
            if (rs != null) {
                rs.close();
            }
            if (stmt != null) {
                stmt.close();
            }
        }
        catch (Exception e) {
            log.debug((Object)"getNodeLabel: an exception occured closing the SQL statement", (Throwable)e);
        }
        if (dbConn != null) {
            try {
                dbConn.close();
            }
            catch (Throwable t) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)"getNodeLabel: an exception occured closing the SQL connection", t);
                }
            }
        }
        return nodeid;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getNodeLabel(int nodeId) throws SQLException {
        Connection dbConn;
        String nodeLabel;
        Category log;
        block17: {
            log = this.log();
            nodeLabel = null;
            dbConn = null;
            Statement stmt = null;
            ResultSet rs = null;
            try {
                dbConn = this.getConnection();
                stmt = dbConn.createStatement();
                rs = stmt.executeQuery("SELECT nodelabel FROM node WHERE nodeid=" + String.valueOf(nodeId));
                if (rs.next()) {
                    nodeLabel = rs.getString("nodelabel");
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("getNodeLabel: nodeid=" + nodeId + " nodelabel=" + nodeLabel));
                    }
                }
                Object var8_7 = null;
            }
            catch (Throwable throwable) {
                block19: {
                    block18: {
                        Object var8_8 = null;
                        try {
                            if (rs != null) {
                                rs.close();
                            }
                            if (stmt != null) {
                                stmt.close();
                            }
                        }
                        catch (Exception e) {
                            if (!log.isDebugEnabled()) break block18;
                            log.debug((Object)"getNodeLabel: an exception occured closing the SQL statement", (Throwable)e);
                        }
                    }
                    if (dbConn != null) {
                        try {
                            dbConn.close();
                        }
                        catch (Throwable t) {
                            if (!log.isDebugEnabled()) break block19;
                            log.debug((Object)"getNodeLabel: an exception occured closing the SQL connection", t);
                        }
                    }
                }
                throw throwable;
            }
            try {
                if (rs != null) {
                    rs.close();
                }
                if (stmt != null) {
                    stmt.close();
                }
            }
            catch (Exception e) {
                if (!log.isDebugEnabled()) break block17;
                log.debug((Object)"getNodeLabel: an exception occured closing the SQL statement", (Throwable)e);
            }
        }
        if (dbConn != null) {
            try {
                dbConn.close();
            }
            catch (Throwable t) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)"getNodeLabel: an exception occured closing the SQL connection", t);
                }
            }
        }
        return nodeLabel;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getServiceCountForInterface(String ipaddr) throws SQLException {
        int count;
        PreparedStatement stmt;
        Connection dbConn;
        block8: {
            Category log = this.log();
            dbConn = this.getConnection();
            stmt = null;
            ResultSet rs = null;
            count = -1;
            try {
                stmt = dbConn.prepareStatement(SQL_COUNT_IFSERVICES_TO_POLL);
                stmt.setString(1, ipaddr);
                rs = stmt.executeQuery();
                while (rs.next()) {
                    count = rs.getInt(1);
                    if (!log.isDebugEnabled()) continue;
                    log.debug((Object)("restartPollingInterfaceHandler: count active ifservices to poll for interface: " + ipaddr));
                }
                Object var8_7 = null;
                if (rs == null) break block8;
            }
            catch (Throwable throwable) {
                Object var8_8 = null;
                if (rs != null) {
                    rs.close();
                }
                if (stmt != null) {
                    stmt.close();
                }
                if (dbConn != null) {
                    dbConn.close();
                }
                throw throwable;
            }
            rs.close();
        }
        if (stmt != null) {
            stmt.close();
        }
        if (dbConn != null) {
            dbConn.close();
        }
        return count;
    }

    public List getInterfacesWithService(String svcName) throws SQLException {
        Category log = this.log();
        Connection dbConn = this.getConnection();
        if (log.isDebugEnabled()) {
            log.debug((Object)("scheduleExistingInterfaces: dbConn = " + dbConn + ", svcName = " + svcName));
        }
        PreparedStatement stmt = dbConn.prepareStatement(SQL_RETRIEVE_INTERFACES);
        stmt.setString(1, svcName);
        ResultSet rs = stmt.executeQuery();
        ArrayList<IfKey> ifkeys = new ArrayList<IfKey>();
        while (rs.next()) {
            IfKey key = new IfKey(rs.getInt(1), rs.getString(2));
            ifkeys.add(key);
        }
        if (rs != null) {
            rs.close();
        }
        if (stmt != null) {
            stmt.close();
        }
        if (dbConn != null) {
            dbConn.close();
        }
        return ifkeys;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public Date getServiceLostDate(int nodeId, String ipAddr, String svcName, int serviceId) {
        Timestamp lostDate;
        Timestamp regainedDate;
        Date svcLostDate;
        Category log;
        block21: {
            Connection dbConn;
            ResultSet outagesResult;
            PreparedStatement outagesQuery;
            block20: {
                log = ThreadCategory.getInstance(Poller.class);
                log.debug((Object)("getting last known status for address: " + ipAddr + " service: " + svcName));
                svcLostDate = null;
                if (serviceId < 0) {
                    log.warn((Object)("Failed to retrieve service identifier for interface " + ipAddr + " and service '" + svcName + "'"));
                    return svcLostDate;
                }
                outagesQuery = null;
                outagesResult = null;
                regainedDate = null;
                lostDate = null;
                dbConn = null;
                dbConn = this.getConnection();
                outagesQuery = dbConn.prepareStatement(SQL_RETRIEVE_SERVICE_STATUS);
                outagesQuery.setInt(1, nodeId);
                outagesQuery.setString(2, ipAddr);
                outagesQuery.setInt(3, serviceId);
                outagesQuery.setInt(4, nodeId);
                outagesQuery.setString(5, ipAddr);
                outagesQuery.setInt(6, serviceId);
                outagesResult = outagesQuery.executeQuery();
                if (outagesResult.next()) {
                    regainedDate = outagesResult.getTimestamp(1);
                    lostDate = outagesResult.getTimestamp(2);
                    log.debug((Object)("getServiceLastKnownStatus: lostDate: " + lostDate));
                    break block20;
                }
                Date currentDate = new Date(System.currentTimeMillis());
                regainedDate = new Timestamp(currentDate.getTime());
                lostDate = new Timestamp(currentDate.getTime());
            }
            Object var14_14 = null;
            try {
                if (outagesResult != null) {
                    outagesResult.close();
                }
                if (outagesQuery != null) {
                    outagesQuery.close();
                }
                if (dbConn != null) {
                    dbConn.close();
                }
                break block21;
            }
            catch (SQLException slqE) {}
            break block21;
            {
                catch (SQLException sqlE) {
                    log.error((Object)("SQL exception while retrieving last known service status for " + ipAddr + "/" + svcName));
                    Object var14_15 = null;
                    try {
                        if (outagesResult != null) {
                            outagesResult.close();
                        }
                        if (outagesQuery != null) {
                            outagesQuery.close();
                        }
                        if (dbConn != null) {
                            dbConn.close();
                        }
                        break block21;
                    }
                    catch (SQLException slqE) {}
                }
            }
            catch (Throwable throwable) {
                Object var14_16 = null;
                try {
                    if (outagesResult != null) {
                        outagesResult.close();
                    }
                    if (outagesQuery != null) {
                        outagesQuery.close();
                    }
                    if (dbConn != null) {
                        dbConn.close();
                    }
                }
                catch (SQLException slqE) {
                    // empty catch block
                }
                throw throwable;
            }
        }
        if (lostDate != null && regainedDate == null) {
            svcLostDate = new Date(lostDate.getTime());
            log.debug((Object)("getServiceLastKnownStatus: svcLostDate: " + svcLostDate));
        }
        return svcLostDate;
    }

    public Timestamp convertEventTimeToTimeStamp(String time) {
        try {
            Date date = EventConstants.parseToDate((String)time);
            Timestamp eventTime = new Timestamp(date.getTime());
            return eventTime;
        }
        catch (ParseException e) {
            throw new RuntimeException("Invalid date format " + time, e);
        }
    }

    public void openOutage(String outageIdSQL, int nodeId, String ipAddr, String svcName, int dbId, String time) {
        boolean notUpdated = true;
        int serviceId = this.getServiceID(svcName);
        for (int attempt = 0; attempt < 2 && notUpdated; ++attempt) {
            try {
                this.log().info((Object)("openOutage: opening outage for " + nodeId + ":" + ipAddr + ":" + svcName + " with cause " + dbId + ":" + time));
                SingleResultQuerier srq = new SingleResultQuerier(this.getDataSource(), outageIdSQL);
                srq.execute();
                Object outageId = srq.getResult();
                if (outageId == null) {
                    throw new Exception("Null outageId returned from Querier with SQL: " + outageIdSQL);
                }
                String sql = "insert into outages (outageId, svcLostEventId, nodeId, ipAddr, serviceId, ifLostService) values (" + outageId + ", ?, ?, ?, ?, ?)";
                Object[] values = new Object[]{new Integer(dbId), new Integer(nodeId), ipAddr, new Integer(serviceId), this.convertEventTimeToTimeStamp(time)};
                Updater updater = new Updater(this.getDataSource(), sql);
                updater.execute(values);
                notUpdated = false;
                continue;
            }
            catch (Exception e) {
                if (attempt > 1) {
                    this.log().fatal((Object)("openOutage: Second and final attempt failed opening outage for " + nodeId + ":" + ipAddr + ":" + svcName), (Throwable)e);
                    continue;
                }
                this.log().info((Object)("openOutage: First attempt failed opening outage for " + nodeId + ":" + ipAddr + ":" + svcName), (Throwable)e);
            }
        }
    }

    public void resolveOutage(int nodeId, String ipAddr, String svcName, int dbId, String time) {
        boolean notUpdated = true;
        for (int attempt = 0; attempt < 2 && notUpdated; ++attempt) {
            try {
                this.log().info((Object)("resolving outage for " + nodeId + ":" + ipAddr + ":" + svcName + " with resolution " + dbId + ":" + time));
                int serviceId = this.getServiceID(svcName);
                String sql = "update outages set svcRegainedEventId=?, ifRegainedService=? where nodeId = ? and ipAddr = ? and serviceId = ? and ifRegainedService is null";
                Object[] values = new Object[]{new Integer(dbId), this.convertEventTimeToTimeStamp(time), new Integer(nodeId), ipAddr, new Integer(serviceId)};
                Updater updater = new Updater(this.getDataSource(), sql);
                updater.execute(values);
                notUpdated = false;
                continue;
            }
            catch (Exception e) {
                if (attempt > 1) {
                    this.log().fatal((Object)("resolveOutage: Second and final attempt failed resolving outage for " + nodeId + ":" + ipAddr + ":" + svcName), (Throwable)e);
                    continue;
                }
                this.log().info((Object)("resolveOutage: first attempt failed resolving outage for " + nodeId + ":" + ipAddr + ":" + svcName), (Throwable)e);
            }
        }
    }

    public void reparentOutages(String ipAddr, int oldNodeId, int newNodeId) {
        try {
            this.log().info((Object)("reparenting outages for " + oldNodeId + ":" + ipAddr + " to new node " + newNodeId));
            String sql = "update outages set nodeId = ? where nodeId = ? and ipaddr = ?";
            Object[] values = new Object[]{new Integer(newNodeId), new Integer(oldNodeId), ipAddr};
            Updater updater = new Updater(this.getDataSource(), sql);
            updater.execute(values);
        }
        catch (Exception e) {
            this.log().fatal((Object)(" Error reparenting outage for " + oldNodeId + ":" + ipAddr + " to " + newNodeId), (Throwable)e);
        }
    }

    public int getServiceID(String serviceName) {
        if (serviceName == null) {
            return -1;
        }
        SingleResultQuerier querier = new SingleResultQuerier(this.getDataSource(), "select serviceId from service where serviceName = ?");
        querier.execute(serviceName);
        Integer result = (Integer)querier.getResult();
        return result == null ? -1 : result;
    }

    private Category log() {
        return ThreadCategory.getInstance(this.getClass());
    }

    public String[] getCriticalPath(int nodeId) {
        Category log = ThreadCategory.getInstance(this.getClass());
        final String[] cpath = new String[2];
        Querier querier = new Querier(this.getDataSource(), "SELECT criticalpathip, criticalpathservicename FROM pathoutage where nodeid=?"){

            public void processRow(ResultSet rs) throws SQLException {
                cpath[0] = rs.getString(1);
                cpath[1] = rs.getString(2);
            }
        };
        querier.execute(nodeId);
        if (cpath[0] == null || cpath[0].equals("")) {
            cpath[0] = OpennmsServerConfigFactory.getInstance().getDefaultCriticalPathIp();
            cpath[1] = "ICMP";
        }
        if (cpath[1] == null || cpath[1].equals("")) {
            cpath[1] = "ICMP";
        }
        return cpath;
    }
}

