/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.notifd;

import java.io.IOException;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Category;
import org.apache.regexp.RE;
import org.apache.regexp.RESyntaxException;
import org.exolab.castor.xml.MarshalException;
import org.exolab.castor.xml.ValidationException;
import org.opennms.core.utils.ThreadCategory;
import org.opennms.core.utils.TimeConverter;
import org.opennms.netmgt.EventConstants;
import org.opennms.netmgt.capsd.EventUtils;
import org.opennms.netmgt.config.DestinationPathManager;
import org.opennms.netmgt.config.GroupManager;
import org.opennms.netmgt.config.NotifdConfigManager;
import org.opennms.netmgt.config.NotificationCommandManager;
import org.opennms.netmgt.config.NotificationManager;
import org.opennms.netmgt.config.PollOutagesConfigManager;
import org.opennms.netmgt.config.UserManager;
import org.opennms.netmgt.config.destinationPaths.Escalate;
import org.opennms.netmgt.config.destinationPaths.Path;
import org.opennms.netmgt.config.destinationPaths.Target;
import org.opennms.netmgt.config.groups.Group;
import org.opennms.netmgt.config.notifd.AutoAcknowledge;
import org.opennms.netmgt.config.notificationCommands.Command;
import org.opennms.netmgt.config.notifications.Notification;
import org.opennms.netmgt.config.users.Contact;
import org.opennms.netmgt.config.users.User;
import org.opennms.netmgt.eventd.EventIpcManager;
import org.opennms.netmgt.eventd.EventIpcManagerFactory;
import org.opennms.netmgt.eventd.EventUtil;
import org.opennms.netmgt.model.events.EventListener;
import org.opennms.netmgt.notifd.NoticeQueue;
import org.opennms.netmgt.notifd.NotificationTask;
import org.opennms.netmgt.utils.RowProcessor;
import org.opennms.netmgt.xml.event.Event;
import org.opennms.netmgt.xml.event.Logmsg;
import org.opennms.netmgt.xml.event.Parm;
import org.opennms.netmgt.xml.event.Parms;
import org.opennms.netmgt.xml.event.Value;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class BroadcastEventProcessor
implements EventListener {
    private volatile Map<String, NoticeQueue> m_noticeQueues;
    private volatile EventIpcManager m_eventManager;
    private volatile PollOutagesConfigManager m_pollOutagesConfigManager;
    private volatile NotificationManager m_notificationManager;
    private volatile NotifdConfigManager m_notifdConfigManager;
    private volatile DestinationPathManager m_destinationPathManager;
    private volatile UserManager m_userManager;
    private volatile GroupManager m_groupManager;
    private volatile NotificationCommandManager m_notificationCommandManager;
    private static final String NOTIFD_EXPANSION_PARM = "%(noticeid)%";
    private static RE m_expandRE;

    protected void init() {
        this.assertPropertiesSet();
        this.initExpandRe();
        this.getEventManager().addEventListener(this);
    }

    private void assertPropertiesSet() {
        if (this.m_noticeQueues == null) {
            throw new IllegalStateException("property noticeQueues not set");
        }
        if (this.m_eventManager == null) {
            throw new IllegalStateException("property eventManager not set");
        }
        if (this.m_pollOutagesConfigManager == null) {
            throw new IllegalStateException("property pollOutagesConfigManager not set");
        }
        if (this.m_notificationManager == null) {
            throw new IllegalStateException("property notificationManager not set");
        }
        if (this.m_notifdConfigManager == null) {
            throw new IllegalStateException("property notifdConfigManager not set");
        }
        if (this.m_destinationPathManager == null) {
            throw new IllegalStateException("property destinationPathManager not set");
        }
        if (this.m_userManager == null) {
            throw new IllegalStateException("property userManager not set");
        }
        if (this.m_groupManager == null) {
            throw new IllegalStateException("property groupManager not set");
        }
        if (this.m_notificationCommandManager == null) {
            throw new IllegalStateException("property notificationCommandManager not set");
        }
    }

    protected void initExpandRe() {
        try {
            m_expandRE = new RE(NOTIFD_EXPANSION_PARM);
        }
        catch (RESyntaxException e) {
            this.log().error((Object)"failed to compile RE %(noticeid)%", (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    public void close() {
        this.getEventManager().removeEventListener(this);
    }

    public void onEvent(Event event) {
        if (event == null) {
            return;
        }
        boolean notifsOn = this.computeNullSafeStatus();
        if (notifsOn && this.checkCriticalPath(event, notifsOn)) {
            this.scheduleNoticesForEvent(event);
        } else if (!notifsOn && this.log().isDebugEnabled()) {
            this.log().debug((Object)("discarding event " + event.getUei() + ", notifd status on = " + notifsOn));
        }
        this.automaticAcknowledge(event, notifsOn);
    }

    public boolean computeNullSafeStatus() {
        String notificationStatus = null;
        try {
            notificationStatus = this.getNotifdConfigManager().getNotificationStatus();
        }
        catch (MarshalException e) {
            this.log().error((Object)"onEvent: problem marshalling configuration", (Throwable)e);
        }
        catch (ValidationException e) {
            this.log().error((Object)"onEvent: problem validating marsharled configuraion", (Throwable)e);
        }
        catch (IOException e) {
            this.log().error((Object)"onEvent: IO problem marshalling configuration", (Throwable)e);
        }
        return "on".equalsIgnoreCase(notificationStatus);
    }

    private boolean checkCriticalPath(Event event, boolean notifsOn) {
        boolean isPathOk = true;
        long nodeid = event.getNodeid();
        try {
            String reason;
            if (event.getUei().equals("uei.opennms.org/nodes/nodeDown") && (reason = EventUtils.getParm(event, "eventReason")) != null && reason.equals("pathOutage")) {
                isPathOk = false;
                String cip = EventUtils.getParm(event, "criticalPathIp");
                String csvc = EventUtils.getParm(event, "criticalPathServiceName");
                if (this.log().isDebugEnabled()) {
                    this.log().debug((Object)("Critical Path " + cip + " " + csvc + " for nodeId " + nodeid + " did not respond. Checking to see if notice would have been sent..."));
                }
                boolean mapsToNotice = false;
                boolean noticeSupressed = false;
                Notification[] notifications = null;
                mapsToNotice = this.getNotificationManager().hasUei(event.getUei());
                notifications = this.getNotificationManager().getNotifForEvent(event);
                if (notifsOn && mapsToNotice && this.continueWithNotice(event) && notifications != null) {
                    noticeSupressed = true;
                }
                this.createPathOutageEvent(nodeid, EventUtils.getParm(event, "nodelabel"), cip, csvc, noticeSupressed);
            }
        }
        catch (MarshalException e) {
            this.log().error((Object)"onEvent: problem marshalling configuration", (Throwable)e);
        }
        catch (ValidationException e) {
            this.log().error((Object)"onEvent: problem validating marsharled configuraion", (Throwable)e);
        }
        catch (IOException e) {
            this.log().error((Object)"onEvent: IO problem marshalling configuration", (Throwable)e);
        }
        return isPathOk;
    }

    private Category log() {
        return ThreadCategory.getInstance(this.getClass());
    }

    private void automaticAcknowledge(Event event, boolean notifsOn) {
        try {
            Collection<AutoAcknowledge> autoAcks = this.getNotifdConfigManager().getAutoAcknowledges();
            for (AutoAcknowledge curAck : autoAcks) {
                if (!curAck.getUei().equals(event.getUei())) continue;
                try {
                    if (this.log().isDebugEnabled()) {
                        this.log().debug((Object)("Acknowledging event " + curAck.getAcknowledge() + " " + event.getNodeid() + ":" + event.getInterface() + ":" + event.getService()));
                    }
                    Collection<Integer> notifIDs = this.getNotificationManager().acknowledgeNotice(event, curAck.getAcknowledge(), curAck.getMatch());
                    try {
                        if (!curAck.getNotify() || !notifsOn) continue;
                        this.sendResolvedNotifications(notifIDs, event, curAck.getAcknowledge(), curAck.getMatch(), curAck.getResolutionPrefix(), this.getNotifdConfigManager().getConfiguration().isNumericSkipResolutionPrefix());
                    }
                    catch (Exception e) {
                        this.log().error((Object)"Failed to send resolution notifications.", (Throwable)e);
                    }
                }
                catch (SQLException e) {
                    this.log().error((Object)"Failed to auto acknowledge notice.", (Throwable)e);
                }
            }
        }
        catch (Exception e) {
            this.log().error((Object)"Unable to auto acknowledge notice due to exception.", (Throwable)e);
        }
    }

    private void sendResolvedNotifications(Collection<Integer> notifIDs, Event event, String acknowledge, String[] match, String resolutionPrefix, boolean skipNumericPrefix) throws Exception {
        for (int notifId : notifIDs) {
            boolean wa = false;
            if (notifId < 0) {
                notifId *= -1;
                wa = true;
                if (this.log().isDebugEnabled()) {
                    this.log().debug((Object)("Conditional autoNotify for notifId " + notifId));
                }
            }
            final boolean wasAcked = wa;
            Map<String, String> parmMap = this.rebuildParameterMap(notifId, resolutionPrefix, skipNumericPrefix);
            NotificationManager.expandMapValues(parmMap, this.getNotificationManager().getEvent(Integer.parseInt(parmMap.get("eventID"))));
            String queueID = this.getNotificationManager().getQueueForNotification(notifId);
            final HashMap userNotifications = new HashMap();
            RowProcessor ackNotifProcessor = new RowProcessor(){

                public void processRow(ResultSet rs) throws SQLException {
                    String userID = rs.getString("userID");
                    String contactInfo = rs.getString("contactinfo");
                    String autoNotifyChar = rs.getString("autonotify");
                    if (userID.equals("email-address")) {
                        userID = contactInfo;
                    }
                    String cmd = rs.getString("media");
                    if (autoNotifyChar == null) {
                        autoNotifyChar = "C";
                    }
                    if (autoNotifyChar.equals("Y") || autoNotifyChar.equals("C") && !wasAcked) {
                        ArrayList<String> cmdList = (ArrayList<String>)userNotifications.get(userID);
                        if (cmdList == null) {
                            cmdList = new ArrayList<String>();
                            userNotifications.put(userID, cmdList);
                        }
                        cmdList.add(cmd);
                    }
                }
            };
            this.getNotificationManager().forEachUserNotification(notifId, ackNotifProcessor);
            for (String userID : userNotifications.keySet()) {
                List cmdList = (List)userNotifications.get(userID);
                String[] cmds = cmdList.toArray(new String[cmdList.size()]);
                if (this.log().isDebugEnabled()) {
                    this.log().debug((Object)("Sending " + resolutionPrefix + " notification to userID = " + userID + " for notice ID " + notifId));
                }
                this.sendResolvedNotificationsToUser(queueID, userID, cmds, parmMap);
            }
        }
    }

    protected void sendResolvedNotificationsToUser(String queueID, String targetName, String[] commands, Map<String, String> params) throws Exception {
        int noticeId = -1;
        NoticeQueue noticeQueue = this.m_noticeQueues.get(queueID);
        long now = System.currentTimeMillis();
        if (this.getUserManager().hasUser(targetName)) {
            NotificationTask newTask = this.makeUserTask(now, params, noticeId, targetName, commands, null, null);
            if (newTask != null) {
                noticeQueue.putItem(now, newTask);
            }
        } else if (targetName.indexOf("@") > -1) {
            NotificationTask newTask = this.makeEmailTask(now, params, noticeId, targetName, commands, null, null);
            if (newTask != null) {
                noticeQueue.putItem(now, newTask);
            }
        } else {
            this.log().warn((Object)("Unrecognized target '" + targetName + "' contained in destinationPaths.xml. Please check the configuration."));
        }
    }

    private boolean continueWithNotice(Event event) {
        String nodeID = event.hasNodeid() ? String.valueOf(event.getNodeid()) : null;
        String ipAddr = event.getInterface();
        String service = event.getService();
        boolean continueNotice = false;
        if (nodeID == null || ipAddr == null || service == null || ipAddr.equals("0.0.0.0")) {
            if (this.log().isDebugEnabled()) {
                this.log().debug((Object)("nodeID=" + nodeID + " ipAddr=" + ipAddr + " service=" + service + ". Not checking DB, continuing..."));
            }
            return true;
        }
        try {
            String notify = this.getNotificationManager().getServiceNoticeStatus(nodeID, ipAddr, service);
            if ("Y".equals(notify)) {
                continueNotice = true;
                if (this.log().isDebugEnabled()) {
                    this.log().debug((Object)("notify status for service " + service + " on interface/node " + ipAddr + "/" + nodeID + " is 'Y', continuing..."));
                }
            } else if (this.log().isDebugEnabled()) {
                this.log().debug((Object)("notify status for service " + service + " on interface/node " + ipAddr + "/" + nodeID + " is " + notify + ", not continuing..."));
            }
        }
        catch (Exception e) {
            continueNotice = true;
            this.log().error((Object)("Not able to get notify status for service " + service + " on interface/node " + ipAddr + "/" + nodeID + ". Continuing notice... " + e.getMessage()));
        }
        return continueNotice;
    }

    private boolean autoAckExistsForEvent(String eventUei) {
        try {
            Collection<AutoAcknowledge> autoAcks = this.getNotifdConfigManager().getAutoAcknowledges();
            for (AutoAcknowledge curAck : autoAcks) {
                if (!curAck.getAcknowledge().equals(eventUei)) continue;
                return true;
            }
            return false;
        }
        catch (Exception e) {
            this.log().error((Object)("Unable to find if an auto acknowledge exists for event " + eventUei + " due to exception."), (Throwable)e);
            return false;
        }
    }

    private void scheduleNoticesForEvent(Event event) {
        boolean mapsToNotice = false;
        try {
            mapsToNotice = this.getNotificationManager().hasUei(event.getUei());
        }
        catch (Exception e) {
            this.log().error((Object)("Couldn't map uei " + event.getUei() + " to a notification entry, not scheduling notice."), (Throwable)e);
            return;
        }
        if (mapsToNotice) {
            if (this.continueWithNotice(event)) {
                Notification[] notifications = null;
                try {
                    notifications = this.getNotificationManager().getNotifForEvent(event);
                }
                catch (Exception e) {
                    this.log().error((Object)("Couldn't get notification mapping for event " + event.getUei() + ", not scheduling notice."), (Throwable)e);
                    return;
                }
                long nodeid = event.getNodeid();
                String ipaddr = event.getInterface();
                if (notifications != null) {
                    for (Notification notification : notifications) {
                        String queueID;
                        int noticeId = 0;
                        try {
                            noticeId = this.getNotificationManager().getNoticeId();
                        }
                        catch (Exception e) {
                            this.log().error((Object)"Failed to get a unique id # for notification, exiting this notification", (Throwable)e);
                            continue;
                        }
                        Map<String, String> paramMap = this.buildParameterMap(notification, event, noticeId);
                        String string = queueID = notification.getNoticeQueue() != null ? notification.getNoticeQueue() : "default";
                        if (this.log().isDebugEnabled()) {
                            this.log().debug((Object)("destination : " + notification.getDestinationPath()));
                            this.log().debug((Object)("text message: " + paramMap.get("-tm")));
                            this.log().debug((Object)("num message : " + paramMap.get("-nm")));
                            this.log().debug((Object)("subject     : " + paramMap.get("-subject")));
                            this.log().debug((Object)("node        : " + paramMap.get("-nodeid")));
                            this.log().debug((Object)("interface   : " + paramMap.get("-interface")));
                            this.log().debug((Object)("service     : " + paramMap.get("-service")));
                        }
                        Path path = null;
                        try {
                            path = this.getDestinationPathManager().getPath(notification.getDestinationPath());
                            if (path == null) {
                                this.log().warn((Object)("Unknown destination path " + notification.getDestinationPath() + ". Please check the <destinationPath> tag for the notification " + notification.getName() + " in the notifications.xml file."));
                                continue;
                            }
                        }
                        catch (Exception e) {
                            this.log().error((Object)("Could not get destination path for " + notification.getDestinationPath() + ", please check the destinationPath.xml for errors."), (Throwable)e);
                            return;
                        }
                        String initialDelay = path.getInitialDelay() == null ? "0s" : path.getInitialDelay();
                        Target[] targets = path.getTarget();
                        Escalate[] escalations = path.getEscalate();
                        try {
                            if (this.getUserCount(targets, escalations) == 0) {
                                this.log().warn((Object)("The path " + notification.getDestinationPath() + " assigned to notification " + notification.getName() + " has no targets or escalations specified, not sending notice."));
                                this.sendNotifEvent("uei.opennms.org/internal/notificationWithoutUsers", "The path " + notification.getDestinationPath() + " assigned to notification " + notification.getName() + " has no targets or escalations specified.", "The message of the notification is as follows: " + paramMap.get("-tm"));
                                return;
                            }
                        }
                        catch (Exception e) {
                            this.log().error((Object)("Failed to get count of users in destination path " + notification.getDestinationPath() + ", exiting notification."), (Throwable)e);
                            return;
                        }
                        try {
                            this.getNotificationManager().insertNotice(noticeId, paramMap, queueID, notification);
                        }
                        catch (SQLException e) {
                            this.log().error((Object)"Failed to enter notification into database, exiting this notification", (Throwable)e);
                            return;
                        }
                        long startTime = System.currentTimeMillis() + TimeConverter.convertToMillis((String)initialDelay);
                        String scheduledOutageName = this.scheduledOutage(nodeid, ipaddr);
                        if (scheduledOutageName != null) {
                            if (!this.autoAckExistsForEvent(event.getUei())) continue;
                            Calendar endOfOutage = this.getPollOutagesConfigManager().getEndOfOutage(scheduledOutageName);
                            startTime = endOfOutage.getTime().getTime();
                        }
                        ArrayList<NotificationTask> targetSiblings = new ArrayList<NotificationTask>();
                        try {
                            NoticeQueue noticeQueue = this.m_noticeQueues.get(queueID);
                            this.processTargets(targets, targetSiblings, noticeQueue, startTime, paramMap, noticeId);
                            this.processEscalations(escalations, targetSiblings, noticeQueue, startTime, paramMap, noticeId);
                        }
                        catch (Exception e) {
                            this.log().error((Object)"notice not scheduled due to error: ", (Throwable)e);
                        }
                    }
                } else if (this.log().isDebugEnabled()) {
                    this.log().debug((Object)("Event doesn't match a notice: " + event.getUei() + " : " + nodeid + " : " + ipaddr + " : " + event.getService()));
                }
            }
        } else if (this.log().isDebugEnabled()) {
            this.log().debug((Object)("No notice match for uei: " + event.getUei()));
        }
    }

    private int getUserCount(Target[] targets, Escalate[] escalations) throws IOException, MarshalException, ValidationException {
        int totalUsers = 0;
        for (int i = 0; i < targets.length; ++i) {
            totalUsers += this.getUsersInTarget(targets[i]);
        }
        for (int j = 0; j < escalations.length; ++j) {
            Target[] escalationTargets = escalations[j].getTarget();
            for (int k = 0; k < escalationTargets.length; ++k) {
                totalUsers += this.getUsersInTarget(escalationTargets[k]);
            }
        }
        return totalUsers;
    }

    private int getUsersInTarget(Target target) throws IOException, MarshalException, ValidationException {
        int count = 0;
        String targetName = target.getName();
        if (this.getGroupManager().hasGroup(targetName)) {
            count = this.getGroupManager().getGroup(targetName).getUserCount();
        } else if (this.getUserManager().hasRole(targetName)) {
            count = this.getUserManager().countUsersWithRole(targetName);
        } else if (this.getUserManager().hasUser(targetName)) {
            count = 1;
        } else if (targetName.indexOf("@") > -1) {
            count = 1;
        }
        return count;
    }

    private void sendNotifEvent(String uei, String logMessage, String description) {
        try {
            Logmsg logMsg = new Logmsg();
            logMsg.setContent(logMessage);
            Event event = new Event();
            event.setUei(uei);
            event.setSource("notifd");
            event.setLogmsg(logMsg);
            event.setDescr(description);
            event.setTime(EventConstants.formatToString((Date)new Date()));
            this.getEventManager().sendNow(event);
        }
        catch (Throwable t) {
            this.log().error((Object)("Could not send event " + uei), t);
        }
    }

    Map<String, String> buildParameterMap(Notification notification, Event event, int noticeId) {
        HashMap<String, String> paramMap = new HashMap<String, String>();
        NotificationManager.addNotificationParams(paramMap, notification);
        paramMap.put("noticeid", Integer.toString(noticeId));
        String textMessage = this.expandNotifParms(this.nullSafeTextMsg(notification), paramMap);
        String numericMessage = this.expandNotifParms(this.nullSafeNumerMsg(notification, noticeId), paramMap);
        String subjectLine = this.expandNotifParms(this.nullSafeSubj(notification, noticeId), paramMap);
        this.nullSafeExpandedPut("-tm", textMessage, event, paramMap);
        this.nullSafeExpandedPut("-nm", numericMessage, event, paramMap);
        this.nullSafeExpandedPut("-subject", subjectLine, event, paramMap);
        paramMap.put("-nodeid", event.hasNodeid() ? String.valueOf(event.getNodeid()) : "");
        paramMap.put("-interface", event.getInterface());
        paramMap.put("-service", event.getService());
        paramMap.put("eventID", String.valueOf(event.getDbid()));
        paramMap.put("eventUEI", event.getUei());
        NotificationManager.expandMapValues(paramMap, event);
        return paramMap;
    }

    private void nullSafeExpandedPut(String key, String value, Event event, Map<String, String> paramMap) {
        String result = EventUtil.expandParms(value, event);
        paramMap.put(key, result == null ? value : result);
    }

    private String nullSafeSubj(Notification notification, int noticeId) {
        return notification.getSubject() != null ? notification.getSubject() : "Notice #" + noticeId;
    }

    private String nullSafeNumerMsg(Notification notification, int noticeId) {
        return notification.getNumericMessage() != null ? notification.getNumericMessage() : "111-" + noticeId;
    }

    private String nullSafeTextMsg(Notification notification) {
        return notification.getTextMessage() != null ? notification.getTextMessage() : "No text message supplied.";
    }

    public String expandNotifParms(String input, Map<String, String> paramMap) {
        String replace;
        String expanded = new String(input);
        if (m_expandRE.match(expanded) && (replace = paramMap.get(m_expandRE.getParen(1))) != null) {
            expanded = m_expandRE.subst(expanded, replace);
        }
        return expanded;
    }

    private void processTargets(Target[] targets, List<NotificationTask> targetSiblings, NoticeQueue noticeQueue, long startTime, Map<String, String> params, int noticeId) throws IOException, MarshalException, ValidationException {
        for (int i = 0; i < targets.length; ++i) {
            String interval = targets[i].getInterval() == null ? "0s" : targets[i].getInterval();
            String targetName = targets[i].getName();
            String autoNotify = targets[i].getAutoNotify();
            autoNotify = autoNotify != null ? (autoNotify.equalsIgnoreCase("on") ? "Y" : (autoNotify.equalsIgnoreCase("off") ? "N" : "C")) : "C";
            if (this.log().isDebugEnabled()) {
                this.log().debug((Object)("Processing target " + targetName + ":" + interval));
            }
            NotificationTask[] tasks = null;
            if (this.getGroupManager().hasGroup(targetName)) {
                tasks = this.makeGroupTasks(startTime, params, noticeId, targetName, targets[i].getCommand(), targetSiblings, autoNotify, TimeConverter.convertToMillis((String)interval));
            } else if (this.getUserManager().hasRole(targetName)) {
                tasks = this.makeRoleTasks(startTime, params, noticeId, targetName, targets[i].getCommand(), targetSiblings, autoNotify, TimeConverter.convertToMillis((String)interval));
            } else if (this.getUserManager().hasUser(targetName)) {
                NotificationTask[] userTasks = new NotificationTask[]{this.makeUserTask(startTime, params, noticeId, targetName, targets[i].getCommand(), targetSiblings, autoNotify)};
                tasks = userTasks;
            } else if (targetName.indexOf("@") > -1) {
                String[] emailCommands = new String[]{this.getNotifdConfigManager().getConfiguration().getEmailAddressCommand()};
                NotificationTask[] emailTasks = new NotificationTask[]{this.makeEmailTask(startTime, params, noticeId, targetName, emailCommands, targetSiblings, autoNotify)};
                tasks = emailTasks;
            }
            if (tasks != null) {
                for (int index = 0; index < tasks.length; ++index) {
                    NotificationTask task = tasks[index];
                    if (task == null) continue;
                    noticeQueue.putItem(task.getSendTime(), task);
                    targetSiblings.add(task);
                }
                continue;
            }
            this.log().warn((Object)("Unrecognized target '" + targetName + "' contained in destinationPaths.xml. Please check the configuration."));
        }
    }

    NotificationTask[] makeGroupTasks(long startTime, Map<String, String> params, int noticeId, String targetName, String[] command, List<NotificationTask> targetSiblings, String autoNotify, long interval) throws IOException, MarshalException, ValidationException {
        String[] users;
        Group group = this.getGroupManager().getGroup(targetName);
        Calendar startCal = Calendar.getInstance();
        startCal.setTimeInMillis(startTime);
        long next = this.getGroupManager().groupNextOnDuty(group.getName(), startCal);
        if (next < 0L) {
            if (this.log().isDebugEnabled()) {
                this.log().debug((Object)("The group " + group.getName() + " is not scheduled to come back on duty. No notification will be sent to this group."));
            }
            return null;
        }
        if (this.log().isDebugEnabled()) {
            this.log().debug((Object)("The group " + group.getName() + " is on duty in " + next + " millisec."));
        }
        if ((users = group.getUser()) == null || users.length == 0) {
            if (this.log().isDebugEnabled()) {
                this.log().debug((Object)("Not sending notice, no users specified for group " + group.getName()));
            }
            return null;
        }
        return this.constructTasksFromUserList(users, startTime, next, params, noticeId, command, targetSiblings, autoNotify, interval);
    }

    private NotificationTask[] constructTasksFromUserList(String[] users, long startTime, long offset, Map<String, String> params, int noticeId, String[] command, List<NotificationTask> targetSiblings, String autoNotify, long interval) throws IOException, MarshalException, ValidationException {
        ArrayList<NotificationTask> taskList = new ArrayList<NotificationTask>(users.length);
        long curSendTime = 0L;
        for (int j = 0; j < users.length; ++j) {
            NotificationTask newTask = this.makeUserTask(offset + startTime + curSendTime, params, noticeId, users[j], command, targetSiblings, autoNotify);
            if (newTask == null) continue;
            taskList.add(newTask);
            curSendTime += interval;
        }
        return taskList.toArray(new NotificationTask[taskList.size()]);
    }

    NotificationTask[] makeRoleTasks(long startTime, Map<String, String> params, int noticeId, String targetName, String[] command, List<NotificationTask> targetSiblings, String autoNotify, long interval) throws MarshalException, ValidationException, IOException {
        String[] users = this.getUserManager().getUsersScheduledForRole(targetName, new Date(startTime));
        if (users == null || users.length == 0) {
            if (this.log().isDebugEnabled()) {
                this.log().debug((Object)("Not sending notice, no users scheduled for role  " + targetName));
            }
            return null;
        }
        return this.constructTasksFromUserList(users, startTime, 0L, params, noticeId, command, targetSiblings, autoNotify, interval);
    }

    private void processEscalations(Escalate[] escalations, List<NotificationTask> targetSiblings, NoticeQueue noticeQueue, long startTime, Map<String, String> params, int noticeId) throws IOException, MarshalException, ValidationException {
        for (int i = 0; i < escalations.length; ++i) {
            Target[] targets = escalations[i].getTarget();
            this.processTargets(targets, targetSiblings, noticeQueue, startTime += TimeConverter.convertToMillis((String)escalations[i].getDelay()), params, noticeId);
        }
    }

    NotificationTask makeUserTask(long sendTime, Map<String, String> parameters, int noticeId, String targetName, String[] commandList, List<NotificationTask> siblings, String autoNotify) throws IOException, MarshalException, ValidationException {
        NotificationTask task = null;
        task = new NotificationTask(this.getNotificationManager(), this.getUserManager(), sendTime, parameters, siblings, autoNotify);
        User user = this.getUserManager().getUser(targetName);
        Command[] commands = new Command[commandList.length];
        for (int i = 0; i < commandList.length; ++i) {
            commands[i] = this.getNotificationCommandManager().getCommand(commandList[i]);
        }
        if (user == null) {
            this.log().error((Object)("user " + targetName + " is not a valid user, not adding this user to escalation thread"));
            return null;
        }
        task.setUser(user);
        task.setCommands(commands);
        task.setNoticeId(noticeId);
        task.setAutoNotify(autoNotify);
        return task;
    }

    NotificationTask makeEmailTask(long sendTime, Map<String, String> parameters, int noticeId, String address, String[] commandList, List<NotificationTask> siblings, String autoNotify) throws IOException, MarshalException, ValidationException {
        NotificationTask task = null;
        task = new NotificationTask(this.getNotificationManager(), this.getUserManager(), sendTime, parameters, siblings, autoNotify);
        User user = new User();
        user.setUserId(address);
        Contact contact = new Contact();
        contact.setType("email");
        if (this.log().isDebugEnabled()) {
            this.log().debug((Object)("email address = " + address + ", using contact type " + contact.getType()));
        }
        contact.setInfo(address);
        user.addContact(contact);
        Command[] commands = new Command[commandList.length];
        for (int i = 0; i < commandList.length; ++i) {
            commands[i] = this.getNotificationCommandManager().getCommand(commandList[i]);
        }
        task.setUser(user);
        task.setCommands(commands);
        task.setNoticeId(noticeId);
        task.setAutoNotify(autoNotify);
        return task;
    }

    public String getName() {
        return "Notifd:BroadcastEventProcessor";
    }

    public Map<String, String> rebuildParameterMap(int notifId, String resolutionPrefix, boolean skipNumericPrefix) throws Exception {
        return this.getNotificationManager().rebuildParameterMap(notifId, resolutionPrefix, skipNumericPrefix);
    }

    public String scheduledOutage(long nodeId, String theInterface) {
        try {
            PollOutagesConfigManager outageFactory = this.getPollOutagesConfigManager();
            Collection<String> outageCalendarNames = this.getNotifdConfigManager().getOutageCalendarNames();
            for (String outageName : outageCalendarNames) {
                if (!outageFactory.isCurTimeInOutage(outageName) || !outageFactory.isNodeIdInOutage(nodeId, outageName) && !outageFactory.isInterfaceInOutage(theInterface, outageName) && !outageFactory.isInterfaceInOutage("match-any", outageName)) continue;
                if (this.log().isDebugEnabled()) {
                    this.log().debug((Object)("scheduledOutage: configured outage '" + outageName + "' applies, notification for interface " + theInterface + " on node " + nodeId + " will not be sent"));
                }
                return outageName;
            }
        }
        catch (Exception e) {
            this.log().error((Object)"Error determining current outages", (Throwable)e);
        }
        return null;
    }

    private void createPathOutageEvent(long nodeid, String nodeLabel, String intfc, String svc, boolean noticeSupressed) {
        if (this.log().isDebugEnabled()) {
            this.log().debug((Object)("nodeid = " + nodeid + ", nodeLabel = " + nodeLabel + ", noticeSupressed = " + noticeSupressed));
        }
        Event newEvent = new Event();
        newEvent.setUei("uei.opennms.org/nodes/pathOutage");
        newEvent.setSource("OpenNMS.notifd");
        newEvent.setNodeid(nodeid);
        newEvent.setTime(EventConstants.formatToString((Date)new Date()));
        Parms eventParms = new Parms();
        Parm eventParm = null;
        Value parmValue = null;
        eventParm = new Parm();
        eventParm.setParmName("nodelabel");
        parmValue = new Value();
        if (nodeLabel == null) {
            parmValue.setContent("");
        } else {
            parmValue.setContent(nodeLabel);
        }
        eventParm.setValue(parmValue);
        eventParms.addParm(eventParm);
        eventParm = new Parm();
        eventParm.setParmName("criticalPathIp");
        parmValue = new Value();
        parmValue.setContent(intfc);
        eventParm.setValue(parmValue);
        eventParms.addParm(eventParm);
        eventParm = new Parm();
        eventParm.setParmName("criticalPathServiceName");
        parmValue = new Value();
        parmValue.setContent(svc);
        eventParm.setValue(parmValue);
        eventParms.addParm(eventParm);
        eventParm = new Parm();
        eventParm.setParmName("noticeSupressed");
        parmValue = new Value();
        if (noticeSupressed) {
            parmValue.setContent("true");
        } else {
            parmValue.setContent("false");
        }
        eventParm.setValue(parmValue);
        eventParms.addParm(eventParm);
        newEvent.setParms(eventParms);
        if (this.log().isDebugEnabled()) {
            this.log().debug((Object)("Creating pathOutageEvent for nodeid: " + nodeid));
        }
        try {
            EventIpcManagerFactory.getIpcManager().sendNow(newEvent);
        }
        catch (Throwable t) {
            this.log().warn((Object)"run: unexpected throwable exception caught during event send", t);
        }
    }

    public DestinationPathManager getDestinationPathManager() {
        return this.m_destinationPathManager;
    }

    public void setDestinationPathManager(DestinationPathManager destinationPathManager) {
        this.m_destinationPathManager = destinationPathManager;
    }

    public EventIpcManager getEventManager() {
        return this.m_eventManager;
    }

    public void setEventManager(EventIpcManager eventManager) {
        this.m_eventManager = eventManager;
    }

    public GroupManager getGroupManager() {
        return this.m_groupManager;
    }

    public void setGroupManager(GroupManager groupManager) {
        this.m_groupManager = groupManager;
    }

    public NotifdConfigManager getNotifdConfigManager() {
        return this.m_notifdConfigManager;
    }

    public void setNotifdConfigManager(NotifdConfigManager notifdConfigManager) {
        this.m_notifdConfigManager = notifdConfigManager;
    }

    public NotificationCommandManager getNotificationCommandManager() {
        return this.m_notificationCommandManager;
    }

    public void setNotificationCommandManager(NotificationCommandManager notificationCommandManager) {
        this.m_notificationCommandManager = notificationCommandManager;
    }

    public NotificationManager getNotificationManager() {
        return this.m_notificationManager;
    }

    public void setNotificationManager(NotificationManager notificationManager) {
        this.m_notificationManager = notificationManager;
    }

    public PollOutagesConfigManager getPollOutagesConfigManager() {
        return this.m_pollOutagesConfigManager;
    }

    public void setPollOutagesConfigManager(PollOutagesConfigManager pollOutagesConfigManager) {
        this.m_pollOutagesConfigManager = pollOutagesConfigManager;
    }

    public UserManager getUserManager() {
        return this.m_userManager;
    }

    public void setUserManager(UserManager userManager) {
        this.m_userManager = userManager;
    }

    public Map<String, NoticeQueue> getNoticeQueues() {
        return this.m_noticeQueues;
    }

    public void setNoticeQueues(Map<String, NoticeQueue> noticeQueues) {
        this.m_noticeQueues = noticeQueues;
    }
}

