/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.linkd;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.text.ParseException;
import java.util.Date;
import org.apache.log4j.Category;
import org.opennms.core.utils.ThreadCategory;
import org.opennms.netmgt.EventConstants;
import org.opennms.netmgt.config.DataSourceFactory;

public class DbStpNodeEntry {
    static final char STATUS_ACTIVE = 'A';
    static final char STATUS_NOT_POLLED = 'N';
    static final char STATUS_DELETE = 'D';
    static final char STATUS_UNKNOWN = 'K';
    static final int BASE_TYPE_UNKNOWN = 1;
    static final int BASE_TYPE_TRASPARENT_ONLY = 2;
    static final int BASE_TYPE_SOURCEROUTE_ONLY = 3;
    static final int BASE_TYPE_SRT = 4;
    static final int STP_UNKNOWN = 1;
    static final int STP_DECLB100 = 2;
    static final int STP_IEEE8011D = 3;
    int m_nodeId;
    String m_basebridgeaddress;
    int m_basenumports;
    int m_basetype;
    int m_stpprotocolspecification;
    int m_stppriority;
    String m_stpdesignatedroot;
    int m_stprootcost;
    int m_stprootport;
    int m_basevlan;
    String m_basevlanname;
    char m_status = (char)75;
    Timestamp m_lastPollTime;
    private static final String SQL_LOAD_STPNODE = "SELECT baseBridgeAddress,baseNumPorts,basetype,stpProtocolSpecification,stpPriority,stpdesignatedroot,stprootcost,stprootport,basevlanname,status,lastPollTime FROM stpnode WHERE nodeid = ? AND basevlan = ? ";
    private boolean m_fromDb;
    private int m_changed;
    private static final int CHANGED_BRIDGEADDR = 1;
    private static final int CHANGED_NUMPORTS = 2;
    private static final int CHANGED_BASETYPE = 4;
    private static final int CHANGED_STPPROTSPEC = 8;
    private static final int CHANGED_STPPRIORITY = 16;
    private static final int CHANGED_STPDESROOT = 32;
    private static final int CHANGED_STPROOTCOST = 64;
    private static final int CHANGED_STPROOTPORT = 128;
    private static final int CHANGED_VLANNAME = 256;
    private static final int CHANGED_STATUS = 512;
    private static final int CHANGED_POLLTIME = 1024;

    private void insert(Connection c) throws SQLException {
        if (this.m_fromDb) {
            throw new IllegalStateException("The record already exists in the database");
        }
        Category log = ThreadCategory.getInstance(this.getClass());
        StringBuffer names = new StringBuffer("INSERT INTO StpNode (nodeid,basevlan");
        StringBuffer values = new StringBuffer("?,?");
        if ((this.m_changed & 1) == 1) {
            values.append(",?");
            names.append(",baseBridgeAddress");
        }
        if ((this.m_changed & 2) == 2) {
            values.append(",?");
            names.append(",baseNumPorts");
        }
        if ((this.m_changed & 4) == 4) {
            values.append(",?");
            names.append(",basetype");
        }
        if ((this.m_changed & 8) == 8) {
            values.append(",?");
            names.append(",stpProtocolSpecification");
        }
        if ((this.m_changed & 0x10) == 16) {
            values.append(",?");
            names.append(",stpPriority");
        }
        if ((this.m_changed & 0x20) == 32) {
            values.append(",?");
            names.append(",stpdesignatedroot");
        }
        if ((this.m_changed & 0x40) == 64) {
            values.append(",?");
            names.append(",stprootcost");
        }
        if ((this.m_changed & 0x80) == 128) {
            values.append(",?");
            names.append(",stprootport");
        }
        if ((this.m_changed & 0x100) == 256) {
            values.append(",?");
            names.append(",basevlanname");
        }
        if ((this.m_changed & 0x200) == 512) {
            values.append(",?");
            names.append(",status");
        }
        if ((this.m_changed & 0x400) == 1024) {
            values.append(",?");
            names.append(",lastpolltime");
        }
        names.append(") VALUES (").append(values).append(')');
        if (log.isDebugEnabled()) {
            log.debug((Object)("DbStpNodeEntry.insert: SQL insert statment = " + names.toString()));
        }
        PreparedStatement stmt = c.prepareStatement(names.toString());
        int ndx = 1;
        stmt.setInt(ndx++, this.m_nodeId);
        stmt.setInt(ndx++, this.m_basevlan);
        if ((this.m_changed & 1) == 1) {
            stmt.setString(ndx++, this.m_basebridgeaddress);
        }
        if ((this.m_changed & 2) == 2) {
            stmt.setInt(ndx++, this.m_basenumports);
        }
        if ((this.m_changed & 4) == 4) {
            stmt.setInt(ndx++, this.m_basetype);
        }
        if ((this.m_changed & 8) == 8) {
            stmt.setInt(ndx++, this.m_stpprotocolspecification);
        }
        if ((this.m_changed & 0x10) == 16) {
            stmt.setInt(ndx++, this.m_stppriority);
        }
        if ((this.m_changed & 0x20) == 32) {
            stmt.setString(ndx++, this.m_stpdesignatedroot);
        }
        if ((this.m_changed & 0x40) == 64) {
            stmt.setInt(ndx++, this.m_stprootcost);
        }
        if ((this.m_changed & 0x80) == 128) {
            stmt.setInt(ndx++, this.m_stprootport);
        }
        if ((this.m_changed & 0x100) == 256) {
            stmt.setString(ndx++, this.m_basevlanname);
        }
        if ((this.m_changed & 0x200) == 512) {
            stmt.setString(ndx++, new String(new char[]{this.m_status}));
        }
        if ((this.m_changed & 0x400) == 1024) {
            stmt.setTimestamp(ndx++, this.m_lastPollTime);
        }
        int rc = stmt.executeUpdate();
        if (log.isDebugEnabled()) {
            log.debug((Object)("StpNodeEntry.insert: row " + rc));
        }
        stmt.close();
        this.m_fromDb = true;
        this.m_changed = 0;
    }

    private void update(Connection c) throws SQLException {
        if (!this.m_fromDb) {
            throw new IllegalStateException("The record does not exists in the database");
        }
        Category log = ThreadCategory.getInstance(this.getClass());
        StringBuffer sqlText = new StringBuffer("UPDATE StpNode SET ");
        int comma = 32;
        if ((this.m_changed & 1) == 1) {
            sqlText.append((char)comma).append("baseBridgeAddress = ?");
            comma = 44;
        }
        if ((this.m_changed & 2) == 2) {
            sqlText.append((char)comma).append("baseNumPorts = ?");
            comma = 44;
        }
        if ((this.m_changed & 4) == 4) {
            sqlText.append((char)comma).append("basetype = ?");
            comma = 44;
        }
        if ((this.m_changed & 8) == 8) {
            sqlText.append((char)comma).append("stpProtocolSpecification = ?");
            comma = 44;
        }
        if ((this.m_changed & 0x10) == 16) {
            sqlText.append((char)comma).append("stpPriority = ?");
            comma = 44;
        }
        if ((this.m_changed & 0x20) == 32) {
            sqlText.append((char)comma).append("stpdesignatedroot = ?");
            comma = 44;
        }
        if ((this.m_changed & 0x40) == 64) {
            sqlText.append((char)comma).append("stprootcost = ?");
            comma = 44;
        }
        if ((this.m_changed & 0x80) == 128) {
            sqlText.append((char)comma).append("stprootport = ?");
            comma = 44;
        }
        if ((this.m_changed & 0x100) == 256) {
            sqlText.append((char)comma).append("basevlanname = ?");
            comma = 44;
        }
        if ((this.m_changed & 0x200) == 512) {
            sqlText.append((char)comma).append("status = ?");
            comma = 44;
        }
        if ((this.m_changed & 0x400) == 1024) {
            sqlText.append((char)comma).append("lastpolltime = ?");
            comma = 44;
        }
        sqlText.append(" WHERE nodeid = ? AND basevlan = ? ");
        if (log.isDebugEnabled()) {
            log.debug((Object)("DbStpNodeEntry.update: SQL insert statment = " + sqlText.toString()));
        }
        PreparedStatement stmt = c.prepareStatement(sqlText.toString());
        int ndx = 1;
        if ((this.m_changed & 1) == 1) {
            stmt.setString(ndx++, this.m_basebridgeaddress);
        }
        if ((this.m_changed & 2) == 2) {
            stmt.setInt(ndx++, this.m_basenumports);
        }
        if ((this.m_changed & 4) == 4) {
            stmt.setInt(ndx++, this.m_basetype);
        }
        if ((this.m_changed & 8) == 8) {
            stmt.setInt(ndx++, this.m_stpprotocolspecification);
        }
        if ((this.m_changed & 0x10) == 16) {
            stmt.setInt(ndx++, this.m_stppriority);
        }
        if ((this.m_changed & 0x20) == 32) {
            stmt.setString(ndx++, this.m_stpdesignatedroot);
        }
        if ((this.m_changed & 0x40) == 64) {
            stmt.setInt(ndx++, this.m_stprootcost);
        }
        if ((this.m_changed & 0x80) == 128) {
            stmt.setInt(ndx++, this.m_stprootport);
        }
        if ((this.m_changed & 0x100) == 256) {
            stmt.setString(ndx++, this.m_basevlanname);
        }
        if ((this.m_changed & 0x200) == 512) {
            stmt.setString(ndx++, new String(new char[]{this.m_status}));
        }
        if ((this.m_changed & 0x400) == 1024) {
            stmt.setTimestamp(ndx++, this.m_lastPollTime);
        }
        stmt.setInt(ndx++, this.m_nodeId);
        stmt.setInt(ndx++, this.m_basevlan);
        int rc = stmt.executeUpdate();
        if (log.isDebugEnabled()) {
            log.debug((Object)("StpNodeEntry.update: row " + rc));
        }
        stmt.close();
        this.m_changed = 0;
    }

    private boolean load(Connection c) throws SQLException {
        String str;
        if (!this.m_fromDb) {
            throw new IllegalStateException("The record does not exists in the database");
        }
        Category log = ThreadCategory.getInstance(this.getClass());
        PreparedStatement stmt = null;
        stmt = c.prepareStatement(SQL_LOAD_STPNODE);
        stmt.setInt(1, this.m_nodeId);
        stmt.setInt(2, this.m_basevlan);
        ResultSet rset = stmt.executeQuery();
        if (!rset.next()) {
            rset.close();
            stmt.close();
            if (log.isDebugEnabled()) {
                log.debug((Object)"StpNodeEntry.load: no result found");
            }
            return false;
        }
        int ndx = 1;
        this.m_basebridgeaddress = rset.getString(ndx++);
        if (rset.wasNull()) {
            this.m_basebridgeaddress = null;
        }
        this.m_basenumports = rset.getInt(ndx++);
        if (rset.wasNull()) {
            this.m_basenumports = -1;
        }
        this.m_basetype = rset.getInt(ndx++);
        if (rset.wasNull()) {
            this.m_basetype = -1;
        }
        this.m_stpprotocolspecification = rset.getInt(ndx++);
        if (rset.wasNull()) {
            this.m_stpprotocolspecification = -1;
        }
        this.m_stppriority = rset.getInt(ndx++);
        if (rset.wasNull()) {
            this.m_stppriority = -1;
        }
        this.m_stpdesignatedroot = rset.getString(ndx++);
        if (rset.wasNull()) {
            this.m_stpdesignatedroot = null;
        }
        this.m_stprootcost = rset.getInt(ndx++);
        if (rset.wasNull()) {
            this.m_stprootcost = -1;
        }
        this.m_stprootport = rset.getInt(ndx++);
        if (rset.wasNull()) {
            this.m_stprootport = -1;
        }
        this.m_basevlanname = rset.getString(ndx++);
        if (rset.wasNull()) {
            this.m_basevlanname = null;
        }
        this.m_status = (str = rset.getString(ndx++)) != null && !rset.wasNull() ? str.charAt(0) : (char)75;
        this.m_lastPollTime = rset.getTimestamp(ndx++);
        rset.close();
        stmt.close();
        if (log.isDebugEnabled()) {
            log.debug((Object)"StpNodeEntry.load: result found");
        }
        this.m_changed = 0;
        return true;
    }

    DbStpNodeEntry() {
        throw new UnsupportedOperationException("Default constructor not supported!");
    }

    DbStpNodeEntry(int nodeId, int basevlan, boolean exists) {
        this.m_nodeId = nodeId;
        this.m_fromDb = exists;
        this.m_basenumports = -1;
        this.m_basetype = -1;
        this.m_stpprotocolspecification = -1;
        this.m_stppriority = -1;
        this.m_stprootcost = -1;
        this.m_stprootcost = -1;
        this.m_basevlan = basevlan;
        this.m_basebridgeaddress = null;
        this.m_stpdesignatedroot = null;
        this.m_basevlanname = null;
    }

    static DbStpNodeEntry create(int nodeId, int basevlan) {
        return new DbStpNodeEntry(nodeId, basevlan, false);
    }

    public int get_nodeId() {
        return this.m_nodeId;
    }

    public int get_basevlan() {
        return this.m_basevlan;
    }

    public String get_basevlanname() {
        return this.m_basevlanname;
    }

    void set_basevlanname(String basevlanname) {
        this.m_basevlanname = basevlanname;
        this.m_changed |= 0x100;
    }

    boolean hasBaseVlanNameChanged() {
        return (this.m_changed & 0x100) == 256;
    }

    boolean updateBaseVlanName(String basevlanname) {
        if (basevlanname != this.m_basevlanname) {
            this.set_basevlanname(basevlanname);
            return true;
        }
        return false;
    }

    public String get_basebridgeaddress() {
        return this.m_basebridgeaddress;
    }

    void set_basebridgeaddress(String basebridgeaddress) {
        this.m_basebridgeaddress = basebridgeaddress;
        this.m_changed |= 1;
    }

    boolean hasBaseBridgeAddressChanged() {
        return (this.m_changed & 1) == 1;
    }

    boolean updateBaseBridgeAddress(String basebridgeaddress) {
        if (basebridgeaddress != this.m_basebridgeaddress) {
            this.set_basebridgeaddress(basebridgeaddress);
            return true;
        }
        return false;
    }

    public int get_basenumports() {
        return this.m_basenumports;
    }

    void set_basenumports(int basenumports) {
        this.m_basenumports = basenumports;
        this.m_changed |= 2;
    }

    boolean hasBaseNumPortsChanged() {
        return (this.m_changed & 2) == 2;
    }

    boolean updateBaseNumPorts(int basenumports) {
        if (basenumports != this.m_basenumports) {
            this.set_basenumports(basenumports);
            return true;
        }
        return false;
    }

    public int get_basetype() {
        return this.m_basetype;
    }

    void set_basetype(int basetype) {
        this.m_basetype = basetype == 4 || basetype == 2 || basetype == 3 ? basetype : 1;
        this.m_changed |= 4;
    }

    boolean hasBaseTypeChanged() {
        return (this.m_changed & 4) == 4;
    }

    boolean updateBaseType(int basetype) {
        if (basetype != this.m_basetype) {
            this.set_basetype(basetype);
            return true;
        }
        return false;
    }

    public String get_stpdesignatedroot() {
        return this.m_stpdesignatedroot;
    }

    void set_stpdesignatedroot(String stpdesignatedroot) {
        this.m_stpdesignatedroot = stpdesignatedroot;
        this.m_changed |= 0x20;
    }

    boolean hasStpDesignatedRootChanged() {
        return (this.m_changed & 0x20) == 32;
    }

    boolean updateStpDesignatedRoot(String stpdesignatedroot) {
        if (stpdesignatedroot != this.m_stpdesignatedroot) {
            this.set_stpdesignatedroot(stpdesignatedroot);
            return true;
        }
        return false;
    }

    public int get_stppriority() {
        return this.m_stppriority;
    }

    void set_stppriority(int stppriority) {
        this.m_stppriority = stppriority;
        this.m_changed |= 0x10;
    }

    boolean hasStpPriorityChanged() {
        return (this.m_changed & 0x10) == 16;
    }

    boolean updateStpPriority(int stppriority) {
        if (stppriority != this.m_stppriority) {
            this.set_stppriority(stppriority);
            return true;
        }
        return false;
    }

    public int get_stpprotocolspecification() {
        return this.m_stpprotocolspecification;
    }

    void set_stpprotocolspecification(int stpprotocolspecification) {
        this.m_stpprotocolspecification = stpprotocolspecification == 2 || stpprotocolspecification == 3 ? stpprotocolspecification : 1;
        this.m_changed |= 8;
    }

    boolean hasStpProtocolSpecificationChanged() {
        return (this.m_changed & 8) == 8;
    }

    boolean updateStpProtocolSpecification(int stpprotocolspecification) {
        if (stpprotocolspecification != this.m_stpprotocolspecification) {
            this.set_stpprotocolspecification(stpprotocolspecification);
            return true;
        }
        return false;
    }

    public int get_stprootcost() {
        return this.m_stprootcost;
    }

    void set_stprootcost(int stprootcost) {
        this.m_stprootcost = stprootcost;
        this.m_changed |= 0x40;
    }

    boolean hasStpRootCostChanged() {
        return (this.m_changed & 0x40) == 64;
    }

    boolean updateStpRootCost(int stprootcost) {
        if (stprootcost != this.m_stprootcost) {
            this.set_stprootcost(stprootcost);
            return true;
        }
        return false;
    }

    public int get_stprootport() {
        return this.m_stprootport;
    }

    void set_stprootport(int stprootport) {
        this.m_stprootport = stprootport;
        this.m_changed |= 0x80;
    }

    boolean hasStpRootPortChanged() {
        return (this.m_changed & 0x80) == 128;
    }

    boolean updateStpRootPort(int stprootport) {
        if (stprootport != this.m_stprootport) {
            this.set_stprootport(stprootport);
            return true;
        }
        return false;
    }

    char get_status() {
        return this.m_status;
    }

    void set_status(char status) {
        if (status == 'A' || status == 'N' || status == 'D') {
            this.m_status = status;
        }
        this.m_changed |= 0x200;
    }

    boolean hasStatusChanged() {
        return (this.m_changed & 0x200) == 512;
    }

    boolean updateStatus(char status) {
        if (status != this.m_status) {
            this.set_status(status);
            return true;
        }
        return false;
    }

    Timestamp get_lastpolltime() {
        return this.m_lastPollTime;
    }

    String getLastPollTimeString() {
        String result = null;
        if (this.m_lastPollTime != null) {
            result = this.m_lastPollTime.toString();
        }
        return result;
    }

    void set_lastpolltime(String time) throws ParseException {
        if (time == null) {
            this.m_lastPollTime = null;
        } else {
            Date tmpDate = EventConstants.parseToDate((String)time);
            this.m_lastPollTime = new Timestamp(tmpDate.getTime());
        }
        this.m_changed |= 0x400;
    }

    void set_lastpolltime(Date time) {
        this.m_lastPollTime = new Timestamp(time.getTime());
        this.m_changed |= 0x400;
    }

    void set_lastpolltime(Timestamp time) {
        this.m_lastPollTime = time;
        this.m_changed |= 0x400;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void store() throws SQLException {
        if (this.m_changed != 0 || !this.m_fromDb) {
            Connection db = null;
            try {
                db = DataSourceFactory.getInstance().getConnection();
                this.store(db);
                if (!db.getAutoCommit()) {
                    db.commit();
                }
                Object var3_2 = null;
            }
            catch (Throwable throwable) {
                Object var3_3 = null;
                try {
                    if (db != null) {
                        db.close();
                    }
                }
                catch (SQLException e) {
                    ThreadCategory.getInstance(this.getClass()).warn((Object)"Exception closing JDBC connection", (Throwable)e);
                }
                throw throwable;
            }
            try {
                if (db != null) {
                    db.close();
                }
            }
            catch (SQLException e) {
                ThreadCategory.getInstance(this.getClass()).warn((Object)"Exception closing JDBC connection", (Throwable)e);
            }
        }
    }

    void store(Connection db) throws SQLException {
        if (this.m_changed != 0 || !this.m_fromDb) {
            if (this.m_fromDb) {
                this.update(db);
            } else {
                this.insert(db);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static DbStpNodeEntry get(int nid, int basevlan) throws SQLException {
        DbStpNodeEntry dbStpNodeEntry;
        Connection db = null;
        try {
            db = DataSourceFactory.getInstance().getConnection();
            dbStpNodeEntry = DbStpNodeEntry.get(db, nid, basevlan);
            Object var5_4 = null;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            try {
                if (db != null) {
                    db.close();
                }
            }
            catch (SQLException e) {
                ThreadCategory.getInstance(DbStpNodeEntry.class).warn((Object)"Exception closing JDBC connection", (Throwable)e);
            }
            throw throwable;
        }
        try {
            if (db != null) {
                db.close();
            }
        }
        catch (SQLException e) {
            ThreadCategory.getInstance(DbStpNodeEntry.class).warn((Object)"Exception closing JDBC connection", (Throwable)e);
        }
        return dbStpNodeEntry;
    }

    static DbStpNodeEntry get(Connection db, int nid, int basevlan) throws SQLException {
        DbStpNodeEntry entry = new DbStpNodeEntry(nid, basevlan, true);
        if (!entry.load(db)) {
            entry = null;
        }
        return entry;
    }

    public String toString() {
        String sep = System.getProperty("line.separator");
        StringBuffer buf = new StringBuffer();
        buf.append("from db = ").append(this.m_fromDb).append(sep);
        buf.append("node id = ").append(this.m_nodeId).append(sep);
        buf.append("base vlan index = ").append(this.m_basevlan).append(sep);
        buf.append("base bridge address = ").append(this.m_basebridgeaddress).append(sep);
        buf.append("base number of ports = ").append(this.m_basenumports).append(sep);
        buf.append("base bridge type id = ").append(this.m_basetype).append(sep);
        buf.append("stp protocol specification id = ").append(this.m_stpprotocolspecification).append(sep);
        buf.append("stp bridge priority = ").append(this.m_stppriority).append(sep);
        buf.append("stp designated root = ").append(this.m_stpdesignatedroot).append(sep);
        buf.append("stp root cost = ").append(this.m_stprootcost).append(sep);
        buf.append("stp root port = ").append(this.m_stprootport).append(sep);
        buf.append("base vlan name = ").append(this.m_basevlanname).append(sep);
        buf.append("status = ").append(this.m_status).append(sep);
        buf.append("last poll time = ").append(this.m_lastPollTime).append(sep);
        return buf.toString();
    }
}

